/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.networkanalyst;

import com.supermap.data.GeoLine3D;
import com.supermap.realspace.networkanalyst.InternalGeometry;
import com.supermap.realspace.networkanalyst.InternalHandleDisposable;
import com.supermap.realspace.networkanalyst.InternalResource;
import com.supermap.realspace.networkanalyst.TransportationAnalystResult3DNative;

public class TransportationAnalystResult3D
extends InternalHandleDisposable {
    private GeoLine3D[] m_routes = null;
    private int[][] m_nodes = null;
    private int[][] m_edges = null;
    private int[][] m_stops = null;
    private double[] m_weights = null;
    private double[][] m_stopWeights = null;

    TransportationAnalystResult3D(long handle) {
        this.setHandle(handle, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            TransportationAnalystResult3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public GeoLine3D[] getRoutes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRoutes()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_routes == null) {
            int n = TransportationAnalystResult3DNative.jni_GetRouteCount(this.getHandle());
            if (n > 0) {
                long[] lArray = new long[n];
                TransportationAnalystResult3DNative.jni_GetRouteHandles(this.getHandle(), lArray);
                this.m_routes = new GeoLine3D[n];
                for (int i = 0; i < n; ++i) {
                    if (lArray[i] == 0L) continue;
                    this.m_routes[i] = (GeoLine3D)InternalGeometry.createInstance(lArray[i]);
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_routes[i], false);
                }
            } else {
                this.m_routes = new GeoLine3D[0];
            }
        }
        return this.m_routes;
    }

    public int[][] getNodes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNodes()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_nodes == null) {
            int n = TransportationAnalystResult3DNative.jni_GetNodeCount(this.getHandle());
            if (n > 0) {
                this.m_nodes = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResult3DNative.jni_GetNodeCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_nodes[i] = new int[nArray[i]];
                }
                TransportationAnalystResult3DNative.jni_GetNodes(this.getHandle(), this.m_nodes);
            } else {
                this.m_nodes = new int[0][0];
            }
        }
        return this.m_nodes;
    }

    public int[][] getEdges() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEdges()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_edges == null) {
            int n = TransportationAnalystResult3DNative.jni_GetEdgeCount(this.getHandle());
            if (n > 0) {
                this.m_edges = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResult3DNative.jni_GetEdgeCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_edges[i] = new int[nArray[i]];
                }
                TransportationAnalystResult3DNative.jni_GetEdges(this.getHandle(), this.m_edges);
            } else {
                this.m_edges = new int[0][0];
            }
        }
        return this.m_edges;
    }

    public int[][] getStopIndexes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStops()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_stops == null) {
            int n = TransportationAnalystResult3DNative.jni_GetStopCount(this.getHandle());
            if (n > 0) {
                this.m_stops = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResult3DNative.jni_GetStopCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_stops[i] = new int[nArray[i]];
                }
                TransportationAnalystResult3DNative.jni_GetStops(this.getHandle(), this.m_stops);
            } else {
                this.m_stops = new int[0][0];
            }
        }
        return this.m_stops;
    }

    public double[][] getStopWeights() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStopWeights()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_stopWeights == null) {
            this.m_stopWeights = TransportationAnalystResult3DNative.jni_GetStopWeights(this.getHandle());
        }
        return this.m_stopWeights;
    }

    public double[] getWeights() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWeights()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_weights == null) {
            int n = TransportationAnalystResult3DNative.jni_GetWeightCount(this.getHandle());
            if (n > 0) {
                this.m_weights = new double[n];
                TransportationAnalystResult3DNative.jni_GetWeights(this.getHandle(), this.m_weights);
            } else {
                this.m_weights = new double[0];
            }
        }
        return this.m_weights;
    }
}

