/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plot;

import com.supermap.data.GeoGraphicObject;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.plot.AnimationDefine;
import com.supermap.plot.AnimationGONative;
import com.supermap.plot.AnimationManager;
import com.supermap.plot.AnimationPlayBeginEvent;
import com.supermap.plot.AnimationPlayFinishEvent;
import com.supermap.plot.SendFinishEventListener;
import com.supermap.ui.MapControl;
import com.supermap.ui.SceneControl;
import java.util.Vector;

public class AnimationGO
extends InternalHandleDisposable {
    static transient Vector<SendFinishEventListener> m_AnimationPlayFinisListener;
    private long m_SelfEventHandle = 0L;

    static void AnimationPlayBeginCallBack(AnimationGO animationgo, String strAnimationName) {
        AnimationPlayBeginEvent animationPlayBeginEvent = new AnimationPlayBeginEvent(strAnimationName);
        AnimationManager.getInstance().fireAnimationPlayBegin(animationPlayBeginEvent);
    }

    static void AnimationPlayFinishCallBack(AnimationGO animationgo, String strAnimationName) {
        AnimationPlayFinishEvent animationPlayFinishEvent = new AnimationPlayFinishEvent(strAnimationName);
        AnimationManager.getInstance().fireAnimationPlayFinish(animationPlayFinishEvent);
    }

    public AnimationGO(long handle) {
        this.setHandle(handle, false);
        this.initAnimationGo();
    }

    protected AnimationGO() {
        this.initAnimationGo();
    }

    private void initAnimationGo() {
        this.m_SelfEventHandle = AnimationGONative.jni_NewSelfEventHandle(this.getHandle(), this);
    }

    public AnimationDefine.AnimationType getAnimationType() {
        int n = AnimationGONative.jni_GetAnimationType(this.getHandle());
        return new AnimationDefine.AnimationType(n, n);
    }

    public void setGeometry3D(GeoGraphicObject pGeometry3d, SceneControl pSceneControl, String layerName) {
        AnimationGONative.jni_SetGeometry3D(this.getHandle(), InternalHandle.getHandle((InternalHandle)pGeometry3d), pSceneControl.get_mHandle(), layerName);
    }

    public void setGeometry2D(GeoGraphicObject pGeometry3d, MapControl pMapControl, String layerName) {
        AnimationGONative.jni_SetGeometry2D(this.getHandle(), InternalHandle.getHandle((InternalHandle)pGeometry3d), pMapControl.get_mHandle(), layerName);
    }

    public boolean setGeometry(String geometryUuID) {
        return AnimationGONative.jni_SetGeometry(this.getHandle(), geometryUuID);
    }

    public String getGeometryUuID() {
        return AnimationGONative.jni_GetGeometryUUID(this.getHandle());
    }

    public int getGeometryID() {
        return AnimationGONative.jni_GetGeometryID(this.getHandle());
    }

    public boolean setName(String name) {
        return AnimationGONative.jni_SetName(this.getHandle(), name);
    }

    public String getName() {
        return AnimationGONative.jni_GetName(this.getHandle());
    }

    public boolean setStartTime(double nStartTime) {
        return AnimationGONative.jni_SetStartTime(this.getHandle(), nStartTime);
    }

    public double getStartTime() {
        return AnimationGONative.jni_GetStartTime(this.getHandle());
    }

    public boolean setDuration(double Timelong) {
        return AnimationGONative.jni_SetDuration(this.getHandle(), Timelong);
    }

    public double getDuration() {
        return AnimationGONative.jni_GetDuration(this.getHandle());
    }

    public double getComplete() {
        return AnimationGONative.jni_GetComplete(this.getHandle());
    }

    public String getControlName() {
        return AnimationGONative.jni_GetControlName(this.getHandle());
    }

    public String getLayerName() {
        return AnimationGONative.jni_GetLayerName(this.getHandle());
    }

    public void setCaption(String caption) {
        AnimationGONative.jni_SetCaption(this.getHandle(), caption);
    }

    public void dispose() {
    }

    private void clearEventHandle() {
        if (this.m_SelfEventHandle != 0L) {
            AnimationGONative.jni_DeleteSelfEventHandle(this.m_SelfEventHandle);
            this.m_SelfEventHandle = 0L;
        }
    }
}

