/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.License;
import com.supermap.LicenseFeatureInfo;
import com.supermap.ProductType;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.layout.InternalEnum;
import com.supermap.layout.InternalGeoStyle;
import com.supermap.layout.InternalHandle;
import com.supermap.layout.InternalImageType;
import com.supermap.layout.InternalResource;
import com.supermap.layout.InternalToolkitLayout;
import com.supermap.layout.LayoutElements;
import com.supermap.layout.LayoutSelection;
import com.supermap.layout.MapLayoutDrawingEvent;
import com.supermap.layout.MapLayoutDrawingListener;
import com.supermap.layout.MapLayoutDrawnEvent;
import com.supermap.layout.MapLayoutDrawnListener;
import com.supermap.layout.MapLayoutNative;
import com.supermap.layout.Paper;
import com.supermap.layout.PrintFileType;
import com.supermap.layout.Printer;
import com.supermap.layout.Ruler;
import com.supermap.layout.RulerLines;
import com.supermap.layout.RulerSetting;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.MapLayoutControl;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class MapLayout
extends InternalHandleDisposable {
    private Dimension m_imageSize = new Dimension(256, 256);
    private RulerSetting m_rulerSetting;
    private Paper m_paper;
    private Printer m_printer;
    private RulerLines m_rulerLines;
    private MapLayoutControl m_mapLayoutControl;
    private static final int COMPLEVEL = 5;
    private Workspace m_workspace;
    transient Vector m_mapDrawingListeners;
    transient Vector m_mapDrawnListeners;
    private LayoutSelection m_layoutSelection;
    private LayoutElements m_layoutElements;
    private long m_selfEventHandle = 0L;
    private License m_license;
    private GeoStyle m_backGroundStyle;
    private static final double m_scaleRatio = 10000.0;
    private Ruler m_ruler;

    public MapLayout() {
        this.checkLicense();
        long l = MapLayoutNative.jni_New();
        this.setHandle(l, true);
        this.getPaper();
        this.getPrinter();
        MapLayoutNative.jni_setName(this.getHandle(), "UntitledMapLayout");
        MapLayoutNative.jni_SetModified(this.getHandle(), false);
        MapLayoutNative.jni_RegisteAllEvents(l, this);
    }

    public MapLayout(Workspace workspace) {
        this.checkLicense();
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = MapLayoutNative.jni_New();
        this.setHandle(l2, true);
        MapLayoutNative.jni_RegisteAllEvents(l2, this);
        this.setWorkspace(workspace);
        this.m_workspace = workspace;
        this.getPaper();
        this.getPrinter();
        MapLayoutNative.jni_setName(this.getHandle(), "UntitledMapLayout");
        MapLayoutNative.jni_SetModified(this.getHandle(), false);
    }

    MapLayout(long handle) {
        this.checkLicense();
        this.setHandle(handle, false);
        MapLayoutNative.jni_RegisteAllEvents(handle, this);
        MapLayoutNative.jni_setName(this.getHandle(), "UntitledMapLayout");
        MapLayoutNative.jni_SetModified(this.getHandle(), false);
    }

    MapLayout(long handle, MapLayoutControl mapLayoutControl) {
        this.checkLicense();
        this.setHandle(handle, false);
        MapLayoutNative.jni_RegisteAllEvents(handle, this);
        this.m_mapLayoutControl = mapLayoutControl;
        this.getPaper();
        this.getPrinter();
        MapLayoutNative.jni_setName(this.getHandle(), "UntitledMapLayout");
        MapLayoutNative.jni_SetModified(this.getHandle(), false);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getName(this.getHandle());
    }

    public void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_setName(this.getHandle(), name);
    }

    public Paper getPaper() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_paper == null) {
            this.m_paper = new Paper(this);
        }
        return this.m_paper;
    }

    public Printer getPrinter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrinter()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_printer == null) {
            this.m_printer = new Printer(this);
        }
        return this.m_printer;
    }

    public Ruler getRuler() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRuler()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_ruler == null) {
            this.m_ruler = new Ruler(this);
        }
        return this.m_ruler;
    }

    public RulerLines getRulerLines() {
        return null;
    }

    public RulerSetting getRulerSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRulerSetting()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_rulerSetting == null) {
            this.m_rulerSetting = new RulerSetting(this);
        }
        return this.m_rulerSetting;
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapLayoutNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public Rectangle2D getViewBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewBounds()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapLayoutNative.jni_getViewBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[3], dArray[2], dArray[1]);
        return rectangle2D;
    }

    public void setViewBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewBounds(Rectangle2D rectangle2D)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("rectangle2D", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_setViewBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        MapLayoutNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getZoomRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getZoomRatio()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getZoomRatio(this.getHandle(), 10000.0);
    }

    public void setZoomRatio(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setZoomRatio(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setZoomRatio(this.getHandle(), value / 10000.0);
    }

    public double getMaxZoomRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxZoomRatio()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getMaxZoomRatio(this.getHandle(), 10000.0);
    }

    public void setMaxZoomRatio(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxZoomRatio(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setMaxZoomRatio(this.getHandle(), value / 10000.0);
    }

    public double getMinZoomRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinZoomRatio()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getMinZoomRatio(this.getHandle(), 10000.0);
    }

    public void setMinZoomRatio(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinZoomRatio(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setMinZoomRatio(this.getHandle(), value / 10000.0);
    }

    public int getHorizontalPaperCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalPaperCount()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getHorizontalPaperCount(this.getHandle());
    }

    public void setHorizontalPaperCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalPaperCount(int value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setHorizontalPaperCount(this.getHandle(), value);
    }

    public int getVerticalPaperCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalPaperCount()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getVerticalPaperCount(this.getHandle());
    }

    public void setVerticalPaperCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalPaperCount(int value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setVerticalPaperCount(this.getHandle(), value);
    }

    public boolean getPrintPreview() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrintPreview()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getPaperPreview(this.getHandle());
    }

    public void setPrintPreview(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrintPreview()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setPaperPreview(this.getHandle(), value);
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspace()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    public void setWorkspace(Workspace workspace) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        if (this.m_workspace != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace)) == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "MapLayout_DontDisposeOldWorkspace", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace != null && !this.m_workspace.getConnectionInfo().getServer().equals("")) {
            this.close();
        }
        if (workspace == null) {
            this.m_workspace = null;
        } else {
            l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l == 0L) {
                String string = InternalResource.loadString("workspace", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            MapLayoutNative.jni_SetWorkspace(this.getHandle(), l);
            this.m_workspace = workspace;
        }
    }

    public LayoutElements getElements() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getElements()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layoutElements == null) {
            this.m_layoutElements = new LayoutElements(this);
        }
        return this.m_layoutElements;
    }

    public Dimension getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        Dimension dimension = null;
        dimension = this.m_mapLayoutControl == null ? new Dimension(this.m_imageSize) : new Dimension(this.m_mapLayoutControl.getWidth(), this.m_mapLayoutControl.getHeight());
        return dimension;
    }

    public void setImageSize(Dimension size) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageSize(Dimension size)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (size.getWidth() > 0.0 && size.getHeight() > 0.0) {
            MapLayoutNative.jni_setImageSize(this.getHandle(), size.getWidth(), size.getHeight());
        }
        this.m_imageSize = size;
    }

    public LayoutSelection getSelection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelection()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layoutSelection == null) {
            long l = MapLayoutNative.jni_getSelection(this.getHandle());
            this.m_layoutSelection = new LayoutSelection(l);
        }
        return this.m_layoutSelection;
    }

    public void setSelection(LayoutSelection layoutSelection) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelection(LayoutSelection layoutSelection)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (layoutSelection == null) {
            String string = InternalResource.loadString("layoutSelection", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)layoutSelection);
        if (l == 0L) {
            String string = InternalResource.loadString("layoutSelection", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_setSelection(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)layoutSelection));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)layoutSelection));
    }

    public boolean open(String name) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open(String name)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapLayoutNative.jni_open(this.getHandle(), name);
        this.clearLocalVariable();
        this.setModified(false);
        return bl;
    }

    public boolean loadTemplate(String templateName) {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("loadTemplate(String templateName)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (templateName == null || templateName.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layoutElements != null) {
            this.m_layoutElements.clearHandle();
        }
        if (bl = MapLayoutNative.jni_loadTemplate(this.getHandle(), templateName)) {
            this.m_layoutElements = new LayoutElements(this);
        }
        return bl;
    }

    public boolean saveAsTemplate(String templateName) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveAsTemplate(String templateName)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (templateName == null || templateName.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return MapLayoutNative.jni_saveAsTemplate(this.getHandle(), templateName);
    }

    public void zoomToPaper() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoomToPaper()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_ZoomToPaper(this.getHandle());
    }

    public void zoomToPaperWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoomToPaperWidth()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_zoomToPaperWidth(this.getHandle());
    }

    public void zoomToPaperHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoomToPaperHeight()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_zoomToPaperHeight(this.getHandle());
    }

    public void zoom(double ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoom(double ratio)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (ratio <= 0.0) {
            String string = InternalResource.loadString("ratio", "MapLayout_ZoomRatioShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_Zoom(this.getHandle(), ratio);
    }

    public void pan(double offsetX, double offsetY) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pan(double offsetX, double offsetY)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_Pan(this.getHandle(), offsetX, offsetY);
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refresh()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_Refresh(this.getHandle());
    }

    public Point2D pixelToLayout(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapLayoutNative.jni_pixelToLayout(this.getHandle(), point.x, point.y, dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public Point layoutToPixel(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("layoutToPixel(Point point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[2];
        MapLayoutNative.jni_layoutToPixel(this.getHandle(), point.getX(), point.getY(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public boolean outputLayoutToBMP(String fileName, int dpi) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputLayoutToBMP(String fileName, int dpi)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().equals("")) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".bmp");
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string2 = InternalResource.loadString("", "MapLayout_WorkspaceHasNoDatasource", "layout_resources");
            throw new IllegalStateException(string2);
        }
        int n = InternalEnum.getUGCValue(InternalImageType.BMP);
        return MapLayoutNative.jni_OutputMapToBMP(this.getHandle(), string, dpi);
    }

    public boolean outputLayoutToJPG(String fileName) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToJPG(String fileName, int imageWidth, int imageHeight)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".jpg");
        return this.outputMapToFile(string, InternalImageType.JPG, this.m_imageSize.width, this.m_imageSize.height);
    }

    public boolean outputLayoutToJPG(String fileName, int dpi, int compress) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToJPG(String fileName, int imageWidth, int imageHeight)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".jpg");
        int n = InternalEnum.getUGCValue(InternalImageType.JPG);
        return MapLayoutNative.jni_PrintToFile(this.getHandle(), string, n, dpi, compress, false);
    }

    public boolean outputLayoutToPNG(String fileName, boolean isBackTransparent) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".png");
        if (this.m_imageSize.width <= 0) {
            String string2 = InternalResource.loadString("imageWidth", "MapLayout_ImageWidthShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.m_imageSize.height <= 0) {
            String string3 = InternalResource.loadString("imageHeight", "MapLayout_ImageHeightShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string4 = InternalResource.loadString("", "MapLayout_WorkspaceHasNoDatasource", "layout_resources");
            throw new IllegalStateException(string4);
        }
        boolean bl = false;
        bl = MapLayoutNative.jni_OutputMapToPNG(this.getHandle(), string, InternalImageType.PNG.value(), this.m_imageSize.width, this.m_imageSize.height, isBackTransparent);
        return bl;
    }

    public boolean outputLayoutToEPS(String fileName) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputLayoutToEPS(String fileName)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".eps");
        return this.outputMapToFile(string, InternalImageType.EPS, this.m_imageSize.width, this.m_imageSize.height);
    }

    public boolean outputLayoutToEMF(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputLayoutToEMF(String fileName)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".emf");
        return this.outputMapToFile(string, InternalImageType.EMF, this.m_imageSize.width, this.m_imageSize.height);
    }

    public BufferedImage outputLayoutToBitmap() {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputLayoutToBitmap", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        InternalBufferImage internalBufferImage = new InternalBufferImage(this.m_imageSize.width, this.m_imageSize.height);
        MapLayoutNative.jni_OutputMapToBitmap(this.getHandle(), InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage));
        BufferedImage bufferedImage = new BufferedImage(this.m_imageSize.width, this.m_imageSize.height, 5);
        bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, null);
        return bufferedImage;
    }

    public boolean outputLayoutToGIF(String fileName, boolean isBackTransparent) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputLayoutToGIF(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".gif");
        if (!this.isWorkspaceAttatched()) {
            String string2 = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (fileName == null || fileName.trim().equals("")) {
            String string3 = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.m_imageSize.width < 0) {
            String string4 = InternalResource.loadString("imageWidth", "MapLayout_ImageWidthShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        if (this.m_imageSize.height < 0) {
            String string5 = InternalResource.loadString("imageHeight", "MapLayout_ImageHeightShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string6 = InternalResource.loadString("", "MapLayout_WorkspaceHasNoDatasource", "layout_resources");
            throw new IllegalStateException(string6);
        }
        int n = InternalEnum.getUGCValue(InternalImageType.GIF);
        return MapLayoutNative.jni_OutputLayoutToGIF(this.getHandle(), string, n, this.m_imageSize.width, this.m_imageSize.height, isBackTransparent);
    }

    public boolean printToFile(String fileName, PrintFileType type, int dpi) {
        return this.printToFile(fileName, type, dpi, false);
    }

    public boolean printToFile(String fileName, PrintFileType type, int dpi, boolean isMultiPageWithPrinterPaper) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("printToFile(String fileName, int dpi)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().equals("")) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameByType(fileName, type);
        int n = InternalEnum.getUGCValue(type);
        boolean bl = false;
        bl = MapLayoutNative.jni_PrintToFile(this.getHandle(), string, n, dpi, 100, isMultiPageWithPrinterPaper);
        return bl;
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace != null) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace);
            if (l == 0L) {
                String string = InternalResource.loadString("close()", "MapLayout_CloseMapBeforeDisposeWksp", "layout_resources");
                throw new IllegalStateException(string);
            }
            this.clearLocalVariable();
            MapLayoutNative.jni_close(this.getHandle());
        }
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace) == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = MapLayoutNative.jni_FromXML(this.getHandle(), xml);
            this.clearLocalVariable();
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("toXML()", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_ToXML(this.getHandle());
    }

    public GeoStyle getBackgroundStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackgroundStyle()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_backGroundStyle == null && (l = MapLayoutNative.jni_GetBackGroundStyle(this.getHandle())) != 0L) {
            this.m_backGroundStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_backGroundStyle;
    }

    public void setBackgroundStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackgroundStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style.clone());
        MapLayoutNative.jni_SetBackgroundStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isModified()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_IsModified(this.getHandle());
    }

    public void setModified(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModified(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetModified(this.getHandle(), value);
    }

    public boolean isOverlapDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOverlapDisplayed()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_IsOverlapDisplayed(this.getHandle());
    }

    public void setOverlapDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetOverlapDisplayed(this.getHandle(), value);
    }

    public boolean isTextAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTextAntialias()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_IsTextAntialias(this.getHandle());
    }

    public void setTextAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetTextAntialias(this.getHandle(), value);
    }

    public boolean isLineAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLineAntialias()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_IsLineAntialias(this.getHandle());
    }

    public void setLineAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetLineAntialias(this.getHandle(), value);
    }

    public int getOverlapLengthOfPrinterPaper() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapLengthOfPrinterPaper()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getOverlapLengthOfPrinterPaper(this.getHandle());
    }

    public void setOverlapLengthOfPrinterPaper(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapLengthOfPrinterPaper(int value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0 || value > 100) {
            String string = InternalResource.loadString("value", "MapLayout_OverlapLengthOfPrinterPaperShouldBetween0And100", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_setOverlapLengthOfPrinterPaper(this.getHandle(), value);
    }

    public boolean ensureVisible(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Rectangle2D rectangle2D)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double d = rectangle2D.getLeft();
        double d2 = rectangle2D.getRight();
        double d3 = rectangle2D.getTop();
        double d4 = rectangle2D.getBottom();
        return MapLayoutNative.jni_EnsureVisible(this.getHandle(), d, d3, d2, d4);
    }

    public Point2D layoutToLogical(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("layoutToLogical(Point2D point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = new double[2];
        MapLayoutNative.jni_LayoutToLogical(this.getHandle(), dArray, point.getX(), point.getY());
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public Point2D logicalToLayout(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("logicalToLayout(Point2D point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        double d = Math.round(point.getX() * 10.0);
        double d2 = Math.round(point.getY() * 10.0);
        double[] dArray = new double[2];
        MapLayoutNative.jni_LogicalToLayout(this.getHandle(), dArray, d, d2);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public Point logicalToPixel(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("logicalToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        double d = Math.round(point.getX() * 10.0);
        double d2 = Math.round(point.getY() * 10.0);
        int[] nArray = new int[2];
        MapLayoutNative.jni_LogicalToPixel(this.getHandle(), nArray, d, d2);
        Point point2 = new Point(nArray[0], nArray[1]);
        return point2;
    }

    public Point2D pixelToLogical(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pixelToLogical(Point point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = new double[2];
        MapLayoutNative.jni_PixelToLogical(this.getHandle(), dArray, point.getX(), point.getY());
        Point2D point2D = new Point2D(dArray[0] / 10.0, dArray[1] / 10.0);
        return point2D;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace) == 0L) {
            String string = InternalResource.loadString("dispose()", "MapLayout_DontDisposeOldWorkspace", "layout_resources");
            throw new IllegalStateException(string);
        }
        this.clearHandle();
        MapLayoutNative.jni_Delete(this.getHandle());
        this.setHandle(0L);
        this.unLoadLicense();
    }

    public boolean adjustLayoutPaperSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("adjustLayoutPaperSize()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_AdjustLayoutPaperSize(this.getHandle(), true, true);
    }

    public LayoutSelection hitTest(Point2D pt, double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D pt, double tolerance)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "ArgumentShouldNotBeNegative", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        double d = pt.getX();
        double d2 = pt.getY();
        LayoutSelection layoutSelection = null;
        long l = MapLayoutNative.jni_HitTest(this.getHandle(), d, d2, tolerance);
        if (l != 0L) {
            layoutSelection = new LayoutSelection(l);
            InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)layoutSelection, (boolean)true);
        }
        return layoutSelection;
    }

    public synchronized void addDrawingListener(MapLayoutDrawingListener l) {
        if (this.m_mapDrawingListeners == null) {
            this.m_mapDrawingListeners = new Vector();
        }
        if (!this.m_mapDrawingListeners.contains(l)) {
            this.m_mapDrawingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeDrawingListener(MapLayoutDrawingListener l) {
        if (this.m_mapDrawingListeners != null && this.m_mapDrawingListeners.contains(l)) {
            this.m_mapDrawingListeners.remove(l);
        }
    }

    protected void fireDrawing(MapLayoutDrawingEvent event) {
        if (this.m_mapDrawingListeners != null) {
            Vector vector = this.m_mapDrawingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MapLayoutDrawingListener)vector.elementAt(i)).mapLayoutDrawing(event);
            }
        }
    }

    static void drawingCallBack(MapLayout mapLayout, long cancelHandle) {
        if (mapLayout != null) {
            Boolean bl = InternalToolkitLayout.getHandleBooleanValue(cancelHandle);
            MapLayoutDrawingEvent mapLayoutDrawingEvent = new MapLayoutDrawingEvent((Object)mapLayout, mapLayout, bl);
            mapLayout.fireDrawing(mapLayoutDrawingEvent);
            InternalToolkitLayout.setHandleBooleanValue(cancelHandle, mapLayoutDrawingEvent.getCancel());
        }
    }

    public synchronized void addDrawnListener(MapLayoutDrawnListener l) {
        if (this.m_mapDrawnListeners == null) {
            this.m_mapDrawnListeners = new Vector();
        }
        if (!this.m_mapDrawnListeners.contains(l)) {
            this.m_mapDrawnListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeDrawnListener(MapLayoutDrawnListener l) {
        if (this.m_mapDrawnListeners != null && this.m_mapDrawnListeners.contains(l)) {
            this.m_mapDrawnListeners.remove(l);
        }
    }

    protected void fireDrawn(MapLayoutDrawnEvent event) {
        if (this.m_mapDrawnListeners != null) {
            Vector vector = this.m_mapDrawnListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MapLayoutDrawnListener)vector.elementAt(i)).mapLayoutDrawn(event);
            }
        }
    }

    static void drawnCallBack(MapLayout mapLayout) {
        if (mapLayout != null) {
            MapLayoutDrawnEvent mapLayoutDrawnEvent = new MapLayoutDrawnEvent((Object)mapLayout, mapLayout);
            mapLayout.fireDrawn(mapLayoutDrawnEvent);
        }
    }

    private boolean outputMapToFile(String fileName, InternalImageType imageType, int imageWidth, int imageHeight) {
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().equals("")) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (imageWidth < 0) {
            String string = InternalResource.loadString("imageWidth", "MapLayout_ImageWidthShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (imageHeight < 0) {
            String string = InternalResource.loadString("imageHeight", "MapLayout_ImageHeightShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string = InternalResource.loadString("", "MapLayout_WorkspaceHasNoDatasource", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(imageType);
        return MapLayoutNative.jni_OutputMapToFile(this.getHandle(), fileName, n, imageWidth, imageHeight);
    }

    private boolean isWorkspaceAttatched() {
        if (this.m_workspace == null) {
            return false;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace);
        return l != 0L;
    }

    private boolean isDirectoryExisted(String fileName) {
        File file = new File(fileName);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    private String getFileNameWithSuffix(String fileName, String suffix) {
        String string = null;
        if (fileName.toLowerCase().endsWith(suffix)) {
            int n = fileName.toLowerCase().lastIndexOf(suffix);
            string = fileName.substring(0, n) + suffix;
        } else {
            string = fileName + suffix;
        }
        return string;
    }

    private String getFileNameByType(String fileName, PrintFileType type) {
        int n = type.value();
        String string = "";
        switch (n) {
            case 123: {
                string = ".png";
                break;
            }
            case 122: {
                string = ".jpg";
                break;
            }
            case 121: {
                string = ".bmp";
                break;
            }
            case 103: {
                string = ".tif";
            }
        }
        return this.getFileNameWithSuffix(fileName, string);
    }

    protected static void clearHandle(MapLayout maplayout) {
        maplayout.clearHandle();
    }

    protected static MapLayout createInstance(long handle, MapLayoutControl mapLayoutControl) {
        return new MapLayout(handle, mapLayoutControl);
    }

    protected void clearHandle() {
        this.clearLocalVariable();
        this.clearSelfEventHandle();
        this.m_workspace = null;
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            MapLayoutNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    private void clearLocalVariable() {
        if (this.m_layoutSelection != null) {
            this.m_layoutSelection.clearHandle();
            this.m_layoutSelection = null;
        }
        if (this.m_layoutElements != null) {
            this.m_layoutElements.clearHandle();
            this.m_layoutElements = null;
        }
        if (this.m_rulerLines != null) {
            this.m_rulerLines.clearHandle();
            this.m_rulerLines = null;
        }
        this.m_mapLayoutControl = null;
        if (this.m_printer != null) {
            this.m_printer.internalDispose();
            this.m_printer = null;
        }
        if (this.m_paper != null) {
            this.m_paper = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    protected void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitLayout.managerProducts(InternalToolkitLayout.getLayoutProducts());
        this.m_license = InternalToolkitLayout.verifyLicense(arrayList);
        LicenseFeatureInfo licenseFeatureInfo = this.m_license.getFeatureInfo();
        InternalToolkitLayout.setLayoutRuntimeLicenseMode(licenseFeatureInfo.isTrial());
        InternalToolkitLayout.updateStatus();
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    public void setSymbolScalable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolScalable(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setSymbolScalable(this.getHandle(), value);
    }

    public boolean isSymbolScalable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSymbolScalable()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getSymbolScalable(this.getHandle());
    }

    public void setPreLoadWebCache(int seconds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPreLoadWebCache()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetPreLoadWebCache(this.getHandle(), seconds);
    }

    public void refreshGeoMap(int geoMapID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refreshGeoMap()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapID < 0) {
            String string = InternalResource.loadString("geoMapID", "Selection_TheArgumentOfGeometryIDShouldBePositive", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_RefreshGeoMap(this.getHandle(), geoMapID);
    }

    public String getExternalXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExternalXML()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_GetExternalXML(this.getHandle());
    }

    public void setExternalXML(String enternalXML) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExternalXML(String name)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (enternalXML == null || enternalXML.trim().length() == 0) {
            String string = InternalResource.loadString("enternalXML", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_SetExternalXML(this.getHandle(), enternalXML);
    }
}

