/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.EditHistory;
import com.supermap.data.Enum;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.IDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TextPart;
import com.supermap.data.Workspace;
import com.supermap.layout.MapLayout;
import com.supermap.mapping.Map;
import com.supermap.ui.Action;
import com.supermap.ui.ActionChangedEvent;
import com.supermap.ui.ActionChangedListener;
import com.supermap.ui.ActionCursorChangingEvent;
import com.supermap.ui.ActionCursorChangingListener;
import com.supermap.ui.EditHandleEvent;
import com.supermap.ui.EditHandleMoveListener;
import com.supermap.ui.EditHandleType;
import com.supermap.ui.ElementAddedListener;
import com.supermap.ui.ElementDeletedListener;
import com.supermap.ui.ElementDeletingListener;
import com.supermap.ui.ElementEvent;
import com.supermap.ui.ElementModifiedListener;
import com.supermap.ui.ElementModifyingListener;
import com.supermap.ui.ElementSelectedEvent;
import com.supermap.ui.ElementSelectedListener;
import com.supermap.ui.ElementsAlignment;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.InternalEditHistory;
import com.supermap.ui.InternalEnum;
import com.supermap.ui.InternalHandle;
import com.supermap.ui.InternalHandleDisposable;
import com.supermap.ui.InternalLayoutEnvironment;
import com.supermap.ui.InternalLayoutGeometry;
import com.supermap.ui.InternalLayoutMap;
import com.supermap.ui.InternalLayoutResource;
import com.supermap.ui.InternalMapLayout;
import com.supermap.ui.InternalMappingGeoStyle;
import com.supermap.ui.InternalMappingGeometry;
import com.supermap.ui.InternalMappingResource;
import com.supermap.ui.InternalToolkitLayoutUI;
import com.supermap.ui.InternalToolkitMappingUI;
import com.supermap.ui.MapLayoutControlNative;
import com.supermap.ui.MapLayoutControl_this_componentAdapter;
import com.supermap.ui.MapLayoutControl_this_keyAdapter;
import com.supermap.ui.MapLayoutControl_this_mouseAdapter;
import com.supermap.ui.MapLayoutControl_this_mouseMotionAdapter;
import com.supermap.ui.MapLayoutControl_this_mouseWheelAdapter;
import com.supermap.ui.PointInputedEvent;
import com.supermap.ui.PointInputedListener;
import com.supermap.ui.TrackMode;
import com.supermap.ui.TrackedEvent;
import com.supermap.ui.TrackedListener;
import com.supermap.ui.TrackingEvent;
import com.supermap.ui.TrackingListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.Beans;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class MapLayoutControl
extends JComponent
implements IDisposable,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isNewFlag;
    private long m_handle;
    private MapLayout m_layout;
    private Action m_layoutAction = Action.NULL;
    private Action m_geoMapAction = Action.NULL;
    private TrackMode m_trackMode;
    private Map m_activeMap;
    private BorderLayout m_borderLayout;
    private boolean m_bNeedOndraw;
    private InternalBufferImage m_bufferImage;
    transient Vector m_actionChangedListeners;
    transient Vector m_elementSelectedListeners;
    transient Vector m_elementDeletingListeners;
    transient Vector m_elementAddedListeners;
    transient Vector m_elementModifyingListeners;
    transient Vector m_elementModifiedListeners;
    transient Vector m_pointInputedListeners;
    transient Vector m_actionCursorChangingListeners;
    transient Vector m_trackingListeners;
    transient Vector m_trackedListeners;
    transient Vector m_elementDeletedListeners;
    transient Vector m_editHandleMoveListeners;
    private License m_license;
    private GeoPoint m_lastPoint = new GeoPoint();
    private double m_lastLength;
    private double m_lastAngle;
    private double m_lastAzimuth;
    private double m_lastArea;
    private Action m_beforeActionLayout = Action.NULL;
    private Action m_beforeActionMap = Action.NULL;
    private JScrollBar m_scrollHorizontal;
    private JScrollBar m_scrollVertical;
    private int m_eVerticalOldValue;
    private int m_eHorizontalOldValue;
    private boolean m_hasDrawn = false;
    private boolean m_scroll;
    private boolean m_firstShow = true;
    private EditHistory m_editHistory;
    private GeoStyle m_defaultEditStyle = null;
    private GeoStyle m_trackingZoomAndSelectStyle = null;

    public MapLayoutControl() {
        this.initialize();
        if (!Beans.isDesignTime()) {
            this.getMapLayout().setWorkspace(new Workspace());
        }
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitLayoutUI.managerProducts(InternalToolkitLayoutUI.getLayoutProducts());
        this.m_license = InternalToolkitLayoutUI.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    public MapLayout getMapLayout() {
        long l;
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("getMapLayout()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layout == null && (l = MapLayoutControlNative.jni_GetMapLayout(this.m_handle, this.getWidth(), this.getHeight())) != 0L) {
            this.m_layout = InternalMapLayout.createInstance(l, this);
        }
        return this.m_layout;
    }

    public Map getActiveMap() {
        long l;
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("getActiveMap()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_activeMap == null && this.getActiveGeoMapID() != -1 && this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
            long l2 = MapLayoutControlNative.jni_getActiveMap(this.m_handle, l);
            this.m_activeMap = InternalLayoutMap.createInstance(l2);
            this.m_activeMap.setWorkspace(this.getMapLayout().getWorkspace());
        }
        return this.m_activeMap;
    }

    public int getActiveGeoMapID() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("getActiveMap()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_GetActiveGeoMapID(this.m_handle);
    }

    public void setActiveGeoMapID(int geoMapID) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("setActiveGeoMapID(int geoMapID)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_activeMap != null && this.getActiveGeoMapID() != geoMapID) {
            this.m_activeMap = null;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
        if (geoMapID != -1) {
            MapLayoutControlNative.jni_SetActiveMapID(this.m_handle, geoMapID, l);
        } else {
            MapLayoutControlNative.jni_SetActiveMapID(this.m_handle, -1, l);
        }
        this.setMapAction(this.getMapAction());
    }

    public Action getLayoutAction() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("getLayoutAction()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n = MapLayoutControlNative.jni_GetLayoutUserAction(this.m_handle);
        this.m_layoutAction = (Action)InternalEnum.parseUGCValue(Action.class, (int)n);
        return this.m_layoutAction;
    }

    public void setLayoutAction(Action layoutAction) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("setLayoutAction(Action layoutAction)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (layoutAction == null) {
            String string = InternalLayoutResource.loadString("layoutAction", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        Action action = this.getLayoutAction();
        int n = InternalEnum.getUGCValue((Enum)layoutAction);
        this.m_layoutAction = layoutAction;
        int n2 = InternalEnum.getUGCValue((Enum)this.m_trackMode);
        MapLayoutControlNative.jni_SetLayoutAction(this.m_handle, n, n2);
        ActionChangedEvent actionChangedEvent = new ActionChangedEvent((Object)this, action, this.m_layoutAction);
        this.fireActionChanged(actionChangedEvent);
        this.setCursor();
    }

    public Action getMapAction() {
        int n;
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("getMapAction()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.getActiveGeoMapID() != -1 && (n = MapLayoutControlNative.jni_GetMapAction(this.m_handle)) >= 0 && n <= Action.getEnums(Action.class).length) {
            this.m_geoMapAction = (Action)InternalEnum.parseUGCValue(Action.class, (int)n);
        }
        return this.m_geoMapAction;
    }

    public void setMapAction(Action action) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("setMapAction(Action action)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoMapAction == null) {
            String string = InternalLayoutResource.loadString("m_geoMapAction", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue((Enum)action);
        if (this.getActiveGeoMapID() != -1) {
            int n2 = InternalEnum.getUGCValue((Enum)TrackMode.EDIT);
            MapLayoutControlNative.jni_SetMapAction(this.m_handle, n, n2);
        }
        this.m_geoMapAction = action;
    }

    public TrackMode getTrackMode() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("getTrackMode()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this.m_trackMode;
    }

    public void setTrackMode(TrackMode trackMode) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("getTrackMode()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (!InternalEnum.isDefined(TrackMode.class, (int)trackMode.value())) {
            String string = InternalLayoutResource.loadString("TrackMode value", "Global_EnumValueIsError", "layout_resources");
            throw new IllegalStateException(string);
        }
        this.m_trackMode = trackMode;
        this.setLayoutAction(this.getLayoutAction());
    }

    public boolean isHorizontalScrollbarVisible() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("isHorizontalScrollbarVisible()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this.m_scrollHorizontal.isVisible();
    }

    public void setHorizontalScrollbarVisible(boolean value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("setHorizontalScrollbarVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        this.m_scrollHorizontal.setVisible(value);
    }

    public boolean isVerticalScrollbarVisible() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("isVerticalScrollbarVisible()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this.m_scrollVertical.isVisible();
    }

    public void setVerticalScrollbarVisible(boolean value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("setVerticalScrollbarVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        this.m_scrollVertical.setVisible(value);
    }

    public boolean isGridSnapable() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("isSnapable()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_IsSnapable(this.m_handle);
    }

    public void setGridSnapable(boolean value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("setSnapable(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutControlNative.jni_SetSnapable(this.m_handle, value);
    }

    public boolean isSnapEnabled() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("isSnapEnabled()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_IsSnapEnabled(this.m_handle);
    }

    public void setSnapEnabled(boolean value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("setSnapEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutControlNative.jni_SetSnapEnabled(this.m_handle, value);
    }

    public boolean canRedo() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("canRedo()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanRedo(this.m_handle);
    }

    public boolean canUndo() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("canUndo()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanUndo(this.m_handle);
    }

    public boolean canCut() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("canCut()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanCut(this.m_handle);
    }

    public boolean canCopy() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("canCopy()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanCopy(this.m_handle);
    }

    public boolean canDelete() {
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("canDelete()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this.canCut();
    }

    public boolean canPaste() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("canPaste()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanPaste(this.m_handle);
    }

    public boolean CanCombination() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("CanCombination()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanCombination(this.m_handle);
    }

    public boolean CanSplit() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("CanSplit()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanSplit(this.m_handle);
    }

    public boolean delete() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("delete()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Delete2(this.m_handle);
    }

    public boolean redo() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("redo()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Redo(this.m_handle);
    }

    public boolean undo() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("undo()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Undo(this.m_handle);
    }

    public boolean copy() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("copy()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Copy(this.m_handle);
    }

    public boolean cut() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("cut()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Cut(this.m_handle);
    }

    public boolean paste() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("paste()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Paste(this.m_handle);
    }

    public boolean Combination() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("Combination()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Combination(this.m_handle);
    }

    public boolean Split() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("Split()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Split(this.m_handle);
    }

    public boolean align(ElementsAlignment alignment) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("align(ElementsAlignment alignment)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = alignment.value();
        switch (n) {
            case 10: 
            case 11: {
                bl = true;
                break;
            }
        }
        return MapLayoutControlNative.jni_Align(this.m_handle, n, bl);
    }

    public boolean makeSameWidth() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("makeSameWidth()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeSameWidth(this.m_handle);
    }

    public boolean makeSameHeight() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("makeSameHeight()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeSameHeight(this.m_handle);
    }

    public boolean makeSameSize() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("makeSameSize()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeSameSize(this.m_handle);
    }

    public boolean makeVerticalSpacingEqual() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("makeVerticalSpacingEqual()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeVerticalSpacingEqual(this.m_handle);
    }

    public boolean makeHorizontalSpacingEqual() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("makeHorizontalSpacingEqual()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeHorizontalSpacingEqual(this.m_handle);
    }

    public boolean makeSpacingEqual() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("makeSpacingEqual()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeSpacingEqual(this.m_handle);
    }

    public boolean bringForward() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("bringForward()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_BringForward(this.m_handle);
    }

    public boolean sendBackward() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("sendBackward()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_SendBackward(this.m_handle);
    }

    public boolean bringToFront() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("bringToFront()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_BringToFront(this.m_handle);
    }

    public boolean sendToBack() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("sendToBack()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_SendToBack(this.m_handle);
    }

    private void makeSureNewFromJNI() {
        if (!this.isNewFlag) {
            this.m_handle = MapLayoutControlNative.jni_New(this);
            this.reset();
            this.m_bufferImage = new InternalBufferImage(this.getWidth(), this.getHeight());
            this.isNewFlag = true;
        }
    }

    public void setRefreshAtTracked(boolean value) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString((String)"setRefreshAtTracked(boolean value)", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutControlNative.jni_SetRefreshAtTracked(this.m_handle, value);
    }

    public boolean refreshAtTracked() {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString((String)"refreshAtTracked()", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_RefreshAtTracked(this.m_handle);
    }

    public void setRefreshInInvalidArea(boolean value) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString((String)"setRefreshInInvalidArea(boolean value)", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutControlNative.jni_SetRefreshInInvalidArea(this.m_handle, value);
    }

    public boolean refreshInInvalidArea() {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString((String)"refreshInInvalidArea()", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_RefreshInInvalidArea(this.m_handle);
    }

    private Rectangle2D getPSize() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
        int[] nArray = new int[4];
        MapLayoutControlNative.jni_GetPreferredSize(this.m_handle, nArray, l);
        return new Rectangle2D((double)nArray[0], (double)nArray[3], (double)nArray[2], (double)nArray[1]);
    }

    @Override
    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        this.resize(d);
    }

    @Override
    public void resize(int width, int height) {
        ComponentListener componentListener = null;
        if (this.getComponentListeners().length > 0) {
            componentListener = this.getComponentListeners()[0];
            this.removeComponentListener(componentListener);
        }
        super.resize(width, height);
        if (componentListener != null) {
            this.addComponentListener(componentListener);
        }
        this.this_componentResized();
    }

    @Override
    public void resize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public EditHistory getEditHistory() {
        if (this.m_handle == 0L) {
            String string = InternalLayoutResource.loadString("paste()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_editHistory == null) {
            long l = this.getEditorHistoryHanle();
            this.m_editHistory = InternalEditHistory.createInstance(l);
        }
        return this.m_editHistory;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.checkLicense();
        if (this.m_handle != 0L && !Beans.isDesignTime()) {
            if (this.m_bNeedOndraw) {
                if (this.m_firstShow) {
                    this.m_firstShow = false;
                    this.this_componentResized();
                }
                this.setCursor(Cursors.getBusy());
                this.onDraw();
                this.m_bNeedOndraw = false;
                this.setCursor();
                this.m_hasDrawn = true;
            }
            if (this.m_hasDrawn) {
                g.drawImage(this.m_bufferImage.getMemoryImage(), 0, 0, null);
            }
        } else {
            g.drawString("MapLayoutControl", this.getWidth() / 2 - 30, this.getHeight() / 2);
        }
    }

    private long getEditorHistoryHanle() {
        long l = MapLayoutControlNative.jni_getEditorHistoryHandle(this.m_handle);
        return l;
    }

    static void mapLayoutControlInvalidate(MapLayoutControl mapLayoutControl) {
        mapLayoutControl.m_bNeedOndraw = true;
        mapLayoutControl.repaint();
    }

    static void mapLayoutControlDrawPaint(MapLayoutControl mapLayoutControl) {
        mapLayoutControl.repaint();
    }

    protected static void onDraw(MapLayoutControl mapLayoutControl) {
        mapLayoutControl.onDraw();
    }

    private synchronized void onDraw() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
        if (l != 0L && this.m_handle != 0L) {
            MapLayoutControlNative.jni_OnDraw(this.m_handle, l);
            this.SetSrollValue();
        }
    }

    private void initialize() {
        this.m_borderLayout = new BorderLayout();
        this.m_scrollHorizontal = new JScrollBar();
        this.m_scrollHorizontal.setOrientation(0);
        this.m_scrollHorizontal.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!MapLayoutControl.this.m_scroll) {
                    MapLayoutControl.this.scroll(e.getValue() - MapLayoutControl.this.m_eHorizontalOldValue, 0);
                    MapLayoutControl.this.m_eHorizontalOldValue = e.getValue();
                }
            }
        });
        this.m_scrollVertical = new JScrollBar();
        this.m_scrollVertical.setOrientation(1);
        this.m_scrollVertical.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!MapLayoutControl.this.m_scroll) {
                    MapLayoutControl.this.scroll(0, MapLayoutControl.this.m_eVerticalOldValue - e.getValue());
                    MapLayoutControl.this.m_eVerticalOldValue = e.getValue();
                }
            }
        });
        this.setSize(256, 256);
        this.setLayout(this.m_borderLayout);
        this.setBackground(Color.white);
        this.setFocusable(true);
        this.add((Component)this.m_scrollHorizontal, "South");
        this.add((Component)this.m_scrollVertical, "East");
        this.addComponentListener(new MapLayoutControl_this_componentAdapter(this));
        this.addMouseListener(new MapLayoutControl_this_mouseAdapter(this));
        this.addMouseMotionListener(new MapLayoutControl_this_mouseMotionAdapter(this));
        this.addMouseWheelListener(new MapLayoutControl_this_mouseWheelAdapter(this));
        this.addKeyListener(new MapLayoutControl_this_keyAdapter(this));
        this.setFocusable(true);
        this.m_trackMode = TrackMode.EDIT;
        this.m_geoMapAction = Action.PAN2;
    }

    private void scroll(int hDistance, int vDistance) {
        Point2D point2D = this.getMapLayout().getCenter();
        point2D.offset((double)hDistance, (double)vDistance);
        this.getMapLayout().setCenter(point2D);
        this.getMapLayout().refresh();
    }

    private void SetSrollValue() {
        this.m_scroll = true;
        Rectangle2D rectangle2D = this.getMapLayout().getViewBounds();
        Rectangle2D rectangle2D2 = this.getMapLayout().getBounds();
        Rectangle2D rectangle2D3 = new Rectangle2D(rectangle2D2.getLeft() - (rectangle2D2.getRight() - rectangle2D2.getLeft()) / 2.0, rectangle2D2.getBottom() - (rectangle2D2.getTop() - rectangle2D2.getBottom()) / 2.0, rectangle2D2.getRight() + (rectangle2D2.getRight() - rectangle2D2.getLeft()) / 2.0, rectangle2D2.getTop() + (rectangle2D2.getTop() - rectangle2D2.getBottom()) / 2.0);
        if ((rectangle2D3.getLeft() > rectangle2D.getLeft() || com.supermap.data.Toolkit.isZero((double)(rectangle2D3.getLeft() - rectangle2D.getLeft()))) && (rectangle2D3.getRight() < rectangle2D.getRight() || com.supermap.data.Toolkit.isZero((double)(rectangle2D3.getRight() - rectangle2D.getRight())))) {
            this.m_scrollHorizontal.setMaximum(0);
            this.m_scrollHorizontal.setMinimum(0);
            this.m_scrollHorizontal.setValue(0);
        } else {
            if (rectangle2D.getLeft() < rectangle2D3.getLeft()) {
                rectangle2D3.setLeft(rectangle2D.getLeft());
            } else if (rectangle2D.getRight() > rectangle2D3.getRight()) {
                rectangle2D3.setRight(rectangle2D.getRight());
            }
            this.m_scrollHorizontal.setMinimum((int)(rectangle2D3.getRight() - rectangle2D3.getLeft()));
            this.m_scrollHorizontal.setMaximum((int)(2.0 * rectangle2D3.getRight() - 2.0 * rectangle2D3.getLeft()));
            this.m_scrollHorizontal.setValue((int)(rectangle2D3.getRight() - 2.0 * rectangle2D3.getLeft() + rectangle2D.getLeft()));
            this.m_scrollHorizontal.setVisibleAmount((int)rectangle2D.getWidth());
        }
        if ((rectangle2D3.getTop() < rectangle2D.getTop() || com.supermap.data.Toolkit.isZero((double)(rectangle2D3.getTop() - rectangle2D.getTop()))) && (rectangle2D3.getBottom() > rectangle2D.getBottom() || com.supermap.data.Toolkit.isZero((double)(rectangle2D3.getBottom() - rectangle2D.getBottom())))) {
            this.m_scrollVertical.setMaximum(0);
            this.m_scrollVertical.setMinimum(0);
            this.m_scrollVertical.setValue(0);
        } else {
            if (rectangle2D.getTop() > rectangle2D3.getTop()) {
                rectangle2D3.setTop(rectangle2D.getTop());
            } else if (rectangle2D.getBottom() < rectangle2D3.getBottom()) {
                rectangle2D3.setBottom(rectangle2D.getBottom());
            }
            this.m_scrollVertical.setMinimum((int)(-rectangle2D3.getTop() + 2.0 * rectangle2D3.getTop() - rectangle2D3.getBottom()));
            this.m_scrollVertical.setMaximum((int)(-rectangle2D3.getBottom() + 2.0 * rectangle2D3.getTop() - rectangle2D3.getBottom()));
            this.m_scrollVertical.setValue((int)(-rectangle2D.getTop() + 2.0 * rectangle2D3.getTop() - rectangle2D3.getBottom()));
            this.m_scrollVertical.getModel().setExtent((int)rectangle2D.getHeight());
        }
        this.m_scrollHorizontal.setBlockIncrement(this.m_scrollHorizontal.getMaximum() / 10 - this.m_scrollHorizontal.getMinimum() / 10);
        this.m_scrollHorizontal.setUnitIncrement(this.m_scrollHorizontal.getMaximum() / 50 - this.m_scrollHorizontal.getMinimum() / 50);
        this.m_scrollVertical.setBlockIncrement(this.m_scrollVertical.getMaximum() / 10 - this.m_scrollVertical.getMinimum() / 10);
        this.m_scrollVertical.setUnitIncrement(this.m_scrollVertical.getMaximum() / 50 - this.m_scrollVertical.getMinimum() / 50);
        this.m_eVerticalOldValue = this.m_scrollVertical.getValue();
        this.m_eHorizontalOldValue = this.m_scrollHorizontal.getValue();
        this.m_scroll = false;
    }

    void mouseMoved(MouseEvent e) {
        this.mouseDragged(e);
        this.setCursor();
    }

    int getMouseFlag(MouseEvent e) {
        int n = 0;
        if ((e.getModifiersEx() & 0x80) == 128) {
            n = 8;
        }
        if ((e.getModifiersEx() & 0x40) == 64) {
            n = 4;
        }
        return n;
    }

    void mouseDragged(MouseEvent e) {
        long l;
        int n = this.getMouseFlag(e);
        if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
            this.setCursor();
            MapLayoutControlNative.jni_mouseMoved(this.m_handle, l, n, e.getX(), e.getY());
            this.setCursor();
        }
    }

    void mousePressed(MouseEvent e) {
        long l;
        int n = this.getMouseFlag(e);
        this.requestFocusInWindow();
        this.m_beforeActionLayout = this.getLayoutAction();
        this.m_beforeActionMap = this.getMapAction();
        if (e.getButton() == 1 && this.getLayoutAction().equals((Object)Action.CREATETEXT)) {
            long l2;
            if (this.m_handle != 0L && this.m_bufferImage != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
                GeoText geoText = new GeoText();
                geoText.getTextStyle().setSizeFixed(false);
                geoText.getTextStyle().setFontName("");
                Point2D point2D = this.getMapLayout().pixelToLayout(e.getPoint());
                geoText.addPart(new TextPart("", point2D));
                TrackedEvent trackedEvent = new TrackedEvent((Object)this, (Geometry)geoText, this.m_lastLength, this.m_lastAngle, this.m_lastAzimuth, this.m_lastArea);
                this.fireTracked(trackedEvent);
                if (!geoText.getText().equals("")) {
                    GeoText geoText2 = new GeoText();
                    geoText2.setTextStyle(geoText.getTextStyle());
                    geoText2.addPart(new TextPart(geoText.getText(), point2D));
                    MapLayoutControlNative.jni_AddText(this.m_handle, l2, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoText2));
                    geoText2.dispose();
                }
            }
        } else if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
            if (e.getButton() == 2) {
                if (this.getActiveGeoMapID() != -1) {
                    this.setMapAction(Action.PAN);
                } else {
                    this.setLayoutAction(Action.PAN);
                }
                MapLayoutControlNative.jni_mousePressed(this.m_handle, l, 1, n, e.getX(), e.getY());
            } else {
                MapLayoutControlNative.jni_mousePressed(this.m_handle, l, e.getButton(), n, e.getX(), e.getY());
            }
        }
    }

    void mouseReleased(MouseEvent e) {
        long l;
        int n = this.getMouseFlag(e);
        if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
            if (e.getButton() == 2) {
                this.setCursor();
                MapLayoutControlNative.jni_mouseReleased(this.m_handle, l, 1, n, e.getX(), e.getY());
                this.setCursor();
                if (this.getActiveGeoMapID() != -1) {
                    this.setMapAction(this.m_beforeActionMap);
                } else {
                    this.setLayoutAction(this.m_beforeActionLayout);
                }
            } else if (e.getButton() == 3 && this.getLayoutAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT)) {
                long l2 = MapLayoutControlNative.jni_getTrackGeometry(this.m_handle);
                if (l2 != 0L) {
                    Geometry geometry = InternalMappingGeometry.createInstance2((long)l2);
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, (boolean)false);
                    GeoText geoText = new GeoText();
                    geoText.getTextStyle().setSizeFixed(false);
                    geoText.getTextStyle().setFontName("");
                    Point2D point2D = this.getMapLayout().pixelToLayout(e.getPoint());
                    geoText.addPart(new TextPart("", point2D));
                    GeoCompound geoCompound = new GeoCompound();
                    geoCompound.addPart((Geometry)geoText);
                    geoCompound.addPart(geometry);
                    geoText.dispose();
                    TrackedEvent trackedEvent = new TrackedEvent((Object)this, (Geometry)geoCompound, this.m_lastLength, this.m_lastAngle, this.m_lastAzimuth, this.m_lastArea);
                    this.fireTracked(trackedEvent);
                    if (!((GeoText)geoCompound.getPart(0)).getText().equals("")) {
                        GeoText geoText2 = new GeoText();
                        geoText2.setTextStyle(((GeoText)geoCompound.getPart(0)).getTextStyle());
                        geoText2.addPart(new TextPart(((GeoText)geoCompound.getPart(0)).getText(), point2D));
                        MapLayoutControlNative.jni_AddText(this.m_handle, l, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoText2));
                        geoText2.dispose();
                    }
                }
            } else {
                this.setCursor();
                MapLayoutControlNative.jni_mouseReleased(this.m_handle, l, e.getButton(), n, e.getX(), e.getY());
                this.setCursor();
            }
        }
    }

    void mouseWheelMoved(MouseWheelEvent e) {
        long l;
        if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
            this.setCursor(Cursors.getBusy());
            Point2D point2D = this.getMapLayout().pixelToLayout(e.getPoint());
            double d = 0.0;
            d = -e.getUnitsToScroll() > 0 ? 1.25 : 0.75;
            if (this.getActiveGeoMapID() != -1) {
                MapLayoutControlNative.jni_ZoomMap(this.m_handle, l, d);
            } else {
                this.getMapLayout().zoom(d);
                Point2D point2D2 = this.getMapLayout().pixelToLayout(e.getPoint());
                this.getMapLayout().pan(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
                this.getMapLayout().refresh();
            }
            this.setCursor();
        }
    }

    public void doKeyDown(KeyEvent e) {
        long l;
        int n = 0;
        if (e.isShiftDown()) {
            n |= 4;
        }
        if (e.isControlDown()) {
            n |= 8;
        }
        int n2 = this.getKey(e);
        boolean bl = false;
        if (e.isControlDown() && (n2 == 90 || n2 == 89) || n2 == 117) {
            bl = true;
        }
        boolean bl2 = true;
        if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
            this.setCursor();
            MapLayoutControlNative.jni_keyPressed(this.m_handle, l, n2, 1, n);
            this.setCursor();
        }
        if (bl) {
            MapLayoutControlNative.jni_Refresh(this.m_handle);
        }
        this.setCursor();
    }

    void keyPressed(KeyEvent e) {
        this.doKeyDown(e);
    }

    int getKey(KeyEvent e) {
        int n = 0;
        switch (e.getKeyCode()) {
            case 127: {
                n = 46;
                break;
            }
            case 27: {
                n = 27;
                break;
            }
            case 36: {
                n = 36;
                break;
            }
            case 35: {
                n = 35;
                break;
            }
            case 33: {
                n = 33;
                break;
            }
            case 34: {
                n = 34;
                break;
            }
            case 38: {
                n = 38;
                break;
            }
            case 40: {
                n = 40;
                break;
            }
            case 37: {
                n = 37;
                break;
            }
            case 39: {
                n = 39;
                break;
            }
            default: {
                n = e.getKeyCode();
            }
        }
        return n;
    }

    void this_componentResized(ComponentEvent e) {
        this.this_componentResized();
    }

    synchronized void this_componentResized() {
        long l;
        if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
            this.m_bufferImage.resize(this.getWidth(), this.getHeight(), Color.white);
            MapLayoutControlNative.jni_OnSize(this.m_handle, l);
            this.m_layout.setImageSize(this.getSize());
        }
    }

    private void reset() {
        MapLayoutControlNative.jni_Reset(this.m_handle);
    }

    private void setCursor() {
        if (this.m_handle == 0L) {
            return;
        }
        Cursor cursor = this.getCursor();
        if (cursor != null) {
            Cursor cursor2 = this.getDefaultCursor();
            if (!cursor.equals(cursor2)) {
                ActionCursorChangingEvent actionCursorChangingEvent = new ActionCursorChangingEvent((Object)this, cursor, cursor2);
                this.fireActionCursorChanging(actionCursorChangingEvent);
            }
            try {
                this.setCursor(cursor2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Cursor getCursor(int cur) {
        int n = MapLayoutControlNative.jni_GetCursorShape(this.m_handle);
        Cursor cursor = null;
        switch (n) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 3: {
                cursor = Cursors.getMarginPanLeft();
                break;
            }
            case 4: {
                cursor = Cursors.getMarginPanRight();
                break;
            }
            case 5: {
                cursor = Cursors.getMarginPanTop();
                break;
            }
            case 6: {
                cursor = Cursors.getMarginPanBottom();
                break;
            }
            case 7: {
                cursor = Cursors.getMarginPanTopLeft();
                break;
            }
            case 8: {
                cursor = Cursors.getMarginPanTopRight();
                break;
            }
            case 9: {
                cursor = Cursors.getMarginPanBottomRight();
                break;
            }
            case 10: {
                cursor = Cursors.getMarginPanBottomLeft();
                break;
            }
            case 11: {
                cursor = Cursors.getZoomFree();
                break;
            }
            case 12: {
                cursor = Cursors.getZoomFree2();
                break;
            }
            case 13: {
                cursor = Cursors.getPan();
                break;
            }
            case 14: {
                cursor = Cursors.getPan2();
                break;
            }
            case 15: {
                cursor = Cursors.getZoonIn();
                break;
            }
            case 16: {
                cursor = Cursors.getZoonOut();
                break;
            }
            case 17: {
                cursor = Cursors.getSelect();
                break;
            }
            case 18: {
                cursor = Cursors.getSelect2();
                break;
            }
            case 19: {
                cursor = Cursors.getSelectRectangle();
                break;
            }
            case 20: {
                cursor = Cursors.getSelectCircle();
                break;
            }
            case 21: {
                cursor = Cursors.getSelectRegion();
                break;
            }
            case 22: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 23: {
                cursor = Cursors.getCreatePoint();
                break;
            }
            case 24: {
                cursor = Cursors.getCreateLine();
                break;
            }
            case 25: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 26: {
                cursor = Cursors.getCreateEllipseArc();
                break;
            }
            case 27: {
                cursor = Cursors.getCreateArc3P();
                break;
            }
            case 28: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 29: {
                cursor = Cursors.getCreateRectangle();
                break;
            }
            case 30: {
                cursor = Cursors.getCreateRoundRectangle();
                break;
            }
            case 31: {
                cursor = Cursors.getCreateCircle();
                break;
            }
            case 32: {
                cursor = Cursors.getCreateCircle3P();
                break;
            }
            case 33: {
                cursor = Cursors.getCreateCircle2P();
                break;
            }
            case 34: {
                cursor = Cursors.getCreateEllipse();
                break;
            }
            case 35: {
                cursor = Cursors.getCreateObliqueEllipse();
                break;
            }
            case 36: {
                cursor = Cursors.getCreatePolygon();
                break;
            }
            case 37: {
                cursor = Cursors.getCreateText();
                break;
            }
            case 38: {
                cursor = Cursors.getCreateAlongLineText();
                break;
            }
            case 39: {
                cursor = Cursors.getCreateParallel();
                break;
            }
            case 40: {
                cursor = Cursors.getCross();
                break;
            }
            case 41: {
                cursor = Cursors.getRotation();
                break;
            }
            case 42: {
                cursor = Cursors.getBeam();
                break;
            }
            case 43: {
                cursor = Cursors.getMove();
                break;
            }
            case 44: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 45: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 46: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 47: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 48: {
                cursor = Cursors.getSnapPoint();
                break;
            }
            case 49: {
                cursor = Cursors.getSnapVertex();
                break;
            }
            case 50: {
                cursor = Cursors.getSnapMidpoint();
                break;
            }
            case 51: {
                cursor = Cursors.getSnapLine();
                break;
            }
            case 52: {
                cursor = Cursors.getSnapVertical();
                break;
            }
            case 53: {
                cursor = Cursors.getSnapParallel();
                break;
            }
            case 54: {
                cursor = Cursors.getMoveRotationBase();
                break;
            }
            case 55: {
                cursor = Cursors.getCreatePie();
                break;
            }
            case 56: {
                cursor = Cursors.getCreateParallelogram();
            }
        }
        if (this.getLayoutAction().equals((Object)Action.CREATE_NORTHARROW)) {
            cursor = Cursors.getCreateNorthArrow();
        }
        if (this.getLayoutAction().equals((Object)Action.CREATE_MAPSCALE)) {
            cursor = Cursors.getCreateMapScale();
        }
        return cursor;
    }

    private Cursor getDefaultCursor() {
        int n = MapLayoutControlNative.jni_GetCursorShape(this.m_handle);
        Cursor cursor = null;
        switch (n) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 3: {
                cursor = Cursors.getMarginPanLeft();
                break;
            }
            case 4: {
                cursor = Cursors.getMarginPanRight();
                break;
            }
            case 5: {
                cursor = Cursors.getMarginPanTop();
                break;
            }
            case 6: {
                cursor = Cursors.getMarginPanBottom();
                break;
            }
            case 7: {
                cursor = Cursors.getMarginPanTopLeft();
                break;
            }
            case 8: {
                cursor = Cursors.getMarginPanTopRight();
                break;
            }
            case 9: {
                cursor = Cursors.getMarginPanBottomRight();
                break;
            }
            case 10: {
                cursor = Cursors.getMarginPanBottomLeft();
                break;
            }
            case 11: {
                cursor = Cursors.getZoomFree();
                break;
            }
            case 12: {
                cursor = Cursors.getZoomFree2();
                break;
            }
            case 13: {
                cursor = Cursors.getPan();
                break;
            }
            case 14: {
                cursor = Cursors.getPan2();
                break;
            }
            case 15: {
                cursor = Cursors.getZoonIn();
                break;
            }
            case 16: {
                cursor = Cursors.getZoonOut();
                break;
            }
            case 17: {
                cursor = Cursors.getSelect();
                break;
            }
            case 18: {
                cursor = Cursors.getSelect2();
                break;
            }
            case 19: {
                cursor = Cursors.getSelectRectangle();
                break;
            }
            case 20: {
                cursor = Cursors.getSelectCircle();
                break;
            }
            case 21: {
                cursor = Cursors.getSelectRegion();
                break;
            }
            case 22: {
                cursor = Cursors.getSelectLine();
                break;
            }
            case 23: {
                cursor = Cursors.getCreatePoint();
                break;
            }
            case 24: {
                cursor = Cursors.getCreateLine();
                break;
            }
            case 25: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 26: {
                cursor = Cursors.getCreateEllipseArc();
                break;
            }
            case 27: {
                cursor = Cursors.getCreateArc3P();
                break;
            }
            case 28: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 29: {
                if (this.getLayoutAction().equals((Object)Action.CREATE_NORTHARROW)) {
                    cursor = Cursors.getCreateNorthArrow();
                    break;
                }
                if (this.getLayoutAction().equals((Object)Action.CREATE_MAPSCALE)) {
                    cursor = Cursors.getCreateMapScale();
                    break;
                }
                if (this.getLayoutAction().equals((Object)Action.CREATE_GEOLEGEND)) {
                    cursor = Cursors.getCreateGeoLegend();
                    break;
                }
                cursor = Cursors.getCreateRectangle();
                break;
            }
            case 30: {
                cursor = Cursors.getCreateRoundRectangle();
                break;
            }
            case 31: {
                cursor = Cursors.getCreateCircle();
                break;
            }
            case 32: {
                cursor = Cursors.getCreateCircle3P();
                break;
            }
            case 33: {
                cursor = Cursors.getCreateCircle2P();
                break;
            }
            case 34: {
                cursor = Cursors.getCreateEllipse();
                break;
            }
            case 35: {
                cursor = Cursors.getCreateObliqueEllipse();
                break;
            }
            case 36: {
                cursor = Cursors.getCreatePolygon();
                break;
            }
            case 37: {
                cursor = Cursors.getCreateText();
                break;
            }
            case 38: {
                cursor = Cursors.getCreateAlongLineText();
                break;
            }
            case 39: {
                cursor = Cursors.getCreateParallel();
                break;
            }
            case 40: {
                cursor = Cursors.getCross();
                break;
            }
            case 41: {
                cursor = Cursors.getRotation();
                break;
            }
            case 42: {
                cursor = Cursors.getBeam();
                break;
            }
            case 43: {
                cursor = Cursors.getMove();
                break;
            }
            case 44: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 45: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 46: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 47: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 48: {
                cursor = Cursors.getSnapPoint();
                break;
            }
            case 49: {
                cursor = Cursors.getSnapVertex();
                break;
            }
            case 50: {
                cursor = Cursors.getSnapMidpoint();
                break;
            }
            case 51: {
                cursor = Cursors.getSnapLine();
                break;
            }
            case 52: {
                cursor = Cursors.getSnapVertical();
                break;
            }
            case 53: {
                cursor = Cursors.getSnapParallel();
                break;
            }
            case 54: {
                cursor = Cursors.getMoveRotationBase();
                break;
            }
            case 55: {
                cursor = Cursors.getCreatePie();
                break;
            }
            case 56: {
                cursor = Cursors.getCreateParallelogram();
                break;
            }
            case 59: {
                cursor = Cursors.getCreateBSpline();
                break;
            }
            case 60: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 61: {
                cursor = Cursors.getCreateFreePolyline();
                break;
            }
            case 62: {
                cursor = Cursors.getCreateCardinal();
            }
        }
        return cursor;
    }

    public synchronized void addLayoutActionChangedListener(ActionChangedListener l) {
        if (this.m_actionChangedListeners == null) {
            this.m_actionChangedListeners = new Vector();
        }
        if (!this.m_actionChangedListeners.contains(l)) {
            this.m_actionChangedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayoutActionChangedListener(ActionChangedListener l) {
        if (this.m_actionChangedListeners != null && this.m_actionChangedListeners.contains(l)) {
            this.m_actionChangedListeners.remove(l);
        }
    }

    protected void fireActionChanged(ActionChangedEvent event) {
        if (this.m_actionChangedListeners != null) {
            Vector vector = this.m_actionChangedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ActionChangedListener)vector.elementAt(i)).actionChanged(event);
            }
        }
    }

    public synchronized void addElementSelectedListener(ElementSelectedListener l) {
        if (this.m_elementSelectedListeners == null) {
            this.m_elementSelectedListeners = new Vector();
        }
        if (!this.m_elementSelectedListeners.contains(l)) {
            this.m_elementSelectedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeElementSelectedListener(ElementSelectedListener l) {
        if (this.m_elementSelectedListeners != null && this.m_elementSelectedListeners.contains(l)) {
            this.m_elementSelectedListeners.remove(l);
        }
    }

    protected void fireElementSelected(ElementSelectedEvent event) {
        if (this.m_elementSelectedListeners != null) {
            Vector vector = this.m_elementSelectedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ElementSelectedListener)vector.elementAt(i)).elementSelected(event);
            }
        }
    }

    static void elementSelectedCallBack(MapLayoutControl mapLayoutControl, int selectedGeometryCount) {
        if (mapLayoutControl != null) {
            ElementSelectedEvent elementSelectedEvent = new ElementSelectedEvent(mapLayoutControl, selectedGeometryCount);
            mapLayoutControl.fireElementSelected(elementSelectedEvent);
        }
    }

    public synchronized void addElementDeletingListener(ElementDeletingListener l) {
        if (this.m_elementDeletingListeners == null) {
            this.m_elementDeletingListeners = new Vector();
        }
        if (!this.m_elementDeletingListeners.contains(l)) {
            this.m_elementDeletingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeElementDeletingListener(ElementDeletingListener l) {
        if (this.m_elementDeletingListeners != null && this.m_elementDeletingListeners.contains(l)) {
            this.m_elementDeletingListeners.remove(l);
        }
    }

    protected void fireElementDeleting(ElementEvent event) {
        if (this.m_elementDeletingListeners != null) {
            Vector vector = this.m_elementDeletingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ElementDeletingListener)vector.elementAt(i)).elementDeleting(event);
            }
        }
    }

    static void elementDeletingCallBack(MapLayoutControl mapLayoutControl, long cancelHandle, int elementID) {
        if (mapLayoutControl != null) {
            boolean bl = InternalToolkitLayoutUI.getHandleBooleanValue(cancelHandle);
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, elementID, bl);
            mapLayoutControl.fireElementDeleting(elementEvent);
            InternalToolkitLayoutUI.setHandleBooleanValue(cancelHandle, elementEvent.getCancel());
        }
    }

    public synchronized void addElementDeletedListener(ElementDeletedListener l) {
        if (this.m_elementDeletedListeners == null) {
            this.m_elementDeletedListeners = new Vector();
        }
        if (!this.m_elementDeletedListeners.contains(l)) {
            this.m_elementDeletedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeElementDeletedListener(ElementDeletedListener l) {
        if (this.m_elementDeletedListeners != null && this.m_elementDeletedListeners.contains(l)) {
            this.m_elementDeletedListeners.remove(l);
        }
    }

    protected void fireElementDeleted(ElementEvent event) {
        if (this.m_elementDeletedListeners != null) {
            Vector vector = this.m_elementDeletedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ElementDeletedListener)vector.elementAt(i)).elementDeleted(event);
            }
        }
    }

    static void elementDeletedCallBack(MapLayoutControl mapLayoutControl, long cancelHandle, int elementID) {
        if (mapLayoutControl != null) {
            boolean bl = InternalToolkitLayoutUI.getHandleBooleanValue(cancelHandle);
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, elementID, bl);
            mapLayoutControl.fireElementDeleted(elementEvent);
            InternalToolkitLayoutUI.setHandleBooleanValue(cancelHandle, elementEvent.getCancel());
        }
    }

    public synchronized void addElementAddedListener(ElementAddedListener l) {
        if (this.m_elementAddedListeners == null) {
            this.m_elementAddedListeners = new Vector();
        }
        if (!this.m_elementAddedListeners.contains(l)) {
            this.m_elementAddedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeElementAddedListener(ElementAddedListener l) {
        if (this.m_elementAddedListeners != null && this.m_elementAddedListeners.contains(l)) {
            this.m_elementAddedListeners.remove(l);
        }
    }

    protected void fireElementAdded(ElementEvent event) {
        if (this.m_elementAddedListeners != null) {
            Vector vector = this.m_elementAddedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ElementAddedListener)vector.elementAt(i)).elementAdded(event);
            }
        }
    }

    static void elementAddedCallBack(MapLayoutControl mapLayoutControl, int id) {
        if (mapLayoutControl != null) {
            boolean bl = false;
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, id, bl);
            mapLayoutControl.fireElementAdded(elementEvent);
        }
    }

    public synchronized void addElementModifyingListener(ElementModifyingListener l) {
        if (this.m_elementModifyingListeners == null) {
            this.m_elementModifyingListeners = new Vector();
        }
        if (!this.m_elementModifyingListeners.contains(l)) {
            this.m_elementModifyingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeElementModifyingListener(ElementModifyingListener l) {
        if (this.m_elementModifyingListeners != null && this.m_elementModifyingListeners.contains(l)) {
            this.m_elementModifyingListeners.remove(l);
        }
    }

    protected void fireElementModifying(ElementEvent event) {
        if (this.m_elementModifyingListeners != null) {
            Vector vector = this.m_elementModifyingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ElementModifyingListener)vector.elementAt(i)).elementModifying(event);
            }
        }
    }

    static void elementModifyingCallBack(MapLayoutControl mapLayoutControl, long cancelHandle, int elementID) {
        if (mapLayoutControl != null) {
            boolean bl = InternalToolkitLayoutUI.getHandleBooleanValue(cancelHandle);
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, elementID, bl);
            mapLayoutControl.fireElementModifying(elementEvent);
            InternalToolkitLayoutUI.setHandleBooleanValue(cancelHandle, elementEvent.getCancel());
        }
    }

    public synchronized void addElementModifiedListener(ElementModifiedListener l) {
        if (this.m_elementModifiedListeners == null) {
            this.m_elementModifiedListeners = new Vector();
        }
        if (!this.m_elementModifiedListeners.contains(l)) {
            this.m_elementModifiedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeElementModifiedListener(ElementModifiedListener l) {
        if (this.m_elementModifiedListeners != null && this.m_elementModifiedListeners.contains(l)) {
            this.m_elementModifiedListeners.remove(l);
        }
    }

    protected void fireElementModified(ElementEvent event) {
        if (this.m_elementModifiedListeners != null) {
            Vector vector = this.m_elementModifiedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ElementModifiedListener)vector.elementAt(i)).elementModified(event);
            }
        }
    }

    static void elementModifiedCallBack(MapLayoutControl mapLayoutControl, int elementID) {
        if (mapLayoutControl != null) {
            boolean bl = false;
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, elementID, bl);
            mapLayoutControl.fireElementModified(elementEvent);
        }
    }

    public synchronized void addPointInputedListener(PointInputedListener l) {
        if (this.m_pointInputedListeners == null) {
            this.m_pointInputedListeners = new Vector();
        }
        if (!this.m_pointInputedListeners.contains(l)) {
            this.m_pointInputedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removePointInputedListener(PointInputedListener l) {
        if (this.m_pointInputedListeners != null && this.m_pointInputedListeners.contains(l)) {
            this.m_pointInputedListeners.remove(l);
        }
    }

    protected void firePointInputed(PointInputedEvent event) {
        if (this.m_pointInputedListeners != null) {
            Vector vector = this.m_pointInputedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((PointInputedListener)vector.elementAt(i)).pointInputed(event);
            }
        }
    }

    static void pointInputedCallBack(MapLayoutControl mapLayoutControl, double x, double y, double z) {
        if (mapLayoutControl != null) {
            PointInputedEvent pointInputedEvent = new PointInputedEvent((Object)mapLayoutControl, x, y, z);
            mapLayoutControl.firePointInputed(pointInputedEvent);
        }
    }

    public synchronized void addActionCursorChangingListener(ActionCursorChangingListener l) {
        if (this.m_actionCursorChangingListeners == null) {
            this.m_actionCursorChangingListeners = new Vector();
        }
        if (!this.m_actionCursorChangingListeners.contains(l)) {
            this.m_actionCursorChangingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeActionCursorChangingListener(ActionCursorChangingListener l) {
        if (this.m_actionCursorChangingListeners != null && this.m_actionCursorChangingListeners.contains(l)) {
            this.m_actionCursorChangingListeners.remove(l);
        }
    }

    protected void fireActionCursorChanging(ActionCursorChangingEvent event) {
        if (this.m_actionCursorChangingListeners != null) {
            Vector vector = this.m_actionCursorChangingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ActionCursorChangingListener)vector.elementAt(i)).actionCursorChanging(event);
            }
        }
    }

    public synchronized void addTrackingListener(TrackingListener l) {
        if (this.m_trackingListeners == null) {
            this.m_trackingListeners = new Vector();
        }
        if (!this.m_trackingListeners.contains(l)) {
            this.m_trackingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeTrackingListener(TrackingListener l) {
        if (this.m_trackingListeners != null && this.m_trackingListeners.contains(l)) {
            this.m_trackingListeners.remove(l);
        }
    }

    protected void fireTracking(TrackingEvent event) {
        double d = this.computeAzimuth(event.getX(), event.getY());
        this.m_lastPoint.setX(event.getX());
        this.m_lastPoint.setY(event.getY());
        this.m_lastAngle = event.getAngle();
        this.m_lastArea = event.getArea();
        this.m_lastAzimuth = event.getCurrentAzimuth();
        this.m_lastLength = event.getLength();
        event.setCurrentAzimuth(d);
        if (this.m_trackingListeners != null) {
            Vector vector = this.m_trackingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((TrackingListener)vector.elementAt(i)).tracking(event);
            }
        }
    }

    private double computeAzimuth(double x, double y) {
        double d = 0.0;
        if (this.m_lastPoint.getX() == -1.7976931348623157E308 && this.m_lastPoint.getY() == -1.7976931348623157E308) {
            d = this.m_lastPoint.getY() >= y ? Math.asin((this.m_lastPoint.getX() - x) / Math.sqrt((this.m_lastPoint.getX() - x) * (this.m_lastPoint.getX() - x) - (this.m_lastPoint.getY() - y) * (this.m_lastPoint.getY() - y))) / Math.PI * 180.0 - 90.0 : (this.m_lastPoint.getX() > x ? 0.0 - (Math.asin((this.m_lastPoint.getX() - x) / Math.sqrt((this.m_lastPoint.getX() - x) * (this.m_lastPoint.getX() - x) - (this.m_lastPoint.getY() - y) * (this.m_lastPoint.getY() - y))) / Math.PI * 180.0 - 90.0) + 360.0 : 270.0 - Math.asin((this.m_lastPoint.getX() - x) / Math.sqrt((this.m_lastPoint.getX() - x) * (this.m_lastPoint.getX() - x) - (this.m_lastPoint.getY() - y) * (this.m_lastPoint.getY() - y))) / Math.PI * 180.0);
        }
        return d;
    }

    static void trackingCallBack(MapLayoutControl mapLayoutControl, double x, double y, double length, double totalLength, double angle, double area) {
        if (mapLayoutControl != null) {
            Geometry geometry = null;
            long l = MapLayoutControlNative.jni_getTrackingGeometry(mapLayoutControl.m_handle);
            if (l != 0L) {
                geometry = InternalLayoutGeometry.createInstance2(l, null);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, (boolean)false);
            }
            TrackingEvent trackingEvent = new TrackingEvent((Object)mapLayoutControl, x, y, length, angle, 0.0, area, totalLength, geometry);
            mapLayoutControl.fireTracking(trackingEvent);
        }
    }

    public synchronized void addTrackedListener(TrackedListener l) {
        if (this.m_trackedListeners == null) {
            this.m_trackedListeners = new Vector();
        }
        if (!this.m_trackedListeners.contains(l)) {
            this.m_trackedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeTrackedListener(TrackedListener l) {
        if (this.m_trackedListeners != null && this.m_trackedListeners.contains(l)) {
            this.m_trackedListeners.remove(l);
        }
    }

    protected void fireTracked(TrackedEvent event) {
        event.setAngle(this.m_lastAngle);
        event.setArea(this.m_lastArea);
        event.setAzimuth(this.m_lastAzimuth);
        event.setLength(this.m_lastLength);
        if (this.m_trackedListeners != null) {
            Vector vector = this.m_trackedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((TrackedListener)vector.elementAt(i)).tracked(event);
            }
        }
    }

    static void trackedCallBack(MapLayoutControl mapLayoutControl) {
        if (mapLayoutControl != null) {
            Geometry geometry = null;
            long l = MapLayoutControlNative.jni_getTrackGeometry(mapLayoutControl.m_handle);
            if (l != 0L) {
                geometry = InternalLayoutGeometry.createInstance2(l, null);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, (boolean)false);
            }
            TrackedEvent trackedEvent = new TrackedEvent((Object)mapLayoutControl, geometry, 0.0, 0.0, 0.0, 0.0);
            if (!mapLayoutControl.getLayoutAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT) && !mapLayoutControl.getLayoutAction().equals((Object)Action.CREATETEXT)) {
                mapLayoutControl.fireTracked(trackedEvent);
            }
        }
    }

    Geometry[] getEditGeometries() {
        long[] lArray = MapLayoutControlNative.jni_GetEditGeometries(this.m_handle);
        Geometry[] geometryArray = new Geometry[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geometryArray[i] = InternalMappingGeometry.createInstance2((long)lArray[i]);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometryArray[i], (boolean)false);
        }
        return geometryArray;
    }

    public synchronized void addEditHandleMoveListener(EditHandleMoveListener l) {
        if (this.m_editHandleMoveListeners == null) {
            this.m_editHandleMoveListeners = new Vector();
        }
        if (!this.m_editHandleMoveListeners.contains(l)) {
            this.m_editHandleMoveListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeEditHandleMoveListener(EditHandleMoveListener l) {
        if (this.m_editHandleMoveListeners != null && this.m_editHandleMoveListeners.contains(l)) {
            this.m_editHandleMoveListeners.remove(l);
        }
    }

    protected void fireEditHandleMove(EditHandleEvent event) {
        if (this.m_editHandleMoveListeners != null) {
            Vector vector = this.m_editHandleMoveListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((EditHandleMoveListener)vector.elementAt(i)).editHandleMove(event);
            }
        }
    }

    static void editHandleMoveCallBack(MapLayoutControl mapLayoutControl, int editHandleType, long cancelHandle, int[] editHandles, double x, double y) {
        if (mapLayoutControl != null) {
            EditHandleType editHandleType2 = null;
            try {
                editHandleType2 = (EditHandleType)InternalEnum.parse(EditHandleType.class, (int)editHandleType);
            }
            catch (Exception exception) {
                editHandleType2 = null;
            }
            EditHandleEvent editHandleEvent = null;
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue((long)cancelHandle);
            Geometry[] geometryArray = mapLayoutControl.getEditGeometries();
            if (editHandles.length > 0 && editHandles[0] != -1) {
                Geometry geometry = geometryArray[0];
                int[] nArray = InternalMappingGeometry.getSpatialData2((long)InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
                int n = -1;
                int[] nArray2 = new int[editHandles.length];
                if (editHandles[0] - 10 >= 0) {
                    int n2 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (editHandles[0] - 10 >= (n2 += nArray[i])) continue;
                        n = i;
                        for (int j = 0; j < nArray2.length; ++j) {
                            nArray2[j] = editHandles[j] - 10 - (n2 - nArray[i]);
                        }
                        break;
                    }
                    editHandleEvent = new EditHandleEvent((Object)mapLayoutControl, x, y, editHandleType2, bl, nArray2, n, geometryArray);
                } else {
                    editHandleEvent = new EditHandleEvent((Object)mapLayoutControl, x, y, editHandleType2, bl, new int[0], -1, geometryArray);
                }
            } else {
                editHandleEvent = new EditHandleEvent((Object)mapLayoutControl, x, y, editHandleType2, bl, new int[0], -1, geometryArray);
            }
            mapLayoutControl.fireEditHandleMove(editHandleEvent);
            InternalToolkitMappingUI.setHandleBooleanValue((long)cancelHandle, (boolean)editHandleEvent.getCancel());
        }
    }

    public void setDefaultEditGeoStyle(GeoStyle style) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString((String)"setDefaultEditGeoStyle(GeoStyle style)", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalMappingResource.loadString((String)"style", (String)"Global_ArgumentNull", (String)"ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalMappingResource.loadString((String)"GeoStyle style", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutControlNative.jni_SetDefaultEditGeoStyle(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public GeoStyle getDefaultEditGeoStyle() {
        long l;
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString((String)"getDefaultEditGeoStyle()", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_defaultEditStyle == null && (l = MapLayoutControlNative.jni_GetDefaultEditGeoStyle(this.m_handle)) != 0L) {
            this.m_defaultEditStyle = InternalMappingGeoStyle.createInstance((long)l);
        }
        return this.m_defaultEditStyle;
    }

    public void setTrackingZoomAndSelectStyle(GeoStyle style) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString((String)"setTrackingZoomAndSelectStyle(GeoStyle style)", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalMappingResource.loadString((String)"style", (String)"Global_ArgumentNull", (String)"ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalMappingResource.loadString((String)"GeoStyle style", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutControlNative.jni_SetTrackingZoomAndSelectStyle(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public GeoStyle getTrackingZoomAndSelectStyle() {
        long l;
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString((String)"getDefaultEditGeoStyle()", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_trackingZoomAndSelectStyle == null && (l = MapLayoutControlNative.jni_GetTrackingZoomAndSelectStyle(this.m_handle)) != 0L) {
            this.m_trackingZoomAndSelectStyle = InternalMappingGeoStyle.createInstance((long)l);
        }
        return this.m_trackingZoomAndSelectStyle;
    }

    void clearHandle() {
        if (this.m_layout != null) {
            InternalMapLayout.clearHandle(this.m_layout);
            this.m_layout = null;
        }
    }

    public void dispose() {
        this.clearHandle();
        if (this.m_handle != 0L) {
            MapLayoutControlNative.jni_Delete(this.m_handle);
            this.m_handle = 0L;
        }
        if (this.m_bufferImage != null) {
            this.m_bufferImage.dispose();
        }
        this.unLoadLicense();
    }

    static {
        InternalLayoutEnvironment.LoadWrapJ();
    }

    public static class Cursors {
        private static Cursor m_busy = null;
        private static Cursor m_arrow = null;
        private static Cursor m_marginPanLeft = null;
        private static Cursor m_marginPanRight = null;
        private static Cursor m_marginPanTop = null;
        private static Cursor m_marginPanBottom = null;
        private static Cursor m_marginPanTopLeft = null;
        private static Cursor m_marginPanTopRight = null;
        private static Cursor m_marginPanBottomRightt = null;
        private static Cursor m_marginPanBottomLeft = null;
        private static Cursor m_zoomFree = null;
        private static Cursor m_pan2 = null;
        private static Cursor m_zoomFree2 = null;
        private static Cursor m_select = null;
        private static Cursor m_pan = null;
        private static Cursor m_zoonOut = null;
        private static Cursor m_zoonIn = null;
        private static Cursor m_selectRegion = null;
        private static Cursor m_select2 = null;
        private static Cursor m_line = null;
        private static Cursor m_point = null;
        private static Cursor m_selectCircle = null;
        private static Cursor m_selectLine = null;
        private static Cursor m_polyline = null;
        private static Cursor m_circle = null;
        private static Cursor m_polygon = null;
        private static Cursor m_text = null;
        private static Cursor m_alongLineText = null;
        private static Cursor m_parallel = null;
        private static Cursor m_pie = null;
        private static Cursor m_parallelogram = null;
        private static Cursor m_cross = null;
        private static Cursor m_rotation = null;
        private static Cursor m_roundRectangle = null;
        private static Cursor m_circle2P = null;
        private static Cursor m_circle3P = null;
        private static Cursor m_ellipse = null;
        private static Cursor m_ellipseArc = null;
        private static Cursor m_arc3P = null;
        private static Cursor m_curve = null;
        private static Cursor m_rectangle = null;
        private static Cursor m_beam = null;
        private static Cursor m_move = null;
        private static Cursor m_northSouth = null;
        private static Cursor m_westEast = null;
        private static Cursor m_northeastSouthwest = null;
        private static Cursor m_northwestSoutheast = null;
        private static Cursor m_snapPoint = null;
        private static Cursor m_snapVertex = null;
        private static Cursor m_snapMidpoint = null;
        private static Cursor m_snapLine = null;
        private static Cursor m_obliqueEllipse = null;
        private static Cursor m_snapVertical = null;
        private static Cursor m_snapParallel = null;
        private static Cursor m_moveRotationBase = null;
        private static Cursor m_rectangleSelect = null;
        private static Cursor m_createNorthArrow = null;
        private static Cursor m_createMapScale = null;
        private static Cursor m_createGeoLegend = null;
        private static Cursor m_selectHorizontalRulerLine;
        private static Cursor m_selectVerticalRulerLine;
        private static Cursor m_createBSpline;
        private static Cursor m_createFreePolyline;
        private static Cursor m_createCardinal;
        private static String imagePath;

        private Cursors() {
        }

        private static Cursor setCursorFromFile(String fileName) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/MapControl.class");
            String string = uRL.getFile();
            int n = string.indexOf("com/supermap/ui/MapControl.class");
            string = string.substring(0, n);
            Image image = null;
            String string2 = string + "Mapping/Resources/" + fileName;
            File file = new File(string2);
            if (file.exists()) {
                image = toolkit.createImage(string2);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/mappingImage/" + fileName);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(7, 7), "");
            }
            return cursor;
        }

        private static Cursor setCursorFromFile(String fileName, int x, int y) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/MapControl.class");
            String string = uRL.getFile();
            int n = string.indexOf("com/supermap/ui/MapControl.class");
            string = string.substring(0, n);
            Image image = null;
            String string2 = string + "Mapping/Resources/" + fileName;
            File file = new File(string2);
            if (file.exists()) {
                image = toolkit.createImage(string2);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/mappingImage/" + fileName);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(x, y), "");
            }
            return cursor;
        }

        public static Cursor getBusy() {
            if (m_busy == null) {
                m_busy = Cursors.setCursorFromFile(imagePath + "busy.gif");
            }
            return m_busy;
        }

        public static void setBusy(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_busy = cursor;
        }

        public static Cursor getArrow() {
            if (m_arrow == null) {
                m_arrow = Cursors.setCursorFromFile(imagePath + "null.gif");
            }
            return m_arrow;
        }

        public static void setArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_arrow = cursor;
        }

        public static Cursor getMarginPanLeft() {
            if (m_marginPanLeft == null) {
                m_marginPanLeft = Cursors.setCursorFromFile(imagePath + "marginPanLeft.gif", 0, 15);
            }
            return m_marginPanLeft;
        }

        public static void setMarginPanLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanLeft = cursor;
        }

        public static Cursor getMarginPanRight() {
            if (m_marginPanRight == null) {
                m_marginPanRight = Cursors.setCursorFromFile(imagePath + "marginPanRight.gif", 30, 10);
            }
            return m_marginPanRight;
        }

        public static void setMarginPanRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanRight = cursor;
        }

        public static Cursor getMarginPanTop() {
            if (m_marginPanTop == null) {
                m_marginPanTop = Cursors.setCursorFromFile(imagePath + "marginPanTop.gif", 10, 0);
            }
            return m_marginPanTop;
        }

        public static void setMarginPanTop(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanTop = cursor;
        }

        public static Cursor getMarginPanBottom() {
            if (m_marginPanBottom == null) {
                m_marginPanBottom = Cursors.setCursorFromFile(imagePath + "marginPanBottom.gif", 10, 30);
            }
            return m_marginPanBottom;
        }

        public static void setMarginPanBottom(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanBottom = cursor;
        }

        public static Cursor getMarginPanTopLeft() {
            if (m_marginPanTopLeft == null) {
                m_marginPanTopLeft = Cursors.setCursorFromFile(imagePath + "marginPanBottomLeft.gif");
            }
            return m_marginPanTopLeft;
        }

        public static void setMarginPanTopLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanTopLeft = cursor;
        }

        public static Cursor getMarginPanTopRight() {
            if (m_marginPanTopRight == null) {
                m_marginPanTopRight = Cursors.setCursorFromFile(imagePath + "marginPanTopRight.gif", 30, 0);
            }
            return m_marginPanTopRight;
        }

        public static void setMarginPanTopRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanTopRight = cursor;
        }

        public static Cursor getMarginPanBottomRight() {
            if (m_marginPanBottomRightt == null) {
                m_marginPanBottomRightt = Cursors.setCursorFromFile(imagePath + "marginPanBottomRight.gif", 30, 30);
            }
            return m_marginPanBottomRightt;
        }

        public static void setMarginPanBottomRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanBottomRightt = cursor;
        }

        public static Cursor getMarginPanBottomLeft() {
            if (m_marginPanBottomLeft == null) {
                m_marginPanBottomLeft = Cursors.setCursorFromFile(imagePath + "marginPanBottomLeft.gif", 0, 30);
            }
            return m_marginPanBottomLeft;
        }

        public static void setMarginPanBottomLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanBottomLeft = cursor;
        }

        public static Cursor getZoomFree() {
            if (m_zoomFree == null) {
                m_zoomFree = Cursors.setCursorFromFile(imagePath + "zoomfree.gif");
            }
            return m_zoomFree;
        }

        public static void setZoomFree(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_zoomFree = cursor;
        }

        public static Cursor getZoomFree2() {
            if (m_zoomFree2 == null) {
                m_zoomFree2 = Cursors.setCursorFromFile(imagePath + "zoomfree1.gif");
            }
            return m_zoomFree2;
        }

        public static void setZoomFree2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_zoomFree2 = cursor;
        }

        public static Cursor getPan() {
            if (m_pan == null) {
                m_pan = Cursors.setCursorFromFile(imagePath + "pan.gif");
            }
            return m_pan;
        }

        public static void setPan(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_pan = cursor;
        }

        public static Cursor getPan2() {
            if (m_pan2 == null) {
                m_pan2 = Cursors.setCursorFromFile(imagePath + "Pan-1.gif");
            }
            return m_pan2;
        }

        public static void setPan2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_pan2 = cursor;
        }

        public static Cursor getZoonIn() {
            if (m_zoonIn == null) {
                m_zoonIn = Cursors.setCursorFromFile(imagePath + "zoomin.gif");
            }
            return m_zoonIn;
        }

        public static void setZoonIn(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_zoonIn = cursor;
        }

        public static Cursor getZoonOut() {
            if (m_zoonOut == null) {
                m_zoonOut = Cursors.setCursorFromFile(imagePath + "zoomout.gif");
            }
            return m_zoonOut;
        }

        public static void setZoonOut(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_zoonOut = cursor;
        }

        public static Cursor getSelect() {
            if (m_select == null) {
                m_select = Cursors.setCursorFromFile(imagePath + "select.gif", 4, 5);
            }
            return m_select;
        }

        public static void setSelect(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_select = cursor;
        }

        public static Cursor getSelect2() {
            if (m_select2 == null) {
                m_select2 = Cursors.setCursorFromFile(imagePath + "select.gif", 4, 5);
            }
            return m_select2;
        }

        public static void setSelect2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_select2 = cursor;
        }

        public static Cursor getSelectCircle() {
            if (m_selectCircle == null) {
                m_selectCircle = Cursors.setCursorFromFile(imagePath + "selectCircle.gif", 0, 0);
            }
            return m_selectCircle;
        }

        public static void setSelectCircle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_selectCircle = cursor;
        }

        public static Cursor getSelectRegion() {
            if (m_selectRegion == null) {
                m_selectRegion = Cursors.setCursorFromFile(imagePath + "selectregion.gif", 0, 0);
            }
            return m_selectRegion;
        }

        public static void setSelectRegion(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_selectRegion = cursor;
        }

        public static Cursor getCreatePoint() {
            if (m_point == null) {
                m_point = Cursors.setCursorFromFile(imagePath + "createPoint.gif");
            }
            return m_point;
        }

        public static void setCreatePoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_point = cursor;
        }

        public static Cursor getCreateLine() {
            if (m_line == null) {
                m_line = Cursors.setCursorFromFile(imagePath + "createline.gif");
            }
            return m_line;
        }

        public static void setCreateLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_line = cursor;
        }

        public static Cursor getCreatePolyline() {
            if (m_polyline == null) {
                m_polyline = Cursors.setCursorFromFile(imagePath + "createPolyLine.gif");
            }
            return m_polyline;
        }

        public static void setCreatePolyline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_polyline = cursor;
        }

        public static Cursor getCreateEllipseArc() {
            if (m_ellipseArc == null) {
                m_ellipseArc = Cursors.setCursorFromFile(imagePath + "createEllipseArc.gif");
            }
            return m_ellipseArc;
        }

        public static void setCreateEllipseArc(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_ellipseArc = cursor;
        }

        public static Cursor getCreateArc3P() {
            if (m_arc3P == null) {
                m_arc3P = Cursors.setCursorFromFile(imagePath + "createArc3p.gif");
            }
            return m_arc3P;
        }

        public static void setCreateArc3P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_arc3P = cursor;
        }

        public static Cursor getCreateCurve() {
            if (m_curve == null) {
                m_curve = Cursors.setCursorFromFile(imagePath + "createCurve.gif");
            }
            return m_curve;
        }

        public static void setCreateCurve(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_curve = cursor;
        }

        public static Cursor getCreateRectangle() {
            if (m_rectangle == null) {
                m_rectangle = Cursors.setCursorFromFile(imagePath + "createRectangle.gif");
            }
            return m_rectangle;
        }

        public static void setCreateRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_rectangle = cursor;
        }

        public static Cursor getCreateRoundRectangle() {
            if (m_roundRectangle == null) {
                m_roundRectangle = Cursors.setCursorFromFile(imagePath + "createRoundRectangle.gif");
            }
            return m_roundRectangle;
        }

        public static void setCreateRoundRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_roundRectangle = cursor;
        }

        public static Cursor getCreateCircle() {
            if (m_circle == null) {
                m_circle = Cursors.setCursorFromFile(imagePath + "createCircle.gif");
            }
            return m_circle;
        }

        public static void setCreateCircle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_circle = cursor;
        }

        public static Cursor getCreateCircle2P() {
            if (m_circle2P == null) {
                m_circle2P = Cursors.setCursorFromFile(imagePath + "createCircle2p.gif");
            }
            return m_circle2P;
        }

        public static void setCreateCircle2P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_circle2P = cursor;
        }

        public static Cursor getCreateCircle3P() {
            if (m_circle3P == null) {
                m_circle3P = Cursors.setCursorFromFile(imagePath + "createCircle3p.gif");
            }
            return m_circle3P;
        }

        public static void setCreateCircle3P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_circle3P = cursor;
        }

        public static Cursor getCreateEllipse() {
            if (m_ellipse == null) {
                m_ellipse = Cursors.setCursorFromFile(imagePath + "createEllipse.gif");
            }
            return m_ellipse;
        }

        public static void setCreateEllipse(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_ellipse = cursor;
        }

        public static Cursor getCreateObliqueEllipse() {
            if (m_obliqueEllipse == null) {
                m_obliqueEllipse = Cursors.setCursorFromFile(imagePath + "createObliqueEllipse.gif");
            }
            return m_obliqueEllipse;
        }

        public static void setCreateObliqueEllipse(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_obliqueEllipse = cursor;
        }

        public static Cursor getCreatePolygon() {
            if (m_polygon == null) {
                m_polygon = Cursors.setCursorFromFile(imagePath + "createPolygon.gif");
            }
            return m_polygon;
        }

        public static void setCreatePolygon(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_polygon = cursor;
        }

        public static Cursor getCreateText() {
            if (m_text == null) {
                m_text = Cursors.setCursorFromFile(imagePath + "createText.gif");
            }
            return m_text;
        }

        public static void setCreateText(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_text = cursor;
        }

        public static Cursor getCreateAlongLineText() {
            if (m_alongLineText == null) {
                m_alongLineText = Cursors.setCursorFromFile(imagePath + "createAlongLineText.gif");
            }
            return m_alongLineText;
        }

        public static void setCreateAlongLineText(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_alongLineText = cursor;
        }

        public static Cursor getCreateParallel() {
            if (m_parallel == null) {
                m_parallel = Cursors.setCursorFromFile(imagePath + "createparallel.gif");
            }
            return m_parallel;
        }

        public static void setCreateParallel(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_parallel = cursor;
        }

        public static Cursor getCreatePie() {
            if (m_pie == null) {
                m_pie = Cursors.setCursorFromFile(imagePath + "createPie.gif");
            }
            return m_pie;
        }

        public static void setCreatePie(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_pie = cursor;
        }

        public static Cursor getCreateParallelogram() {
            if (m_parallelogram == null) {
                m_parallelogram = Cursors.setCursorFromFile(imagePath + "createParallelogram.gif");
            }
            return m_parallelogram;
        }

        public static void setCreateParallelogram(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_parallelogram = cursor;
        }

        public static Cursor getCross() {
            if (m_cross == null) {
                m_cross = Cursors.setCursorFromFile(imagePath + "cross.gif");
            }
            return m_cross;
        }

        public static void setCross(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_cross = cursor;
        }

        public static Cursor getRotation() {
            if (m_rotation == null) {
                m_rotation = Cursors.setCursorFromFile(imagePath + "rotation.gif");
            }
            return m_rotation;
        }

        public static void setRotation(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_rotation = cursor;
        }

        public static Cursor getBeam() {
            if (m_beam == null) {
                m_beam = Cursors.setCursorFromFile(imagePath + "beam.gif");
            }
            return m_beam;
        }

        public static void setBeam(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_beam = cursor;
        }

        public static Cursor getMove() {
            if (m_move == null) {
                m_move = Cursors.setCursorFromFile(imagePath + "move.gif", 0, 0);
            }
            return m_move;
        }

        public static void setMove(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_move = cursor;
        }

        public static Cursor getNorthSouth() {
            if (m_northSouth == null) {
                m_northSouth = Cursors.setCursorFromFile(imagePath + "northSouth.gif");
            }
            return m_northSouth;
        }

        public static void setNorthSouth(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_northSouth = cursor;
        }

        public static Cursor getSelectLine() {
            if (m_selectLine == null) {
                m_selectLine = Cursors.setCursorFromFile(imagePath + "selectLine.gif", 0, 0);
            }
            return m_selectLine;
        }

        public void setSelectLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_selectLine = cursor;
        }

        public static Cursor getWestEast() {
            if (m_westEast == null) {
                m_westEast = Cursors.setCursorFromFile(imagePath + "weateast.gif");
            }
            return m_westEast;
        }

        public static void setWestEast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_westEast = cursor;
        }

        public static Cursor getNortheastSouthwest() {
            if (m_northeastSouthwest == null) {
                m_northeastSouthwest = Cursors.setCursorFromFile(imagePath + "northeastSouthwest.gif");
            }
            return m_northeastSouthwest;
        }

        public static void setNortheastSouthwest(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_northeastSouthwest = cursor;
        }

        public static Cursor getNorthwestSoutheast() {
            if (m_northwestSoutheast == null) {
                m_northwestSoutheast = Cursors.setCursorFromFile(imagePath + "northwestSoutheast.gif");
            }
            return m_northwestSoutheast;
        }

        public static void setNorthwestSoutheast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_northwestSoutheast = cursor;
        }

        public static Cursor getSnapPoint() {
            if (m_snapPoint == null) {
                m_snapPoint = Cursors.setCursorFromFile(imagePath + "snapPoint.gif");
            }
            return m_snapPoint;
        }

        public static void setSnapPoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapPoint = cursor;
        }

        public static Cursor getSnapVertex() {
            if (m_snapVertex == null) {
                m_snapVertex = Cursors.setCursorFromFile(imagePath + "snapVertex.gif");
            }
            return m_snapVertex;
        }

        public static void setSnapVertex(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapVertex = cursor;
        }

        public static Cursor getSnapMidpoint() {
            if (m_snapMidpoint == null) {
                m_snapMidpoint = Cursors.setCursorFromFile(imagePath + "snapMidpoint.gif");
            }
            return m_snapMidpoint;
        }

        public static void setSnapMidpoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapMidpoint = cursor;
        }

        public static Cursor getSnapLine() {
            if (m_snapLine == null) {
                m_snapLine = Cursors.setCursorFromFile(imagePath + "snapLine.gif");
            }
            return m_snapLine;
        }

        public static void setSnapLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapLine = cursor;
        }

        public static Cursor getSnapVertical() {
            if (m_snapVertical == null) {
                m_snapVertical = Cursors.setCursorFromFile(imagePath + "snapVertical.gif");
            }
            return m_snapVertical;
        }

        public static void setSnapVertical(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapVertical = cursor;
        }

        public static Cursor getSnapParallel() {
            if (m_snapParallel == null) {
                m_snapParallel = Cursors.setCursorFromFile(imagePath + "snapParallel.gif");
            }
            return m_snapParallel;
        }

        public static void setSnapParallel(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapParallel = cursor;
        }

        public static Cursor getMoveRotationBase() {
            if (m_moveRotationBase == null) {
                m_moveRotationBase = Cursors.setCursorFromFile(imagePath + "moveRotationBase.gif");
            }
            return m_moveRotationBase;
        }

        public static void setMoveRotationBase(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_moveRotationBase = cursor;
        }

        public static Cursor getSelectRectangle() {
            if (m_rectangleSelect == null) {
                m_rectangleSelect = Cursors.setCursorFromFile(imagePath + "selectRect.gif", 0, 0);
            }
            return m_rectangleSelect;
        }

        public static void setSelectRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_rectangleSelect = cursor;
        }

        public static Cursor getCreateNorthArrow() {
            if (m_createNorthArrow == null) {
                m_createNorthArrow = Cursors.setCursorFromFile(imagePath + "createNorthArrow.gif");
            }
            return m_createNorthArrow;
        }

        public static void setCreateNorthArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_createNorthArrow = cursor;
        }

        public static Cursor getCreateMapScale() {
            if (m_createMapScale == null) {
                m_createMapScale = Cursors.setCursorFromFile(imagePath + "createMapScale.gif");
            }
            return m_createMapScale;
        }

        public static void setCreateMapScale(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_createMapScale = cursor;
        }

        public static Cursor getCreateGeoLegend() {
            if (m_createGeoLegend == null) {
                m_createGeoLegend = Cursors.setCursorFromFile(imagePath + "createRectangle.gif");
            }
            return m_createGeoLegend;
        }

        public void setCreateGeoLegend(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_createGeoLegend = cursor;
        }

        public static Cursor getSelectVerticalRulerLine() {
            if (m_selectVerticalRulerLine == null) {
                m_selectVerticalRulerLine = Cursors.setCursorFromFile(imagePath + "selectverticalrulerline.gif");
            }
            return m_selectVerticalRulerLine;
        }

        public void setSelectVerticalRulerLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_selectVerticalRulerLine = cursor;
        }

        public static Cursor getSelectHorizontalRulerLine() {
            if (m_selectHorizontalRulerLine == null) {
                m_selectHorizontalRulerLine = Cursors.setCursorFromFile(imagePath + "selecthorizontalrulerline.gif");
            }
            return m_selectHorizontalRulerLine;
        }

        public void setSelectHorizontalRulerLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            m_selectHorizontalRulerLine = cursor;
        }

        public static Cursor getCreateBSpline() {
            if (m_createBSpline == null) {
                m_createBSpline = Cursors.setCursorFromFile(imagePath + "createBSpline.gif");
            }
            return m_createBSpline;
        }

        public void setCreateBSpline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString((String)"cursor", (String)"Global_ArgumentNull", (String)"ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createBSpline = cursor;
        }

        public static Cursor getCreateFreePolyline() {
            if (m_createFreePolyline == null) {
                m_createFreePolyline = Cursors.setCursorFromFile(imagePath + "createFreePolyline.gif");
            }
            return m_createFreePolyline;
        }

        public void setCreateFreePolyline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString((String)"cursor", (String)"Global_ArgumentNull", (String)"ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createFreePolyline = cursor;
        }

        public static Cursor getCreateCardinal() {
            if (m_createCardinal == null) {
                m_createCardinal = Cursors.setCursorFromFile(imagePath + "createCardinal.gif");
            }
            return m_createCardinal;
        }

        public void setCreateCardinal(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString((String)"cursor", (String)"Global_ArgumentNull", (String)"ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createCardinal = cursor;
        }

        static {
            m_createBSpline = null;
            m_createFreePolyline = null;
            m_createCardinal = null;
            imagePath = "";
        }
    }
}

