/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Charset;
import com.supermap.data.Dataset;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.CADRasterImageSetting;
import com.supermap.data.conversion.DataExportNative;
import com.supermap.data.conversion.ExportFieldModifyInfo;
import com.supermap.data.conversion.ExportResult;
import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.ExportSettingBMP;
import com.supermap.data.conversion.ExportSettingCSV;
import com.supermap.data.conversion.ExportSettingDWG;
import com.supermap.data.conversion.ExportSettingDXF;
import com.supermap.data.conversion.ExportSettingE00;
import com.supermap.data.conversion.ExportSettingEGC;
import com.supermap.data.conversion.ExportSettingFileGDBVector;
import com.supermap.data.conversion.ExportSettingGIF;
import com.supermap.data.conversion.ExportSettingGJB;
import com.supermap.data.conversion.ExportSettingGJB9121;
import com.supermap.data.conversion.ExportSettingGeoJson;
import com.supermap.data.conversion.ExportSettingJPG;
import com.supermap.data.conversion.ExportSettingKML;
import com.supermap.data.conversion.ExportSettingKMZ;
import com.supermap.data.conversion.ExportSettingModelX;
import com.supermap.data.conversion.ExportSettingPNG;
import com.supermap.data.conversion.ExportSettingPersonalGDBVector;
import com.supermap.data.conversion.ExportSettingSIT;
import com.supermap.data.conversion.ExportSettingSimpleJson;
import com.supermap.data.conversion.ExportSettingTAB;
import com.supermap.data.conversion.ExportSettingTEMSBuildingVector;
import com.supermap.data.conversion.ExportSettingTEMSTextLabels;
import com.supermap.data.conversion.ExportSettingTEMSVector;
import com.supermap.data.conversion.ExportSettingTIF;
import com.supermap.data.conversion.ExportSettingVCT;
import com.supermap.data.conversion.ExportSettings;
import com.supermap.data.conversion.ExportSteppedEvent;
import com.supermap.data.conversion.ExportSteppedListener;
import com.supermap.data.conversion.GJBExportLayerSetting;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalToolkiConversion;
import java.util.ArrayList;
import java.util.Vector;

public class DataExport
extends InternalHandleDisposable {
    private static License m_license;
    private ExportSettings m_ExportSettings = new ExportSettings();
    private long m_selfEventHandle;
    private int m_completed = 0;
    transient Vector m_steppedListeners;

    public DataExport() {
        this.setHandle(DataExportNative.jni_New(), true);
    }

    public ExportResult run() {
        DataExport.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("importData()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_selfEventHandle = DataExportNative.jni_NewSelfEventHandle(this.getHandle(), this);
        this.m_completed = 0;
        int n = this.m_ExportSettings.getCount();
        ArrayList<ExportSetting> arrayList = new ArrayList<ExportSetting>();
        ArrayList<ExportSetting> arrayList2 = new ArrayList<ExportSetting>();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                int n2;
                if (!this.m_ExportSettings.get(i).check()) {
                    arrayList2.add(this.m_ExportSettings.get(i));
                    continue;
                }
                long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)this.m_ExportSettings.get(i).getSourceData()));
                String string = this.m_ExportSettings.get(i).getTargetFilePath();
                int n3 = this.m_ExportSettings.get(i).getTargetFileType().value();
                boolean bl = this.m_ExportSettings.get(i).isOverwrite();
                Charset charset = this.m_ExportSettings.get(i).getTargetFileCharset();
                String[] stringArray = this.m_ExportSettings.get(i).getIgnoreFieldNames();
                String string2 = this.m_ExportSettings.get(i).getFilter();
                String[] stringArray2 = null;
                int[] nArray = null;
                int[] nArray2 = null;
                int[] nArray3 = null;
                ExportFieldModifyInfo[] exportFieldModifyInfoArray = this.m_ExportSettings.get(i).getModifyFieldInfos();
                if (exportFieldModifyInfoArray != null) {
                    stringArray2 = new String[exportFieldModifyInfoArray.length];
                    nArray = new int[exportFieldModifyInfoArray.length];
                    nArray2 = new int[exportFieldModifyInfoArray.length];
                    nArray3 = new int[exportFieldModifyInfoArray.length];
                    for (n2 = 0; n2 < exportFieldModifyInfoArray.length; ++n2) {
                        stringArray2[n2] = exportFieldModifyInfoArray[n2].getName();
                        nArray[n2] = exportFieldModifyInfoArray[n2].getType().value();
                        nArray2[n2] = exportFieldModifyInfoArray[n2].getPrecision();
                        nArray3[n2] = exportFieldModifyInfoArray[n2].getScale();
                    }
                }
                n2 = 0;
                if (this.m_ExportSettings.get(i) instanceof ExportSettingPNG) {
                    ExportSettingPNG exportSettingPNG = (ExportSettingPNG)this.m_ExportSettings.get(i);
                    n2 = DataExportNative.jni_ExportDataPNG(this.getHandle(), l, string, bl, exportSettingPNG.getWorldFilePath()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingTIF) {
                    ExportSettingTIF exportSettingTIF = (ExportSettingTIF)this.m_ExportSettings.get(i);
                    object2 = exportSettingTIF.getCompression();
                    n2 = DataExportNative.jni_ExportDataTIF(this.getHandle(), l, string, bl, exportSettingTIF.isExportingPRJFile(), exportSettingTIF.isExportingGeoTransformFile(), exportSettingTIF.isExportAsTile(), object2.value()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingBMP) {
                    ExportSettingBMP exportSettingBMP = (ExportSettingBMP)this.m_ExportSettings.get(i);
                    n2 = DataExportNative.jni_ExportDataBMP(this.getHandle(), l, string, bl, exportSettingBMP.getWorldFilePath()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingDWG) {
                    ExportSettingDWG exportSettingDWG = (ExportSettingDWG)this.m_ExportSettings.get(i);
                    object2 = exportSettingDWG.getRasterImageSettings();
                    object = null;
                    if (object2 != null) {
                        object = new long[((CADRasterImageSetting[])object2).length];
                        for (int j = 0; j < ((CADRasterImageSetting[])object2).length; ++j) {
                            object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)object2[j]);
                        }
                    }
                    n2 = DataExportNative.jni_ExportDataDWG(this.getHandle(), l, stringArray, string, bl, exportSettingDWG.getVersion().value(), exportSettingDWG.isExportingExternalData(), exportSettingDWG.isExportingXRecord(), exportSettingDWG.isExportingBorder(), exportSettingDWG.m_strStyleMappingPath, string2, object, exportSettingDWG.isExportPolylineWidth()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingDXF) {
                    ExportSettingDXF exportSettingDXF = (ExportSettingDXF)this.m_ExportSettings.get(i);
                    object2 = exportSettingDXF.getRasterImageSettings();
                    object = null;
                    if (object2 != null) {
                        object = new long[((CADRasterImageSetting[])object2).length];
                        for (int j = 0; j < ((CADRasterImageSetting[])object2).length; ++j) {
                            object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)object2[j]);
                        }
                    }
                    n2 = DataExportNative.jni_ExportDataDXF(this.getHandle(), l, stringArray, string, bl, exportSettingDXF.getVersion().value(), exportSettingDXF.isExportingExternalData(), exportSettingDXF.isExportingXRecord(), exportSettingDXF.isExportingBorder(), string2, object, exportSettingDXF.isExportPolylineWidth()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingKML) {
                    ExportSettingKML exportSettingKML = (ExportSettingKML)this.m_ExportSettings.get(i);
                    int n4 = exportSettingKML.getSourceDatas().length;
                    object = new long[n4];
                    for (int j = 0; j < n4; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingKML.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataKML(this.getHandle(), object, string, bl, string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingKMZ) {
                    ExportSettingKMZ exportSettingKMZ = (ExportSettingKMZ)this.m_ExportSettings.get(i);
                    int n5 = exportSettingKMZ.getSourceDatas().length;
                    object = new long[n5];
                    for (int j = 0; j < n5; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingKMZ.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataKMZ(this.getHandle(), object, string, bl, string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingJPG) {
                    ExportSettingJPG exportSettingJPG = (ExportSettingJPG)this.m_ExportSettings.get(i);
                    n2 = DataExportNative.jni_ExportDataJPG(this.getHandle(), l, string, bl, exportSettingJPG.getWorldFilePath(), exportSettingJPG.getCompression()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingModelX) {
                    ExportSettingModelX exportSettingModelX = (ExportSettingModelX)this.m_ExportSettings.get(i);
                    n2 = DataExportNative.jni_ExportDataX(this.getHandle(), l, string, bl) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingGIF) {
                    ExportSettingGIF exportSettingGIF = (ExportSettingGIF)this.m_ExportSettings.get(i);
                    n2 = DataExportNative.jni_ExportDataGIF(this.getHandle(), l, string, bl, exportSettingGIF.getWorldFilePath()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingTEMSVector) {
                    ExportSettingTEMSVector exportSettingTEMSVector = (ExportSettingTEMSVector)this.m_ExportSettings.get(i);
                    int n6 = exportSettingTEMSVector.getSourceDatas().length;
                    object = new long[n6];
                    for (int j = 0; j < n6; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingTEMSVector.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataTEMSVector(this.getHandle(), object, string, bl, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingTEMSBuildingVector) {
                    ExportSettingTEMSBuildingVector exportSettingTEMSBuildingVector = (ExportSettingTEMSBuildingVector)this.m_ExportSettings.get(i);
                    int n7 = exportSettingTEMSBuildingVector.getSourceDatas().length;
                    object = new long[n7];
                    for (int j = 0; j < n7; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingTEMSBuildingVector.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataTEMSBuildingVector(this.getHandle(), object, string, bl, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingTEMSTextLabels) {
                    ExportSettingTEMSTextLabels exportSettingTEMSTextLabels = (ExportSettingTEMSTextLabels)this.m_ExportSettings.get(i);
                    int n8 = exportSettingTEMSTextLabels.getSourceDatas().length;
                    object = new long[n8];
                    for (int j = 0; j < n8; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingTEMSTextLabels.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataTEMSTextLabels(this.getHandle(), object, string, bl, charset.value(), string2, exportSettingTEMSTextLabels.getLabelName()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingSIT) {
                    ExportSettingSIT exportSettingSIT = (ExportSettingSIT)this.m_ExportSettings.get(i);
                    object2 = exportSettingSIT.getPassword();
                    n2 = DataExportNative.jni_ExportDataSIT(this.getHandle(), l, string, (String)object2, bl) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingE00) {
                    ExportSettingE00 exportSettingE00 = (ExportSettingE00)this.m_ExportSettings.get(i);
                    n2 = DataExportNative.jni_ExportDataE00(this.getHandle(), l, stringArray, string, bl, exportSettingE00.isExportingAsDoublePrecision(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingVCT) {
                    ExportSettingVCT exportSettingVCT = (ExportSettingVCT)this.m_ExportSettings.get(i);
                    int n9 = exportSettingVCT.getSourceDatas().length;
                    object = new long[n9];
                    for (int j = 0; j < n9; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingVCT.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataVCT(this.getHandle(), object, exportSettingVCT.getConfigFilePath(), stringArray, string, bl, charset.value(), string2, exportSettingVCT.getVersion().value()) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingPersonalGDBVector) {
                    ExportSettingPersonalGDBVector exportSettingPersonalGDBVector = (ExportSettingPersonalGDBVector)this.m_ExportSettings.get(i);
                    int n10 = exportSettingPersonalGDBVector.getSourceDatas().length;
                    object = new long[n10];
                    for (int j = 0; j < n10; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingPersonalGDBVector.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataPersonalGDBVector(this.getHandle(), object, stringArray, string, bl, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingFileGDBVector) {
                    ExportSettingFileGDBVector exportSettingFileGDBVector = (ExportSettingFileGDBVector)this.m_ExportSettings.get(i);
                    int n11 = exportSettingFileGDBVector.getSourceDatas().length;
                    object = new long[n11];
                    for (int j = 0; j < n11; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingFileGDBVector.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataFileGDBVector(this.getHandle(), object, stringArray, string, bl, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingGeoJson) {
                    ExportSettingGeoJson exportSettingGeoJson = (ExportSettingGeoJson)this.m_ExportSettings.get(i);
                    int n12 = exportSettingGeoJson.getSourceDatas().length;
                    object = new long[n12];
                    for (int j = 0; j < n12; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingGeoJson.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataGeoJson(this.getHandle(), object, stringArray, string, bl, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingSimpleJson) {
                    n2 = DataExportNative.jni_ExportDataSimpleJson(this.getHandle(), l, stringArray, string, bl, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingGJB) {
                    ExportSettingGJB exportSettingGJB = (ExportSettingGJB)this.m_ExportSettings.get(i);
                    int n13 = exportSettingGJB.getSourceDatas().length;
                    object = new long[n13];
                    for (int j = 0; j < n13; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingGJB.getSourceDatas()[j]));
                    }
                    GJBExportLayerSetting[] gJBExportLayerSettingArray = exportSettingGJB.getExportLayer();
                    long[] lArray = null;
                    if (gJBExportLayerSettingArray != null) {
                        lArray = new long[gJBExportLayerSettingArray.length];
                        for (int j = 0; j < gJBExportLayerSettingArray.length; ++j) {
                            lArray[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)gJBExportLayerSettingArray[j]);
                        }
                    }
                    n2 = DataExportNative.jni_ExportDataGJB(this.getHandle(), object, lArray, stringArray, string, bl, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingGJB9121) {
                    ExportSettingGJB9121 exportSettingGJB9121 = (ExportSettingGJB9121)this.m_ExportSettings.get(i);
                    int n14 = exportSettingGJB9121.getSourceDatas().length;
                    object = new long[n14];
                    for (int j = 0; j < n14; ++j) {
                        object[j] = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)((Dataset)exportSettingGJB9121.getSourceDatas()[j]));
                    }
                    n2 = DataExportNative.jni_ExportDataGJB9121(this.getHandle(), object, stringArray, string, bl, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingCSV) {
                    ExportSettingCSV exportSettingCSV = (ExportSettingCSV)this.m_ExportSettings.get(i);
                    boolean bl2 = !exportSettingCSV.GetIsExportPointAsWKT();
                    boolean bl3 = exportSettingCSV.getIsExportFieldName();
                    n2 = DataExportNative.jni_ExportDataCSV(this.getHandle(), l, stringArray, string, bl, bl2, bl3, charset.value(), string2) ? 1 : 0;
                } else if (this.m_ExportSettings.get(i) instanceof ExportSettingTAB) {
                    ExportSettingTAB exportSettingTAB = (ExportSettingTAB)this.m_ExportSettings.get(i);
                    n2 = DataExportNative.jni_ExportDataTAB(this.getHandle(), l, stringArray, string, exportSettingTAB.getStyleMappingTableFile(), bl, charset.value(), string2) ? 1 : 0;
                } else {
                    n2 = this.m_ExportSettings.get(i) instanceof ExportSettingEGC ? (int)(DataExportNative.jni_ExportDataEGC(this.getHandle(), l, string, bl) ? 1 : 0) : (int)(DataExportNative.jni_ExportDataNormal(this.getHandle(), l, stringArray, string, n3, bl, charset.value(), string2, stringArray2, nArray, nArray2, nArray3) ? 1 : 0);
                }
                ++this.m_completed;
                int n15 = this.m_completed * 100 / n;
                object2 = this.getExportSettings().get(this.m_completed - 1);
                object = new ExportSteppedEvent((Object)this, n15, 100, (ExportSetting)object2, n, false);
                this.fireStepped((ExportSteppedEvent)object);
                if (object.getCancel()) break;
                if (n2 != 0) {
                    arrayList.add(this.m_ExportSettings.get(i));
                    continue;
                }
                arrayList2.add(this.m_ExportSettings.get(i));
            }
        }
        this.clearSelfEventHandle();
        ExportSetting[] exportSettingArray = new ExportSetting[arrayList.size()];
        ExportSetting[] exportSettingArray2 = new ExportSetting[arrayList2.size()];
        arrayList.toArray(exportSettingArray);
        arrayList2.toArray(exportSettingArray2);
        return new ExportResult(exportSettingArray, exportSettingArray2);
    }

    public ExportSettings getExportSettings() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExportSettings()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_ExportSettings;
    }

    public void setExportSettings(ExportSettings settings) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExportSettings(ExportSettings settings)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_ExportSettings = settings;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            DataExportNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        this.clearSelfEventHandle();
    }

    public synchronized void addExportSteppedListener(ExportSteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeExportSteppedListener(ExportSteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(ExportSteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ExportSteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void exportSteppedCallBack(DataExport dataExport, int nPercent, long cancelHandle) {
        int n = nPercent;
        int n2 = dataExport.getExportSettings().getCount();
        int n3 = dataExport.m_completed;
        ExportSetting exportSetting = dataExport.getExportSettings().get(n3);
        if (n3 >= n2) {
            return;
        }
        int n4 = n3 * 100 / n2;
        Boolean bl = InternalToolkiConversion.getHandleBooleanValue(cancelHandle);
        ExportSteppedEvent exportSteppedEvent = new ExportSteppedEvent((Object)dataExport, n4, n, exportSetting, n2, bl);
        dataExport.fireStepped(exportSteppedEvent);
        InternalToolkiConversion.setHandleBooleanValue(cancelHandle, exportSteppedEvent.getCancel());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)dataExport));
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DataExportNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkiConversion.managerProducts(InternalToolkiConversion.getDataProducts());
        m_license = InternalToolkiConversion.verifyLicense(arrayList);
    }
}

