/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Geometry;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.InternalDatasetVector;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.ShadowVisibilityQueryNative;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;

public class ShadowVisibilityQuery
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;
    private static transient Vector m_steppedListeners;
    private static String m_senderMethodName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public ShadowVisibilityQuery(Scene scene) {
        ShadowVisibilityQuery.verifyLicense();
        this.m_scene = scene;
        long l = ShadowVisibilityQueryNative.jni_New("");
        this.setHandle(l, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            ShadowVisibilityQueryNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    public void setSpacing(double spacing) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpacing()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ShadowVisibilityQueryNative.jni_SetSpacing(this.getHandle(), spacing);
    }

    public double getSpacing() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpacing()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ShadowVisibilityQueryNative.jni_GetSpacing(this.getHandle());
    }

    public void setQueryRegion(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setQueryRegion()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry2, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        ShadowVisibilityQueryNative.jni_SetQueryRegion(this.getHandle(), l2);
    }

    public Geometry getQueryRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getQueryRegion()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = ShadowVisibilityQueryNative.jni_GetQueryRegion(this.getHandle());
        Geometry geometry = null;
        if (l != 0L && (geometry = InternalGeometry.createInstance(l)) != null) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public void setStartTime(Calendar value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartTime()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", value);
        ShadowVisibilityQueryNative.jni_SetStartTime(this.getHandle(), string);
    }

    public Calendar getStartTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartTime()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        String string = ShadowVisibilityQueryNative.jni_GetStartTime(this.getHandle());
        return this.dateTimeStringToCalendar(string);
    }

    private Calendar dateTimeStringToCalendar(String dateTime) {
        String[] stringArray = dateTime.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        return new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
    }

    public void setEndTime(Calendar value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndTime()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", value);
        ShadowVisibilityQueryNative.jni_SetEndTime(this.getHandle(), string);
    }

    public Calendar getEndTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndTime()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        String string = ShadowVisibilityQueryNative.jni_GetEndTime(this.getHandle());
        return this.dateTimeStringToCalendar(string);
    }

    public int getTimeInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeInterval()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ShadowVisibilityQueryNative.jni_GetTimeInterval(this.getHandle());
    }

    public void setTimeInterval(int minutes) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeInterval()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ShadowVisibilityQueryNative.jni_SetTimeInterval(this.getHandle(), minutes);
    }

    public void setColorDictTable(HashMap<Double, Color> colorTable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorDictTable()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = colorTable.size();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        Set<Map.Entry<Double, Color>> set = colorTable.entrySet();
        Iterator<Map.Entry<Double, Color>> iterator = set.iterator();
        Map.Entry<Double, Color> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            nArray[i] = entry.getValue().getRGB();
        }
        ShadowVisibilityQueryNative.jni_SetColorDictTable(this.getHandle(), dArray, nArray);
    }

    public HashMap<Double, Color> getColorDictTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorDictTable()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Double, Color> hashMap = new HashMap<Double, Color>();
        double[] dArray = ShadowVisibilityQueryNative.jni_GetColorTable_Keys(this.getHandle());
        int[] nArray = ShadowVisibilityQueryNative.jni_GetColotTable_Colors(this.getHandle());
        for (int i = 0; i < dArray.length; ++i) {
            hashMap.put(dArray[i], new Color(nArray[i], true));
        }
        return hashMap;
    }

    public double getShadowRatio(Point point) {
        return ShadowVisibilityQueryNative.jni_GetShadowRatio(this.getHandle(), point.getX(), point.getY());
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ShadowVisibilityQueryNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ShadowVisibilityQueryNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void setCurrentTimeZone(TimeZone value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentTimeZone()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ShadowVisibilityQueryNative.jni_SetTimeZoneOffset(this.getHandle(), -((int)((double)value.getRawOffset() / 60000.0)));
    }

    public TimeZone getCurrentTimeZone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentTimeZone()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = ShadowVisibilityQueryNative.jni_GetTimeZoneOffset(this.getHandle());
        String[] stringArray = TimeZone.getAvailableIDs(-(n * 1000 * 60));
        return TimeZone.getTimeZone(stringArray[0]);
    }

    public int getInViewport() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVisibilityQuery", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ShadowVisibilityQueryNative.jni_GetInViewport(this.getHandle());
    }

    public void setInViewport(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVisibilityQuery", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ShadowVisibilityQueryNative.jni_SetInViewport(this.getHandle(), value);
    }

    public boolean buildDatasetVolume(Datasource datasource, String dtName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildDatasetVolume()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (!datasource.isOpened()) {
            return false;
        }
        return ShadowVisibilityQueryNative.jni_BuildDatasetVolume(this.getHandle(), l, dtName);
    }

    public boolean buildDatasetPoint3Ds(Datasource targetDatasource, String dtName, String fieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowVisibilityQuery", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (targetDatasource == null) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        if (l == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (!targetDatasource.isOpened()) {
            return false;
        }
        boolean bl = false;
        long l2 = ShadowVisibilityQueryNative.jni_BuildDatasetPoint3Ds(this.getHandle(), l, dtName, fieldName);
        if (l2 != 0L) {
            DatasetVector datasetVector = InternalDatasetVector.createInstance(l2, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            bl = true;
        }
        return bl;
    }

    static void steppedCallBack(ShadowVisibilityQuery source, int percent, long remainTime, String title, String message, long cancelHandle) {
        Object object = new Object();
        m_senderMethodName = "ShadowQuery";
        boolean bl = InternalToolkitSpatialAnalyst3D.getHandleBooleanValue(cancelHandle);
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, m_senderMethodName, bl);
        ShadowVisibilityQuery.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst3D.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

