/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.navigation;

import com.supermap.analyst.navigation.DataVersion;
import com.supermap.analyst.navigation.InternalResource;
import com.supermap.analyst.navigation.PackageType;
import com.supermap.data.Datasource;

public class CompilerParameter {
    private Datasource m_datasource = null;
    private String m_nameRoadLine = "";
    private String m_nameRoadPoint = "";
    private String m_nameCondPoint = "";
    private String m_nameAdminCode = "";
    private String m_nameRoadNameLink = "";
    private String m_nameRoadName = "";
    private String m_workspace = "";
    private String m_district = "";
    private PackageType[] m_packageTypes = null;
    private DataVersion m_dataVersion;
    private int m_lang;

    public CompilerParameter() {
        this.m_nameRoadLine = "NG_T";
        this.m_nameRoadPoint = "NP";
        this.m_nameCondPoint = "CP";
        this.m_nameAdminCode = "AdminCodeA";
        this.m_nameRoadNameLink = "RL";
        this.m_nameRoadName = "R";
        this.m_dataVersion = DataVersion.NIG2013SUMGREATCHINA;
        this.m_lang = 1;
    }

    public CompilerParameter(CompilerParameter parameter) {
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.setDatasource(parameter.getDatasource());
        this.setNameRoadLine(parameter.getNameRoadLine());
        this.setNameRoadPoint(parameter.getNameRoadPoint());
        this.setNameCondPoint(parameter.getNameCondPoint());
        this.setNameAdminCode(parameter.getNameAdminCode());
        this.setExportPath(parameter.getExportPath());
        this.setDistrictName(parameter.getDistrictName());
    }

    public void setDatasource(Datasource datasource) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_datasource = datasource;
    }

    public void setNameRoadLine(String nameRoadLine) {
        if (nameRoadLine == null || nameRoadLine.trim().length() == 0) {
            String string = InternalResource.loadString("NG_TName", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nameRoadLine = nameRoadLine;
    }

    public void setNameRoadPoint(String nameRoadPoint) {
        if (nameRoadPoint == null || nameRoadPoint.trim().length() == 0) {
            String string = InternalResource.loadString("NPName", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nameRoadPoint = nameRoadPoint;
    }

    public void setNameCondPoint(String nameCondPoint) {
        if (nameCondPoint == null || nameCondPoint.trim().length() == 0) {
            String string = InternalResource.loadString("CPName", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nameCondPoint = nameCondPoint;
    }

    public void setNameAdminCode(String nameAdminCode) {
        if (nameAdminCode == null || nameAdminCode.trim().length() == 0) {
            String string = InternalResource.loadString("AdminCodeName", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nameAdminCode = nameAdminCode;
    }

    public Datasource getDatasource() {
        return this.m_datasource;
    }

    public String getNameRoadLine() {
        return this.m_nameRoadLine;
    }

    public String getNameRoadPoint() {
        return this.m_nameRoadPoint;
    }

    public String getNameCondPoint() {
        return this.m_nameCondPoint;
    }

    public String getNameAdminCode() {
        return this.m_nameAdminCode;
    }

    public void setNameRoadNameLink(String nameRoadNameLink) {
        if (nameRoadNameLink == null || nameRoadNameLink.trim().length() == 0) {
            String string = InternalResource.loadString("RLName", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nameRoadNameLink = nameRoadNameLink;
    }

    public void setNameRoadName(String nameRoadName) {
        if (nameRoadName == null || nameRoadName.trim().length() == 0) {
            String string = InternalResource.loadString("RName", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nameRoadName = nameRoadName;
    }

    public String getNameRoadNameLink() {
        return this.m_nameRoadNameLink;
    }

    public String getNameRoadName() {
        return this.m_nameRoadName;
    }

    public void setExportPath(String exportPath) {
        if (exportPath == null || exportPath.trim().length() == 0) {
            String string = InternalResource.loadString("exportPath", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_workspace = exportPath;
    }

    public void setDistrictName(String districtName) {
        if (districtName == null || districtName.trim().length() == 0) {
            String string = InternalResource.loadString("districtName", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_district = districtName;
    }

    public String getExportPath() {
        return this.m_workspace;
    }

    public String getDistrictName() {
        return this.m_district;
    }

    public void setPackageTypes(PackageType[] packageTypes) {
        if (packageTypes == null || packageTypes.length == 0) {
            String string = InternalResource.loadString("packageTypes", "Global_ArrayLengthShouldGreaterThanZero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        int n = packageTypes.length;
        this.m_packageTypes = new PackageType[n];
        for (int i = 0; i < n; ++i) {
            this.m_packageTypes[i] = packageTypes[i];
        }
    }

    public PackageType[] getPackageTypes() {
        return this.m_packageTypes;
    }

    DataVersion getSourceDataVersion() {
        return this.m_dataVersion;
    }

    void setSourceDataVersion(DataVersion version) {
        this.m_dataVersion = version;
    }

    public int getLanguage() {
        return this.m_lang;
    }

    public void setLanguage(int lang) {
        this.m_lang = lang;
    }
}

