/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.networkanalyst;

import com.supermap.data.Point3Ds;
import com.supermap.realspace.networkanalyst.InternalHandleDisposable;
import com.supermap.realspace.networkanalyst.InternalResource;
import com.supermap.realspace.networkanalyst.TransportationAnalystParameter3DNative;

public class TransportationAnalystParameter3D
extends InternalHandleDisposable {
    private int[] m_nodes = null;
    private Point3Ds m_points = null;
    private String m_weightName = "";
    private int[] m_barrierNodes = null;
    private int[] m_barrierEdges = null;
    private Point3Ds m_barrierPoints = null;
    private String m_turnWeightField = "";
    private boolean m_isRoutesReturn = false;
    private boolean m_isNodesReturn = false;
    private boolean m_isEdgesReturn = false;
    private boolean m_isPathGuidesReturn = false;
    private boolean m_isStopsReturn = false;

    public TransportationAnalystParameter3D() {
        long l = TransportationAnalystParameter3DNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            TransportationAnalystParameter3DNative.jni_Reset(l);
        }
    }

    public TransportationAnalystParameter3D(TransportationAnalystParameter3D transportationAnalystParameter) {
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("transportationAnalystParameter", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        long l = TransportationAnalystParameter3DNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.copyFrom(transportationAnalystParameter);
    }

    void copyFrom(TransportationAnalystParameter3D value) {
        if (value != null) {
            this.setNodes(value.getNodes());
            this.setPoints(value.getPoints());
            this.setWeightName(value.getWeightName());
            this.setBarrierNodes(value.getBarrierNodes());
            this.setBarrierEdges(value.getBarrierEdges());
            this.setBarrierPoints(value.getBarrierPoints());
            this.setTurnWeightField(value.getTurnWeightField());
            this.setNodesReturn(value.isNodesReturn());
            this.setEdgesReturn(value.isEdgesReturn());
            this.setPathGuidesReturn(value.isPathGuidesReturn());
            this.setRoutesReturn(value.isRoutesReturn());
            this.setStopIndexesReturn(value.isStopIndexesReturn());
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            int n;
            double[] dArray;
            double[] dArray2;
            double[] dArray3;
            int n2;
            TransportationAnalystParameter3DNative.jni_SetIsRoutesReturn(l, this.m_isRoutesReturn);
            TransportationAnalystParameter3DNative.jni_SetIsNodesReturn(l, this.m_isNodesReturn);
            TransportationAnalystParameter3DNative.jni_SetIsEdgesReturn(l, this.m_isEdgesReturn);
            TransportationAnalystParameter3DNative.jni_SetIsPathGuidesReturn(l, this.m_isPathGuidesReturn);
            TransportationAnalystParameter3DNative.jni_SetIsStopsReturn(l, this.m_isStopsReturn);
            if (this.m_nodes != null && this.m_nodes.length != 0) {
                TransportationAnalystParameter3DNative.jni_SetNodes(l, this.m_nodes);
            }
            if (this.m_points != null && this.m_points.getCount() != 0) {
                n2 = this.m_points.getCount();
                dArray3 = new double[n2];
                dArray2 = new double[n2];
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray3[n] = this.m_points.getItem(n).getX();
                    dArray2[n] = this.m_points.getItem(n).getY();
                    dArray[n] = this.m_points.getItem(n).getZ();
                }
                TransportationAnalystParameter3DNative.jni_SetPoints(l, dArray3, dArray2, dArray);
            }
            TransportationAnalystParameter3DNative.jni_SetWeightName(l, this.m_weightName);
            if (this.m_barrierNodes != null) {
                TransportationAnalystParameter3DNative.jni_SetBarrierNodes(l, this.m_barrierNodes);
            } else {
                TransportationAnalystParameter3DNative.jni_SetBarrierNodes(l, new int[0]);
            }
            if (this.m_barrierEdges != null) {
                TransportationAnalystParameter3DNative.jni_SetBarrierEdges(l, this.m_barrierEdges);
            } else {
                TransportationAnalystParameter3DNative.jni_SetBarrierEdges(l, new int[0]);
            }
            if (this.m_barrierPoints != null && this.m_barrierPoints.getCount() != 0) {
                n2 = this.m_barrierPoints.getCount();
                dArray3 = new double[n2];
                dArray2 = new double[n2];
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray3[n] = this.m_barrierPoints.getItem(n).getX();
                    dArray2[n] = this.m_barrierPoints.getItem(n).getY();
                    dArray[n] = this.m_barrierPoints.getItem(n).getZ();
                }
                TransportationAnalystParameter3DNative.jni_SetBarrierPoints(l, dArray3, dArray2, dArray);
            }
            TransportationAnalystParameter3DNative.jni_SetTurnWeightField(l, this.m_turnWeightField);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            TransportationAnalystParameter3DNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean isRoutesReturn() {
        return this.m_isRoutesReturn;
    }

    public void setRoutesReturn(boolean value) {
        this.m_isRoutesReturn = value;
    }

    public boolean isNodesReturn() {
        return this.m_isNodesReturn;
    }

    public void setNodesReturn(boolean value) {
        this.m_isNodesReturn = value;
    }

    public boolean isEdgesReturn() {
        return this.m_isEdgesReturn;
    }

    public void setEdgesReturn(boolean value) {
        this.m_isEdgesReturn = value;
    }

    private boolean isPathGuidesReturn() {
        return this.m_isPathGuidesReturn;
    }

    private void setPathGuidesReturn(boolean value) {
        this.m_isPathGuidesReturn = value;
    }

    public boolean isStopIndexesReturn() {
        return this.m_isStopsReturn;
    }

    public void setStopIndexesReturn(boolean value) {
        this.m_isStopsReturn = value;
    }

    public int[] getNodes() {
        if (this.m_nodes != null) {
            return (int[])this.m_nodes.clone();
        }
        return null;
    }

    public void setNodes(int[] value) {
        if (value == null) {
            this.m_nodes = null;
        } else {
            int n = value.length;
            this.m_nodes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_nodes[i] = value[i];
            }
            if (n > 0) {
                this.m_points = null;
            }
        }
    }

    public Point3Ds getPoints() {
        if (this.m_points != null) {
            return this.m_points.clone();
        }
        return null;
    }

    public void setPoints(Point3Ds value) {
        if (value == null) {
            this.m_points = null;
        } else {
            if (this.m_points == null) {
                this.m_points = new Point3Ds();
            }
            this.m_points.clear();
            this.m_points.addRange(value.toArray());
            if (value.getCount() > 0) {
                this.m_nodes = null;
            }
        }
    }

    public String getWeightName() {
        return this.m_weightName;
    }

    public void setWeightName(String value) {
        this.m_weightName = value;
    }

    public int[] getBarrierNodes() {
        if (this.m_barrierNodes != null) {
            return this.m_barrierNodes;
        }
        return null;
    }

    public void setBarrierNodes(int[] value) {
        if (value == null) {
            this.m_barrierNodes = null;
        } else {
            int n = value.length;
            this.m_barrierNodes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_barrierNodes[i] = value[i];
            }
        }
    }

    public int[] getBarrierEdges() {
        if (this.m_barrierEdges != null) {
            return (int[])this.m_barrierEdges.clone();
        }
        return null;
    }

    public Point3Ds getBarrierPoints() {
        if (this.m_barrierPoints != null) {
            return this.m_barrierPoints.clone();
        }
        return null;
    }

    public void setBarrierPoints(Point3Ds value) {
        if (value == null) {
            this.m_barrierPoints = null;
        } else {
            if (this.m_barrierPoints == null) {
                this.m_barrierPoints = new Point3Ds();
            }
            this.m_barrierPoints.clear();
            this.m_barrierPoints.addRange(value.toArray());
        }
    }

    public void setBarrierEdges(int[] value) {
        if (value == null) {
            this.m_barrierEdges = null;
        } else {
            int n = value.length;
            this.m_barrierEdges = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_barrierEdges[i] = value[i];
            }
        }
    }

    protected String getTurnWeightField() {
        return this.m_turnWeightField;
    }

    protected void setTurnWeightField(String value) {
        this.m_turnWeightField = value;
    }
}

