/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.AltitudeMode;
import com.supermap.data.Toolkit;

public class LookAt {
    private double m_latitude;
    private double m_longitude;
    private double m_altitude;
    private double m_tilt;
    private double m_heading;
    private double m_range;
    private AltitudeMode m_altitudeMode;

    public LookAt(double longitude, double latitude, double range) {
        this.initialize(longitude, latitude, 0.0, 0.0, 0.0, range, AltitudeMode.ABSOLUTE);
    }

    public LookAt(double longitude, double latitude, double range, AltitudeMode mode) {
        this.initialize(longitude, latitude, 0.0, 0.0, 0.0, range, mode);
    }

    public LookAt(double longitude, double latitude, double altitude, AltitudeMode mode, double tilt, double heading, double range) {
        this.initialize(longitude, latitude, altitude, tilt, heading, range, mode);
    }

    private void initialize(double longitude, double latitude, double altitude, double tilt, double heading, double range, AltitudeMode mode) {
        this.m_altitude = altitude;
        this.m_latitude = latitude;
        this.m_longitude = longitude;
        this.m_heading = tilt;
        this.m_tilt = heading;
        this.m_range = range;
        this.m_altitudeMode = mode;
    }

    public double getLatitude() {
        return this.m_latitude;
    }

    public void setLatitude(double latitude) {
        this.m_latitude = latitude;
    }

    public double getLongitude() {
        return this.m_longitude;
    }

    public void setLongtitude(double longtitude) {
        this.m_longitude = longtitude;
    }

    public double getAltitude() {
        return this.m_altitude;
    }

    public void setAltitude(double atitude) {
        this.m_altitude = atitude;
    }

    public double getTilt() {
        return this.m_tilt;
    }

    public void setTilt(double tilt) {
        this.m_tilt = tilt;
    }

    public double getHeading() {
        return this.m_heading;
    }

    public void setHeading(double heading) {
        this.m_heading = heading;
    }

    public double getRange() {
        return this.m_range;
    }

    public void setRange(double range) {
        this.m_range = range;
    }

    public AltitudeMode getAltitudeMode() {
        return this.m_altitudeMode;
    }

    public void setAltitudeMode(AltitudeMode mode) {
        this.m_altitudeMode = mode;
    }

    public boolean isValid() {
        boolean bl = Double.isNaN(this.m_altitude) || Double.isNaN(this.m_latitude) || Double.isNaN(this.m_longitude) || Double.isNaN(this.m_tilt) || Double.isNaN(this.m_heading) || Double.isNaN(this.m_range) || this.m_tilt < 0.0 || this.m_tilt > 90.0;
        return !bl;
    }

    public boolean lookAtEquals(LookAt lookAt) {
        if (lookAt == null) {
            return false;
        }
        return Toolkit.isZero((double)(this.m_altitude - lookAt.getAltitude())) && Toolkit.isZero((double)(this.m_latitude - lookAt.getLatitude())) && Toolkit.isZero((double)(this.m_longitude - lookAt.getLongitude())) && Toolkit.isZero((double)(this.m_heading - lookAt.getHeading())) && Toolkit.isZero((double)(this.m_tilt - lookAt.getTilt())) && Toolkit.isZero((double)(this.m_range - lookAt.getRange()));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Altitude=");
        stringBuffer.append(this.getAltitude());
        stringBuffer.append(",Longtitude=");
        stringBuffer.append(this.getLongitude());
        stringBuffer.append(",Latitude=");
        stringBuffer.append(this.getLatitude());
        stringBuffer.append(",Heading=");
        stringBuffer.append(this.getHeading());
        stringBuffer.append(",Tilt=");
        stringBuffer.append(this.getTilt());
        stringBuffer.append(",Range=");
        stringBuffer.append(this.getRange());
        stringBuffer.append(",AltitudeMode=");
        stringBuffer.append(this.getAltitudeMode());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

