/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.AltitudeMode;
import com.supermap.data.Enum;
import com.supermap.data.GeoStyle3D;
import com.supermap.realspace.Camera;
import com.supermap.realspace.FlyEventType;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.PropertiesChangedEvent;
import com.supermap.realspace.RotationItems;
import com.supermap.realspace.RouteStopNative;
import com.supermap.realspace.StopMode;

public class RouteStop
extends InternalHandleDisposable {
    private static final double DTOR = Math.PI / 180;
    private static final double RTOD = 57.29577951308232;
    FlyManager m_flyManager;
    GeoStyle3D m_geoStyle3D;
    RotationItems m_rotationItems;

    public RouteStop() {
        long l = RouteStopNative.jni_New();
        this.setHandle(l, true);
    }

    public RouteStop(RouteStop routeStop) {
        this(routeStop, true);
    }

    protected RouteStop(long handle) {
        this.setHandle(handle, false);
    }

    protected RouteStop(RouteStop routeStop, boolean isDisposable) {
        if (routeStop == null) {
            String string = InternalResource.loadString("routeStop", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (routeStop.getHandle() == 0L) {
            String string = InternalResource.loadString("routeStop", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = RouteStopNative.jni_Clone(routeStop.getHandle());
        this.setHandle(l, isDisposable);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)routeStop));
    }

    public Camera getCamera() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        long l = RouteStopNative.jni_GetCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l != 0L) {
            AltitudeMode altitudeMode = (AltitudeMode)InternalEnum.parse(AltitudeMode.class, (int)((int)dArray[3]));
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, dArray[2], altitudeMode, dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCamera(camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        RouteStopNative.jni_SetCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), camera.getAltitude(), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public GeoStyle3D getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoStyle3D == null && (l = RouteStopNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.m_geoStyle3D = InternalGeoStyle3D.createInstance(l);
        }
        return this.m_geoStyle3D;
    }

    public void setStyle(GeoStyle3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setStyle", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3D geoStyle3D = value.clone();
        RouteStopNative.jni_SetStyle(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D));
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public double getDuration() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDuration()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetDuration(this.getHandle());
    }

    public void setDuration(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDuration(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_SetDuration(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public double getRotationDuration() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationDuration()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetRotationDuration(this.getHandle());
    }

    public StopMode getMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = RouteStopNative.jni_GetMode(this.getHandle());
        return (StopMode)Enum.parse(StopMode.class, (int)n);
    }

    public void setMode(StopMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMode(StopMode value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_SetMode(this.getHandle(), value.value());
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public double getWaitTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWaitTime()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetWaitTime(this.getHandle());
    }

    public void setWaitTime(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWaitTime(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RouteStopNative.jni_SetWaitTime(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean isExcluded() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isExcluded()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetIsExcluded(this.getHandle());
    }

    public void setExcluded(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExcluded(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_SetIsExcluded(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setName", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RouteStopNative.jni_SetName(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public double getSpeed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpeed()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetSpeed(this.getHandle());
    }

    public void setSpeed(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpeed(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_SetSpeed(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public double getTurnTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTurnTime()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetTurnTime(this.getHandle());
    }

    public void setTurnTime(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTurnTime(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_SetTurnTime(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public RotationItems getRotationItems() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationItems()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_rotationItems == null) {
            this.m_rotationItems = new RotationItems(this.getHandle());
        }
        return this.m_rotationItems;
    }

    public boolean isSlowTurning() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTurnSlowly()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_IsTurnSlowly(this.getHandle());
    }

    public void setSlowTurning(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTurnSlowly(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_SetTurnSlowly(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public double getAngularSpeed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAngularSpeed()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetAngularSpeed(this.getHandle());
    }

    public void setAngularSpeed(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAngularSpeed(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_SetAngularSpeed(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            RouteStopNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_ToXML(this.getHandle());
    }

    public boolean fromXML(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("fromXML", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = RouteStopNative.jni_FromXML(this.getHandle(), value);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    protected void clearHandle() {
        if (this.m_geoStyle3D != null) {
            this.m_geoStyle3D = null;
        }
        this.setHandle(0L);
    }
}

