/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.FlyEventType;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.PropertiesChangedEvent;
import com.supermap.realspace.RouteStop;
import com.supermap.realspace.RouteStopsNative;
import java.util.ArrayList;

public class RouteStops
extends InternalHandle {
    FlyManager m_flyManager;
    ArrayList<RouteStop> m_routeStops;

    RouteStops(long handle) {
        this.setHandle(handle);
        this.m_routeStops = new ArrayList();
        this.fillRouteStops();
    }

    private void fillRouteStops() {
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            long l = RouteStopsNative.jni_Get(this.getHandle(), i);
            RouteStop routeStop = new RouteStop(l);
            routeStop.m_flyManager = this.m_flyManager;
            this.m_routeStops.add(routeStop);
        }
    }

    public int getStartIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartIndex", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopsNative.jni_GetStartIndex(this.getHandle());
    }

    public void setStartIndex(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartIndex", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("setStartIndex", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RouteStopsNative.jni_SetStartIndex(this.getHandle(), index);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopsNative.jni_GetCount(this.getHandle());
    }

    public int indexOf(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("indexOf", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            int n2 = this.getCount();
            for (int i = 0; i < n2; ++i) {
                if (!name.equalsIgnoreCase(this.get(i).getName())) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public boolean contains(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.indexOf(name) != -1;
    }

    public int add(RouteStop routeStop) {
        String string = routeStop.getName();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("add", "Route_IsAlreadyExist", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        RouteStop routeStop2 = new RouteStop(routeStop, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)routeStop2);
        int n = -1;
        if (l != 0L && (n = RouteStopsNative.jni_Add(this.getHandle(), l)) != -1) {
            this.m_routeStops.add(routeStop2);
        }
        if (this.m_flyManager != null) {
            routeStop2.m_flyManager = this.m_flyManager;
            routeStop.m_flyManager = this.m_flyManager;
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)routeStop));
        return n;
    }

    public boolean insert(int index, RouteStop stop) {
        String string = stop.getName();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("insert", "Route_IsAlreadyExist", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        boolean bl = false;
        RouteStop routeStop = new RouteStop(stop);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)routeStop);
        if (l != 0L && (bl = RouteStopsNative.jni_Insert(this.getHandle(), index, l))) {
            this.m_routeStops.add(index, routeStop);
        }
        if (this.m_flyManager != null) {
            routeStop.m_flyManager = this.m_flyManager;
            stop.m_flyManager = this.m_flyManager;
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)routeStop));
        return bl;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("remove", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RouteStop routeStop = this.get(index);
        boolean bl = RouteStopsNative.jni_Remove(this.getHandle(), index);
        if (bl) {
            this.m_routeStops.remove(index);
            routeStop.clearHandle();
        }
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        int n = this.indexOf(name);
        return this.remove(n);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopsNative.jni_Clear(this.getHandle());
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public RouteStop get(String name) {
        return this.get(this.indexOf(name));
    }

    public RouteStop get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("get", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RouteStop routeStop = this.m_routeStops.get(index);
        routeStop.m_flyManager = this.m_flyManager;
        return routeStop;
    }

    public void set(String name, RouteStop stop) {
        this.set(this.indexOf(name), stop);
    }

    public void set(int index, RouteStop stop) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("set", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)stop);
        RouteStopsNative.jni_Set(this.getHandle(), index, l);
        this.m_routeStops.set(index, stop);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)stop));
    }

    protected void finalize() throws Throwable {
        if (this.getHandle() != 0L) {
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        int n = this.m_routeStops.size();
        for (int i = 0; i < n; ++i) {
            RouteStop routeStop = this.m_routeStops.get(i);
            routeStop.clearHandle();
        }
    }
}

