/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.addressmatching.AddressLoadSetting;
import com.supermap.analyst.addressmatching.AddressMatchNative;
import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.analyst.addressmatching.InternalToolkitAddressMatching;
import com.supermap.data.DatasetVector;
import java.util.ArrayList;

public class AddressLoad {
    private AddressLoadSetting m_setting;
    private License m_license;

    public AddressLoad() {
        this.checkLicense();
        this.m_setting = new AddressLoadSetting();
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitAddressMatching.managerProducts(InternalToolkitAddressMatching.getAddressMatchingProducts());
        this.m_license = InternalToolkitAddressMatching.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public AddressLoadSetting getSetting() {
        return this.m_setting;
    }

    public void setSetting(AddressLoadSetting value) {
        if (value == null) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (!this.m_setting.equals(value)) {
            this.m_setting.copyFrom(value);
        }
    }

    @Deprecated
    public boolean load() {
        this.verifyLicense();
        boolean bl = false;
        DatasetVector[] datasetVectorArray = this.m_setting.getDatasets();
        int n = datasetVectorArray.length;
        if (n <= 0) {
            String string = InternalResource.loadString("getSetting().getDatasets().length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[i]);
        }
        String[] stringArray = this.m_setting.getFields();
        if (stringArray.length <= 0) {
            String string = InternalResource.loadString("getSetting().getFields().length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        String string = this.m_setting.getDictionaryFile();
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("getSetting().getDictionaryFile()", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string2);
        }
        bl = AddressMatchNative.jni_Load2(lArray, stringArray, string, this.m_setting.getLoadDirectory());
        this.m_setting.clearData();
        this.unLoadLicense();
        return bl;
    }

    public boolean load(boolean isAppend) {
        this.verifyLicense();
        boolean bl = false;
        DatasetVector[] datasetVectorArray = this.m_setting.getDatasets();
        int n = datasetVectorArray.length;
        if (n <= 0) {
            String string = InternalResource.loadString("getSetting().getDatasets().length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[i]);
        }
        String[] stringArray = this.m_setting.getIndexFields();
        if (stringArray.length <= 0) {
            String string = InternalResource.loadString("getSetting().getIndexFields().length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray2 = this.m_setting.getSaveFields();
        String string = this.m_setting.getDictionaryFile();
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("getSetting().getDictionaryFile()", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string2);
        }
        bl = !isAppend ? AddressMatchNative.jni_Load3(lArray, stringArray, stringArray2, string, this.m_setting.getLoadDirectory(), this.m_setting.getTopGroupField(), this.m_setting.getSecondaryGroupField(), this.m_setting.getLowestGroupField(), this.m_setting.getBINDistance(), this.m_setting.getLoadPoint(), this.m_setting.isTraditional()) : AddressMatchNative.jni_Load4(lArray, stringArray, stringArray2, string, this.m_setting.getLoadDirectory(), this.m_setting.getLoadPoint());
        this.m_setting.clearData();
        this.unLoadLicense();
        return bl;
    }
}

