/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.DatasetVector;
import com.supermap.data.Point3D;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.Point3DLinkModelCacheBuilderNative;
import com.supermap.data.processing.ProcessFileType;
import com.supermap.data.processing.TileInfos;
import com.supermap.realspace.CacheFileType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Point3DLinkModelCacheBuilder
extends InternalHandleDisposable {
    private static transient Vector m_steppedListeners;
    private static String m_senderMethodName;
    private long m_selfEventHandle;
    private Recordset m_recordset;
    private DatasetVector m_dataset;

    public Point3DLinkModelCacheBuilder() {
        long l = Point3DLinkModelCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this.m_selfEventHandle = Point3DLinkModelCacheBuilderNative.jni_NewSelfEventHandle(this);
        this.m_dataset = null;
        this.m_recordset = null;
    }

    public Point3DLinkModelCacheBuilder(DatasetVector dataset, String outputFolder, String name) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        this.m_dataset = dataset;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = Point3DLinkModelCacheBuilderNative.jni_New1(l, outputFolder, name);
        this.setHandle(l2, true);
        this.m_selfEventHandle = Point3DLinkModelCacheBuilderNative.jni_NewSelfEventHandle(this);
        this.m_recordset = null;
        this.m_dataset = dataset;
    }

    public ArrayList<TileInfos> getTileInfosArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Point3DLinkModelCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<TileInfos> arrayList = new ArrayList<TileInfos>();
        int[] nArray = new int[1];
        long l = Point3DLinkModelCacheBuilderNative.jni_GetTileInfosArray(this.getHandle(), nArray);
        if (nArray[0] != 0 && l != 0L) {
            Object[] objectArray = new Object[nArray[0]];
            String[] stringArray = new String[nArray[0]];
            Point3DLinkModelCacheBuilderNative.jni_GetTileInfosArray(this.getHandle(), l, stringArray, objectArray);
            if (stringArray != null && objectArray != null && objectArray.length == stringArray.length) {
                for (int i = 0; i < stringArray.length; ++i) {
                    double[] dArray = (double[])objectArray[i];
                    Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
                    TileInfos tileInfos = new TileInfos();
                    tileInfos.setName(stringArray[i]);
                    tileInfos.setBounds(rectangle2D);
                    arrayList.add(tileInfos);
                }
            }
        }
        return arrayList;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            Point3DLinkModelCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public DatasetVector getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dataset;
    }

    public void setDataset(DatasetVector value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        Point3DLinkModelCacheBuilderNative.jni_SetDataset(this.getHandle(), l);
        this.m_dataset = value;
        this.m_recordset = null;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        Point3DLinkModelCacheBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{value.getLeft(), value.getBottom(), value.getRight(), value.getTop()};
        Point3DLinkModelCacheBuilderNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetCacheName(this.getHandle(), name);
    }

    public void setFileType(CacheFileType fileType) {
        if (fileType == null) {
            String string = InternalResource.loadString("setFileType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (fileType == CacheFileType.OSGB) {
            n = 505;
        } else if (fileType == CacheFileType.S3M) {
            n = 511;
        } else if (fileType == CacheFileType.S3MB) {
            n = 515;
        } else {
            String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetFileType(this.getHandle(), n);
    }

    public CacheFileType getFileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = Point3DLinkModelCacheBuilderNative.jni_GetFileType(this.getHandle());
        switch (n) {
            case 505: {
                n = 0;
                break;
            }
            case 511: {
                n = 1;
                break;
            }
            case 515: {
                n = 2;
                break;
            }
            default: {
                String string = InternalResource.loadString("fileType", "CacheFileTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        return (CacheFileType)InternalEnum.parseUGCValue(CacheFileType.class, n);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), name);
    }

    public double getOutputScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_GetOutputScale(this.getHandle());
    }

    public void setOutputScale(double value) {
        double d = 1.0E-10;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value < d || value > 1.0 - d) {
            String string = InternalResource.loadString("setOutputScale()", "ArgumentOutOfRange", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetOutputScale(this.getHandle(), value);
    }

    @Deprecated
    public ProcessFileType getProcessType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProcessType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = Point3DLinkModelCacheBuilderNative.jni_GetProcessType(this.getHandle());
        return (ProcessFileType)InternalEnum.parseUGCValue(ProcessFileType.class, n);
    }

    @Deprecated
    public void setProcessType(ProcessFileType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProcessType(ProcessFileType value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetProcessType(this.getHandle(), value.value());
    }

    public void setRecordset(Recordset value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRecordset(Recordset value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (value != null && 0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value))) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetRecordset(this.getHandle(), l);
        this.m_recordset = value;
        this.m_dataset = null;
    }

    public Recordset getRecordset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRecordset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_recordset;
    }

    public void setTileWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileWidth", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetTileWidth(this.getHandle(), value);
    }

    public double getTileWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_GetTileWidth(this.getHandle());
    }

    public void setLODSize(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLODSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetLODSize(this.getHandle(), value);
    }

    public int getLODSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLODSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_GetLODSize(this.getHandle());
    }

    public void setObjectFiltrateThreshold(double dbValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetObjectFiltrateThreshold(this.getHandle(), dbValue);
    }

    public double getObjectFiltrateThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getObjectFiltrateThreshold", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_GetObjectFiltrateThreshold(this.getHandle());
    }

    @Deprecated
    public void setSimplifyPercent(Map<Integer, Double> mapPercent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSimplifyPercent", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[mapPercent.size()];
        double[] dArray = new double[mapPercent.size()];
        int n = 0;
        for (Integer n2 : mapPercent.keySet()) {
            Double d = mapPercent.get(n2);
            nArray[n] = n2;
            dArray[n] = d;
            ++n;
        }
        Point3DLinkModelCacheBuilderNative.jni_SetSimplifyPercent(this.getHandle(), nArray, dArray);
    }

    @Deprecated
    public HashMap<Integer, Double> getSimplifyPercent() {
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        double[] dArray = Point3DLinkModelCacheBuilderNative.jni_GetSimplifyPercent(this.getHandle());
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                hashMap.put(i, dArray[i]);
            }
        }
        return hashMap;
    }

    public ArrayList<Rectangle2D> getTileBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileBounds", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<Rectangle2D> arrayList = null;
        Object[] objectArray = Point3DLinkModelCacheBuilderNative.jni_GetTileBounds(this.getHandle());
        if (objectArray != null) {
            arrayList = new ArrayList<Rectangle2D>();
            for (int i = 0; i < objectArray.length; ++i) {
                double[] dArray = (double[])objectArray[i];
                arrayList.add(new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]));
            }
        }
        return arrayList;
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProcessThreadsCount", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_GetProcessThreadsCount(this.getHandle());
    }

    public void setProcessThreadsCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProcessThreadsCount", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetProcessThreadsCount(this.getHandle(), value);
    }

    static void steppedCallBack(Point3DLinkModelCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            Point3DLinkModelCacheBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public Point3D getPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPosition", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Point3DLinkModelCacheBuilderNative.jni_GetPosition(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setPosition(Point3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPosition", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetPosition(this.getHandle(), value.getX(), value.getY(), value.getZ());
    }

    public String getScaleXField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleXField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = Point3DLinkModelCacheBuilderNative.jni_GetScaleXField(this.getHandle());
        return string;
    }

    public void setScaleXField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleXField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetScaleXField(this.getHandle(), value);
    }

    public String getScaleYField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleYField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = Point3DLinkModelCacheBuilderNative.jni_GetScaleYField(this.getHandle());
        return string;
    }

    public void setScaleYField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleYField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetScaleYField(this.getHandle(), value);
    }

    public String getScaleZField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleZField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = Point3DLinkModelCacheBuilderNative.jni_GetScaleZField(this.getHandle());
        return string;
    }

    public void setScaleZField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleZField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetScaleZField(this.getHandle(), value);
    }

    public String getRotateXField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotateXField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = Point3DLinkModelCacheBuilderNative.jni_GetRotateXField(this.getHandle());
        return string;
    }

    public void setRotateXField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotateXField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetRotateXField(this.getHandle(), value);
    }

    public String getRotateYField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotateYField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = Point3DLinkModelCacheBuilderNative.jni_GetRotateYField(this.getHandle());
        return string;
    }

    public void setRotateYField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotateYField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetRotateYField(this.getHandle(), value);
    }

    public String getRotateZField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotateZField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = Point3DLinkModelCacheBuilderNative.jni_GetRotateZField(this.getHandle());
        return string;
    }

    public void setRotateZField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotateZField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetRotateZField(this.getHandle(), value);
    }

    public String getModelPathField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getModelFilePath", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = Point3DLinkModelCacheBuilderNative.jni_GetModelPathField(this.getHandle());
        return string;
    }

    public void setModelPathField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModelFilePath", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetModelPathField(this.getHandle(), value);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildWithoutConfigFile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_BuildWithoutConfigFile(this.getHandle(), this.m_selfEventHandle);
    }

    public boolean toConfigAndIndexFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toConfigAndIndexFile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return Point3DLinkModelCacheBuilderNative.jni_ToFile(this.getHandle(), path);
    }

    public void setTileInfos(TileInfos value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileInfos", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.getName() == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = value.getName().split("_");
        if (stringArray.length != 4) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        int n3 = Integer.parseInt(stringArray[3]);
        Point3DLinkModelCacheBuilderNative.jni_SetTileInfos(this.getHandle(), n, n2, n3);
    }

    public String getMatrixField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileInfos", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = Point3DLinkModelCacheBuilderNative.jni_GetMatrixField(this.getHandle());
        return string;
    }

    public void setMatrixField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileInfos", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Point3DLinkModelCacheBuilderNative.jni_SetMatrixField(this.getHandle(), value);
    }
}

