/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.CompressedTextureType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.processing.CacheImageSize;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalProcessingEnum;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.InternalWorkspaceConectionInfo;
import com.supermap.data.processing.SceneCacheBuilderNative;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TerrainCacheType;
import com.supermap.realspace.Scene;
import java.io.File;
import java.util.Vector;

public class SceneCacheBuilder
extends InternalHandleDisposable {
    private long m_selfEventHandle;
    private String m_password;
    private String m_outputFolder;
    private Scene m_scene;
    private WorkspaceConnectionInfo m_workspaceConnectionInfo;
    transient Vector m_steppedListeners;
    private static String m_senderMethodName;

    public SceneCacheBuilder() {
        long l = SceneCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this.m_selfEventHandle = SceneCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public SceneCacheBuilder(Scene scene, String outputFolder) {
        long l = 0L;
        if (scene != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)scene)) == 0L) {
            String string = InternalResource.loadString("scene", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(outputFolder);
        if (!file.exists()) {
            String string = InternalResource.loadString("outputFolder", "CacheBuilderSCI3D_OutputFolderNotExists", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l2 = SceneCacheBuilderNative.jni_New1(l, outputFolder);
        this.setHandle(l2, true);
        this.m_selfEventHandle = SceneCacheBuilderNative.jni_NewSelfEventHandle(this);
        this.m_scene = scene;
        this.m_outputFolder = outputFolder;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)scene);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.m_scene == null) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.m_outputFolder == null || this.m_outputFolder.trim().length() == 0) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        return SceneCacheBuilderNative.jni_Build(this.getHandle(), this.m_selfEventHandle, this.m_password);
    }

    @Deprecated
    public static boolean buildOfflinePackage(String workspacePath, String sceneName) {
        if (workspacePath == null || workspacePath.trim().length() == 0) {
            String string = InternalResource.loadString("buildOfflinePackage(String strWorkspacePath,String strSceneName)", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (sceneName == null || sceneName.trim().length() == 0) {
            String string = InternalResource.loadString("buildOfflinePackage(String strWorkspacePath,String strSceneName)", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        return SceneCacheBuilderNative.jni_BuildOfflinePackage(workspacePath, sceneName);
    }

    public Scene getScene() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScene()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_scene;
    }

    public void setScene(Scene value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            SceneCacheBuilderNative.jni_SetScene(this.getHandle(), 0L);
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
            SceneCacheBuilderNative.jni_SetScene(this.getHandle(), l);
        }
        this.m_scene = value;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneCacheBuilderNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalProcessingEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType(StorageType value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = value.value();
        SceneCacheBuilderNative.jni_SetStorageType(this.getHandle(), n);
    }

    public int getUpdateSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUpdateSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetUpdateSize(this.getHandle());
    }

    public void setUpdateSize(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUpdateSize(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetUpdateSize(this.getHandle(), value);
    }

    public CacheImageSize getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return (CacheImageSize)CacheImageSize.parse(CacheImageSize.class, (int)SceneCacheBuilderNative.jni_GetImageSize(this.getHandle()));
    }

    public void setImageSize(CacheImageSize value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageSize(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetImageSize(this.getHandle(), value.value());
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(value);
        if (!file.exists()) {
            String string = InternalResource.loadString("outputFolder", "CacheBuilderSCI3D_OutputFolderNotExists", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), value);
        this.m_outputFolder = value;
    }

    public WorkspaceConnectionInfo getOutputWorkspaceConnectionInfo() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspaceConnectionInfo", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspaceConnectionInfo == null && (l = SceneCacheBuilderNative.jni_GetWorkspaceConnectionInfo(this.getHandle())) != 0L) {
            this.m_workspaceConnectionInfo = InternalWorkspaceConectionInfo.createInstance(l);
        }
        return this.m_workspaceConnectionInfo;
    }

    public void setOutputWorkspaceConnectionInfo(WorkspaceConnectionInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspaceConnectionInfo(WorkspaceConnectionInfo value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            if (this.m_workspaceConnectionInfo != null) {
                InternalWorkspaceConectionInfo.clearHandle(this.m_workspaceConnectionInfo);
                this.m_workspaceConnectionInfo = null;
            }
            SceneCacheBuilderNative.jni_SetWorkspaceConnectionInfo(this.getHandle(), 0L);
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
            SceneCacheBuilderNative.jni_SetWorkspaceConnectionInfo(this.getHandle(), l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public String getOutputSceneName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputSceneName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetOutputSceneName(this.getHandle());
    }

    public void setOutputSceneName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputSceneName(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("setOutputSceneName()", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        SceneCacheBuilderNative.jni_SetOutputSceneName(this.getHandle(), value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        SceneCacheBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{value.getLeft(), value.getBottom(), value.getRight(), value.getTop()};
        SceneCacheBuilderNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SceneCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this.clearSelfEventHandle();
            if (this.m_workspaceConnectionInfo != null) {
                InternalWorkspaceConectionInfo.clearHandle(this.m_workspaceConnectionInfo);
            }
        }
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            SceneCacheBuilderNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_password;
    }

    public void setPassword(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPassword(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_password = value;
    }

    public void setOutputLayerNames(String[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputLayerNames(String[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetOutputLayerNames(this.getHandle(), value);
    }

    public void setOutputTerrainLayerNames(String[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputTerrainlayerNames(String[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_setOutpuTerrainLayerNames(this.getHandle(), value);
    }

    public String[] getOutputLayerNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputLayerNames()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetOutputLayerNames(this.getHandle());
    }

    public String[] getOutputTerrainLayerNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputTerrainlayerNames()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetTerrainOutputLayerNames(this.getHandle());
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    public boolean isBoundsCeiled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBoundsCeiled()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_IsBoudsCeiled(this.getHandle());
    }

    public void setIsCalNormal(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsCalNormal", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetIsCalNormal(this.getHandle(), value);
    }

    public boolean getIsCalNormal() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsCalNormal", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetIsCalNormal(this.getHandle());
    }

    public void setIsInstance(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsInstance", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetIsInstance(this.getHandle(), value);
    }

    public boolean getIsInstance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsInstance", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetIsInstance(this.getHandle());
    }

    public void setBoundsCeiled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBoundsCeiled()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetBoudsCeiled(this.getHandle(), value);
    }

    public CompressedTextureType getCompressedTextureType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCompressedTextureType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneCacheBuilderNative.jni_GetCompressedTextureType(this.getHandle());
        return (CompressedTextureType)InternalEnum.parseUGCValue(CompressedTextureType.class, n);
    }

    public void setCompressedTextureType(CompressedTextureType value) {
        if (value == null) {
            String string = InternalResource.loadString("CompressedTextureType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompressedTextureType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetCompressedTextureType(this.getHandle(), value.value());
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(SceneCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    public String[] getPreCacheLayerNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPreCacheLayerNames()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetPreCacheLayerNames(this.getHandle());
    }

    public void setPreCacheLayerNames(String[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPreCacheLayerNames(String[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetPreCacheLayerNames(this.getHandle(), value);
    }

    public void setTerrainCacheType(TerrainCacheType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTerrainCacheType(TerrainCacheType value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetTerrainCacheType(this.getHandle(), value.value());
    }

    public TerrainCacheType getTerrainCacheType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTerrainCacheType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneCacheBuilderNative.jni_GetTerrainCacheType(this.getHandle());
        return (TerrainCacheType)InternalEnum.parseUGCValue(TerrainCacheType.class, n);
    }

    public void setProcessThreadsCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SceneCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetProcessThreadsCount(this.getHandle(), value);
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SceneCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetProcessThreadsCount(this.getHandle());
    }

    public void setObjectFiltrateThreshold(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SceneCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetObjectFiltrateThreshold(this.getHandle(), value);
    }

    public double getObjectFiltrateThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SceneCacheBuilder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetObjectFiltrateThreshold(this.getHandle());
    }

    public String getUserIDField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUserIDField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetUserIDField(this.getHandle());
    }

    public void setUserIDField(String userIDName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUserIDField", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetUserIDField(this.getHandle(), userIDName);
    }
}

