/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.bslicense;

import com.supermap.bslicense.BsWebSocketClient;
import com.supermap.bslicense.Feature;
import com.supermap.bslicense.GISType;
import com.supermap.bslicense.GetAllFeaturesEvent;
import com.supermap.bslicense.GetAllFeaturesListener;
import com.supermap.bslicense.ImportLicenseEvent;
import com.supermap.bslicense.ImportLicenseListener;
import com.supermap.bslicense.LicenseChangeEvent;
import com.supermap.bslicense.LicenseChangeListener;
import com.supermap.bslicense.LicenseChangeParam;
import com.supermap.bslicense.LicenseChangeType;
import com.supermap.bslicense.LicenseCloseEvent;
import com.supermap.bslicense.LicenseCloseListener;
import com.supermap.bslicense.LicenseNumberChangeListener;
import com.supermap.bslicense.SupermapProductType;
import com.supermap.bslicense.SupermapProductVersion;
import com.supermap.bslicense.util.SystemInfo;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsLicense {
    private static final int SYNC_RETRY_TIME = 30;
    private static final long SYNC_RETRY_PERIOD = 1000L;
    private String serverUrl = "";
    private final String urlEnd = "/api/v1/external/websocket/heart/";
    private SupermapProductType productType = SupermapProductType.IMANAGER;
    private SupermapProductVersion productVersion = SupermapProductVersion.V_9D;
    private GISType gisType = GISType.NONE;
    private String caption = "";
    private double cpuQuota = 0.0;
    private int[] featureIds = null;
    private int pid = -1;
    private BsWebSocketClient client;
    private boolean isOpen = false;
    private int sleepNumber = 10;
    private long sleepTime = 500L;
    private LicenseChangeListener licenseChangeListener;
    private LicenseNumberChangeListener licenseNumberChangeListener;
    private LicenseChangeEvent licenseChangeEvent;
    private LicenseCloseListener licenseCloseListener;
    private GetAllFeaturesListener getAllFeaturesListener;
    private GetAllFeaturesEvent getAllFeaturesEvent;
    private ImportLicenseListener importLicenseListener;
    private ImportLicenseEvent importLicenseEvent;
    private ScheduledExecutorService service;
    private Runnable runnable;
    private int taskTime = 5000;
    private int maxTaskTime = 3600000;
    private Logger logger = LoggerFactory.getLogger(BsLicense.class);

    public void setProductType(SupermapProductType productType) {
        this.productType = productType;
    }

    public void setProductVersion(SupermapProductVersion productVersion) {
        this.productVersion = productVersion;
    }

    public void setGISType(GISType gisType) {
        this.gisType = gisType;
    }

    public void setCpuQuota(double cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setFeatureIds(int[] featureIds) {
        this.featureIds = (int[])(featureIds != null ? (int[])featureIds.clone() : null);
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public void setServerUrl(String url) {
        if (url != null && !url.equals("")) {
            this.serverUrl = url.contains("/api/v1/external/websocket/heart/") ? url : url + "/api/v1/external/websocket/heart/";
        }
    }

    public boolean open() {
        for (int i = 0; i < this.sleepNumber && this.isOpen; ++i) {
            try {
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.isOpen) {
            this.logger.debug("repeat open");
            return false;
        }
        if (this.serverUrl != null && !this.serverUrl.isEmpty()) {
            try {
                this.client = new BsWebSocketClient(this.serverUrl);
                this.client.setLicenseChangeParam(this.updateLicenseChangeParam());
                this.client.addMessageOpenListener(event -> {
                    this.logger.debug("open success");
                    this.taskTime = 5000;
                    this.runnable = null;
                    if (this.service != null && !this.service.isShutdown()) {
                        this.logger.debug("close reconnect task");
                        this.service.shutdown();
                    }
                    this.service = null;
                });
                this.client.addMessageChangeListener(event -> {
                    if (event.getFeatureIds() != null && event.getFeatureIds().length > 0) {
                        this.featureIds = event.getFeatureIds();
                    }
                    this.licenseChangeEvent = event;
                    this.fireLicenseChangeListener(event.getFeatureIds(), event.getLicenseXml(), event.getIps(), event.getCpuQuotaNumber(), event.getLicenseChangeType());
                });
                this.client.addMessageCloseListener(event -> {
                    this.logger.debug("start reconnect: taskTime {} ", (Object)this.taskTime);
                    this.isOpen = false;
                    if (this.taskTime == 10000) {
                        this.fireLicenseChangeListener(null, "", null, 0.0, LicenseChangeType.CLOSE);
                        this.fireLicenseCloseListener();
                    }
                    this.clear();
                    if (this.runnable == null) {
                        this.runnable = new Runnable(){

                            @Override
                            public void run() {
                                BsLicense.this.open();
                            }
                        };
                    }
                    if (this.service == null) {
                        this.service = Executors.newSingleThreadScheduledExecutor();
                    }
                    if (this.taskTime > this.maxTaskTime) {
                        this.logger.debug("taskTime exceeding the limit,can not reconnect");
                        this.taskTime = 5000;
                        this.runnable = null;
                        if (this.service != null && !this.service.isShutdown()) {
                            this.service.shutdown();
                        }
                        this.service = null;
                    } else {
                        this.service.schedule(this.runnable, (long)this.taskTime, TimeUnit.MILLISECONDS);
                        this.taskTime += 5000;
                    }
                });
                this.client.addMessageGetListener(event -> {
                    this.getAllFeaturesEvent = event;
                    this.fireGetAllFeaturesListener(event.getFeatures());
                });
                this.client.addMessageLicenseNumberChangeListener(event -> this.fireLicenseNumberChangeListener(event.getFeatures()));
                this.client.addMessageImportListener(event -> this.fireImportLicenseListener(event.getFeatures()));
                this.client.connect();
                this.isOpen = true;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public LicenseChangeParam updateLicenseChangeParam() {
        SystemInfo systemInfo = SystemInfo.getSystemInfo();
        if (this.pid < 0) {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            this.pid = Integer.parseInt(name.split("@")[0]);
        }
        String featureCodesString = "";
        if (this.featureIds != null && this.featureIds.length > 0) {
            for (int i = 0; i < this.featureIds.length; ++i) {
                featureCodesString = featureCodesString + this.featureIds[i] + "_";
            }
            featureCodesString = featureCodesString.substring(0, featureCodesString.length() - 1);
        }
        LicenseChangeParam param = new LicenseChangeParam();
        param.setIp(systemInfo.getIp());
        param.setMac(systemInfo.getMac());
        param.setHostName(systemInfo.getName());
        param.setProductName(this.productType.getName());
        param.setVersion(this.productVersion.getName());
        param.setPid(this.pid);
        param.setFeatureCodes(featureCodesString);
        param.setGISType(this.gisType);
        param.setCpuQuota(this.cpuQuota);
        param.setCaption(this.caption);
        return param;
    }

    public boolean getLicense() {
        if (this.isClientOpen()) {
            this.client.setLicenseChangeParam(this.updateLicenseChangeParam());
            this.client.getLicense();
            return true;
        }
        return false;
    }

    public LicenseChangeEvent getLicenseSyn() {
        LicenseChangeEvent result = null;
        if (this.isClientOpen()) {
            this.client.setLicenseChangeParam(this.updateLicenseChangeParam());
            this.client.getLicense();
            for (int i = 0; i < 30; ++i) {
                if (this.licenseChangeEvent != null) {
                    result = this.licenseChangeEvent;
                    this.licenseChangeEvent = null;
                    break;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public boolean getAllFeatures() {
        return this.getAllFeatures(SupermapProductType.ALL);
    }

    public boolean getAllFeatures(SupermapProductType supermapProductType) {
        if (this.isClientOpen()) {
            this.client.getAllFeatures(supermapProductType.getProductId());
            return true;
        }
        return false;
    }

    public GetAllFeaturesEvent getAllFeaturesSyn() {
        return this.getAllFeaturesSyn(SupermapProductType.ALL);
    }

    public GetAllFeaturesEvent getAllFeaturesSyn(SupermapProductType supermapProductType) {
        GetAllFeaturesEvent result = null;
        if (this.isClientOpen()) {
            this.client.getAllFeatures(supermapProductType.getProductId());
            for (int i = 0; i < 30; ++i) {
                if (this.getAllFeaturesEvent != null) {
                    result = this.getAllFeaturesEvent;
                    this.getAllFeaturesEvent = null;
                    break;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public boolean isClientOpen() {
        for (int i = 0; i < this.sleepNumber && !this.client.isOpen(); ++i) {
            try {
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.client.isOpen();
    }

    public boolean isOpen() {
        if (this.client != null) {
            return this.client.isOpen();
        }
        return false;
    }

    public void addLicenseChangeListener(LicenseChangeListener licenseChangeListener) {
        this.licenseChangeListener = licenseChangeListener;
    }

    public void addLicenseNumberChangeListener(LicenseNumberChangeListener licenseNumberChangeListener) {
        this.licenseNumberChangeListener = licenseNumberChangeListener;
    }

    public void addLicenseCloseListener(LicenseCloseListener licenseCloseListener) {
        this.licenseCloseListener = licenseCloseListener;
    }

    public void addGetAllFeaturesListener(GetAllFeaturesListener getAllFeaturesListener) {
        this.getAllFeaturesListener = getAllFeaturesListener;
    }

    public void addImportLicenseListener(ImportLicenseListener importLicenseListener) {
        this.importLicenseListener = importLicenseListener;
    }

    public void removeLicenseChangeListener() {
        if (this.client != null) {
            this.client.removeMessageChangeListener();
        }
        this.licenseChangeListener = null;
    }

    public void removeLicenseCloseListener() {
        if (this.client != null) {
            this.client.removeMessageCloseListener();
        }
        this.licenseCloseListener = null;
    }

    public void removeGetAllFeaturesListener() {
        if (this.client != null) {
            this.client.removeMessageGetListener();
        }
        this.getAllFeaturesListener = null;
    }

    public void removeLicenseNumberChangeListener() {
        if (this.client != null) {
            this.client.removeMessageLicenseNumberChangeListener();
        }
        this.licenseNumberChangeListener = null;
    }

    public void removeImportLicenseListener() {
        if (this.client != null) {
            this.client.removeMessageImportListener();
        }
        this.importLicenseListener = null;
    }

    public void fireLicenseChangeListener(int[] featureIds, String licenseXml, String[] ips, double puQuotaNumber, LicenseChangeType licenseChangeType) {
        if (this.licenseChangeListener == null) {
            return;
        }
        LicenseChangeEvent event = new LicenseChangeEvent(this, featureIds, licenseXml, ips, puQuotaNumber, licenseChangeType);
        this.licenseChangeListener.licenseChange(event);
    }

    public void fireLicenseNumberChangeListener(List<Feature> features) {
        if (this.licenseNumberChangeListener == null) {
            return;
        }
        GetAllFeaturesEvent event = new GetAllFeaturesEvent(this, features);
        this.licenseNumberChangeListener.getAllFeatures(event);
    }

    public void fireLicenseCloseListener() {
        if (this.licenseCloseListener == null) {
            return;
        }
        LicenseCloseEvent event = new LicenseCloseEvent(this);
        this.licenseCloseListener.licenseClose(event);
    }

    public void fireGetAllFeaturesListener(List<Feature> features) {
        if (this.getAllFeaturesListener == null) {
            return;
        }
        GetAllFeaturesEvent event = new GetAllFeaturesEvent(this, features);
        this.getAllFeaturesListener.getAllFeatures(event);
    }

    public void fireImportLicenseListener(List<Feature> features) {
        if (this.importLicenseListener == null) {
            return;
        }
        ImportLicenseEvent event = new ImportLicenseEvent(this, features);
        this.importLicenseListener.importLicense(event);
    }

    public void close() {
        if (this.client != null) {
            this.client.removeMessageOpenListener();
            this.client.removeMessageChangeListener();
            this.client.removeMessageCloseListener();
            this.client.removeMessageGetListener();
            this.client.removeMessageImportListener();
            this.client.removeMessageLicenseNumberChangeListener();
            this.client.close();
            this.isOpen = false;
        }
    }

    private void clear() {
        if (this.client != null) {
            this.client.removeMessageOpenListener();
            this.client.removeMessageChangeListener();
            this.client.removeMessageCloseListener();
            this.client.removeMessageGetListener();
            this.client.removeMessageImportListener();
            this.client.setLicenseChangeParam(null);
        }
    }
}

