/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import com.supermap.LicenseConnectMode;
import com.supermap.LicenseFeatureInfo;
import com.supermap.LicenseFileServiceImpl;
import com.supermap.LicenseService;
import com.supermap.LicenseVerifyFailedEvent;
import com.supermap.ProductType;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import supermap.shaded.org.slf4j.Logger;
import supermap.shaded.org.slf4j.LoggerFactory;

public class License {
    private static Logger logger = LoggerFactory.getLogger(License.class);
    static String PROGRAM_PATH = "C:/Program Files/Common Files/SuperMap/License/";
    static String OPT_PATH = "/opt/SuperMap/License/";
    static boolean g_debug;
    static int SuperMap_License_Error_Cannot_Find_LicenseInstance;
    static int SuperMap_License_Error_License_Must_Be_9D;
    static int SuperMap_License_Error_Limit_License;
    public static String CONNECTION_CONFIG_FILE_NAME;
    private static String g_UGOBasePath;
    private static URLClassLoader g_LicenseClassLoader;
    private LicenseService m_licHasp;
    private LicenseService m_licFile;
    private int[] m_featureIDS;

    public License() {
        try {
            this.m_licFile = this.loadFileImpl();
            if (!LicenseFileServiceImpl.findAndReadLicFile()) {
                this.m_licFile = null;
            }
        }
        catch (ClassNotFoundException e) {
            logger.debug("ClassNotFoundException ", e);
        }
        catch (InstantiationException e) {
            logger.debug("InstantiationException ", e);
        }
        catch (IllegalAccessException e) {
            logger.debug("IllegalAccessException ", e);
        }
        String arch = System.getProperty("os.arch");
        if (arch.equals("x86") || arch.equals("x86_64") || arch.equals("amd64") || arch.equals("aarch64")) {
            try {
                this.m_licHasp = this.loadHaspImplFromJar();
            }
            catch (MalformedURLException e) {
                logger.debug("MalformedURLException ", e);
            }
            catch (ClassNotFoundException e) {
                logger.debug("ClassNotFoundException ", e);
            }
            catch (InstantiationException e) {
                logger.debug("InstantiationException ", e);
            }
            catch (IllegalAccessException e) {
                logger.debug("IllegalAccessException ", e);
            }
            catch (UnsupportedEncodingException e) {
                logger.debug("UnsupportedEncodingException ", e);
            }
        }
        if (this.m_licFile == null && this.m_licHasp == null) {
            logger.error("new License error! no license impl to use");
            throw new IllegalStateException("new License error! no license impl to use");
        }
    }

    private LicenseService loadFileImpl() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> fileImplClass = License.class.getClassLoader().loadClass("com.supermap.LicenseFileServiceImpl");
        LicenseService impl = (LicenseService)fileImplClass.newInstance();
        return impl;
    }

    private static void debug(String message) {
        if (g_debug) {
            System.out.println(message);
        }
        logger.debug(message);
    }

    private LicenseService loadHaspImplFromJar() throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedEncodingException {
        LicenseService impl;
        block25: {
            impl = null;
            try {
                Boolean loadFromJar = false;
                try {
                    ClassLoader dataClassLoader = License.class.getClassLoader();
                    Class<?> c = dataClassLoader.loadClass("com.supermap.LicenseHaspServiceImpl");
                    impl = (LicenseService)c.newInstance();
                }
                catch (Throwable dataClassLoader) {
                    // empty catch block
                }
                loadFromJar = impl == null;
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.contains("com.supermap.licensehasp");
                    }
                };
                if (!loadFromJar.booleanValue()) break block25;
                String url = License.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                String jarPath = URLDecoder.decode(url, "UTF-8");
                loadFromJar = false;
                if (jarPath != null && !jarPath.isEmpty()) {
                    File[] jars;
                    License.debug("found jarPath is" + jarPath);
                    File file = new File(jarPath);
                    if (file.isFile()) {
                        if (jarPath.endsWith("license.jar")) {
                            jarPath = jarPath.replace("license.jar", "licensehasp.jar");
                        } else {
                            File parent = file.getParentFile();
                            if (parent != null && parent.isDirectory() && parent.exists()) {
                                jars = parent.listFiles(filter);
                                if (jars != null && jars.length > 0) {
                                    try {
                                        jarPath = jars[0].getCanonicalPath();
                                        loadFromJar = true;
                                    }
                                    catch (IOException e) {
                                        License.debug("getCanonicalPath error" + e.getMessage());
                                    }
                                    License.debug("found jarPath from parent is " + jarPath);
                                } else {
                                    License.debug("no licensehasp in " + parent.getPath());
                                }
                            } else {
                                License.debug("current path is {} to find licensehasp.jar error" + parent.toString());
                            }
                        }
                    } else if (file.isDirectory()) {
                        jarPath = jarPath.replace("LicenseManager/bin", "LicenseHasp/bin");
                        loadFromJar = true;
                    }
                    if (!loadFromJar.booleanValue()) {
                        String ugoBasePath = License.getUGOBasePath();
                        jars = new File(ugoBasePath).listFiles(filter);
                        if (jars != null && jars.length > 0) {
                            try {
                                jarPath = jars[0].getCanonicalPath();
                            }
                            catch (IOException e) {
                                License.debug("getCanonicalPath error" + e.getMessage());
                            }
                            License.debug("found jarPath in UGO PATH is " + jarPath);
                        } else {
                            License.debug("no licensehasp in UGO path" + ugoBasePath);
                        }
                    }
                    if ((file = new File(jarPath)).exists()) {
                        URL currentPath = file.toURI().toURL();
                        ClassLoader dataClassLoader = License.class.getClassLoader();
                        URLClassLoader cl = License.getHaspClassLoader(dataClassLoader, currentPath);
                        try {
                            Class<?> c = cl.loadClass("com.supermap.LicenseHaspServiceImpl");
                            impl = (LicenseService)c.newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    } else {
                        License.debug("cannot find licensehasp jar in filesystem");
                    }
                    break block25;
                }
                License.debug("cannot find license.jar contains license class in filesystem");
            }
            catch (Throwable ex) {
                License.debug(ex.getMessage());
            }
        }
        return impl;
    }

    private static URLClassLoader getHaspClassLoader(ClassLoader parent, URL jarURL) {
        if (g_LicenseClassLoader == null) {
            g_LicenseClassLoader = new URLClassLoader(new URL[]{jarURL}, parent);
        }
        return g_LicenseClassLoader;
    }

    public void dispose() {
        if (this.m_licHasp != null) {
            this.m_licHasp.dispose();
        }
        if (this.m_licFile != null) {
            this.m_licFile.dispose();
        }
    }

    public int connect(ProductType product) {
        return this.connect(product.getUGCValue());
    }

    public int[] getFeatureIDS() {
        return this.m_featureIDS;
    }

    public void setFeatureIDS(int[] featureIDS) {
        this.m_featureIDS = featureIDS;
    }

    public int connect(int featureID) {
        int code;
        block5: {
            block4: {
                code = SuperMap_License_Error_Cannot_Find_LicenseInstance;
                if (this.m_licFile != null) {
                    code = this.m_licFile.connect(featureID);
                }
                if (this.m_featureIDS == null || this.m_featureIDS.length <= 0) break block4;
                code = SuperMap_License_Error_Limit_License;
                for (int i = 0; i < this.m_featureIDS.length; ++i) {
                    if (this.m_featureIDS[i] != featureID || code == 0 || this.m_licHasp == null) continue;
                    code = this.m_licHasp.connect(featureID);
                }
                break block5;
            }
            if (code == 0 || this.m_licHasp == null) break block5;
            try {
                code = this.m_licHasp.connect(featureID);
            }
            catch (Throwable ex) {
                logger.info("lichasp.connect return exception", ex);
            }
        }
        return code;
    }

    public int connectLic(int featureID) {
        if (featureID < 10000) {
            return SuperMap_License_Error_License_Must_Be_9D;
        }
        int code = SuperMap_License_Error_Cannot_Find_LicenseInstance;
        if (this.m_licFile != null) {
            code = this.m_licFile.connect(featureID);
        }
        return code;
    }

    public int verify() {
        int code = SuperMap_License_Error_Cannot_Find_LicenseInstance;
        if (this.m_licFile != null) {
            code = this.m_licFile.verify();
        }
        if (this.m_licHasp != null && code != 0) {
            code = this.m_licHasp.verify();
        }
        return code;
    }

    public Boolean isCloudLicense() {
        boolean isCloudLicense = false;
        if (this.m_licFile != null) {
            isCloudLicense = this.m_licFile.isCloudLicense();
        }
        return isCloudLicense;
    }

    public LicenseFeatureInfo getWrapFeatureInfo() {
        LicenseFeatureInfo result = null;
        if (this.m_licFile != null && this.m_licFile.getFeatureInfo() != null) {
            result = this.m_licFile.getFeatureInfo();
        }
        return result;
    }

    public LicenseFeatureInfo getFeatureInfo() {
        LicenseFeatureInfo result = null;
        if (this.m_licFile != null && this.m_licFile.getFeatureInfo() != null && this.m_licFile.verify() == 0) {
            result = this.m_licFile.getFeatureInfo();
        } else if (this.m_licHasp != null) {
            result = this.m_licHasp.getFeatureInfo();
        }
        return result;
    }

    public void disconnect() {
        if (this.m_licHasp != null) {
            this.m_licHasp.disconnect();
        }
        if (this.m_licFile != null) {
            this.m_licFile.disconnect();
        }
    }

    public String getUser() {
        String user = "";
        if (this.m_licFile != null) {
            user = this.m_licFile.getUser();
        } else if (this.m_licHasp != null) {
            user = this.m_licHasp.getUser();
        }
        return user;
    }

    public String getCompany() {
        String company = "";
        if (this.m_licFile != null) {
            company = this.m_licFile.getCompany();
        } else if (this.m_licHasp != null) {
            company = this.m_licHasp.getCompany();
        }
        return company;
    }

    public List<Integer> getAllFeatureID() {
        List<Integer> featureList = new ArrayList<Integer>();
        if (this.m_licFile != null) {
            featureList = ((LicenseFileServiceImpl)this.m_licFile).getAllFeatureID();
        }
        return featureList;
    }

    public static List<String> getMacList() {
        return LicenseFileServiceImpl.getMacList();
    }

    public static List<Long> getMACNumList() {
        return LicenseFileServiceImpl.getMACNumList();
    }

    public String getLicenseConnectServer() {
        if (this.m_licHasp != null) {
            return this.m_licHasp.getLicenseConnectServer();
        }
        return "";
    }

    public void setLicenseConnectServer(String value) {
        if (this.m_licHasp != null) {
            this.m_licHasp.setLicenseConnectServer(value);
        }
    }

    public LicenseConnectMode getLicenseConnectMode() {
        if (this.m_licHasp != null) {
            return this.m_licHasp.getLicenseConnectMode();
        }
        return LicenseConnectMode.DEFAULT;
    }

    public void setLicenseConnectMode(LicenseConnectMode value) {
        if (this.m_licHasp != null) {
            this.m_licHasp.setLicenseConnectMode(value);
        }
    }

    public static String getSpecifyLicenseFilePath() {
        return LicenseFileServiceImpl.getSpecifyLicenseFilePath();
    }

    public static void setSpecifyLicenseFilePath(String value) {
        LicenseFileServiceImpl.setSpecifyLicenseFilePath(value);
    }

    public static String getSpecifyLicenseXML() {
        return LicenseFileServiceImpl.getSpecifyLicenseXML();
    }

    public static void setSpecifyLicenseXML(String value) {
        LicenseFileServiceImpl.setSpecifyLicenseXML(value);
    }

    public static String getUGOBasePath() {
        return g_UGOBasePath;
    }

    public static void setUGOBasePath(String value) {
        if (g_debug) {
            License.debug("set UGO path is" + value);
        }
        g_UGOBasePath = value;
    }

    public String getConnectErrorMessage(int code) {
        String errorMessage = "";
        if (this.m_licFile != null) {
            errorMessage = this.m_licFile.getErrorMessage(code);
        } else if (errorMessage.isEmpty() && this.m_licHasp != null) {
            errorMessage = this.m_licHasp.getErrorMessage(code);
        }
        return errorMessage;
    }

    public static String getErrorMessage(int code) {
        String errorMessage = "";
        switch (code) {
            case 0: {
                errorMessage = "ok";
                break;
            }
            case 1: {
                errorMessage = "hasp_mem_range";
                break;
            }
            case 2: {
                errorMessage = "hasp_inv_prognum_opt";
                break;
            }
            case 3: {
                errorMessage = "hasp_insuf_mem";
                break;
            }
            case 4: {
                errorMessage = "hasp_tmof";
                break;
            }
            case 5: {
                errorMessage = "hasp_access_denied";
                break;
            }
            case 6: {
                errorMessage = "hasp_incompat_feature";
                break;
            }
            case 7: {
                errorMessage = "hasp_container_not_found";
                break;
            }
            case 8: {
                errorMessage = "hasp_too_short";
                break;
            }
            case 9: {
                errorMessage = "hasp_inv_hnd";
                break;
            }
            case 10: {
                errorMessage = "hasp_inv_fileid";
                break;
            }
            case 11: {
                errorMessage = "hasp_old_driver";
                break;
            }
            case 12: {
                errorMessage = "hasp_no_time";
                break;
            }
            case 13: {
                errorMessage = "hasp_sys_err";
                break;
            }
            case 14: {
                errorMessage = "hasp_no_driver";
                break;
            }
            case 15: {
                errorMessage = "hasp_inv_format";
                break;
            }
            case 16: {
                errorMessage = "hasp_req_not_supp";
                break;
            }
            case 17: {
                errorMessage = "hasp_inv_update_obj";
                break;
            }
            case 18: {
                errorMessage = "hasp_keyid_not_found";
                break;
            }
            case 19: {
                errorMessage = "hasp_inv_update_data";
                break;
            }
            case 20: {
                errorMessage = "hasp_inv_update_notsupp";
                break;
            }
            case 21: {
                errorMessage = "hasp_inv_update_cntr";
                break;
            }
            case 22: {
                errorMessage = "hasp_inv_vcode";
                break;
            }
            case 23: {
                errorMessage = "hasp_enc_not_supp";
                break;
            }
            case 24: {
                errorMessage = "hasp_inv_time";
                break;
            }
            case 25: {
                errorMessage = "hasp_no_battery_power";
                break;
            }
            case 26: {
                errorMessage = "hasp_no_ack_space";
                break;
            }
            case 27: {
                errorMessage = "hasp_ts_detected";
                break;
            }
            case 28: {
                errorMessage = "hasp_feature_type_not_impl";
                break;
            }
            case 29: {
                errorMessage = "hasp_unknown_alg";
                break;
            }
            case 30: {
                errorMessage = "hasp_inv_sig";
                break;
            }
            case 31: {
                errorMessage = "hasp_feature_not_found";
                break;
            }
            case 32: {
                errorMessage = "hasp_no_log";
                break;
            }
            case 33: {
                errorMessage = "hasp_local_comm_err";
                break;
            }
            case 34: {
                errorMessage = "hasp_unknown_vcode";
                break;
            }
            case 35: {
                errorMessage = "hasp_inv_spec";
                break;
            }
            case 36: {
                errorMessage = "hasp_inv_scope";
                break;
            }
            case 37: {
                errorMessage = "hasp_too_many_keys";
                break;
            }
            case 38: {
                errorMessage = "hasp_too_many_users";
                break;
            }
            case 39: {
                errorMessage = "hasp_broken_session";
                break;
            }
            case 40: {
                errorMessage = "hasp_remote_comm_err";
                break;
            }
            case 41: {
                errorMessage = "hasp_feature_expired";
                break;
            }
            case 42: {
                errorMessage = "hasp_old_lm";
                break;
            }
            case 43: {
                errorMessage = "hasp_device_err";
                break;
            }
            case 44: {
                errorMessage = "hasp_update_blocked";
                break;
            }
            case 45: {
                errorMessage = "hasp_time_err";
                break;
            }
            case 46: {
                errorMessage = "hasp_schan_err";
                break;
            }
            case 47: {
                errorMessage = "hasp_storage_corrupt";
                break;
            }
            case 48: {
                errorMessage = "hasp_no_vlib";
                break;
            }
            case 49: {
                errorMessage = "hasp_inv_vlib";
                break;
            }
            case 50: {
                errorMessage = "hasp_scope_results_empty";
                break;
            }
            case 51: {
                errorMessage = "hasp_vm_detected";
                break;
            }
            case 52: {
                errorMessage = "hasp_hardware_modified";
                break;
            }
            case 53: {
                errorMessage = "hasp_user_denied";
                break;
            }
            case 54: {
                errorMessage = "hasp_update_too_old";
                break;
            }
            case 55: {
                errorMessage = "hasp_update_too_new";
                break;
            }
            case 56: {
                errorMessage = "hasp_old_vlib";
                break;
            }
            case 57: {
                errorMessage = "hasp_upload_error";
                break;
            }
            case 58: {
                errorMessage = "hasp_inv_recipient";
                break;
            }
            case 59: {
                errorMessage = "hasp_inv_detach_action";
                break;
            }
            case 60: {
                errorMessage = "hasp_too_many_products";
                break;
            }
            case 61: {
                errorMessage = "hasp_inv_product";
                break;
            }
            case 62: {
                errorMessage = "hasp_unknown_recipient";
                break;
            }
            case 63: {
                errorMessage = "hasp_inv_duration";
                break;
            }
            case 64: {
                errorMessage = "hasp_clone_detected";
                break;
            }
            case 65: {
                errorMessage = "hasp_update_already_added";
                break;
            }
            case 66: {
                errorMessage = "hasp_hasp_inactive";
                break;
            }
            case 67: {
                errorMessage = "hasp_no_deatchable_feature";
                break;
            }
            case 68: {
                errorMessage = "hasp_too_many_hosts";
                break;
            }
            case 69: {
                errorMessage = "hasp_rehost_not_allowed";
                break;
            }
            case 70: {
                errorMessage = "hasp_license_rehosted";
                break;
            }
            case 71: {
                errorMessage = "hasp_rehost_already_applied";
                break;
            }
            case 72: {
                errorMessage = "hasp_cannot_read_file";
                break;
            }
            case 400: {
                errorMessage = "hasp_no_api_dylib";
                break;
            }
            case 401: {
                errorMessage = "hasp_inv_api_dylib";
                break;
            }
            case 501: {
                errorMessage = "hasp_inv_param";
                break;
            }
            case 650: {
                errorMessage = "hasp_inv_port_type";
                break;
            }
            case 651: {
                errorMessage = "hasp_inv_port";
                break;
            }
            case 698: {
                errorMessage = "hasp_not_impl";
                break;
            }
            case 699: {
                errorMessage = "hasp_int_err";
                break;
            }
            case 4000: {
                errorMessage = "SuperMap_License_Error_Cannot_Find_LicenseInstance";
                break;
            }
            case 4001: {
                errorMessage = "SuperMap_License_Error_Hasp_Load_Library_Error";
                break;
            }
            case 5000: {
                errorMessage = "SuperMap_licensefile_7C_unknown_error";
                break;
            }
            case 5001: {
                errorMessage = "SuperMap_licensefile_7C_later_than_ExpiredDate";
                break;
            }
            case 5002: {
                errorMessage = "SuperMap_License_Error_early_than_StartDate";
                break;
            }
            case 5003: {
                errorMessage = "SuperMap_licensefile_7C_wrong_license_data";
                break;
            }
            case 5004: {
                errorMessage = "SuperMap_licensefile_7C_wrong_product_version";
                break;
            }
            case 5005: {
                errorMessage = "SuperMap_licensefile_7C_encrypt_failed";
                break;
            }
            case 5006: {
                errorMessage = "SuperMap_licensefile_7C_computer_name_error";
                break;
            }
            case 5007: {
                errorMessage = "SuperMap_licensefile_7C_featrue_not_found";
                break;
            }
            case 5008: {
                errorMessage = "SuperMap_licensefile_7C_specify_MAC_not_found";
                break;
            }
            case 5009: {
                errorMessage = "SuperMap_licensefile_7C_wrong_feature_in_license_data";
                break;
            }
            default: {
                errorMessage = "unknown error code: " + code;
            }
        }
        if (!errorMessage.equals("")) {
            LicenseVerifyFailedEvent licenseVerifyFailedEvent = new LicenseVerifyFailedEvent(License.class, code, errorMessage);
        }
        return errorMessage;
    }

    public String toString() {
        return "License";
    }

    public static ArrayList<ProductType> getTrialLicenses() {
        ArrayList<ProductType> products = new ArrayList<ProductType>();
        products.add(new ProductType(65400, 65400));
        products.add(new ProductType(65401, 65401));
        products.add(new ProductType(65402, 65402));
        products.add(new ProductType(65403, 65403));
        products.add(new ProductType(65404, 65404));
        products.add(new ProductType(65405, 65405));
        products.add(new ProductType(65406, 65406));
        products.add(new ProductType(65407, 65407));
        products.add(new ProductType(65408, 65408));
        products.add(new ProductType(65409, 65409));
        products.add(new ProductType(65410, 65410));
        products.add(new ProductType(65411, 65411));
        return products;
    }

    public static ArrayList<ProductType> getDesktopTrialLicenses() {
        ArrayList<ProductType> trialLicenses = License.getTrialLicenses();
        trialLicenses.add(new ProductType(65412, 65412));
        return trialLicenses;
    }

    public static String getElementValueByName(Element element, String tagName) {
        String temp = "";
        try {
            Element firstElement = (Element)License.getFirstElement(element.getElementsByTagName(tagName));
            temp = firstElement.getFirstChild().getNodeValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return temp;
    }

    public static Element getFirstElementByName(Element element, String tagName) {
        return (Element)License.getFirstElement(element.getElementsByTagName(tagName));
    }

    private static Node getFirstElement(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        return nodeList.item(0);
    }

    static {
        SuperMap_License_Error_Cannot_Find_LicenseInstance = 4000;
        SuperMap_License_Error_License_Must_Be_9D = 4100;
        SuperMap_License_Error_Limit_License = 4200;
        CONNECTION_CONFIG_FILE_NAME = "LICENSECONNECT.XML";
        g_LicenseClassLoader = null;
        g_debug = false;
        String debug = System.getenv("SuperMapLicenseDebug");
        if (debug != null && debug.equalsIgnoreCase("true")) {
            g_debug = true;
        }
        g_UGOBasePath = "";
    }
}

