/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroupItemAddedEvent;
import com.supermap.data.DatasetGroupItemAddedListener;
import com.supermap.data.DatasetGroupItemRemovedEvent;
import com.supermap.data.DatasetGroupItemRemovedListener;
import com.supermap.data.DatasetGroupItemRemovingEvent;
import com.supermap.data.DatasetGroupItemRemovingListener;
import com.supermap.data.DatasetGroupNative;
import com.supermap.data.DatasetGroupRenamedEvent;
import com.supermap.data.DatasetGroupRenamedListener;
import com.supermap.data.DatasetGroupRenamingEvent;
import com.supermap.data.DatasetGroupRenamingListener;
import com.supermap.data.DatasetGroups;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import java.util.Vector;

public class DatasetGroup
extends InternalHandle {
    private DatasetGroup m_parent;
    private DatasetGroups m_childGroups;
    private Datasource m_datasource;
    private Vector<DatasetGroupRenamedListener> m_renamedListeners;
    private Vector<DatasetGroupRenamingListener> m_renamingListeners;
    private Vector<DatasetGroupItemAddedListener> m_addedListeners;
    private Vector<DatasetGroupItemRemovingListener> m_removingListeners;
    private Vector<DatasetGroupItemRemovedListener> m_removedListeners;

    DatasetGroup(long handle, Datasource datasource, DatasetGroup parent) {
        this.setHandle(handle);
        this.m_datasource = datasource;
        this.m_parent = parent;
    }

    public DatasetGroup getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_parent;
    }

    public DatasetGroups getChildGroups() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_childGroups == null) {
            this.m_childGroups = new DatasetGroups(this);
        }
        return this.m_childGroups;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGroupNative.jni_GetName(this.getHandle());
    }

    public void setName(String newName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && this.m_parent.getChildGroups().contains(newName)) {
            String string = InternalResource.loadString("name", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getName();
        DatasetGroupRenamingEvent datasetGroupRenamingEvent = new DatasetGroupRenamingEvent(this, string, newName, false);
        this.fireRenaming(datasetGroupRenamingEvent);
        if (!datasetGroupRenamingEvent.isCancel()) {
            DatasetGroupNative.jni_SetName(this.getHandle(), newName);
            this.fireRenamed(new DatasetGroupRenamedEvent(this, string, newName));
        }
    }

    public Dataset get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = null;
        String string = DatasetGroupNative.jni_GetDatasetTableName(this.getHandle(), index);
        dataset = this.getDatasource().getDatasets().getDatasetByTableName(string);
        return dataset;
    }

    public Datasource getDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasource;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGroupNative.jni_GetDatasetCount(this.getHandle());
    }

    public int add(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.indexOf(dataset.getName()) != -1) {
            String string = InternalResource.loadString("", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.getDatasource() != this.getDatasource()) {
            String string = InternalResource.loadString("", "DatasetGroup_AndDatasetMustBeInTheSameDatasource", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = DatasetGroupNative.jni_AddDataset(this.getHandle(), dataset.getHandle());
        this.fireAdded(new DatasetGroupItemAddedEvent(this, dataset.getName()));
        return n;
    }

    public boolean remove(String datasetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGroupItemRemovingEvent datasetGroupItemRemovingEvent = new DatasetGroupItemRemovingEvent(this, datasetName, false);
        this.fireRemoving(datasetGroupItemRemovingEvent);
        boolean bl = false;
        if (!datasetGroupItemRemovingEvent.isCancel()) {
            bl = DatasetGroupNative.jni_RemoveDataset(this.getHandle(), datasetName);
            this.fireRemoved(new DatasetGroupItemRemovedEvent(this, datasetName));
        }
        return bl;
    }

    public int indexOf(String datasetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        String string = "";
        Dataset dataset = this.m_parent.getDatasource().getDatasets().get(datasetName);
        if (dataset != null) {
            string = dataset.getTableName();
            n = DatasetGroupNative.jni_IndexOfDataset(this.getHandle(), string);
        }
        return n;
    }

    @Override
    protected void clearHandle() {
        this.m_parent = null;
        this.m_datasource = null;
        if (this.m_childGroups != null) {
            this.m_childGroups.clearHandle();
            this.m_childGroups = null;
        }
        this.setHandle(0L);
    }

    public synchronized void addRenamedListener(DatasetGroupRenamedListener l) {
        if (this.m_renamedListeners == null) {
            this.m_renamedListeners = new Vector();
        }
        if (!this.m_renamedListeners.contains(l)) {
            this.m_renamedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRenamedListener(DatasetGroupRenamedListener l) {
        if (this.m_renamedListeners != null && this.m_renamedListeners.contains(l)) {
            this.m_renamedListeners.remove(l);
        }
    }

    public synchronized void addRenamingListener(DatasetGroupRenamingListener l) {
        if (this.m_renamingListeners == null) {
            this.m_renamingListeners = new Vector();
        }
        if (!this.m_renamingListeners.contains(l)) {
            this.m_renamingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRenamingListener(DatasetGroupRenamingListener l) {
        if (this.m_renamingListeners != null && this.m_renamingListeners.contains(l)) {
            this.m_renamingListeners.remove(l);
        }
    }

    protected void fireRenaming(DatasetGroupRenamingEvent event) {
        if (this.m_renamingListeners != null) {
            Vector<DatasetGroupRenamingListener> vector = this.m_renamingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupRenaming(event);
            }
        }
    }

    protected void fireRenamed(DatasetGroupRenamedEvent event) {
        if (this.m_renamedListeners != null) {
            Vector<DatasetGroupRenamedListener> vector = this.m_renamedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupRenamed(event);
            }
        }
    }

    public synchronized void addAddedListener(DatasetGroupItemAddedListener l) {
        if (this.m_addedListeners == null) {
            this.m_addedListeners = new Vector();
        }
        if (!this.m_addedListeners.contains(l)) {
            this.m_addedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeAddedListener(DatasetGroupItemAddedListener l) {
        if (this.m_addedListeners != null && this.m_addedListeners.contains(l)) {
            this.m_addedListeners.remove(l);
        }
    }

    protected void fireAdded(DatasetGroupItemAddedEvent event) {
        if (this.m_addedListeners != null) {
            Vector<DatasetGroupItemAddedListener> vector = this.m_addedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupItemAdded(event);
            }
        }
    }

    public synchronized void addRemovingListener(DatasetGroupItemRemovingListener l) {
        if (this.m_removingListeners == null) {
            this.m_removingListeners = new Vector();
        }
        if (!this.m_removingListeners.contains(l)) {
            this.m_removingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRemovingListener(DatasetGroupItemRemovingListener l) {
        if (this.m_removingListeners != null && this.m_removingListeners.contains(l)) {
            this.m_removingListeners.remove(l);
        }
    }

    protected void fireRemoving(DatasetGroupItemRemovingEvent event) {
        if (this.m_removingListeners != null) {
            Vector<DatasetGroupItemRemovingListener> vector = this.m_removingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupItemRemoving(event);
            }
        }
    }

    public synchronized void addRemovedListener(DatasetGroupItemRemovedListener l) {
        if (this.m_removedListeners == null) {
            this.m_removedListeners = new Vector();
        }
        if (!this.m_removedListeners.contains(l)) {
            this.m_removedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRemovedListener(DatasetGroupItemRemovedListener l) {
        if (this.m_removedListeners != null && this.m_removedListeners.contains(l)) {
            this.m_removedListeners.remove(l);
        }
    }

    protected void fireRemoved(DatasetGroupItemRemovedEvent e) {
        if (this.m_removedListeners != null) {
            Vector<DatasetGroupItemRemovedListener> vector = this.m_removedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupItemRemoved(e);
            }
        }
    }
}

