/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoDatumNative;
import com.supermap.data.GeoDatumType;
import com.supermap.data.GeoSpheroid;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class GeoDatum
extends InternalHandleDisposable {
    private GeoSpheroid m_geoSpheroid = null;

    public GeoDatum() {
        long l = GeoDatumNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoDatum(GeoDatumType type) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        long l = GeoDatumNative.jni_New2(n);
        this.setHandle(l, true);
    }

    public GeoDatum(GeoSpheroid geoSpheroid, String name) {
        if (geoSpheroid == null || geoSpheroid.getHandle() == 0L) {
            String string = InternalResource.loadString("geoSpheroid", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoDatumNative.jni_New3(geoSpheroid.getHandle(), name);
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoSpheroid);
    }

    public GeoDatum(GeoDatum geoDatum) {
        if (geoDatum == null || geoDatum.getHandle() == 0L) {
            String string = InternalResource.loadString("geoDatum", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoDatumNative.jni_Clone(geoDatum.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoDatum);
    }

    GeoDatum(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    public GeoDatum clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoDatum(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoDatumNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.m_geoSpheroid != null) {
            this.m_geoSpheroid.clearHandle();
            this.m_geoSpheroid = null;
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoDatumNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoDatumNative.jni_SetName(this.getHandle(), value);
    }

    public GeoSpheroid getGeoSpheroid() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeoSpheroid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if ((this.m_geoSpheroid == null || this.m_geoSpheroid.getHandle() == 0L) && (l = GeoDatumNative.jni_GetGeoSpheroid(this.getHandle())) != 0L) {
            this.m_geoSpheroid = new GeoSpheroid(l, false);
        }
        return this.m_geoSpheroid;
    }

    public void setGeoSpheroid(GeoSpheroid value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGeoSpheroid(GeoSpheroid value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != GeoDatumType.DATUM_USER_DEFINED) {
            String string = InternalResource.loadString("setGeoSpheroid(GeoSpheroid value)", "IfTypeNotUserDefinedCantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (value == null || value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoDatumNative.jni_SetGeoSpheroid(this.getHandle(), value.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public GeoDatumType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoDatumNative.jni_GetType(this.getHandle());
        return (GeoDatumType)Enum.parseUGCValue(GeoDatumType.class, n);
    }

    public void setType(GeoDatumType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setType(GeoDatumType value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(value);
        GeoDatumNative.jni_SetType(this.getHandle(), n);
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = GeoDatumNative.jni_FromXML(this.getHandle(), xml);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoDatumNative.jni_ToXML(this.getHandle());
    }
}

