/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PlaneNative;
import com.supermap.data.PlaneType;
import com.supermap.data.Point3D;

public class Plane
extends InternalHandleDisposable {
    public Plane() {
        long l = PlaneNative.jni_New();
        this.setHandle(l, true);
    }

    public Plane(Plane pPlane, Boolean cloneable) {
        if (pPlane == null) {
            String string = InternalResource.loadString("pPlane", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(pPlane);
        if (l == 0L) {
            String string = InternalResource.loadString("pPlane", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (cloneable.booleanValue()) {
            long l2 = PlaneNative.jni_New2(pPlane.getHandle());
            this.setHandle(l2, true);
        } else {
            this.setHandle(pPlane.getHandle(), true);
        }
    }

    public Plane(PlaneType type) {
        this.setType(type);
    }

    public Plane(Point3D normal, double distance) {
        long l = PlaneNative.jni_New3(normal.getX(), normal.getY(), normal.getZ(), distance);
        this.setHandle(l, true);
    }

    public Plane(Point3D normal, Point3D point) {
        long l = PlaneNative.jni_New4(normal.getX(), normal.getY(), normal.getZ(), point.getX(), point.getY(), point.getZ());
        this.setHandle(l, true);
    }

    public Plane(Point3D point0, Point3D point1, Point3D point2) {
        long l = PlaneNative.jni_New5(point0.getX(), point0.getY(), point0.getZ(), point1.getX(), point1.getY(), point1.getZ(), point2.getX(), point2.getY(), point2.getZ());
        this.setHandle(l, true);
    }

    public Plane(double cutA, double cutB, double cutC) {
        long l = PlaneNative.jni_New6(cutA, cutB, cutC);
        this.setHandle(l, true);
    }

    public Plane(double A, double B, double C, double D) {
        long l = PlaneNative.jni_New7(A, B, C, D);
        this.setHandle(l, true);
    }

    public boolean valid() {
        return PlaneNative.jni_Valid(this.getHandle());
    }

    public void setType(PlaneType type) {
        this.setIsDisposable(true);
        this.dispose();
        long l = PlaneNative.jni_SetType(type.value());
        this.setHandle(l, true);
    }

    public boolean ptInPlane(Point3D point) {
        if (this.valid()) {
            return PlaneNative.jni_PtInPlane(this.getHandle(), point.getX(), point.getY(), point.getZ());
        }
        return false;
    }

    public void translate(double offset) {
        if (this.valid()) {
            PlaneNative.jni_Translate(this.getHandle(), offset);
        }
    }

    public double getDistance(Point3D vPoint) {
        double d = 0.0;
        if (this.valid()) {
            d = PlaneNative.jni_GetDistance(this.getHandle(), vPoint.getX(), vPoint.getY(), vPoint.getZ());
        }
        return d;
    }

    public void normalize() {
        if (this.valid()) {
            PlaneNative.jni_Normalize(this.getHandle());
        }
    }

    public Point3D getNormal() {
        Point3D point3D = null;
        if (this.valid()) {
            double[] dArray = new double[3];
            PlaneNative.jni_GetNormal(this.getHandle(), dArray);
            point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        }
        return point3D;
    }

    public void setNormal(Point3D normal) {
        if (this.valid()) {
            PlaneNative.jni_SetNormal(this.getHandle(), normal.getX(), normal.getY(), normal.getZ());
        }
    }

    public double getDistance() {
        Double d = 0.0;
        if (this.valid()) {
            d = PlaneNative.jni_GetPlaneDistance(this.getHandle());
        }
        return d;
    }

    public void setDistance(double distance) {
        if (this.valid()) {
            PlaneNative.jni_SetPlaneDistance(this.getHandle(), distance);
        }
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            PlaneNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

