/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.license;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.bslicense.BsLicense;
import com.supermap.bslicense.LicenseChangeEvent;
import com.supermap.bslicense.SupermapProductType;
import com.supermap.jsuperpy.license.LoginResult;
import java.util.concurrent.ConcurrentHashMap;

class PythonBsLicense {
    private BsLicense m_license = null;
    private static ConcurrentHashMap<SupermapProductType, PythonBsLicense> g_instances = new ConcurrentHashMap();
    private SupermapProductType m_productType;
    private int[] m_featureIds;
    private static String m_licenseServer;
    private LoginResult m_licenseResult = LoginResult.NoLicense();

    public static void setLicenseServer(String licServer) {
        m_licenseServer = licServer;
    }

    private PythonBsLicense(SupermapProductType productType) {
        this.m_productType = productType;
        this.m_featureIds = PythonBsLicense.getFeatureIDs(productType);
        this.login();
    }

    private static int[] getFeatureIDs(SupermapProductType productType) {
        if (productType == SupermapProductType.ISERVER) {
            return new int[]{ProductType.ISERVER_MACHINE_LEARNING.value(), ProductType.ISERVER_MACHINE_LEARNING_16CORES.value(), ProductType.ISERVER_MACHINE_LEARNING_32CORES.value(), ProductType.ISERVER_MACHINE_LEARNING_ADDITIONAL_2CORES.value(), 65400};
        }
        if (productType == SupermapProductType.IDESKTOPJAVA) {
            return new int[]{ProductType.IDESKTOPJAVA_ENTERPRISE.value(), ProductType.IDESKTOPJAVA_MACHINELEANING.value(), ProductType.IDESKTOPJAVA_VIDEOMAP.value(), ProductType.IDESKTOPJAVA_ADVANCE.value(), 65400};
        }
        if (productType == SupermapProductType.IOBJECTSSPARK) {
            return new int[]{ProductType.IOBJECTS_SPARK_RUNTIME.value(), ProductType.IOBJECTS_SPARK_DEVELOP.value(), 65400};
        }
        if (productType == SupermapProductType.IOBJECTPYTHON) {
            return new int[]{ProductType.IOBJECTS_PYTHON_DEVELOP.value(), ProductType.IOBJECTS_PYTHON_RUNTIME.value(), 65400};
        }
        return new int[0];
    }

    private void login() {
        if (m_licenseServer == null || m_licenseServer.isEmpty()) {
            return;
        }
        for (char a : m_licenseServer.toCharArray()) {
            if (!Character.isWhitespace(a)) continue;
            return;
        }
        try {
            this.m_license = new BsLicense();
            this.m_license.setServerUrl(m_licenseServer);
            this.m_license.setProductType(this.m_productType);
            this.m_license.open();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_license = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonBsLicense getInstance(SupermapProductType productType) {
        Class<PythonBsLicense> clazz = PythonBsLicense.class;
        synchronized (PythonBsLicense.class) {
            if (g_instances.containsKey(productType)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return g_instances.get(productType);
            }
            PythonBsLicense instance = new PythonBsLicense(productType);
            g_instances.put(productType, instance);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized LoginResult checkCoreLicense() {
        if (this.m_licenseResult == LoginResult.OK()) {
            return this.m_licenseResult;
        }
        if (this.m_license == null) {
            this.m_licenseResult = LoginResult.NoLicense();
            return this.m_licenseResult;
        }
        this.m_license.open();
        this.m_license.setFeatureIds(this.m_featureIds);
        LicenseChangeEvent event = this.m_license.getLicenseSyn();
        if (event != null) {
            PythonBsLicense.setLicense(event.getLicenseXml());
            this.m_licenseResult = LoginResult.OK();
        } else {
            this.m_licenseResult = LoginResult.NoLicense();
        }
        this.m_license.close();
        return this.m_licenseResult;
    }

    private static void setLicense(String licenseXML) {
        License.setSpecifyLicenseXML((String)licenseXML);
    }
}

