/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer;

import com.supermap.jsuperpy.serializer.DataSerializers;
import com.supermap.jsuperpy.serializer.SerializerUtil;

public abstract class DataSerializer {
    public abstract Class getValueClass();

    public abstract String getTypeName();

    public abstract byte[] encode(Object var1);

    public abstract Object decode(byte[] var1);

    private byte[] serializeNull() {
        byte[] typeNameBytes = SerializerUtil.encodeString("!n;");
        if (typeNameBytes == null || typeNameBytes.length == 0) {
            throw new RuntimeException("Failed to serialize type name !n;");
        }
        return typeNameBytes;
    }

    public byte[] serialize(Object value) {
        if (value == null) {
            return this.serializeNull();
        }
        byte[] typeNameBytes = SerializerUtil.encodeString(String.format("!%s;", this.getTypeName()));
        if (typeNameBytes == null || typeNameBytes.length == 0) {
            throw new RuntimeException("Failed to serialize type name " + this.getTypeName());
        }
        byte[] valueBytes = this.encode(value);
        if (valueBytes == null) {
            valueBytes = new byte[]{};
        }
        byte[] resBytes = new byte[typeNameBytes.length + valueBytes.length];
        System.arraycopy(typeNameBytes, 0, resBytes, 0, typeNameBytes.length);
        System.arraycopy(valueBytes, 0, resBytes, typeNameBytes.length, valueBytes.length);
        return resBytes;
    }

    public static Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        int nPos = -1;
        if (bytes[0] == 33) {
            for (int i = 1; i < bytes.length; ++i) {
                if (bytes[i] != 59) continue;
                nPos = i;
                break;
            }
            if (nPos == -1) {
                throw new IllegalArgumentException("Cannot find valid type name");
            }
            byte[] typeBytes = new byte[nPos - 1];
            System.arraycopy(bytes, 1, typeBytes, 0, nPos - 1);
            String typeName = SerializerUtil.decodeString(typeBytes);
            if (typeName.isEmpty()) {
                throw new IllegalArgumentException("Cannot find valid type name");
            }
            byte[] valueBytes = new byte[bytes.length - nPos - 1];
            System.arraycopy(bytes, nPos + 1, valueBytes, 0, valueBytes.length);
            return DataSerializers.decode(typeName, valueBytes);
        }
        throw new IllegalArgumentException("invalid input bytes");
    }
}

