/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.ProcessInfo;
import com.supermap.jsuperpy.protos.ProcessInfoMessage;
import com.supermap.jsuperpy.serializer.DataSerializer;
import com.supermap.jsuperpy.serializer.DataSerializers;
import java.util.HashMap;
import java.util.Map;
import supermap.shaded.com.google.protobuf.ByteString;
import supermap.shaded.com.google.protobuf.InvalidProtocolBufferException;

public class ProcessInfoSerializer
extends DataSerializer {
    @Override
    public String getTypeName() {
        return "PI";
    }

    @Override
    public Class getValueClass() {
        return ProcessInfo.class;
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof ProcessInfo) {
            ProcessInfo processInfo = (ProcessInfo)value;
            ProcessInfoMessage.ProtoProcessInfo.Builder builder = ProcessInfoMessage.ProtoProcessInfo.newBuilder().setPyCode(processInfo.getPyCode()).setPyEntryClass(processInfo.getEntryClass());
            Map<String, Object> args = processInfo.getArgs();
            for (String name : args.keySet()) {
                Object argValue = args.get(name);
                builder.putKvargs(name, ByteString.copyFrom(DataSerializers.serialize(argValue)));
            }
            return builder.build().toByteArray();
        }
        return new byte[0];
    }

    @Override
    public ProcessInfo decode(byte[] bys) {
        if (bys == null) {
            return null;
        }
        ProcessInfoMessage.ProtoProcessInfo protoProcessInfo = null;
        try {
            protoProcessInfo = ProcessInfoMessage.ProtoProcessInfo.parseFrom(bys);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            return null;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        Map<String, ByteString> kvArgs = protoProcessInfo.getKvargsMap();
        for (String name : kvArgs.keySet()) {
            ByteString byteValue = kvArgs.get(name);
            Object argValue = DataSerializers.deserialize(byteValue.toByteArray());
            args.put(name, argValue);
        }
        return new ProcessInfo(protoProcessInfo.getPyCode(), protoProcessInfo.getPyEntryClass(), args);
    }
}

