/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.serializer.DataSerializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ShortArraySerializer
extends DataSerializer {
    @Override
    public Class getValueClass() {
        return short[].class;
    }

    @Override
    public String getTypeName() {
        return "sL";
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof short[]) {
            short[] values = (short[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 2).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putShort(values[i]);
            }
            return byteBuffer.array();
        }
        if (value instanceof Short[]) {
            Short[] values = (Short[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 2).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putShort(values[i]);
            }
            return byteBuffer.array();
        }
        return new byte[0];
    }

    public short[] decode(byte[] bys) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bys);
        short[] values = new short[byteBuffer.limit() / 2];
        for (int i = 0; i < values.length; ++i) {
            values[i] = byteBuffer.getShort();
        }
        return values;
    }
}

