/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.mapping.ChartAttributeInfoNative;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;

public class ChartAttributeInfo
extends InternalHandleDisposable {
    protected ChartAttributeInfo() {
        this.setHandle(ChartAttributeInfoNative.jni_New(), true);
    }

    protected ChartAttributeInfo(long handle) {
        this.setHandle(handle, true);
    }

    protected static ChartAttributeInfo createInstance(long handle) {
        if (handle == 0L) {
            return null;
        }
        ChartAttributeInfo chartAttributeInfo = new ChartAttributeInfo(handle);
        return chartAttributeInfo;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ChartAttributeInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartAttributeInfoNative.jni_GetName(this.getHandle());
    }

    public String getAcronym() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAcronym()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartAttributeInfoNative.jni_GetAcronym(this.getHandle());
    }

    public int getCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartAttributeInfoNative.jni_GetCode(this.getHandle());
    }

    public Object getValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ChartAttributeInfoNative.jni_GetValueType(this.getHandle(), false);
        Object object = null;
        switch (n) {
            case 3: {
                object = ChartAttributeInfoNative.jni_GetValueInt(this.getHandle());
                break;
            }
            case 4: {
                object = ChartAttributeInfoNative.jni_GetValueLong(this.getHandle());
                break;
            }
            case 6: {
                object = ChartAttributeInfoNative.jni_GetValueDouble(this.getHandle());
                break;
            }
            case 9: {
                object = ChartAttributeInfoNative.jni_GetValueString(this.getHandle());
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    protected void setValue(Object value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ChartAttributeInfoNative.jni_GetValueType(this.getHandle(), true);
        switch (n) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                if (value != null) {
                    String string = value.toString();
                    ChartAttributeInfoNative.jni_SetValueString(this.getHandle(), string);
                    break;
                }
                String string = "";
                ChartAttributeInfoNative.jni_SetValueString(this.getHandle(), string);
                break;
            }
            case 3: {
                if (value != null) {
                    if (value instanceof Double) {
                        Double d = (Double)value;
                        ChartAttributeInfoNative.jni_SetValueDouble(this.getHandle(), d);
                        break;
                    }
                    if (value instanceof Float) {
                        Float f = (Float)value;
                        ChartAttributeInfoNative.jni_SetValueDouble(this.getHandle(), f.doubleValue());
                        break;
                    }
                    if (value instanceof String) {
                        String string = value.toString();
                        if (!string.isEmpty()) {
                            Double d = Double.valueOf(value.toString());
                            ChartAttributeInfoNative.jni_SetValueDouble(this.getHandle(), d);
                            break;
                        }
                        ChartAttributeInfoNative.jni_SetValueString(this.getHandle(), string);
                        break;
                    }
                    String string = InternalResource.loadString("setValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
                String string = "";
                ChartAttributeInfoNative.jni_SetValueString(this.getHandle(), string);
                break;
            }
            case 4: {
                if (value != null) {
                    if (value instanceof Integer) {
                        Integer n2 = (Integer)value;
                        ChartAttributeInfoNative.jni_SetValueInt(this.getHandle(), n2);
                        break;
                    }
                    if (value instanceof String) {
                        String string = value.toString();
                        if (!string.isEmpty()) {
                            Integer n3 = Integer.valueOf(string);
                            ChartAttributeInfoNative.jni_SetValueInt(this.getHandle(), n3);
                            break;
                        }
                        ChartAttributeInfoNative.jni_SetValueString(this.getHandle(), string);
                        break;
                    }
                    String string = InternalResource.loadString("setValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
                String string = "";
                ChartAttributeInfoNative.jni_SetValueString(this.getHandle(), string);
                break;
            }
        }
    }
}

