/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.TextStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.ThemeLabelNative;
import com.supermap.mapping.ThemeLabelUniqueItems;

public class ThemeLabelUniqueItem {
    private String m_unique = null;
    private boolean m_isVisible = true;
    private double m_offsetX = 0.0;
    private double m_offsetY = 0.0;
    private String m_caption = "UntitledThemeUniqueItem";
    private TextStyle m_TextStyle = null;
    private ThemeLabelUniqueItems m_themeLabelUniqueitems = null;
    private boolean isUserThemeLabelUniqueItems = false;

    public ThemeLabelUniqueItem() {
        TextStyle textStyle = new TextStyle();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_TextStyle = textStyle;
        this.isUserThemeLabelUniqueItems = false;
    }

    public ThemeLabelUniqueItem(String unique, TextStyle style) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (unique == null) {
            unique = "";
        }
        this.m_unique = unique;
        TextStyle textStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_TextStyle = textStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        this.isUserThemeLabelUniqueItems = false;
    }

    public ThemeLabelUniqueItem(String unique, String caption, TextStyle style) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (unique == null) {
            unique = "";
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_unique = unique;
        this.m_caption = caption;
        TextStyle textStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_TextStyle = textStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        this.isUserThemeLabelUniqueItems = false;
    }

    public ThemeLabelUniqueItem(String unique, String caption, TextStyle textstyle, double offsetX, double offsetY) {
        if (textstyle == null) {
            String string = InternalResource.loadString("textstyle", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)textstyle);
        if (l == 0L) {
            String string = InternalResource.loadString("textstyle", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (unique == null) {
            unique = "";
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_unique = unique;
        this.m_caption = caption;
        this.m_offsetX = offsetX;
        this.m_offsetY = offsetY;
        TextStyle textStyle = textstyle.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_TextStyle = textStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        this.isUserThemeLabelUniqueItems = false;
    }

    public ThemeLabelUniqueItem(ThemeLabelUniqueItem themeLabelUniqueItem) {
        if (themeLabelUniqueItem == null) {
            String string = InternalResource.loadString("ThemeLabelUniqueItem", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeLabelUniqueItem.isUserThemeLabelUniqueItems) {
            this.getItemIndex();
            this.getThemeLabelHandle();
        }
        this.m_unique = themeLabelUniqueItem.getUnique();
        this.m_isVisible = themeLabelUniqueItem.isVisible();
        this.m_caption = themeLabelUniqueItem.getCaption();
        this.m_offsetX = themeLabelUniqueItem.getOffsetX();
        this.m_offsetY = themeLabelUniqueItem.getOffsetY();
        TextStyle textStyle = themeLabelUniqueItem.getStyle().clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_TextStyle = textStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        this.isUserThemeLabelUniqueItems = false;
    }

    ThemeLabelUniqueItem(ThemeLabelUniqueItems themeLabelUniqueItems) {
        this.m_themeLabelUniqueitems = themeLabelUniqueItems;
        this.isUserThemeLabelUniqueItems = true;
    }

    public String getUnique() {
        String string = null;
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            string = ThemeLabelNative.jni_GetUniqueAt(l, n);
        } else {
            string = this.m_unique == null ? "" : this.m_unique;
        }
        return string;
    }

    private long getThemeLabelHandle() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabelUniqueitems.getThemeLabel());
        if (l == 0L) {
            String string = InternalResource.loadString("getUnique()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return l;
    }

    private int getItemIndex() {
        int n = this.m_themeLabelUniqueitems.getLabelItemsList().indexOf(this);
        if (n == -1) {
            String string = InternalResource.loadString("getUnique()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return n;
    }

    public void setUnique(String value) {
        if (value == null) {
            value = "";
        }
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            boolean bl = ThemeLabelNative.jni_UniqueIsExist(l, value);
            if (bl) {
                String string = InternalResource.loadString("value", "ThemeUniqueItem_TheUniqueIsExist", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeLabelNative.jni_SetUniqueAt(l, n, value);
        }
        this.m_unique = value;
    }

    public boolean isVisible() {
        boolean bl = false;
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            bl = ThemeLabelNative.jni_GetUniqueIsVisible(l, n);
        } else {
            bl = this.m_isVisible;
        }
        return bl;
    }

    public void setVisible(boolean value) {
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            ThemeLabelNative.jni_SetUniqueIsVisible(l, n, value);
        }
        this.m_isVisible = value;
    }

    public String getCaption() {
        String string = null;
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            string = ThemeLabelNative.jni_GetUniqueCaptionAt(l, n);
        } else {
            string = this.m_caption == null ? "" : this.m_caption;
        }
        return string;
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            ThemeLabelNative.jni_SetUniqueCaptionAt(l, n, caption);
        }
        this.m_caption = caption;
    }

    public double getOffsetX() {
        double d;
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            d = ThemeLabelNative.jni_GetUniqueOffsetXAt(l, n);
        } else {
            d = this.m_offsetX == 0.0 ? 0.0 : this.m_offsetX;
        }
        return d;
    }

    public void setOffsetX(double value) {
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            ThemeLabelNative.jni_SetUniqueOffsetXAt(l, n, value);
        }
        this.m_offsetX = value;
    }

    public double getOffsetY() {
        double d;
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            d = ThemeLabelNative.jni_GetUniqueOffsetYAt(l, n);
        } else {
            d = this.m_offsetY == 0.0 ? 0.0 : this.m_offsetY;
        }
        return d;
    }

    public void setOffsetY(double value) {
        if (this.isUserThemeLabelUniqueItems) {
            int n = this.getItemIndex();
            long l = this.getThemeLabelHandle();
            ThemeLabelNative.jni_SetUniqueOffsetYAt(l, n, value);
        }
        this.m_offsetY = value;
    }

    public TextStyle getStyle() {
        if (this.isUserThemeLabelUniqueItems) {
            long l;
            int n = this.getItemIndex();
            long l2 = this.getThemeLabelHandle();
            if (this.m_TextStyle == null && (l = ThemeLabelNative.jni_GetUniqueStyleAt(l2, n)) != 0L) {
                this.m_TextStyle = InternalTextStyle.createInstance(l);
            }
        }
        return this.m_TextStyle;
    }

    public void setStyle(TextStyle textstyle) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeLabelUniqueItems) {
            n = this.getItemIndex();
            l = this.getThemeLabelHandle();
        }
        if (textstyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textstyle);
        if (l2 == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle = textstyle.clone();
        long l3 = 0L;
        if (this.isUserThemeLabelUniqueItems) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
            ThemeLabelNative.jni_SetUniqueStyleAt(l, n, l3);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
            if (this.m_TextStyle == null) {
                this.m_TextStyle = textStyle;
            } else {
                InternalTextStyle.changeHandle(this.m_TextStyle, l3);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
    }

    public String toString() {
        if (this.isUserThemeLabelUniqueItems) {
            this.getItemIndex();
            this.getThemeLabelHandle();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption =");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",Unique = ");
        stringBuffer.append(this.getUnique());
        stringBuffer.append(",Visible = ");
        stringBuffer.append(this.isVisible());
        stringBuffer.append(",TextStyle = ");
        stringBuffer.append(this.getStyle().toString());
        stringBuffer.append(",Offsetx = ");
        stringBuffer.append(this.getOffsetX());
        stringBuffer.append(",OffsetY = ");
        stringBuffer.append(this.getOffsetY());
        stringBuffer.append("}\n");
        String string = new String(stringBuffer);
        return string;
    }

    void clearHandle() {
        if (this.m_TextStyle != null) {
            InternalTextStyle.clearHandle(this.m_TextStyle);
            this.m_TextStyle = null;
        }
    }
}

