/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.TextStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.ThemeLabel;
import com.supermap.mapping.ThemeLabelNative;
import com.supermap.mapping.ThemeLabelUniqueItem;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class ThemeLabelUniqueItems
extends InternalHandle {
    private ArrayList<ThemeLabelUniqueItem> m_ThemeLabelUniqueItems = null;
    private ThemeLabel m_ThemeLabel = null;
    private TextStyle m_defaultTextStyle = null;
    ReentrantLock m_lock;

    protected ThemeLabelUniqueItems(ThemeLabel themeLabel) {
        if (themeLabel == null) {
            String string = InternalResource.loadString("ThemeLabelUniqueItems", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabel) == 0L) {
            String string = InternalResource.loadString("ThemeLabelUniqueItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_ThemeLabel = themeLabel;
        this.m_ThemeLabelUniqueItems = new ArrayList();
        int n = ThemeLabelNative.jni_GetUniqueValueCount(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeLabel));
        for (int i = 0; i < n; ++i) {
            ThemeLabelUniqueItem themeLabelUniqueItem = new ThemeLabelUniqueItem(this);
            this.m_ThemeLabelUniqueItems.add(themeLabelUniqueItem);
        }
        this.m_lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(ThemeLabelUniqueItem labelUniqueitem) {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L && this.m_ThemeLabelUniqueItems != null) {
            String string = InternalResource.loadString("add(ThemeLabelUniqueItem labelUniqueitem)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (labelUniqueitem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeLabelUniqueItem themeLabelUniqueItem = new ThemeLabelUniqueItem(labelUniqueitem);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelUniqueItem.getStyle());
        int n = -1;
        try {
            this.m_lock.lock();
            n = ThemeLabelNative.jni_AddUnique(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel), themeLabelUniqueItem.getUnique(), themeLabelUniqueItem.isVisible(), themeLabelUniqueItem.getCaption(), themeLabelUniqueItem.getOffsetX(), themeLabelUniqueItem.getOffsetY(), l);
            if (n != -1) {
                ThemeLabelUniqueItem themeLabelUniqueItem2 = new ThemeLabelUniqueItem(this);
                if (this.m_ThemeLabelUniqueItems != null) {
                    this.m_ThemeLabelUniqueItems.add(themeLabelUniqueItem2);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)themeLabelUniqueItem);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int index, ThemeLabelUniqueItem item) {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L && this.m_ThemeLabelUniqueItems != null) {
            String string = InternalResource.loadString("insert(int index, ThemeLabelUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index > n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeLabelUniqueItem themeLabelUniqueItem = new ThemeLabelUniqueItem(item);
        boolean bl = false;
        this.m_lock.lock();
        try {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelUniqueItem.getStyle());
            if (index == n) {
                int n2 = ThemeLabelNative.jni_AddUnique(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel), themeLabelUniqueItem.getUnique(), themeLabelUniqueItem.isVisible(), themeLabelUniqueItem.getCaption(), themeLabelUniqueItem.getOffsetX(), themeLabelUniqueItem.getOffsetY(), l);
                if (n2 == n) {
                    bl = true;
                    ThemeLabelUniqueItem themeLabelUniqueItem2 = new ThemeLabelUniqueItem(this);
                    this.m_ThemeLabelUniqueItems.add(themeLabelUniqueItem2);
                }
            } else {
                bl = ThemeLabelNative.jni_InsertUnique(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel), index, themeLabelUniqueItem.getUnique(), themeLabelUniqueItem.isVisible(), themeLabelUniqueItem.getCaption(), themeLabelUniqueItem.getOffsetX(), themeLabelUniqueItem.getOffsetY(), l);
                if (bl) {
                    ThemeLabelUniqueItem themeLabelUniqueItem3 = new ThemeLabelUniqueItem(this);
                    this.m_ThemeLabelUniqueItems.add(index, themeLabelUniqueItem3);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)themeLabelUniqueItem);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int index) {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L && this.m_ThemeLabelUniqueItems != null) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = ThemeLabelNative.jni_RemoveUnique(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel), index);
            if (bl) {
                ThemeLabelUniqueItem themeLabelUniqueItem = this.m_ThemeLabelUniqueItems.get(index);
                themeLabelUniqueItem.clearHandle();
                this.m_ThemeLabelUniqueItems.remove(index);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public ThemeLabelUniqueItem getItem(int index) {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L && this.m_ThemeLabelUniqueItems != null) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_ThemeLabelUniqueItems.get(index);
    }

    public int getCount() {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetUniqueValueCount(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel));
    }

    ArrayList<ThemeLabelUniqueItem> getLabelItemsList() {
        return this.m_ThemeLabelUniqueItems;
    }

    public TextStyle getDefaultStyle() {
        long l;
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("getDefaultStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_defaultTextStyle == null && (l = ThemeLabelNative.jni_GetDefaultUniqueStyle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()))) != 0L) {
            this.m_defaultTextStyle = InternalTextStyle.createInstance(l);
        }
        return this.m_defaultTextStyle;
    }

    public void setDefaultStyle(TextStyle textstyle) {
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("setDefaultStyle(TextStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (textstyle == null) {
            String string = InternalResource.loadString("textstyle", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)textstyle) == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle = textstyle.clone();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        this.m_defaultTextStyle = textStyle;
        this.m_lock.lock();
        ThemeLabelNative.jni_SetDefaultUniqueStyle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        this.m_lock.unlock();
    }

    public double getDefaultOffsetX() {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("getDefaultOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetDefaultUniqueOffsetX(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()));
    }

    public void setDefaultOffsetX(double value) {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("setDefaultOffsetX(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetDefaultUniqueOffsetX(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), value);
    }

    public double getDefaultOffsetY() {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("getDefaultOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetDefaultUniqueOffsetY(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()));
    }

    public void setDefaultOffsetY(double value) {
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("setDefaultOffsetY(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetDefaultUniqueOffsetY(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), value);
    }

    public boolean isDefaultVisible() {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("isDefaultVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetDefaultUniqueVisible(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()));
    }

    public void setDefaultVisible(boolean value) {
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("setDefaultVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetDefaultUniqueVisible(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), value);
    }

    private void clearLabelItemsList() {
        int n = this.m_ThemeLabelUniqueItems.size();
        for (int i = 0; i < n; ++i) {
            ThemeLabelUniqueItem themeLabelUniqueItem = this.m_ThemeLabelUniqueItems.get(i);
            themeLabelUniqueItem.clearHandle();
        }
        this.m_ThemeLabelUniqueItems.clear();
    }

    protected void refreshLabelItemsList() {
        if (this.m_ThemeLabelUniqueItems != null) {
            this.clearLabelItemsList();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeLabelUniqueItem themeLabelUniqueItem = new ThemeLabelUniqueItem(this);
            this.m_ThemeLabelUniqueItems.add(themeLabelUniqueItem);
        }
    }

    public void reverseStyle() {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_ReverseUniqueStyle(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel));
        this.m_lock.unlock();
    }

    protected ThemeLabel getThemeLabel() {
        if (this.m_ThemeLabel == null) {
            String string = InternalResource.loadString("getThemeLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("ThemeLabel", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_ThemeLabel;
    }

    public void clear() {
        if (this.m_ThemeLabel == null) {
            String string = InternalResource.loadString("getThemeLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel);
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("ThemeLabel", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_Clear(l);
        this.m_lock.unlock();
        this.clearHandle();
    }

    protected void clearHandle() {
        int n = this.m_ThemeLabelUniqueItems.size();
        for (int i = 0; i < n; ++i) {
            ThemeLabelUniqueItem themeLabelUniqueItem = this.m_ThemeLabelUniqueItems.get(i);
            themeLabelUniqueItem.clearHandle();
        }
        this.m_ThemeLabelUniqueItems.clear();
    }
}

