/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Map;
import com.supermap.mapping.TrackingLayerNative;
import java.util.concurrent.locks.ReentrantLock;

public class TrackingLayer
extends InternalHandle {
    Map m_map;
    ReentrantLock m_lock;

    private TrackingLayer(long handle, Map map) {
        this.setHandle(handle);
        this.m_map = map;
        this.m_lock = map.m_lock;
        this.reset();
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetCount(this.getHandle());
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayerNative.jni_SetIsVisible(this.getHandle(), value);
    }

    public boolean isSymbolScalable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSymbolScalable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetIsSymbolScalable(this.getHandle());
    }

    public void setSymbolScalable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSymbolScalable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayerNative.jni_SetIsSymbolScalable(this.getHandle(), value);
    }

    public double getSymbolScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetSymbolScale(this.getHandle());
    }

    public void setSymbolScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TrackingLayer_SymbolScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TrackingLayerNative.jni_SetSymbolScale(this.getHandle(), value);
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetIsAntialias(this.getHandle());
    }

    public void setAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAntialias(value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayerNative.jni_SetAntialias(this.getHandle(), value);
    }

    public int add(Geometry geometry, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Geometry geometry, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (tag == null) {
            tag = "";
        }
        this.m_lock.lock();
        int n = TrackingLayerNative.jni_Add(this.getHandle(), l, tag);
        this.makeSureNativeObjectLive((com.supermap.data.InternalHandleDisposable)geometry);
        this.m_lock.unlock();
        return n;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("delete(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_lock.lock();
        boolean bl = TrackingLayerNative.jni_Delete(this.getHandle(), index);
        this.m_lock.unlock();
        return bl;
    }

    public Geometry get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry = null;
        long l = TrackingLayerNative.jni_Get(this.getHandle(), index);
        if (l != 0L) {
            geometry = InternalGeometry.createInstance2(l, this.m_map.getWorkspace());
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public boolean set(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = TrackingLayerNative.jni_Set(this.getHandle(), index, l);
        com.supermap.data.InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        this.m_lock.unlock();
        return bl;
    }

    public String getTag(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTag(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return TrackingLayerNative.jni_GetTag(this.getHandle(), index);
    }

    public boolean setTag(int index, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTag(int index, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (tag == null) {
            tag = "";
        }
        this.m_lock.lock();
        boolean bl = TrackingLayerNative.jni_SetTag(this.getHandle(), index, tag);
        this.m_lock.unlock();
        return bl;
    }

    public int indexOf(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null) {
            String string = InternalResource.loadString("indexOf(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return TrackingLayerNative.jni_IndexOf(this.getHandle(), tag);
    }

    public boolean setEditBulk(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEditBulk(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_SetEditBulk(this.getHandle(), value);
    }

    public boolean flushBulkEdit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FlushBulkEdit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_FlushBulkEdit(this.getHandle());
    }

    @Deprecated
    public boolean cancleBulkOperated() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CancleBulkOperated()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_CancleBulkOperated(this.getHandle());
    }

    public boolean cancelBulkOperated() {
        return this.cancleBulkOperated();
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        TrackingLayerNative.jni_Clear(this.getHandle());
        this.m_lock.unlock();
    }

    public int hitTest(Point2D point, double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "TrackingLayer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return TrackingLayerNative.jni_HitTest(this.getHandle(), point.getX(), point.getY(), tolerance);
    }

    protected static TrackingLayer createInstance(long handle, Map map) {
        return new TrackingLayer(handle, map);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    private void reset() {
        TrackingLayerNative.jni_Reset(this.getHandle());
    }

    private void makeSureNativeObjectLive(com.supermap.data.InternalHandleDisposable obj) {
        InternalHandle.getHandle((com.supermap.data.InternalHandle)obj);
    }
}

