/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Geometry;
import com.supermap.data.Point3D;
import com.supermap.data.Rectangle2D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.InternalEnum;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.SlopMapNative;
import com.supermap.realspace.spatialanalyst.SlopeDisplayMode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SlopeMap
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;
    private Geometry m_coverageRegion = null;
    private double m_opacity = 1.0;
    private SlopeDisplayMode m_displayMode = SlopeDisplayMode.FACE_AND_ARROW;
    private double m_minVisibleSlope = 0.0;
    private double m_maxVisibleSlope = 90.0;
    private boolean m_borderVisible = false;
    private Color m_borderColor = Color.YELLOW;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public SlopeMap(Scene scene) {
        SlopeMap.verifyLicense();
        this.m_scene = scene;
        long l = SlopMapNative.jni_New("");
        this.setHandle(l, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            SlopMapNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    public Geometry getCoverageRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoverageRegion()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_coverageRegion;
    }

    public void setCoverageRegion(Geometry coverageRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoverageRegion()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (coverageRegion == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)coverageRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry = coverageRegion.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        SlopMapNative.jni_SetCoverageRegion(this.getHandle(), l2);
        this.m_coverageRegion = coverageRegion.clone();
    }

    public double getOpacity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOpacity()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_opacity;
    }

    public void setOpacity(double opacity) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOpacity()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SlopMapNative.jni_SetOpacity(this.getHandle(), opacity);
        this.m_opacity = opacity;
    }

    public SlopeDisplayMode getDisplayStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayStyle()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_displayMode;
    }

    public void setDisplayStyle(SlopeDisplayMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayStyle()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(mode);
        SlopMapNative.jni_SetDisplayStyle(this.getHandle(), n);
        this.m_displayMode = mode;
    }

    public double getMinVisibleSlope() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleSlope()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_minVisibleSlope;
    }

    public void setMinVisibleSlope(double slope) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleSlope()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SlopMapNative.jni_SetMinVisibleSlope(this.getHandle(), slope);
        this.m_minVisibleSlope = slope;
    }

    public double getMaxVisibleSlope() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleSlope()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_maxVisibleSlope;
    }

    public void setMaxVisibleSlope(double slope) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleSlope()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SlopMapNative.jni_SetMaxVisibleSlope(this.getHandle(), slope);
        this.m_maxVisibleSlope = slope;
    }

    public boolean isBorderVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBorderVisible()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_borderVisible;
    }

    public void setBorderVisible(boolean borderVisible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderVisible()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SlopMapNative.jni_SetBorderVisible(this.getHandle(), borderVisible);
        this.m_borderVisible = borderVisible;
    }

    public Color getBorderColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBorderColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SlopMapNative.jni_SetBorderColor(this.getHandle(), borderColor.getRGB());
        this.m_borderColor = borderColor;
    }

    public void setColorDictTable(HashMap<Double, Color> colorTable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorDictTable()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = colorTable.size();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        Set<Map.Entry<Double, Color>> set = colorTable.entrySet();
        Iterator<Map.Entry<Double, Color>> iterator = set.iterator();
        Map.Entry<Double, Color> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            nArray[i] = entry.getValue().getRGB();
        }
        SlopMapNative.jni_SetColorDictTable(this.getHandle(), dArray, nArray);
    }

    public HashMap<Double, Color> getColorDictTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorDictTable()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Double, Color> hashMap = new HashMap<Double, Color>();
        double[] dArray = SlopMapNative.jni_GetColorTable_Keys(this.getHandle());
        int[] nArray = SlopMapNative.jni_GetColotTable_Colors(this.getHandle());
        for (int i = 0; i < dArray.length; ++i) {
            hashMap.put(dArray[i], new Color(nArray[i], true));
        }
        return hashMap;
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SlopMapNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SlopMapNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public double getSlopeValue(Point3D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSlopeValue()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SlopMapNative.jni_GetSlopeValue(this.getHandle(), point.getX(), point.getY(), point.getZ());
    }

    public double getSlopeDirectionValue(Point3D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSlopeDirectionValue()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SlopMapNative.jni_GetSlopeDirectionValue(this.getHandle(), point.getX(), point.getY(), point.getZ());
    }

    public boolean isArrowMove() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SlopeMap", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SlopMapNative.jni_IsArrowMove(this.getHandle());
    }

    public void setArrowMove(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SlopeMap", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SlopMapNative.jni_SetArrowMove(this.getHandle(), value);
    }

    public Rectangle2D getCoverageArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SlopeMap", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        SlopMapNative.jni_GetCoverageArea(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setCoverageArea(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SlopeMap", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.isEmpty()) {
            return;
        }
        SlopMapNative.jni_SetCoverageArea(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

