/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.GeoModel3D;
import com.supermap.data.Point3D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.AnalysisQuality;
import com.supermap.realspace.spatialanalyst.DisplayMode;
import com.supermap.realspace.spatialanalyst.DomeType;
import com.supermap.realspace.spatialanalyst.InternalEnum;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.ViewDomeNative;
import java.awt.Color;
import java.util.ArrayList;

public class ViewDome
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public ViewDome(Scene scene) {
        ViewDome.verifyLicense();
        this.m_scene = scene;
        long l = ViewDomeNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            ViewDomeNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ViewDomeNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public Color getColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(ViewDomeNative.jni_GetColor(this.getHandle()), true);
        return color;
    }

    public void setColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("setColor", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        ViewDomeNative.jni_SetColor(this.getHandle(), color.getRGB());
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(ViewDomeNative.jni_GetLineColor(this.getHandle()), true);
        return color;
    }

    public void setLineColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("setLineColor", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        ViewDomeNative.jni_SetLineColor(this.getHandle(), color.getRGB());
    }

    public Point3D getViewerPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = ViewDomeNative.jni_GetViewerPosition(this.getHandle());
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public void setViewerPosition(Point3D position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ViewDomeNative.jni_SetViewerPosition(this.getHandle(), position.getX(), position.getY(), position.getZ());
    }

    public double getDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistance()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ViewDomeNative.jni_GetDistance(this.getHandle());
    }

    public void setDistance(double distance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDistance()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ViewDomeNative.jni_SetDistance(this.getHandle(), distance);
    }

    public AnalysisQuality getQuality() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getQuality()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = ViewDomeNative.jni_GetQuality(this.getHandle());
        return (AnalysisQuality)InternalEnum.parseUGCValue(AnalysisQuality.class, n);
    }

    public void setQuality(AnalysisQuality quality) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setQuality()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ViewDomeNative.jni_SetQuality(this.getHandle(), quality.value());
    }

    public DomeType getDomeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDomeType()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = ViewDomeNative.jni_GetDomeType(this.getHandle());
        return (DomeType)InternalEnum.parseUGCValue(DomeType.class, n);
    }

    public void setDomeType(DomeType domeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDomeType()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ViewDomeNative.jni_SetDomeType(this.getHandle(), domeType.value());
    }

    public DisplayMode getDisplayStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayStyle()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = ViewDomeNative.jni_GetDisplayStyle(this.getHandle());
        return (DisplayMode)InternalEnum.parseUGCValue(DisplayMode.class, n);
    }

    public void setDisplayStyle(DisplayMode displayMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayStyle()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ViewDomeNative.jni_SetDisplayStyle(this.getHandle(), displayMode.value());
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ViewDomeNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public double getViewDomeRatio(DomeType domeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewDomeRatio()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ViewDomeNative.jni_GetViewDomeRatio(this.getHandle(), domeType.value());
    }

    public GeoModel3D getViewDomeShell(DomeType dometype) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewDomeShell()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l = ViewDomeNative.jni_GetViewDomeShell(this.getHandle(), dometype.value());
        if (l != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public GeoModel3D getViewDomeBody(DomeType dometype) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewDomeBody()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l = ViewDomeNative.jni_GetViewDomeBody(this.getHandle(), dometype.value());
        if (l != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

