/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.data.GeoLine3D;
import com.supermap.data.Point3D;
import com.supermap.realspace.spatialanalyst.BarrierPoint3D;
import java.util.ArrayList;

public class VisibleResult3D {
    private Point3D m_viewPoint;
    private Point3D m_targetPoint;
    private boolean m_visible;
    private GeoLine3D m_lineVisible;
    private GeoLine3D m_lineInvisible;
    private ArrayList<BarrierPoint3D> m_barrierPoint3Ds;

    VisibleResult3D(Point3D viewPoint, Point3D targetPoint, boolean visible, GeoLine3D lineVisible, GeoLine3D lineInvisible, ArrayList<BarrierPoint3D> barrierPoint3Ds) {
        this.m_viewPoint = viewPoint;
        this.m_targetPoint = targetPoint;
        this.m_visible = visible;
        this.m_lineVisible = lineVisible;
        this.m_lineInvisible = lineInvisible;
        this.m_barrierPoint3Ds = barrierPoint3Ds;
    }

    public Point3D getPointView() {
        return this.m_viewPoint;
    }

    public Point3D getPointTarget() {
        return this.m_targetPoint;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public GeoLine3D getLineVisible() {
        return this.m_lineVisible;
    }

    public GeoLine3D getLineInvisible() {
        return this.m_lineInvisible;
    }

    public BarrierPoint3D[] getBarrierPoint3Ds() {
        int n = this.m_barrierPoint3Ds.size();
        BarrierPoint3D[] barrierPoint3DArray = new BarrierPoint3D[n];
        for (int i = 0; i < n; ++i) {
            barrierPoint3DArray[i] = this.m_barrierPoint3Ds.get(i);
        }
        return barrierPoint3DArray;
    }
}

