/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.navigation;

import com.supermap.analyst.navigation.GPSData;
import com.supermap.analyst.navigation.InternalDatasetVector;
import com.supermap.analyst.navigation.InternalDatasets;
import com.supermap.analyst.navigation.InternalHandle;
import com.supermap.analyst.navigation.InternalHandleDisposable;
import com.supermap.analyst.navigation.InternalResource;
import com.supermap.analyst.navigation.MapMatchLatestInfo;
import com.supermap.analyst.navigation.MapMatchParameter;
import com.supermap.analyst.navigation.MatchingResult;
import com.supermap.analyst.navigation.PathAnalystNative;
import com.supermap.analyst.navigation.PathInfo;
import com.supermap.analyst.navigation.RouteType;
import com.supermap.analyst.navigation.SSCDataEnvironment;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import java.util.List;

public class PathAnalyst
extends InternalHandleDisposable {
    protected long m_handle;
    protected boolean m_bConnect = false;
    protected boolean m_bSetStartPoint = false;
    protected boolean m_bSetEndPoint = false;
    protected boolean m_bFind = false;
    protected long m_CHhandle = 0L;
    protected boolean m_bUseCH = false;
    protected RouteType m_type = RouteType.RECOMMEND;
    protected Point2D m_pntStart;
    protected Point2D m_pntEnd;
    protected Point2Ds m_arrPoints = null;
    protected boolean m_bCHPath = false;
    protected boolean m_bAlternative = false;
    protected double m_dRatio1 = 0.15;
    protected double m_dRatio2 = 0.8;
    protected double m_dRatio3 = 0.4;

    public void dispose() {
        if (this.m_handle != 0L) {
            this.releasePathInfos();
            PathAnalystNative.jni_Delete(this.m_handle);
        }
        if (this.m_CHhandle != 0L) {
            PathAnalystNative.jni_DeleteCH(this.m_CHhandle);
        }
        if (this.m_arrPoints != null) {
            this.m_arrPoints.clear();
        }
    }

    public boolean connectData(String strPath) {
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_Delete(this.m_handle);
            this.m_handle = 0L;
        }
        this.m_handle = PathAnalystNative.jni_New();
        this.m_bUseCH = false;
        this.m_bConnect = PathAnalystNative.jni_ConnectData(this.m_handle, strPath);
        return this.m_bConnect;
    }

    @Deprecated
    public boolean setSSCEnvironment(SSCDataEnvironment environment) {
        if (environment == null) {
            String string = InternalResource.loadString("environment", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)environment) == 0L) {
            String string = InternalResource.loadString("environment", "SSCEnvironmentNotInitialize", "navigation_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_CHhandle != 0L) {
            PathAnalystNative.jni_DeleteCH(this.m_CHhandle);
            this.m_CHhandle = 0L;
        }
        this.m_CHhandle = PathAnalystNative.jni_NewCH(InternalHandle.getHandle((com.supermap.data.InternalHandle)environment));
        if (this.m_CHhandle != 0L) {
            this.m_bConnect = true;
            this.m_bUseCH = true;
            return true;
        }
        return false;
    }

    public void setStartPoint(Point2D pnt) {
        this.m_pntStart = pnt;
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_SetStartPoint(this.m_handle, pnt.getX(), pnt.getY());
        }
        this.m_bSetStartPoint = true;
    }

    public void setEndPoint(Point2D pnt) {
        this.m_pntEnd = pnt;
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_SetDestinationtPoint(this.m_handle, pnt.getX(), pnt.getY());
        }
        this.m_bSetEndPoint = true;
    }

    public boolean plan() {
        if (this.m_handle != 0L || this.m_CHhandle != 0L) {
            if (this.m_bConnect && this.m_bSetStartPoint && this.m_bSetEndPoint) {
                this.m_bCHPath = false;
                if (this.m_bUseCH) {
                    int n;
                    int n2 = 0;
                    if (this.m_arrPoints != null) {
                        n2 = this.m_arrPoints.getCount();
                    }
                    double[] dArray = new double[n2 + 2];
                    double[] dArray2 = new double[n2 + 2];
                    dArray[0] = this.m_pntStart.getX();
                    dArray2[0] = this.m_pntStart.getY();
                    dArray[n2 + 1] = this.m_pntEnd.getX();
                    dArray2[n2 + 1] = this.m_pntEnd.getY();
                    for (n = 0; n < n2; ++n) {
                        dArray[n + 1] = this.m_arrPoints.getItem(n).getX();
                        dArray2[n + 1] = this.m_arrPoints.getItem(n).getY();
                    }
                    n = PathAnalystNative.jni_PlanCH(this.m_CHhandle, dArray, dArray2, this.m_type.value(), this.m_bAlternative, this.m_dRatio1, this.m_dRatio2, this.m_dRatio3) ? 1 : 0;
                    if (n != 0) {
                        this.m_bCHPath = true;
                        this.m_bFind = true;
                        return true;
                    }
                } else {
                    int n = PathAnalystNative.jni_Plan(this.m_handle);
                    if (n == 1) {
                        this.m_bFind = true;
                        return true;
                    }
                }
            } else {
                if (!this.m_bConnect) {
                    String string = InternalResource.loadString("connectData", "Global_ArgumentNull", "navigation_resources");
                    throw new IllegalArgumentException(string);
                }
                if (!this.m_bSetStartPoint || !this.m_bSetEndPoint) {
                    String string = InternalResource.loadString("StartPoint or EndPoint", "Global_ArgumentNull", "navigation_resources");
                    throw new IllegalArgumentException(string);
                }
            }
        }
        return false;
    }

    public void setPoints(Point2Ds pnts) {
        if (this.m_arrPoints != null) {
            this.m_arrPoints.clear();
        }
        this.m_arrPoints = pnts.clone();
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_RemovePoints(this.m_handle);
            if (pnts != null) {
                for (int i = 0; i < pnts.getCount(); ++i) {
                    PathAnalystNative.jni_SetAddWayPoint(this.m_handle, pnts.getItem(i).getX(), pnts.getItem(i).getY());
                }
            }
        }
    }

    public void setRouteMode(RouteType mode) {
        this.m_type = mode;
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_SetRouteMode(this.m_handle, mode.value());
        }
    }

    public Point2Ds getPathPoints() {
        Point2Ds point2Ds;
        block4: {
            point2Ds = new Point2Ds();
            if (this.m_handle == 0L && this.m_CHhandle == 0L || !this.m_bFind) break block4;
            if (this.m_bCHPath) {
                double[] dArray = PathAnalystNative.jni_GetPathPointCH(this.m_CHhandle);
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Point2D point2D = new Point2D();
                    point2D.setX(dArray[i++]);
                    point2D.setY(dArray[i]);
                    point2Ds.add(point2D);
                }
            } else {
                double[] dArray = PathAnalystNative.jni_GetPathPoint(this.m_handle);
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Point2D point2D = new Point2D();
                    point2D.setX(dArray[i++]);
                    point2D.setY(dArray[i]);
                    point2Ds.add(point2D);
                }
            }
        }
        return point2Ds;
    }

    public double getPathLength() {
        double d = 0.0;
        if ((this.m_handle != 0L || this.m_CHhandle != 0L) && this.m_bFind) {
            d = this.m_bCHPath ? PathAnalystNative.jni_GetPathLengthCH(this.m_CHhandle) : PathAnalystNative.jni_GetPathLength(this.m_handle);
        }
        return d;
    }

    public PathInfo[] getPathInfos() {
        PathInfo[] pathInfoArray;
        block4: {
            pathInfoArray = null;
            if (this.m_handle == 0L && this.m_CHhandle == 0L || !this.m_bFind) break block4;
            if (this.m_bCHPath) {
                long[] lArray = PathAnalystNative.jni_GetPathInfosCH(this.m_CHhandle);
                pathInfoArray = new PathInfo[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    PathInfo pathInfo;
                    pathInfoArray[i] = pathInfo = new PathInfo(lArray[i], this.m_bCHPath);
                }
            } else {
                this.releasePathInfos();
                long[] lArray = PathAnalystNative.jni_GetPathInfos(this.m_handle);
                pathInfoArray = new PathInfo[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    PathInfo pathInfo;
                    pathInfoArray[i] = pathInfo = new PathInfo(lArray[i], this.m_bCHPath);
                }
            }
        }
        return pathInfoArray;
    }

    public double getPathTime() {
        double d = 0.0;
        if (this.m_CHhandle != 0L) {
            d = PathAnalystNative.jni_GetPathTimeCH(this.m_CHhandle);
        }
        return d;
    }

    private void releasePathInfos() {
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_ReleasePathInfos(this.m_handle);
        }
    }

    public boolean isAlternative() {
        return this.m_bAlternative;
    }

    public void setAlternative(boolean value) {
        this.m_bAlternative = value;
    }

    public Point2Ds getAltPathPoints() {
        Point2Ds point2Ds = new Point2Ds();
        if ((this.m_handle != 0L || this.m_CHhandle != 0L) && this.m_bFind && this.m_bAlternative && this.m_bCHPath) {
            double[] dArray = PathAnalystNative.jni_GetAltPathPointCH(this.m_CHhandle);
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Point2D point2D = new Point2D();
                point2D.setX(dArray[i++]);
                point2D.setY(dArray[i]);
                point2Ds.add(point2D);
            }
        }
        return point2Ds;
    }

    public double getAltPathLength() {
        double d = 0.0;
        if ((this.m_handle != 0L || this.m_CHhandle != 0L) && this.m_bFind && this.m_bAlternative && this.m_bCHPath) {
            d = PathAnalystNative.jni_GetAltPathLengthCH(this.m_CHhandle);
        }
        return d;
    }

    public PathInfo[] getAltPathInfos() {
        long[] lArray;
        PathInfo[] pathInfoArray = null;
        if ((this.m_handle != 0L || this.m_CHhandle != 0L) && this.m_bFind && this.m_bAlternative && this.m_bCHPath && (lArray = PathAnalystNative.jni_GetAltPathInfosCH(this.m_CHhandle)).length > 0) {
            pathInfoArray = new PathInfo[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                PathInfo pathInfo;
                pathInfoArray[i] = pathInfo = new PathInfo(lArray[i], this.m_bCHPath);
            }
        }
        return pathInfoArray;
    }

    public double getAltPathTime() {
        double d = 0.0;
        if (this.m_CHhandle != 0L && this.m_bFind && this.m_bAlternative) {
            d = PathAnalystNative.jni_GetAltPathTimeCH(this.m_CHhandle);
        }
        return d;
    }

    private void setRatio1(double value) {
        this.m_dRatio1 = value;
    }

    private double getRatio1() {
        return this.m_dRatio1;
    }

    private void setRatio2(double value) {
        this.m_dRatio2 = value;
    }

    private double getRatio2() {
        return this.m_dRatio2;
    }

    private void setRatio3(double value) {
        this.m_dRatio3 = value;
    }

    private double getRatio3() {
        return this.m_dRatio3;
    }

    MatchingResult mapMatch(List<GPSData> datas, int candidateCount) {
        if (datas == null || datas.size() == 0) {
            String string = InternalResource.loadString("datas", "Global_ArrayLengthShouldGreaterThanZero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (candidateCount <= 0) {
            String string = InternalResource.loadString("candidateCount", "Must_Larger_Than_Zero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_CHhandle != 0L && datas.size() > 0) {
            double[] dArray = new double[datas.size()];
            double[] dArray2 = new double[datas.size()];
            int[] nArray = new int[datas.size()];
            int n = 0;
            for (GPSData gPSData : datas) {
                dArray[n] = gPSData.getPoint().getX();
                dArray2[n] = gPSData.getPoint().getY();
                nArray[n] = gPSData.getTimeValue();
                ++n;
            }
            long l = PathAnalystNative.jni_MapMatch2(this.m_CHhandle, dArray, dArray2, nArray, candidateCount);
            if (l != 0L) {
                return new MatchingResult(l);
            }
        }
        return null;
    }

    @Deprecated
    public Point2Ds mapMatch(GPSData[] datas, int candidateCount) {
        if (datas == null || datas.length == 0) {
            String string = InternalResource.loadString("datas", "Global_ArrayLengthShouldGreaterThanZero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (candidateCount <= 0) {
            String string = InternalResource.loadString("candidateCount", "Must_Larger_Than_Zero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        if (this.m_CHhandle != 0L && datas.length > 0) {
            double[] dArray = new double[datas.length];
            double[] dArray2 = new double[datas.length];
            int[] nArray = new int[datas.length];
            for (int i = 0; i < datas.length; ++i) {
                dArray[i] = datas[i].getPoint().getX();
                dArray2[i] = datas[i].getPoint().getY();
                nArray[i] = datas[i].getTimeValue();
            }
            double[] dArray3 = PathAnalystNative.jni_MapMatch(this.m_CHhandle, dArray, dArray2, nArray, candidateCount);
            int n = dArray3.length;
            for (int i = 0; i < n; ++i) {
                Point2D point2D = new Point2D();
                point2D.setX(dArray3[i++]);
                point2D.setY(dArray3[i]);
                point2Ds.add(point2D);
            }
        }
        return point2Ds;
    }

    @Deprecated
    public Point2Ds traceRectify(GPSData[] tracePoints, int candidateCount) {
        if (tracePoints == null || tracePoints.length == 0) {
            String string = InternalResource.loadString("tracePoints", "Global_ArrayLengthShouldGreaterThanZero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (candidateCount <= 0) {
            String string = InternalResource.loadString("candidateCount", "Must_Larger_Than_Zero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        if (this.m_CHhandle != 0L && tracePoints.length > 0) {
            double[] dArray = new double[tracePoints.length];
            double[] dArray2 = new double[tracePoints.length];
            int[] nArray = new int[tracePoints.length];
            for (int i = 0; i < tracePoints.length; ++i) {
                dArray[i] = tracePoints[i].getPoint().getX();
                dArray2[i] = tracePoints[i].getPoint().getY();
                nArray[i] = tracePoints[i].getTimeValue();
            }
            double[] dArray3 = PathAnalystNative.jni_TraceRectify(this.m_CHhandle, dArray, dArray2, nArray, candidateCount);
            int n = dArray3.length;
            for (int i = 0; i < n; ++i) {
                Point2D point2D = new Point2D();
                point2D.setX(dArray3[i++]);
                point2D.setY(dArray3[i]);
                point2Ds.add(point2D);
            }
        }
        return point2Ds;
    }

    @Deprecated
    public static DatasetVector[] prepareData(MapMatchParameter param, String name) {
        Datasource datasource = param.getDatasetVector().getDatasource();
        DatasetVector datasetVector = param.getDatasetVector();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("param.getDatasetVector()", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "navigation_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().equals("")) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalStateException(string);
        }
        String string = param.getVelocity();
        String string2 = param.getAngle();
        String string3 = param.getTime();
        if (!string.trim().equals("") && datasetVector.getFieldInfos().get(string) == null) {
            String string4 = InternalResource.loadString(string, "FieldNotInDatasetVector", "navigation_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!string2.trim().equals("") && datasetVector.getFieldInfos().get(string2) == null) {
            String string5 = InternalResource.loadString(string2, "FieldNotInDatasetVector", "navigation_resources");
            throw new IllegalArgumentException(string5);
        }
        if (datasetVector.getFieldInfos().get(string3) == null) {
            String string6 = InternalResource.loadString(string3, "FieldNotInDatasetVector", "navigation_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long[] lArray = PathAnalystNative.jni_PrepareData(l, string, string2, string3, name, param.getRarefyTime());
        if (lArray.length < 1) {
            return null;
        }
        DatasetVector[] datasetVectorArray = new DatasetVector[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            DatasetVector datasetVector2 = null;
            datasetVector2 = InternalDatasetVector.createInstance(lArray[i], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
            datasetVectorArray[i] = datasetVector2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)param);
        return datasetVectorArray;
    }

    @Deprecated
    public MapMatchLatestInfo getLatestInfo(GPSData[] datas, int candidateCount) {
        if (candidateCount <= 0) {
            String string = InternalResource.loadString("candidateCount", "Must_Larger_Than_Zero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        MapMatchLatestInfo mapMatchLatestInfo = new MapMatchLatestInfo();
        if (this.m_CHhandle != 0L && datas.length > 0) {
            double[] dArray = new double[datas.length];
            double[] dArray2 = new double[datas.length];
            int[] nArray = new int[datas.length];
            for (int i = 0; i < datas.length; ++i) {
                dArray[i] = datas[i].getPoint().getX();
                dArray2[i] = datas[i].getPoint().getY();
                nArray[i] = datas[i].getTimeValue();
            }
            double[] dArray3 = PathAnalystNative.jni_GetLatestInfo(this.m_CHhandle, dArray, dArray2, nArray, candidateCount);
            int[] nArray2 = new int[dArray3.length - 1];
            for (int i = 0; i < dArray3.length - 1; ++i) {
                nArray2[i] = (int)dArray3[i];
            }
            mapMatchLatestInfo.setArc(nArray2);
            mapMatchLatestInfo.setSpeed(dArray3[dArray3.length - 1]);
        }
        return mapMatchLatestInfo;
    }
}

