/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialstatistics.InternalDatasetVector;
import com.supermap.analyst.spatialstatistics.InternalDatasets;
import com.supermap.analyst.spatialstatistics.InternalHandle;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.InternalToolkitSpatialStatistics;
import com.supermap.analyst.spatialstatistics.MeasureParameter;
import com.supermap.analyst.spatialstatistics.SpatialMeasureNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class SpatialMeasure {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private SpatialMeasure() {
    }

    public static DatasetVector measureMeanCenter(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, MeasureParameter measureParameter) {
        SpatialMeasure.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (measureParameter == null) {
            String string = InternalResource.loadString("measureParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)measureParameter);
        String[] stringArray = new String[1];
        long l4 = SpatialMeasureNative.jni_MeasureMeanCenter(l, l2, targetDatasetName, l3, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)measureParameter));
        return datasetVector;
    }

    public static DatasetVector measureMedianCenter(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, MeasureParameter measureParameter) {
        SpatialMeasure.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (measureParameter == null) {
            String string = InternalResource.loadString("measureParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)measureParameter);
        String[] stringArray = new String[1];
        long l4 = SpatialMeasureNative.jni_MeasureMedianCenter(l, l2, targetDatasetName, l3, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)measureParameter));
        return datasetVector;
    }

    public static DatasetVector measureCentralElement(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, MeasureParameter measureParameter) {
        SpatialMeasure.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (measureParameter == null) {
            String string = InternalResource.loadString("measureParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)measureParameter);
        String[] stringArray = new String[1];
        long l4 = SpatialMeasureNative.jni_MeasureCentralElement(l, l2, targetDatasetName, l3, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)measureParameter));
        return datasetVector;
    }

    public static DatasetVector measureDirectional(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, MeasureParameter measureParameter) {
        SpatialMeasure.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (measureParameter == null) {
            String string = InternalResource.loadString("measureParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)measureParameter);
        String[] stringArray = new String[1];
        long l4 = SpatialMeasureNative.jni_MeasureDirection(l, l2, targetDatasetName, l3, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)measureParameter));
        return datasetVector;
    }

    public static DatasetVector measureStandardDistance(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, MeasureParameter measureParameter) {
        SpatialMeasure.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (measureParameter == null) {
            String string = InternalResource.loadString("measureParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)measureParameter);
        String[] stringArray = new String[1];
        long l4 = SpatialMeasureNative.jni_MeasureStandardDistance(l, l2, targetDatasetName, l3, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)measureParameter));
        return datasetVector;
    }

    public static DatasetVector measureLinearDirectionalMean(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, MeasureParameter measureParameter) {
        SpatialMeasure.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        if (measureParameter == null) {
            String string = InternalResource.loadString("measureParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)measureParameter);
        boolean bl = measureParameter.isOrientation();
        String[] stringArray = new String[1];
        long l4 = SpatialMeasureNative.jni_MeasureLinearDirectionalMean(l, l2, targetDatasetName, l3, bl, stringArray);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)measureParameter));
        return datasetVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "SpatialMeasure";
        boolean bl = InternalToolkitSpatialStatistics.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SpatialMeasure.fireStepped(steppedEvent);
        InternalToolkitSpatialStatistics.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialStatistics.managerProducts(InternalToolkitSpatialStatistics.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialStatistics.verifyLicense(arrayList);
    }
}

