/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.DistanceMethod;
import com.supermap.analyst.spatialstatistics.IncrementalParameterNative;
import com.supermap.analyst.spatialstatistics.InternalEnum;
import com.supermap.analyst.spatialstatistics.InternalHandleDisposable;
import com.supermap.analyst.spatialstatistics.InternalResource;

public class IncrementalParameter
extends InternalHandleDisposable {
    private String m_sAssessmentFieldName;
    private int m_nIncrementalNumber = 10;
    private double m_dBeginDistance = 0.0;
    private double m_dIncrementalDistance = 0.0;
    private boolean m_bStandardization = true;
    private DistanceMethod m_distanceMethod = DistanceMethod.EUCLIDEAN;

    public IncrementalParameter() {
        long l = IncrementalParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            IncrementalParameterNative.jni_Reset(l);
        }
    }

    public IncrementalParameter(IncrementalParameter incrementalParameter) {
        if (incrementalParameter == null) {
            String string = InternalResource.loadString("incrementalParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        long l = IncrementalParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.m_sAssessmentFieldName = incrementalParameter.m_sAssessmentFieldName;
        this.m_nIncrementalNumber = incrementalParameter.m_nIncrementalNumber;
        this.m_dBeginDistance = incrementalParameter.m_dBeginDistance;
        this.m_dIncrementalDistance = incrementalParameter.m_dIncrementalDistance;
        this.m_bStandardization = incrementalParameter.m_bStandardization;
        this.m_distanceMethod = incrementalParameter.m_distanceMethod;
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            IncrementalParameterNative.jni_SetAssessmentField(l, this.m_sAssessmentFieldName);
            IncrementalParameterNative.jni_SetIncrementalNumber(l, this.m_nIncrementalNumber);
            IncrementalParameterNative.jni_SetBeginDistance(l, this.m_dBeginDistance);
            IncrementalParameterNative.jni_SetIncrementalDistance(l, this.m_dIncrementalDistance);
            IncrementalParameterNative.jni_SetStandardization(l, this.m_bStandardization);
            int n = InternalEnum.getUGCValue(this.m_distanceMethod);
            IncrementalParameterNative.jni_SetDistanceMethod(l, n);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            IncrementalParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public String getAssessmentFieldName() {
        return this.m_sAssessmentFieldName;
    }

    public void setAssessmentFieldName(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("AssessmentFieldName", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_sAssessmentFieldName = value;
    }

    public int getIncrementalNumber() {
        return this.m_nIncrementalNumber;
    }

    public void setIncrementalNumber(int value) {
        if (value < 2 || value > 30) {
            String string = InternalResource.loadString("IncrementalNumber", "ArgumentValueOutOfRange", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nIncrementalNumber = value;
    }

    public double getBeginDistance() {
        return this.m_dBeginDistance;
    }

    public void setBeginDistance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("BeginDistance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        if (value > 1.0E9) {
            String string = InternalResource.loadString("BeginDistance", "ArgumentValueOutOfRange", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dBeginDistance = value;
    }

    public double getIncrementalDistance() {
        return this.m_dIncrementalDistance;
    }

    public void setIncrementalDistance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("IncrementalDistance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dIncrementalDistance = value;
    }

    public boolean isStandardization() {
        return this.m_bStandardization;
    }

    public void setStandardization(boolean value) {
        this.m_bStandardization = value;
    }

    public DistanceMethod getDistanceMethod() {
        return this.m_distanceMethod;
    }

    public void setDistanceMethod(DistanceMethod value) {
        this.m_distanceMethod = value;
    }
}

