/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class SamplingFunctionProportionCParameter
extends SamplingFunctionParameter {
    private double m_dProportion = 0.0;
    private double m_dAbsoluteError = 0.0;
    private double m_dSignificanceLevel = 0.0;
    private int m_nInitialIteratedSize = 0;

    private SamplingFunctionProportionCParameter() {
    }

    public SamplingFunctionProportionCParameter(double dProportion, double dAbsoluteError, double dSignificanceLevel, int nInitialIteratedSize) {
        this.m_FunctionType = SamplingFunctionType.FUNCTIONPROPORTIONC;
        this.setProportion(dProportion);
        this.setAbsoluteError(dAbsoluteError);
        this.setSignificanceLevel(dSignificanceLevel);
        this.setInitialIteratedSize(nInitialIteratedSize);
    }

    public double getProportion() {
        return this.m_dProportion;
    }

    public void setProportion(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("Proportion", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dProportion = value;
    }

    public double getAbsoluteError() {
        return this.m_dAbsoluteError;
    }

    public void setAbsoluteError(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("AbsoluteError", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dAbsoluteError = value;
    }

    public double getSignificanceLevel() {
        return this.m_dSignificanceLevel;
    }

    public void setSignificanceLevel(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("SignificanceLevel", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dSignificanceLevel = value;
    }

    public int getInitialIteratedSize() {
        return this.m_nInitialIteratedSize;
    }

    public void setInitialIteratedSize(int value) {
        if (value < 0) {
            String string = InternalResource.loadString("InitialIteratedSize", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nInitialIteratedSize = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setProportion1(handle, this.m_dProportion);
        SamplingParameterNative.jni_setAbsoluteError(handle, this.m_dAbsoluteError);
        SamplingParameterNative.jni_setSignificanceLevel(handle, this.m_dSignificanceLevel);
        SamplingParameterNative.jni_setInitialIteratedSize(handle, this.m_nInitialIteratedSize);
    }
}

