/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.SamplingFunctionParameter;
import com.supermap.analyst.spatialstatistics.SamplingFunctionType;
import com.supermap.analyst.spatialstatistics.SamplingParameterNative;

public class SamplingFunctionProportionDParameter
extends SamplingFunctionParameter {
    private double m_dPresamplingProportion = 0.0;
    private double m_dExpectedVariance = 0.0;
    private int m_nPresamplingSize = 0;

    private SamplingFunctionProportionDParameter() {
    }

    public SamplingFunctionProportionDParameter(double dPresamplingProportion, double dExpectedVariance, int nPresamplingSize) {
        this.m_FunctionType = SamplingFunctionType.FUNCTIONPROPORTIOND;
        this.setPresamplingProportion(dPresamplingProportion);
        this.setExpectedVariance(dExpectedVariance);
        this.setPresamplingSize(nPresamplingSize);
    }

    public double getPresamplingProportion() {
        return this.m_dPresamplingProportion;
    }

    public void setPresamplingProportion(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("PresamplingProportion", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dPresamplingProportion = value;
    }

    public double getExpectedVariance() {
        return this.m_dExpectedVariance;
    }

    public void setExpectedVariance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("ExpectedVariance", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dExpectedVariance = value;
    }

    public int getPresamplingSize() {
        return this.m_nPresamplingSize;
    }

    public void setPresamplingSize(int value) {
        if (value < 0) {
            String string = InternalResource.loadString("PresamplingSize", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nPresamplingSize = value;
    }

    @Override
    protected void SetSampleParameter(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("SamplingFunctionScaleCParameter", "GlobalHandleObjectHasBeenDisposed", "spatialstatistics_resources");
            throw new IllegalStateException(string);
        }
        SamplingParameterNative.jni_setPresamplingProportion(handle, this.m_dPresamplingProportion);
        SamplingParameterNative.jni_setExpectedVariance(handle, this.m_dExpectedVariance);
        SamplingParameterNative.jni_setPresamplingSize(handle, this.m_nPresamplingSize);
    }
}

