/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.CoordSysTransRunnable;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Maps;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Resources;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TextStyle;
import com.supermap.data.TimeSpan;
import com.supermap.data.Unit;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.WorkspaceVersion;
import com.supermap.mapping.BookMarks;
import com.supermap.mapping.ChartSetting;
import com.supermap.mapping.DynamicLayers;
import com.supermap.mapping.GridSetting;
import com.supermap.mapping.ImageType;
import com.supermap.mapping.InternalDataset;
import com.supermap.mapping.InternalDatasets;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoRegion;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalImageType;
import com.supermap.mapping.InternalMapControl;
import com.supermap.mapping.InternalPrjCoordSys;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalResources;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.LabelAvoidWeightInfos;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerExtensionBase;
import com.supermap.mapping.Layers;
import com.supermap.mapping.MapClosedEvent;
import com.supermap.mapping.MapClosedListener;
import com.supermap.mapping.MapColorMode;
import com.supermap.mapping.MapDrawContinuingEvent;
import com.supermap.mapping.MapDrawContinuingListener;
import com.supermap.mapping.MapDrawingEvent;
import com.supermap.mapping.MapDrawingListener;
import com.supermap.mapping.MapDrawnEvent;
import com.supermap.mapping.MapDrawnListener;
import com.supermap.mapping.MapNative;
import com.supermap.mapping.MapOpenedEvent;
import com.supermap.mapping.MapOpenedListener;
import com.supermap.mapping.MapOverlapDisplayedOptions;
import com.supermap.mapping.MapPainter;
import com.supermap.mapping.MapPainterEx;
import com.supermap.mapping.ScreenLayer;
import com.supermap.mapping.Selection;
import com.supermap.mapping.TextPosition;
import com.supermap.mapping.TrackingLayer;
import com.supermap.mapping.TrackingLayerDrawingEvent;
import com.supermap.mapping.TrackingLayerDrawingListener;
import com.supermap.mapping.TrackingLayerDrawnEvent;
import com.supermap.mapping.TrackingLayerDrawnListener;
import com.supermap.ui.Action;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.MapControl;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;

public class Map
extends InternalHandleDisposable {
    private Dimension m_imageSize = new Dimension(256, 256);
    private Workspace m_workspace = null;
    private Layers m_layers = null;
    private TrackingLayer m_trackingLayer = null;
    private DynamicLayers m_DynamicLayers = null;
    private BookMarks m_bookMarks = null;
    private ScreenLayer m_screenLayer = null;
    private GeoRegion m_clipRegion = null;
    private GeoStyle m_backGroundStyle = null;
    private PrjCoordSys m_prjCoordSys = null;
    private MapControl m_mapControl = null;
    private GridSetting m_gridSetting = null;
    private Resources m_resources = null;
    transient Vector m_mapDrawingListeners;
    transient Vector m_mapDrawnListeners;
    transient Vector m_mapDrawContinuingListeners;
    transient Vector m_mapSteppedListeners;
    transient Vector m_trackingLayerDrawingListeners;
    transient Vector m_trackingLayerDrawnListeners;
    transient Vector m_mapOpenedListeners;
    transient Vector m_mapClosedListeners;
    private long m_selfEventHandle = 0L;
    private boolean m_bCanRefreshTrackingLayer = true;
    private static String m_senderMethodName;
    private ChartSetting m_chartSetting = null;
    private MapOverlapDisplayedOptions m_overlapDisplayedOptions = null;
    private CoordSysTransParameter m_transParameter = null;
    private LabelAvoidWeightInfos m_labelAvoidWeightInfos = null;
    private CoordSysTransRunnable m_transRunnable = null;
    ReentrantLock m_lock;

    public static void main(String[] args) {
        WorkspaceConnectionInfo workspaceConnectionInfo;
        Workspace workspace;
        if (args.length == 0) {
            System.out.println("args: workspacefile(required) mapname(default:first) width(default:512) height(default:512) outputfile(default:test.png)");
            return;
        }
        String string = args[0];
        String string2 = "";
        int n = 512;
        int n2 = 512;
        String string3 = "test.png";
        if (args.length > 1) {
            string2 = args[1];
        }
        if (args.length > 2) {
            n = Integer.valueOf(args[2]);
        }
        if (args.length > 3) {
            n2 = Integer.valueOf(args[3]);
        }
        if (args.length > 4) {
            string3 = args[4];
        }
        if (!(workspace = new Workspace()).open(workspaceConnectionInfo = new WorkspaceConnectionInfo(string))) {
            System.out.print("open workspace faild!");
            workspace.dispose();
            return;
        }
        if (workspace.getMaps().getCount() == 0) {
            System.out.print("no map in this workspace!");
            workspace.close();
            workspace.dispose();
            return;
        }
        if (string2.isEmpty()) {
            string2 = workspace.getMaps().get(0);
        }
        Map map = new Map(workspace);
        map.setImageSize(new Dimension(n, n2));
        if (!map.open(string2)) {
            System.out.print("open map faild!");
            map.dispose();
            workspace.close();
            workspace.dispose();
            return;
        }
        if (!map.outputMapToPNG(string3, true)) {
            System.out.print("map output png faild!");
        }
        map.dispose();
        workspace.close();
        workspace.dispose();
    }

    public Map() {
        this.m_lock = new ReentrantLock();
        long l = MapNative.jni_New();
        this.setHandle(l, true);
        this.m_selfEventHandle = MapNative.jni_RegisteAllEvents(l, this);
        this.reset();
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
    }

    public Map(Workspace workspace) {
        this.m_lock = new ReentrantLock();
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = MapNative.jni_New();
        this.setHandle(l2, true);
        this.m_selfEventHandle = MapNative.jni_RegisteAllEvents(l2, this);
        this.reset();
        this.setWorkspace(workspace);
        this.m_workspace = workspace;
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspace);
    }

    private Map(long handle, MapControl mapControl, ReentrantLock lock) {
        this.m_lock = lock;
        this.setHandle(handle, false);
        this.m_mapControl = mapControl;
        MapNative.jni_RegisteAllEvents(handle, this);
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
    }

    private Map(long handle) {
        this.m_lock = new ReentrantLock();
        this.setHandle(handle, false);
        MapNative.jni_RegisteAllEvents(handle, this);
    }

    private Map(long handle, String className) {
        this.m_lock = new ReentrantLock();
        this.setHandle(handle, false);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetName(this.getHandle(), value);
    }

    public boolean isClipRegionEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isClipRegionEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsClipRegionEnabled(this.getHandle());
    }

    public void setClipRegionEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegionEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetClipRegionEnabled(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_clipRegion == null && (l = MapNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this.m_clipRegion = (GeoRegion)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this.m_clipRegion, (boolean)false);
        }
        return this.m_clipRegion;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion(GeoRegion geoRegion)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            String string = InternalResource.loadString("geoRegion", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        if (l2 == 0L) {
            String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetClipRegion(this.getHandle(), l2);
        if (this.m_clipRegion == null && (l = MapNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this.m_clipRegion = (GeoRegion)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this.m_clipRegion, (boolean)false);
        }
        if (this.m_clipRegion != null) {
            this.m_clipRegion.fromXML(geoRegion.toXML());
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        this.m_lock.unlock();
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        MapNative.jni_SetDescription(this.getHandle(), value);
    }

    public double getAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAngle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetAngle(this.getHandle());
    }

    public void setAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAngle(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetAngle(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public GeoStyle getBackgroundStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackgroundStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_backGroundStyle == null && (l = MapNative.jni_GetBackGroundStyle(this.getHandle())) != 0L) {
            this.m_backGroundStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_backGroundStyle;
    }

    public void setBackgroundStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackgroundStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        MapNative.jni_SetBackgroundStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
        this.m_lock.unlock();
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public Rectangle2D getViewBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetViewBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public boolean isViewBoundsLocked() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsViewBoundsLocked(this.getHandle());
    }

    public void setViewBoundsLocked(boolean isViewBoundsLocked) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsViewBoundsLocked(this.getHandle(), isViewBoundsLocked);
        this.m_lock.unlock();
    }

    public void setViewBounds(Rectangle2D rect) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (rect == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rect.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rect", "Map_ViewBoundsHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rect.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rect", "Map_ViewBoundsWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetViewBounds(this.getHandle(), rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop());
    }

    public Rectangle2D getLockedViewBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetLockedViewBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setLockedViewBounds(Rectangle2D rect) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (rect == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rect.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rect", "Map_ViewBoundsHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rect.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rect", "Map_ViewBoundsWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetLockedViewBounds(this.getHandle(), rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop());
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_GetCenter(this.getHandle(), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public void setCenter(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetCenter(this.getHandle(), point.getX(), point.getY());
        this.m_lock.unlock();
    }

    public MapColorMode getColorMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetColorMode(this.getHandle());
        return (MapColorMode)InternalEnum.parseUGCValue(MapColorMode.class, n);
    }

    public void setColorMode(MapColorMode mapColorMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorMode(MapColorMode value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mapColorMode == null) {
            String string = InternalResource.loadString("mapColorMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(mapColorMode);
        this.m_lock.lock();
        MapNative.jni_SetColorMode(this.getHandle(), n);
        this.m_lock.unlock();
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsSmoothingMode(this.getHandle());
    }

    public void setAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsSmoothingMode(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public boolean isTextAngleFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsTextAngleFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        this.m_lock.lock();
        bl = MapNative.jni_GetIsTextFixedAngle(this.getHandle());
        this.m_lock.unlock();
        return bl;
    }

    public void setTextAngleFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsTextAngleFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetIsTextFixedAngle(this.getHandle(), value);
    }

    public boolean isTextOrientationFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsTextOrientationFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsFixedTextOrientation(this.getHandle());
    }

    public void setTextOrientationFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsTextOrientationFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsFixedTextOrientation(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public boolean isMarkerAngleFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsMarkerAngleFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsMarkerFixedAngle(this.getHandle());
    }

    public void setMarkerAngleFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsMarkerAngleFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsMarkerFixedAngle(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsModified(this.getHandle());
    }

    public void setModified(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModified(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetIsModified(this.getHandle(), value);
    }

    public boolean isPaintBackground() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsPaintBackground()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsPaintBackground(this.getHandle());
    }

    public void setPaintBackground(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsPaintBackground(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsPaintBackground(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public double getMaxVisibleTextSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleTextSize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMaxVisibleTextSize(this.getHandle());
    }

    public void setMaxVisibleTextSize(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleTextSize(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Map_MaxVisibleTextSizeError", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMaxVisibleTextSize(this.getHandle(), value);
    }

    public double getMinVisibleTextSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleTextSize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMinVisibleTextSize(this.getHandle());
    }

    public void setMinVisibleTextSize(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleTextSize(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Map_MinVisibleTextSizeError", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMinVisibleTextSize(this.getHandle(), value);
    }

    public int getMaxVisibleVertex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleVertex()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMaxVisibleVertex(this.getHandle());
    }

    public void setMaxVisibleVertex(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleVertex(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Map_MaxVisibleVertexShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMaxVisibleVertex(this.getHandle(), value);
    }

    public double getScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetScale(this.getHandle());
    }

    public void setScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "MapSacleShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = MapNative.jni_SetScale(this.getHandle(), value);
        this.m_lock.unlock();
        if (!bl) {
            String string = InternalResource.loadString("value", "MapScaleIsZero", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public double getMinScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMinScale(this.getHandle());
    }

    public void setMinScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMinScale(this.getHandle(), value);
    }

    public double getMaxScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMaxScale(this.getHandle());
    }

    public void setMaxScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMaxScale(this.getHandle(), value);
    }

    public Unit getCoordUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetCoordUnit(this.getHandle());
        return (Unit)InternalEnum.parseUGCValue(Unit.class, n);
    }

    public void setCoordUnit(Unit value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoordUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue((Enum)value);
        MapNative.jni_SetCoordUnit(this.getHandle(), n);
    }

    public Unit getDistanceUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistanceUnit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetDistanceUnit(this.getHandle());
        return (Unit)InternalEnum.parseUGCValue(Unit.class, n);
    }

    public void setDistanceUnit(Unit value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDistanceUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue((Enum)value);
        MapNative.jni_SetDistanceUnit(this.getHandle(), n);
    }

    public TrackingLayer getTrackingLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTrackingLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_trackingLayer == null) {
            long l = MapNative.jni_GetTrackingLayer(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.m_trackingLayer = TrackingLayer.createInstance(l, this);
        }
        return this.m_trackingLayer;
    }

    public ScreenLayer getScreenLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScreenLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_screenLayer == null) {
            long l = MapNative.jni_GetScreenLayer(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.m_screenLayer = ScreenLayer.createInstance(l, this);
        }
        return this.m_screenLayer;
    }

    public boolean isDynamicProjection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsDynamicProjection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsDynamicProjection(this.getHandle());
    }

    public void setDynamicProjection(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsDynamicProjection(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsDynamicProjection(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_prjCoordSys == null && (l = MapNative.jni_GetPrjCoordSys(this.getHandle())) != 0L) {
            this.m_prjCoordSys = InternalPrjCoordSys.createInstance(l, false);
        }
        return this.m_prjCoordSys;
    }

    public void setPrjCoordSys(PrjCoordSys value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        MapNative.jni_SetPrjCoordSys(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
        this.m_lock.unlock();
    }

    @Deprecated
    public CoordSysTransMethod getDynamicPrjTransMethond() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetTransMethod(this.getHandle());
        return (CoordSysTransMethod)InternalEnum.parseUGCValue(CoordSysTransMethod.class, n);
    }

    public CoordSysTransMethod getDynamicPrjTransMethod() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetTransMethod(this.getHandle());
        return (CoordSysTransMethod)InternalEnum.parseUGCValue(CoordSysTransMethod.class, n);
    }

    @Deprecated
    public void setDynamicPrjTransMethond(CoordSysTransMethod transMethod) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTransMethod(this.getHandle(), transMethod.value());
    }

    public void setDynamicPrjTransMethod(CoordSysTransMethod transMethod) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTransMethod(this.getHandle(), transMethod.value());
    }

    public CoordSysTransParameter getDynamicPrjTransParameter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_transParameter == null) {
            long l = MapNative.jni_GetTransParameter(this.getHandle());
            this.m_transParameter = new CoordSysTransParameter(l, false);
        }
        return this.m_transParameter;
    }

    public void setDynamicPrjTransParameter(CoordSysTransParameter value) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l2 = l = value == null ? 0L : InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        if (l == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_setTransParameter(this.getHandle(), l);
    }

    public CoordSysTransRunnable getDynamicPrjTransRunnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_transRunnable;
    }

    public void setDynamicPrjTransRunnable(CoordSysTransRunnable value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_transRunnable == value) {
            return;
        }
        MapNative.jni_setTransRunnable(this.getHandle(), value);
        this.m_transRunnable = value;
    }

    public Layers getLayers() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayers()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("getLayers()", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        if (this.m_layers == null && (l = MapNative.jni_GetLayersHandle(this.getHandle())) != 0L) {
            this.m_layers = Layers.createInstance(l, this, this.m_lock);
        }
        this.m_lock.unlock();
        return this.m_layers;
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkspace(Workspace workspace) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        try {
            long l;
            this.m_lock.lock();
            String string = "";
            if (this.m_workspace != null) {
                l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace);
                if (l == 0L) {
                    String string2 = InternalResource.loadString("setWorkspace()", "Map_DontDisposeOldWorkspace", "mapping_resources");
                    throw new IllegalStateException(string2);
                }
                string = this.toXML();
            }
            this.close();
            if (workspace == null) {
                this.m_workspace = null;
            } else {
                l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
                if (l == 0L) {
                    String string3 = InternalResource.loadString("workspace", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalArgumentException(string3);
                }
                MapNative.jni_SetWorkspace(this.getHandle(), l);
                this.m_workspace = workspace;
            }
            if (!string.trim().equals("")) {
                this.fromXML(string);
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public Dimension getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Dimension dimension = null;
        dimension = this.m_mapControl == null ? new Dimension(this.m_imageSize) : new Dimension(this.m_mapControl.getWidth(), this.m_mapControl.getHeight());
        return dimension;
    }

    public void setImageSize(Dimension size) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (size == null) {
            String string = InternalResource.loadString("size", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        if (size.getWidth() <= 0.0) {
            String string = InternalResource.loadString("size", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (size.getHeight() <= 0.0) {
            String string = InternalResource.loadString("size", "Map_ClientHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_imageSize.width = size.width;
        this.m_imageSize.height = size.height;
        this.m_lock.lock();
        if (this.m_mapControl == null) {
            MapNative.jni_SetImageSize(this.getHandle(), size.width, size.height);
        } else {
            this.m_mapControl.setSize(this.m_imageSize);
            MapNative.jni_SetImageSize(this.getHandle(), size.width, size.height);
        }
        this.m_lock.unlock();
    }

    public boolean isOverlapDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOverlapDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsOverlapDisplayed(this.getHandle());
    }

    public void setOverlapDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetIsOverlapDisplayed(this.getHandle(), value);
    }

    public MapOverlapDisplayedOptions getOverlapDisplayedOptions() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapDisplayedOptions()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_overlapDisplayedOptions == null && (l = MapNative.jni_GetOverlapDisplayedOptionsHandle(this.getHandle())) != 0L) {
            this.m_overlapDisplayedOptions = new MapOverlapDisplayedOptions(l, false);
        }
        return this.m_overlapDisplayedOptions;
    }

    public void setOverlapDisplayedOptions(MapOverlapDisplayedOptions value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapDisplayedOptions(MapOverlapDisplayedOptions value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        MapNative.jni_SetOverlapDisplayedOptionsHandle(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)value));
    }

    public GridSetting getGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGrid()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_gridSetting == null) {
            this.m_gridSetting = new GridSetting(this);
        }
        return this.m_gridSetting;
    }

    public void setGrid(GridSetting value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGrid(GridSetting value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_gridSetting == null) {
            this.m_gridSetting = new GridSetting(this);
        }
        this.m_gridSetting.setDashStyle(value.getDashStyle());
        this.m_gridSetting.setHorizontalSpacing(value.getHorizontalSpacing());
        this.m_gridSetting.setSizeFixed(value.isSizeFixed());
        this.m_gridSetting.setSnapable(value.isSnapable());
        this.m_gridSetting.setSolidStyle(value.getSolidStyle());
        this.m_gridSetting.setType(value.getType());
        this.m_gridSetting.setVerticalSpacing(value.getVerticalSpacing());
        this.m_gridSetting.setVisible(value.isVisible());
    }

    @Deprecated
    public Resources getResouces() {
        return this.getResources();
    }

    public Resources getResources() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResouces()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_resources == null && (l = MapNative.jni_GetResouces(this.getHandle())) != 0L) {
            this.m_resources = InternalResources.createInstance(this.m_workspace, l);
        }
        return this.m_resources;
    }

    public void setResources(Resources resources) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setResources(Resources resources)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (resources == null) {
            MapNative.jni_SetResources(this.getHandle(), 0L);
            if (this.m_resources != null) {
                InternalResources.clearHandle(this.m_resources);
            }
        } else {
            long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)resources);
            if (l == 0L) {
                String string = InternalResource.loadString("resources", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = MapNative.jni_SetResources(this.getHandle(), l);
            if (this.m_resources != null) {
                InternalResources.refreshHandle(this.m_resources, l2);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resources);
    }

    public Rectangle2D getCustomBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToEMF(String fileName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetCustomBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setCustomBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomBounds(Rectangle2D rectangle2D)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetCustomBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        this.m_lock.unlock();
    }

    public boolean isCustomBoundsEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCustomBoundsEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsCustomBoundsEnabled(this.getHandle());
    }

    public void setCustomBoundsEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomBoundsEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetCustomBoundsEnabled(this.getHandle(), value);
    }

    public boolean isVisibleScalesEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisibleScalesEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsVisibleScalesEnabled(this.getHandle());
    }

    public void setVisibleScalesEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleScalesEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetVisibleScalesEnabled(this.getHandle(), value);
    }

    public double[] getVisibleScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetVisibleScales(this.getHandle());
    }

    public void setVisibleScales(double[] values) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (values == null) {
            String string = InternalResource.loadString("setVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetVisibleScales(this.getHandle(), values);
    }

    public boolean isTextAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTextAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsTextAntialias(this.getHandle());
    }

    public void setTextAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTextAntialias(this.getHandle(), value);
    }

    public boolean isLineAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLineAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsLineAntialias(this.getHandle());
    }

    public void setLineAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetLineAntialias(this.getHandle(), value);
    }

    public boolean outputMapToEMF(String fileName) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToEMF(String fileName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".emf");
        return MapNative.jni_OutputMapToEMF(this.getHandle(), string, this.m_imageSize.width, this.m_imageSize.height);
    }

    public boolean outputMapToPDF(String fileName) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToPDF(String fileName,boolean isEntire)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_imageSize.width <= 0) {
            String string = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_imageSize.height <= 0) {
            String string = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".pdf");
        int n = 0;
        boolean bl = false;
        if (this.getMapControl() != null) {
            InternalMapControl.waitDrawingCompleted(this.getMapControl());
            bl = this.getMapControl().isDrawThreadRunning();
            this.getMapControl().setDrawThreadRunning(false);
        }
        boolean bl2 = MapNative.jni_OutputMapToPDF(this.getHandle(), string, this.m_imageSize.width, this.m_imageSize.height, n, 0, false);
        if (this.getMapControl() != null) {
            this.getMapControl().setDrawThreadRunning(bl);
        }
        return bl2;
    }

    public BufferedImage outputMapToBitmap() {
        if (!this.IsCanOutputChartPicture()) {
            return null;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layers.getCount() == 1 && this.m_layers.get(0) instanceof LayerExtensionBase) {
            LayerExtensionBase layerExtensionBase = (LayerExtensionBase)this.m_layers.get(0);
            MapPainterEx mapPainterEx = new MapPainterEx(this);
            layerExtensionBase.OnDraw(mapPainterEx);
            mapPainterEx.realeaseGraphics();
            return (BufferedImage)mapPainterEx.getImage();
        }
        InternalBufferImage internalBufferImage = new InternalBufferImage(this.m_imageSize.width, this.m_imageSize.height);
        if (InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage) != 0L) {
            boolean bl = false;
            if (this.getMapControl() != null) {
                InternalMapControl.waitDrawingCompleted(this.getMapControl());
                bl = this.getMapControl().isDrawThreadRunning();
                this.getMapControl().setDrawThreadRunning(false);
            }
            MapNative.jni_OutputMapToBitmap(this.getHandle(), InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage));
            if (this.getMapControl() != null) {
                this.getMapControl().setDrawThreadRunning(bl);
            }
            BufferedImage bufferedImage = new BufferedImage(this.m_imageSize.width, this.m_imageSize.height, 5);
            bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, null);
            internalBufferImage.dispose();
            return bufferedImage;
        }
        String string = InternalResource.loadString("outputMapToBitmap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
        throw new IllegalStateException(string);
    }

    public BufferedImage outputMapToBitmap(boolean isBackTransparent) {
        if (!this.IsCanOutputChartPicture()) {
            return null;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layers.getCount() == 1 && this.m_layers.get(0) instanceof LayerExtensionBase) {
            LayerExtensionBase layerExtensionBase = (LayerExtensionBase)this.m_layers.get(0);
            MapPainterEx mapPainterEx = new MapPainterEx(this);
            layerExtensionBase.OnDraw(mapPainterEx);
            mapPainterEx.realeaseGraphics();
            return (BufferedImage)mapPainterEx.getImage();
        }
        InternalBufferImage internalBufferImage = new InternalBufferImage(this.m_imageSize.width, this.m_imageSize.height, isBackTransparent);
        if (InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage) != 0L) {
            boolean bl = false;
            if (this.getMapControl() != null) {
                InternalMapControl.waitDrawingCompleted(this.getMapControl());
                bl = this.getMapControl().isDrawThreadRunning();
                this.getMapControl().setDrawThreadRunning(false);
            }
            MapNative.jni_OutputMapToBitmap(this.getHandle(), InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage), isBackTransparent);
            if (this.getMapControl() != null) {
                this.getMapControl().setDrawThreadRunning(bl);
            }
            BufferedImage bufferedImage = new BufferedImage(this.m_imageSize.width, this.m_imageSize.height, 6);
            bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(isBackTransparent), 0, 0, null);
            internalBufferImage.dispose();
            return bufferedImage;
        }
        String string = InternalResource.loadString("outputMapToBitmap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
        throw new IllegalStateException(string);
    }

    public boolean ensureVisible(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapNative.jni_EnsureVisibleGeo(this.getHandle(), l, 1.0);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return bl;
    }

    public boolean ensureVisible(Geometry geometry, double ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Geometry geometry, double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (ratio <= 0.0) {
            String string = InternalResource.loadString("ratio", "Map_EnsureVisibleRatioShouldBeMoreThanZero", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapNative.jni_EnsureVisibleGeo(this.getHandle(), l, ratio);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return bl;
    }

    public boolean ensureVisible(Recordset recordset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Recordset recordset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapNative.jni_EnsureVisibleRecordset(this.getHandle(), l, 1.0);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return bl;
    }

    public boolean ensureVisible(Recordset recordset, double ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Recordset recordset, double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (ratio <= 0.0) {
            String string = InternalResource.loadString("ratio", "Map_EnsureVisibleRatioShouldBeMoreThanZero", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapNative.jni_EnsureVisibleRecordset(this.getHandle(), l, ratio);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return bl;
    }

    public boolean ensureVisible(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Layer layer)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return MapNative.jni_EnsureVisibleLayer(this.getHandle(), l, 1.0);
    }

    public boolean ensureVisible(Layer layer, double ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Layer layer, double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return MapNative.jni_EnsureVisibleLayer(this.getHandle(), l, ratio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace == null || com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace) == 0L) {
            String string = InternalResource.loadString("open(String name)", "Map_SetTheWorkspaceFirst", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        InternalMapControl.waitDrawingCompleted(this.getMapControl());
        Maps maps = this.m_workspace.getMaps();
        int n = maps.indexOf(name);
        if (n == -1) {
            String string = InternalResource.loadString("name", "Global_SpecifiedNameNotExist", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = false;
        try {
            Dimension dimension = this.getImageSize();
            bl = MapNative.jni_Open(this.getHandle(), maps.get(n));
            this.setImageSize(dimension);
            if (bl) {
                this.clearLayers();
                this.getLayers();
                this.getBookMarks();
                MapOpenedEvent mapOpenedEvent = new MapOpenedEvent((Object)this, this);
                this.fireMapOpened(mapOpenedEvent);
                if (this.getMapControl() != null) {
                    this.getMapControl().setDrawThreadRunning(this.getMapControl().isDrawThreadRunning());
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace != null) {
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace);
            if (l == 0L) {
                String string = InternalResource.loadString("close()", "Map_CloseMapBeforeDisposeWksp", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_mapControl != null) {
                InternalMapControl.waitDrawingCompleted(this.m_mapControl);
                InternalMapControl.clearEdit(this.m_mapControl);
            }
            this.m_clipRegion = null;
            this.m_lock.lock();
            try {
                Dimension dimension = this.getImageSize();
                MapNative.jni_Close(this.getHandle());
                this.setImageSize(dimension);
                if (this.m_layers != null) {
                    this.m_layers.removeAllDrawReleatedListeners();
                }
                this.clearLayers();
                if (this.m_DynamicLayers != null) {
                    this.m_DynamicLayers.cleanHandle();
                    this.m_DynamicLayers = null;
                }
                if (this.m_bookMarks != null) {
                    this.m_bookMarks.cleanHandle();
                    this.m_bookMarks = null;
                }
                MapClosedEvent mapClosedEvent = new MapClosedEvent((Object)this, this);
                this.fireMapClosed(mapClosedEvent);
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    public Selection[] findSelection(boolean hasGeometrySelected) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelection(boolean allVisibleLayer)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<Selection> arrayList = new ArrayList<Selection>();
        ArrayList<Layer> arrayList2 = this.getLayers().getAllLayers(false);
        for (Layer layer : arrayList2) {
            Selection selection = layer.getSelection();
            if (selection == null || hasGeometrySelected && selection.getCount() <= 0) continue;
            arrayList.add(selection);
        }
        return arrayList.toArray(new Selection[0]);
    }

    public boolean outputMapToBMP(String fileName) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToBMP(String fileName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".bmp");
        return this.outputMapToFile(string, InternalImageType.BMP, this.m_imageSize.width, this.m_imageSize.height);
    }

    public boolean outputMapToJPG(String fileName) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToJPG(String fileName, int imageWidth, int imageHeight)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".jpg");
        return this.outputMapToFile(string, InternalImageType.JPG, this.m_imageSize.width, this.m_imageSize.height);
    }

    public boolean outputMapToPNG(String fileName, boolean isBackTransparent) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".png");
        if (this.m_imageSize.width <= 0) {
            String string2 = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.m_imageSize.height <= 0) {
            String string3 = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.m_layers != null && this.m_layers.getCount() == 1 && this.m_layers.get(0) instanceof LayerExtensionBase) {
            LayerExtensionBase layerExtensionBase = (LayerExtensionBase)this.m_layers.get(0);
            MapPainterEx mapPainterEx = new MapPainterEx(this);
            if (!isBackTransparent) {
                Graphics graphics = mapPainterEx.getGraphics();
                graphics.setColor(this.getBackgroundStyle().getFillForeColor());
                graphics.fillRect(0, 0, mapPainterEx.getImageSize().width, mapPainterEx.getImageSize().height);
            }
            layerExtensionBase.OnDraw(mapPainterEx);
            mapPainterEx.realeaseGraphics();
            try {
                ImageIO.write((RenderedImage)((BufferedImage)mapPainterEx.getImage()), "png", new File(fileName));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
            return true;
        }
        boolean bl = false;
        if (this.getMapControl() != null) {
            InternalMapControl.waitDrawingCompleted(this.getMapControl());
            bl = this.getMapControl().isDrawThreadRunning();
            this.getMapControl().setDrawThreadRunning(false);
        }
        boolean bl2 = false;
        bl2 = MapNative.jni_OutputMapToPNG(this.getHandle(), string, InternalImageType.PNG.value(), this.m_imageSize.width, this.m_imageSize.height, isBackTransparent);
        if (this.getMapControl() != null) {
            this.getMapControl().setDrawThreadRunning(bl);
        }
        return bl2;
    }

    public boolean outputMapToWEBP(String fileName, boolean isBackTransparent) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToWEBP(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".webp");
        if (this.m_imageSize.width <= 0) {
            String string2 = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.m_imageSize.height <= 0) {
            String string3 = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        if (this.getMapControl() != null) {
            InternalMapControl.waitDrawingCompleted(this.getMapControl());
            bl = this.getMapControl().isDrawThreadRunning();
            this.getMapControl().setDrawThreadRunning(false);
        }
        boolean bl2 = MapNative.jni_OutputMapToWEBP(this.getHandle(), string, InternalImageType.WEBP.value(), this.m_imageSize.width, this.m_imageSize.height, isBackTransparent);
        if (this.getMapControl() != null) {
            this.getMapControl().setDrawThreadRunning(bl);
        }
        return bl2;
    }

    public boolean outputTrackingLayerToPNG(String fileName, boolean isBackTransparent) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_imageSize.width <= 0) {
            String string = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_imageSize.height <= 0) {
            String string = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".png");
        return MapNative.jni_OutputTrackingLayerToPNG1(this.getHandle(), string, isBackTransparent, this.m_imageSize.width, this.m_imageSize.height);
    }

    public boolean outputTrackingLayerToPNG(String fileName, boolean isBackTransparent, int dpi, Rectangle2D bounds) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".png");
        double[] dArray = new double[]{bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop()};
        return MapNative.jni_OutputTrackingLayerToPNG(this.getHandle(), string, isBackTransparent, dpi, dArray);
    }

    public boolean outputScreenLayerToPNG(String fileName, boolean isBackTransparent) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".png");
        return MapNative.jni_OutputScreenLayerToPNG(this.getHandle(), string, isBackTransparent);
    }

    public boolean outputScreenLayerToPNG(String fileName, boolean isBackTransparent, int dpi, Rectangle2D bounds) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_workspace.getDatasources() == null || this.m_workspace.getDatasources().getCount() == 0) {
            String string = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".png");
        double[] dArray = new double[]{bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop()};
        return MapNative.jni_OutputScreenLayerToPNG(this.getHandle(), string, isBackTransparent, dpi, dArray);
    }

    public boolean outputMapToFile(String fileName, ImageType type, boolean isBackTransparent) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ".bmp";
        if (type.equals((Object)ImageType.JPG)) {
            string = ".jpg";
        } else if (type.equals((Object)ImageType.PNG)) {
            string = ".png";
        } else if (type.equals((Object)ImageType.GIF)) {
            string = ".gif";
        } else if (type.equals((Object)ImageType.TIFF)) {
            string = ".tif";
        } else if (type.equals((Object)ImageType.PDF)) {
            string = ".pdf";
        } else if (type.equals((Object)ImageType.EMF)) {
            string = ".emf";
        } else if (type.equals((Object)ImageType.EPS)) {
            string = ".eps";
        }
        fileName = this.getFileNameWithSuffix(fileName, string);
        boolean bl = false;
        if (this.getMapControl() != null) {
            InternalMapControl.waitDrawingCompleted(this.getMapControl());
            bl = this.getMapControl().isDrawThreadRunning();
            this.getMapControl().setDrawThreadRunning(false);
        }
        boolean bl2 = MapNative.jni_OutputMapToFile1(this.getHandle(), fileName, type.value(), isBackTransparent);
        if (this.getMapControl() != null) {
            this.getMapControl().setDrawThreadRunning(bl);
        }
        return bl2;
    }

    public boolean outputMapToFile(String fileName, ImageType type, int dpi, Rectangle2D bounds, boolean isBackTransparent) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (type != ImageType.BMP && type != ImageType.JPG && type != ImageType.PNG && type != ImageType.TIFF && type != ImageType.PDF) {
            String string = InternalResource.loadString("", "Map_OutputImageTypeIsNOTSupported", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = ".bmp";
        if (type.equals((Object)ImageType.JPG)) {
            string = ".jpg";
        } else if (type.equals((Object)ImageType.PNG)) {
            string = ".png";
        } else if (type.equals((Object)ImageType.GIF)) {
            string = ".gif";
        } else if (type.equals((Object)ImageType.TIFF)) {
            string = ".tif";
        } else if (type.equals((Object)ImageType.PDF)) {
            string = ".pdf";
        } else if (type.equals((Object)ImageType.EMF)) {
            string = ".emf";
        } else if (type.equals((Object)ImageType.EPS)) {
            string = ".eps";
        }
        fileName = this.getFileNameWithSuffix(fileName, string);
        double[] dArray = new double[]{bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop()};
        boolean bl = false;
        if (this.getMapControl() != null) {
            InternalMapControl.waitDrawingCompleted(this.getMapControl());
            bl = this.getMapControl().isDrawThreadRunning();
            this.getMapControl().setDrawThreadRunning(false);
        }
        boolean bl2 = MapNative.jni_OutputMapToFile2(this.getHandle(), fileName, type.value(), dpi, dArray, isBackTransparent);
        if (this.getMapControl() != null) {
            this.getMapControl().setDrawThreadRunning(bl);
        }
        return bl2;
    }

    public DatasetImage outputMapToDatasetImage(Datasource datasource, String datasetName, double resolution, Rectangle2D bounds, EncodeType encodeType) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(datasetName)) {
            String string = InternalResource.loadString("datasetName", "Layer_ArgumentOfDatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = this.getViewBounds();
        if (rectangle2D.getWidth() < resolution || rectangle2D.getHeight() < resolution) {
            String string = InternalResource.loadString("resolution", "ResolutionIsTooHigh", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.isEmpty()) {
            bounds = rectangle2D;
        }
        int n = (int)(bounds.getWidth() / resolution);
        int n2 = (int)(bounds.getHeight() / resolution);
        if (n < 10 || n2 < 10) {
            String string = InternalResource.loadString("resolution", "ResolutionIsTooHigh", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop()};
        int n3 = InternalEnum.getUGCValue((Enum)encodeType);
        long l2 = MapNative.jni_OutputMapToDatasetImage(this.getHandle(), this, l, datasetName, resolution, dArray, n3);
        DatasetImage datasetImage = null;
        if (l2 != 0L) {
            datasetImage = (DatasetImage)InternalDataset.createInstance(l2, DatasetType.IMAGE, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
        }
        return datasetImage;
    }

    public boolean outputMapToEPS(String fileName) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToEPS(String fileName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.outputMapToFile(fileName, InternalImageType.EPS, this.m_imageSize.width, this.m_imageSize.height);
    }

    public boolean outputMapToGIF(String fileName, boolean isBackTransparent) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToGIF(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().length() == 0) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isDirectoryExisted(fileName)) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getFileNameWithSuffix(fileName, ".gif");
        if (!this.isWorkspaceAttatched()) {
            String string2 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (fileName == null || fileName.trim().equals("")) {
            String string3 = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.m_imageSize.width <= 0) {
            String string4 = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (this.m_imageSize.height <= 0) {
            String string5 = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        boolean bl = false;
        if (this.getMapControl() != null) {
            InternalMapControl.waitDrawingCompleted(this.getMapControl());
            bl = this.getMapControl().isDrawThreadRunning();
            this.getMapControl().setDrawThreadRunning(false);
        }
        int n = InternalEnum.getUGCValue(InternalImageType.GIF);
        boolean bl2 = MapNative.jni_OutputMapToGIF(this.getHandle(), string, n, this.m_imageSize.width, this.m_imageSize.height, isBackTransparent);
        if (this.getMapControl() != null) {
            this.getMapControl().setDrawThreadRunning(bl);
        }
        return bl2;
    }

    public void zoom(double ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoom(double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (ratio <= 0.0) {
            String string = InternalResource.loadString("ratio", "Map_ZoomRatioShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        MapNative.jni_Zoom(this.getHandle(), ratio);
        this.m_lock.unlock();
    }

    public void pan(double offsetX, double offsetY) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pan(double offsetX, double offsetY)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_Pan(this.getHandle(), offsetX, offsetY);
        this.m_lock.unlock();
    }

    void panOnZoom(double offsetX, double offsetY) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("panOnZoom(double offsetX, double offsetY)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_PanOnZoom(this.getHandle(), offsetX, offsetY);
        this.m_lock.unlock();
    }

    public Point mapToPixel(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[2];
        MapNative.jni_MapToPixel(this.getHandle(), point.getX(), point.getY(), nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        return new Point(n, n2);
    }

    public Point2D mapToLogical(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_MapToLogical(this.getHandle(), point.getX(), point.getY(), dArray);
        Point2D point2D = new Point2D(dArray[0] / 10.0, dArray[1] / 10.0);
        return point2D;
    }

    public Point2D logicalToMap(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_LogicalToMap(this.getHandle(), Math.round(point.getX() * 10.0), Math.round(point.getY() * 10.0), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public Point logicalToPixel(Point2D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[2];
        MapNative.jni_LogicalToPixel(this.getHandle(), point.getX(), point.getY(), nArray);
        Point point2 = new Point(nArray[0], (int)(this.getImageSize().getHeight() + (double)nArray[1]));
        return point2;
    }

    public Point2D pixelToLogical(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_PixelToLogical(this.getHandle(), point.x, (int)((double)point.y - this.getImageSize().getHeight()), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public Point2D pixelToMap(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pixelToMap(Point point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_PixelToMap(this.getHandle(), point.x, point.y, dArray);
        double d = dArray[0];
        double d2 = dArray[1];
        return new Point2D(d, d2);
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refresh()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_Refresh(this.getHandle());
        if (this.m_mapControl != null && this.m_mapControl.isDisplayable()) {
            InternalMapControl.setEditEnvironment(this.m_mapControl);
            InternalMapControl.mapControlInvalidate(this.m_mapControl);
        }
    }

    public void refreshWithSnapshot() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refreshWithSnapshot()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_RefreshWithBasemap(this.getHandle());
        if (this.m_mapControl != null && this.m_mapControl.isDisplayable()) {
            InternalMapControl.setEditEnvironment(this.m_mapControl);
            InternalMapControl.mapControlInvalidate(this.m_mapControl);
        }
    }

    public void refreshTrackingLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refresh()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_mapControl == null) {
            this.m_bCanRefreshTrackingLayer = true;
        }
        if (!this.m_bCanRefreshTrackingLayer && !InternalMapControl.isPanButtonDown(this.m_mapControl)) {
            MapNative.jni_Refresh(this.getHandle());
            if (this.m_mapControl != null && this.m_mapControl.isDisplayable()) {
                InternalMapControl.mapControlInvalidate(this.m_mapControl);
            }
        } else if (this.m_bCanRefreshTrackingLayer) {
            MapNative.jni_RefreshTrackingLayer(this.getHandle());
            if (this.m_mapControl != null && this.m_mapControl.isDisplayable()) {
                InternalMapControl.mapControlInvalidate(this.m_mapControl);
            }
        }
    }

    public void refreshEx(Rectangle2D rect) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refreshEx(Rectangle2D rect)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_mapControl != null && this.m_mapControl.isDisplayable()) {
            InternalMapControl.refreshEx(this.m_mapControl, rect);
        }
    }

    public void viewEntire() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("viewEntire()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Dimension dimension = this.getImageSize();
        MapNative.jni_ViewEntire(this.getHandle(), dimension.width, dimension.height);
        if (this.m_mapControl != null) {
            this.m_bCanRefreshTrackingLayer = false;
        }
        this.refresh();
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml, boolean ignoreCaption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace == null || com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace) == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.fromXML(xml, 0);
    }

    public boolean fromXML(String xml, WorkspaceVersion version) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml, WorkspaceVersion version)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace == null || com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace) == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = version.value();
        return this.fromXML(xml, n);
    }

    private boolean fromXML(String xml, int ugcValue) {
        InternalMapControl.waitDrawingCompleted(this.getMapControl());
        this.m_lock.lock();
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0 && (bl = MapNative.jni_FromXML2(this.getHandle(), xml, ugcValue))) {
            this.getLayers();
            long l = MapNative.jni_GetLayersHandle(this.getHandle());
            if (l != 0L && this.m_layers != null) {
                this.m_layers.reset(l, this, this.m_lock);
            }
            if (this.m_bookMarks != null) {
                this.m_bookMarks.cleanHandle();
                this.m_bookMarks = null;
            }
            this.getBookMarks();
            if (this.m_mapControl != null) {
                InternalMapControl.setEditEnvironment(this.m_mapControl);
                this.m_mapControl.setDrawThreadRunning(this.m_mapControl.isDrawThreadRunning());
            }
        }
        this.m_lock.unlock();
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("toXML()", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_ToXML(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace != null && com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace) == 0L) {
            String string = InternalResource.loadString("dispose()", "Map_DontDisposeWkspBeforeMap", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.close();
        MapNative.jni_Delete(this.getHandle());
        this.clearHandle();
    }

    public boolean isOrthographView() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOrthographView()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsOrthographView(this.getHandle());
    }

    public void setOrthographView(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOrthographView(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetOrthographView(this.getHandle(), value);
    }

    public boolean isDisableDynamicEffect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisableDynamicEffect()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsDisableDynamicEffect(this.getHandle());
    }

    public void setDisableDynamicEffect(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisableDynamicEffect(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetDisableDynamicEffect(this.getHandle(), value);
    }

    public boolean isDisableAutoAvoidEffect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisableAutoAvoidEffect()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsDisableAutoAvoidEffect(this.getHandle());
    }

    public void setDisableAutoAvoidEffect(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisableAutoAvoidEffect(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetDisableAutoAvoidEffect(this.getHandle(), value);
    }

    public String getHashCode(ImageType imageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHashCode(ImageType imageType)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetHashCode(this.getHandle(), imageType.value());
    }

    public boolean isInflateBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisableAutoAvoidEffect()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsInflateBounds(this.getHandle());
    }

    public void setInflateBounds(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisableAutoAvoidEffect(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetInflateBounds(this.getHandle(), value);
    }

    protected static Map createInstance(long handle, MapControl mapControl, ReentrantLock lock) {
        return new Map(handle, mapControl, lock);
    }

    protected static Map createInstance(long handle) {
        return new Map(handle);
    }

    protected static Map createInstance(long handle, String className) {
        return new Map(handle, className);
    }

    protected static void clearHandle(Map map) {
        map.clearHandle();
    }

    protected static void resetImageSize(Map map, double width, double height) {
        map.m_imageSize.setSize(width, height);
    }

    private void reset() {
        MapNative.jni_Reset(this.getHandle());
        this.setImageSize(this.m_imageSize);
    }

    private boolean isWorkspaceAttatched() {
        if (this.m_workspace == null) {
            return false;
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_workspace);
        return l != 0L;
    }

    private boolean outputMapToFile(String fileName, InternalImageType imageType, int imageWidth, int imageHeight) {
        if (!this.isWorkspaceAttatched()) {
            String string = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.trim().equals("")) {
            String string = InternalResource.loadString("fileName:" + fileName, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (imageWidth <= 0) {
            String string = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (imageHeight <= 0) {
            String string = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (this.getMapControl() != null) {
            InternalMapControl.waitDrawingCompleted(this.getMapControl());
            bl = this.getMapControl().isDrawThreadRunning();
            this.getMapControl().setDrawThreadRunning(false);
        }
        int n = InternalEnum.getUGCValue(imageType);
        boolean bl2 = MapNative.jni_OutputMapToFile(this.getHandle(), fileName, n, imageWidth, imageHeight);
        if (this.getMapControl() != null) {
            this.getMapControl().setDrawThreadRunning(bl);
        }
        return bl2;
    }

    protected void clearHandle() {
        this.clearLocalVariable();
        this.clearSelfEventHandle();
        this.clearChartSettingHandle();
        this.m_workspace = null;
        this.setHandle(0L);
    }

    private void clearChartSettingHandle() {
        if (this.m_chartSetting != null) {
            this.m_chartSetting.clearHandle();
        }
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            MapNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    private void clearLayers() {
        if (this.m_layers != null) {
            ArrayList<Layer> arrayList = this.m_layers.getLayersList();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Layer layer = arrayList.get(i);
                layer.clearHandle();
            }
            arrayList.clear();
            this.m_layers.clearHandle();
            this.m_layers = null;
        }
    }

    private void clearLocalVariable() {
        if (this.m_layers != null) {
            this.m_layers.clearHandle();
            this.m_layers = null;
        }
        if (this.m_trackingLayer != null) {
            this.m_trackingLayer.clearHandle();
            this.m_trackingLayer = null;
        }
        if (this.m_DynamicLayers != null) {
            this.m_DynamicLayers.cleanHandle();
            this.m_DynamicLayers = null;
        }
        if (this.m_screenLayer != null) {
            this.m_screenLayer.clearHandle();
            this.m_screenLayer = null;
        }
        if (this.m_backGroundStyle != null) {
            InternalGeoStyle.clearHandle(this.m_backGroundStyle);
            this.m_backGroundStyle = null;
        }
        if (this.m_prjCoordSys != null) {
            InternalPrjCoordSys.clearHandle(this.m_prjCoordSys);
            this.m_prjCoordSys = null;
        }
        if (this.m_overlapDisplayedOptions != null) {
            this.m_overlapDisplayedOptions.clearHandle();
            this.m_overlapDisplayedOptions = null;
        }
        if (this.m_clipRegion != null) {
            InternalGeoRegion.clearHandle(this.m_clipRegion);
            this.m_clipRegion = null;
        }
        if (this.m_resources != null) {
            InternalResources.clearHandle(this.m_resources);
            this.m_resources = null;
        }
        if (this.m_transParameter != null) {
            this.m_transParameter.clearHandle();
            this.m_transParameter = null;
        }
        if (this.m_bookMarks != null) {
            this.m_bookMarks.cleanHandle();
            this.m_bookMarks = null;
        }
        if (this.m_labelAvoidWeightInfos != null) {
            this.m_labelAvoidWeightInfos.clearHandle();
            this.m_labelAvoidWeightInfos = null;
        }
    }

    private String getFileNameWithSuffix(String fileName, String suffix) {
        String string = null;
        if (fileName.toLowerCase().endsWith(suffix)) {
            int n = fileName.toLowerCase().lastIndexOf(suffix);
            string = fileName.substring(0, n) + suffix;
        } else {
            string = fileName + suffix;
        }
        return string;
    }

    private boolean isDirectoryExisted(String fileName) {
        File file = new File(fileName);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    public synchronized void addDrawingListener(MapDrawingListener l) {
        if (this.m_mapDrawingListeners == null) {
            this.m_mapDrawingListeners = new Vector();
        }
        if (!this.m_mapDrawingListeners.contains(l)) {
            this.m_mapDrawingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeDrawingListener(MapDrawingListener l) {
        if (this.m_mapDrawingListeners != null && this.m_mapDrawingListeners.contains(l)) {
            this.m_mapDrawingListeners.remove(l);
        }
    }

    protected void fireDrawing(MapDrawingEvent event) {
        if (this.m_mapDrawingListeners != null) {
            Vector vector = this.m_mapDrawingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MapDrawingListener)vector.elementAt(i)).mapDrawing(event);
            }
        }
    }

    static void drawingCallBack(final Map map, long cancelHandle, long graphicsHandle) {
        if (map != null) {
            if (map.getMapControl() != null && map.getMapControl().isDrawThreadRunning()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Boolean bl = false;
                        MapDrawingEvent mapDrawingEvent = new MapDrawingEvent((Object)map, map, (boolean)bl);
                        map.fireDrawing(mapDrawingEvent);
                    }
                });
            } else {
                Boolean bl = InternalToolkitMapping.getHandleBooleanValue(cancelHandle);
                MapDrawingEvent mapDrawingEvent = new MapDrawingEvent((Object)map, map, (boolean)bl);
                map.fireDrawing(mapDrawingEvent);
                InternalToolkitMapping.setHandleBooleanValue(cancelHandle, mapDrawingEvent.getCancel());
                InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
            }
        }
    }

    public synchronized void addDrawnListener(MapDrawnListener l) {
        if (this.m_mapDrawnListeners == null) {
            this.m_mapDrawnListeners = new Vector();
        }
        if (!this.m_mapDrawnListeners.contains(l)) {
            this.m_mapDrawnListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeDrawnListener(MapDrawnListener l) {
        if (this.m_mapDrawnListeners != null && this.m_mapDrawnListeners.contains(l)) {
            this.m_mapDrawnListeners.remove(l);
        }
    }

    protected void fireDrawn(MapDrawnEvent event) {
        if (this.m_mapDrawnListeners != null) {
            Vector vector = this.m_mapDrawnListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MapDrawnListener)vector.elementAt(i)).mapDrawn(event);
            }
        }
    }

    static void drawnCallBack(final Map map, final long graphicsHandle) {
        if (map != null) {
            if (map.getMapControl() != null && map.getMapControl().isDrawThreadRunning()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapPainter mapPainter = new MapPainter(map, graphicsHandle);
                        MapDrawnEvent mapDrawnEvent = new MapDrawnEvent((Object)map, map, mapPainter);
                        map.fireDrawn(mapDrawnEvent);
                        mapPainter.copyBufferImageToUGC();
                        mapPainter.realeaseGraphics();
                    }
                });
            } else {
                MapPainter mapPainter = new MapPainter(map, graphicsHandle);
                MapDrawnEvent mapDrawnEvent = new MapDrawnEvent((Object)map, map, mapPainter);
                map.fireDrawn(mapDrawnEvent);
                mapPainter.copyBufferImageToUGC();
                mapPainter.realeaseGraphics();
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    public synchronized void addDrawContinuingListener(MapDrawContinuingListener l) {
        if (this.m_mapDrawContinuingListeners == null) {
            this.m_mapDrawContinuingListeners = new Vector();
        }
        if (!this.m_mapDrawContinuingListeners.contains(l)) {
            this.m_mapDrawContinuingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeDrawContinuingListener(MapDrawContinuingListener l) {
        if (this.m_mapDrawContinuingListeners != null && this.m_mapDrawContinuingListeners.contains(l)) {
            this.m_mapDrawContinuingListeners.remove(l);
        }
    }

    protected void fireDrawContinuing(MapDrawContinuingEvent event) {
        if (this.m_mapDrawContinuingListeners != null) {
            Vector vector = this.m_mapDrawContinuingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MapDrawContinuingListener)vector.elementAt(i)).mapDrawContinuing(event);
            }
        }
    }

    static void drawContinuingCallBack(Map map, int percent, long cancelHandle) {
        if (map != null) {
            Boolean bl = InternalToolkitMapping.getHandleBooleanValue(cancelHandle);
            MapDrawContinuingEvent mapDrawContinuingEvent = new MapDrawContinuingEvent((Object)map, map, percent, bl);
            map.fireDrawContinuing(mapDrawContinuingEvent);
            boolean bl2 = false;
            if (map.getMapControl() != null && !map.getMapControl().isDrawThreadRunning()) {
                Action action = map.getMapControl().getAction();
                bl2 = InternalToolkitMapping.isEscape(action.value(), true);
            }
            InternalToolkitMapping.setHandleBooleanValue(cancelHandle, mapDrawContinuingEvent.getCancel() || bl2);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_mapSteppedListeners == null) {
            this.m_mapSteppedListeners = new Vector();
        }
        if (!this.m_mapSteppedListeners.contains(l)) {
            this.m_mapSteppedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_mapSteppedListeners != null && this.m_mapSteppedListeners.contains(l)) {
            this.m_mapSteppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_mapSteppedListeners != null) {
            Vector vector = this.m_mapSteppedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(Map source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "outputMapToDatasetImage";
            boolean bl = InternalToolkitMapping.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitMapping.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)source));
        }
    }

    public synchronized void addTrackingLayerDrawingListener(TrackingLayerDrawingListener l) {
        if (this.m_trackingLayerDrawingListeners == null) {
            this.m_trackingLayerDrawingListeners = new Vector();
        }
        if (!this.m_trackingLayerDrawingListeners.contains(l)) {
            this.m_trackingLayerDrawingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeTrackingLayerDrawingListener(TrackingLayerDrawingListener l) {
        if (this.m_trackingLayerDrawingListeners != null && this.m_trackingLayerDrawingListeners.contains(l)) {
            this.m_trackingLayerDrawingListeners.remove(l);
        }
    }

    protected void fireTrackingLayerDrawing(TrackingLayerDrawingEvent event) {
        if (this.m_trackingLayerDrawingListeners != null) {
            Vector vector = this.m_trackingLayerDrawingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((TrackingLayerDrawingListener)vector.elementAt(i)).trackingLayerDrawing(event);
            }
        }
    }

    static void trackingLayerDrawingCallBack(Map map, long cancelHandle) {
        if (map != null) {
            Boolean bl = InternalToolkitMapping.getHandleBooleanValue(cancelHandle);
            TrackingLayerDrawingEvent trackingLayerDrawingEvent = new TrackingLayerDrawingEvent((Object)map, map.getTrackingLayer(), new ArrayList<Geometry>(), bl);
            map.fireTrackingLayerDrawing(trackingLayerDrawingEvent);
            InternalToolkitMapping.setHandleBooleanValue(cancelHandle, trackingLayerDrawingEvent.getCancel());
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    public synchronized void addTrackingLayerDrawnListener(TrackingLayerDrawnListener l) {
        if (this.m_trackingLayerDrawnListeners == null) {
            this.m_trackingLayerDrawnListeners = new Vector();
        }
        if (!this.m_trackingLayerDrawnListeners.contains(l)) {
            this.m_trackingLayerDrawnListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeTrackingLayerDrawnListener(TrackingLayerDrawnListener l) {
        if (this.m_trackingLayerDrawnListeners != null && this.m_trackingLayerDrawnListeners.contains(l)) {
            this.m_trackingLayerDrawnListeners.remove(l);
        }
    }

    protected void fireTrackingLayerDrawn(TrackingLayerDrawnEvent event) {
        if (this.m_trackingLayerDrawnListeners != null) {
            Vector vector = this.m_trackingLayerDrawnListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((TrackingLayerDrawnListener)vector.elementAt(i)).trackingLayerDrawn(event);
            }
        }
    }

    public synchronized void addMapOpenedListener(MapOpenedListener l) {
        if (this.m_mapOpenedListeners == null) {
            this.m_mapOpenedListeners = new Vector();
        }
        if (!this.m_mapOpenedListeners.contains(l)) {
            this.m_mapOpenedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeMapOpenedListener(MapOpenedListener l) {
        if (this.m_mapOpenedListeners != null && this.m_mapOpenedListeners.contains(l)) {
            this.m_mapOpenedListeners.remove(l);
        }
    }

    protected void fireMapOpened(MapOpenedEvent event) {
        if (this.m_mapOpenedListeners != null) {
            Vector vector = this.m_mapOpenedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MapOpenedListener)vector.elementAt(i)).mapOpened(event);
            }
        }
    }

    public synchronized void addMapClosedListener(MapClosedListener l) {
        if (this.m_mapClosedListeners == null) {
            this.m_mapClosedListeners = new Vector();
        }
        if (!this.m_mapClosedListeners.contains(l)) {
            this.m_mapClosedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeMapClosedListener(MapClosedListener l) {
        if (this.m_mapClosedListeners != null && this.m_mapClosedListeners.contains(l)) {
            this.m_mapClosedListeners.remove(l);
        }
    }

    protected void fireMapClosed(MapClosedEvent event) {
        if (this.m_mapClosedListeners != null) {
            Vector vector = this.m_mapClosedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MapClosedListener)vector.elementAt(i)).mapClosed(event);
            }
        }
    }

    static void trackingLayerDrawnCallBack(Map map) {
        if (map != null) {
            TrackingLayerDrawnEvent trackingLayerDrawnEvent = new TrackingLayerDrawnEvent((Object)map, map.getTrackingLayer());
            map.fireTrackingLayerDrawn(trackingLayerDrawnEvent);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    static void refreshCallBack(Map map) {
        if (map != null && map.m_mapControl != null) {
            map.refresh();
        }
    }

    public MapControl getMapControl() {
        return this.m_mapControl;
    }

    protected static boolean getCanRefreshTrackingLayer(Map map) {
        return map.getCanRefreshTrackingLayer();
    }

    protected boolean getCanRefreshTrackingLayer() {
        return this.m_bCanRefreshTrackingLayer;
    }

    protected static void setCanRefreshTrackingLayer(Map map, boolean value) {
        if (map != null) {
            map.setCanRefreshTrackingLayer(value);
        }
    }

    protected static void panOnZoom(Map map, double offsetX, double offsetY) {
        if (map != null) {
            map.panOnZoom(offsetX, offsetY);
        }
    }

    protected void setCanRefreshTrackingLayer(boolean value) {
        this.m_bCanRefreshTrackingLayer = value;
        MapNative.jni_SetCanRefreshTrackingLayer(this.getHandle(), value);
    }

    public boolean isFillMarkerAngleFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFillMarkerAngleFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsFillMarkerAngleFixed(this.getHandle());
    }

    public void setFillMarkerAngleFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMarkerAngleFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetFillMarkerAngleFixed(this.getHandle(), value);
    }

    public boolean isSymbolFillIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSymbolFillIgnored()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsSymbolFillIgnored(this.getHandle());
    }

    public void setSymbolFillIgnored(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolFillIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetSymbolFillIgnored(this.getHandle(), value);
    }

    public ChartSetting getChartSetting() {
        if (InternalToolkitMapping.getChartLicenseState() == -1) {
            return null;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChartSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_chartSetting == null) {
            long l = 0L;
            l = MapNative.jni_GetChartSettingHandle(this.getHandle());
            if (l == 0L) {
                String string = InternalResource.loadString("getChartSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_chartSetting = new ChartSetting(l);
        }
        return this.m_chartSetting;
    }

    public boolean isContainLayerChart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChartSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_isContainLayerChart(this.getHandle());
    }

    protected boolean IsCanOutputChartPicture() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChartSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return InternalToolkitMapping.getChartLicenseState() == 0 || !MapNative.jni_isContainLayerChart(this.getHandle());
    }

    public boolean isUseSystemDPI() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isUseSystemDPI()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsUseSystemDPI(this.getHandle());
    }

    public void setUseSystemDPI(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUseSystemDPI(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetUseSystemDPI(this.getHandle(), value);
    }

    public double getDPI() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDPI()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMapDPI(this.getHandle());
    }

    public void setDPI(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDPI(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 60.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMapDPI(this.getHandle(), value);
    }

    public boolean isCompatibleFontHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDPI(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsCompatibleFontHeight(this.getHandle());
    }

    public void setCompatibleFontHeight(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDPI(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetCompatibleFontHeight(this.getHandle(), value);
    }

    public boolean isGraphicsAlphaEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isGraphicsAlphaEnable(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsGraphicsAlphaEnable(this.getHandle());
    }

    public void setGraphicsAlphaEnable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphicsAlphaEnable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetGraphicsAlphaEnable(this.getHandle(), value);
    }

    public DynamicLayers getDynamicLayers() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDynamicLayers()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_DynamicLayers == null) {
            long l = MapNative.jni_GetDynamicLayers(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.m_DynamicLayers = DynamicLayers.createInstance(l, this);
        }
        return this.m_DynamicLayers;
    }

    public BookMarks getBookMarks() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBookMarks()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_bookMarks == null) {
            long l = MapNative.jni_GetBookMarks(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.m_bookMarks = BookMarks.createInstance(l, this);
        }
        return this.m_bookMarks;
    }

    public boolean getTileZoomInCacheEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileZoomInCacheEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsTileZoomInCacheEnable(this.getHandle());
    }

    public void setTileZoomInCacheEnable(boolean bEnable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileZoomInCacheEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTileZoomInCacheEnable(this.getHandle(), bEnable);
    }

    public int getTileRefreshIntervals() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWebTileRefreshTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetTileRefreshIntervals(this.getHandle());
    }

    public void setTileRefreshIntervals(int nTime) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWebTileRefreshTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTileRefreshIntervals(this.getHandle(), nTime);
    }

    public boolean isTempCacheFileEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTempCacheFileEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsTempCacheFileEnable(this.getHandle());
    }

    public void setTempCacheFileEnable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTempCacheFileEnable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTempCacheFileEnable(this.getHandle(), value);
    }

    public TimeSpan getTimeStep() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeStep()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TimeSpan timeSpan = new TimeSpan();
        timeSpan.setTimeSpan(MapNative.jni_GetTimeStep(this.getHandle()));
        return timeSpan;
    }

    public void setTimeStep(TimeSpan timeStep) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeStep(TimeSpan timeStep)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = timeStep.getTimeSpan();
        MapNative.jni_SetTimeStep(this.getHandle(), l);
    }

    public TimeSpan getTimeWindow() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeWindow()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TimeSpan timeSpan = new TimeSpan();
        timeSpan.setTimeSpan(MapNative.jni_GetTimeWindow(this.getHandle()));
        return timeSpan;
    }

    public void setTimeWindow(TimeSpan timeWindow) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeWindow(TimeSpan timeWindow)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = timeWindow.getTimeSpan();
        MapNative.jni_SetTimeWindow(this.getHandle(), l);
    }

    public int getCurrentPlayerTick() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentPlayerTick()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetCurrentPlayerTick(this.getHandle());
    }

    public void setCurrentPlayerTick(int currentTick) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentPlayerTick(int currentTick)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetCurrentPlayerTick(this.getHandle(), currentTick);
    }

    public Date getMapStartTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapStartTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = MapNative.jni_GetStartTime(this.getHandle());
        String[] stringArray = string.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        Date date = new Date(n - 1900, n2 - 1, n3, n4, n5, n6);
        return date;
    }

    public void setMapStartTime(Date startTime) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapStartTime(Date startTime)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", startTime);
        MapNative.jni_SetStartTime(this.getHandle(), string);
    }

    public Date getMapEndTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapEndTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = MapNative.jni_GetEndTime(this.getHandle());
        String[] stringArray = string.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        Date date = new Date(n - 1900, n2 - 1, n3, n4, n5, n6);
        return date;
    }

    public void setMapEndTime(Date endTime) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapEndTime(Date endTime)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", endTime);
        MapNative.jni_SetEndTime(this.getHandle(), string);
    }

    public boolean isTimeEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTimeEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsTimeEnable(this.getHandle());
    }

    @Deprecated
    public boolean IsTimeEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsTimeEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsTimeEnable(this.getHandle());
    }

    public void setTimeEnable(boolean bEnable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeEnable(boolean bEnable)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTimeEnable(this.getHandle(), bEnable);
    }

    public Date getDefaultMapStartTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultMapStartTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = MapNative.jni_GetDefaultMapStartTime(this.getHandle());
        String[] stringArray = string.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        Date date = new Date(n - 1900, n2 - 1, n3, n4, n5, n6);
        return date;
    }

    public Date getDefaultMapEndTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultMapEndTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = MapNative.jni_GetDefaultMapEndTime(this.getHandle());
        String[] stringArray = string.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        Date date = new Date(n - 1900, n2 - 1, n3, n4, n5, n6);
        return date;
    }

    public TimeSpan getMinTimeStep() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinTimeStep()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TimeSpan timeSpan = new TimeSpan();
        timeSpan.setTimeSpan(MapNative.jni_GetMinTimeStep(this.getHandle()));
        return timeSpan;
    }

    public String getTimeFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" getTimeFormat()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetTimeFormat(this.getHandle());
    }

    public void setTimeFormat(String timeFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeFormat(String timeFormat)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (timeFormat == null || timeFormat.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetTimeFormat(this.getHandle(), timeFormat);
    }

    public TextPosition getTimeTextPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeTextPosition()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetTimeTextPosition(this.getHandle());
        return (TextPosition)InternalEnum.parseUGCValue(TextPosition.class, n);
    }

    public void setTimeTextPosition(TextPosition timeTextPosition) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeTextPosition(TextPosition timeTextPosition)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(timeTextPosition);
        MapNative.jni_SetTimeTextPosition(this.getHandle(), n);
    }

    public boolean isShowTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isShowTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsShowTime(this.getHandle());
    }

    public void setIsShowTime(boolean isShowTime) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsShowTime(boolean isShowTime)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetIsShowTime(this.getHandle(), isShowTime);
    }

    public TextStyle getTimeTextStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeTextStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = MapNative.jni_GetTimeTextStyle(this.getHandle());
        TextStyle textStyle = null;
        if (l != 0L) {
            textStyle = InternalTextStyle.createInstance(l);
        }
        return textStyle;
    }

    public void setTimeTextStyle(TextStyle timeTextStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeTextStyle(TextStyle timeTextStyle)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (Map.getHandle((com.supermap.data.InternalHandle)timeTextStyle) == 0L) {
            String string = InternalResource.loadString("setTimeTextStyle(TextStyle timeTextStyle)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTimeTextStyle(this.getHandle(), Map.getHandle((com.supermap.data.InternalHandle)timeTextStyle));
    }

    public boolean isDebugMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDebugMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsDebugMode(this.getHandle());
    }

    public void setDebugMode(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDebugMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetDebugMode(this.getHandle(), value);
    }

    public boolean isMapThreadDrawingEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMapThreadDrawingEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsMapThreadDrawingEnabled(this.getHandle());
    }

    public void setMapThreadDrawingEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapThreadDrawingEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetMapThreadDrawingEnabled(this.getHandle(), value);
    }

    public static boolean isMapProfileingEnable() {
        return MapNative.jni_IsMapProfileingEnable();
    }

    public static void setMapProfileingEnable(boolean value) {
        MapNative.jni_SetMapProfileingEnable(value);
    }

    public String getLastProfilingResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLastProfilingResult()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetLastProfilingResult(this.getHandle());
    }

    public static synchronized void setDatasetToBeUpdated(Dataset dataset) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetDatasetToBeUpdated(l);
    }

    public LabelAvoidWeightInfos getMapLabelAvoidWeightInfos() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapLabelAvoidWeightInfos()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_labelAvoidWeightInfos == null && (l = MapNative.jni_GetLabelAvoidWeightInfosHandle(this.getHandle())) != 0L) {
            this.m_labelAvoidWeightInfos = new LabelAvoidWeightInfos(l, false);
        }
        return this.m_labelAvoidWeightInfos;
    }

    public String getExternalXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExternalXML()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetExternalXML(this.getHandle());
    }

    public void setExternalXML(String enternalXML) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExternalXML(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (enternalXML == null || enternalXML.trim().length() == 0) {
            String string = InternalResource.loadString("enternalXML", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetExternalXML(this.getHandle(), enternalXML);
    }

    public boolean isFullLabel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFullLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsFullLabel(this.getHandle());
    }

    public void setFullLabel(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFullLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetFullLabel(this.getHandle(), value);
    }

    static {
        InternalToolkitMapping.CheckChartLicenseState();
    }
}

