/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.SnapMode;
import com.supermap.mapping.SnapSettingNative;
import java.util.ArrayList;

public class SnapSetting
extends InternalHandleDisposable {
    private static final int SNAPMODE_COUNT = 12;
    private ArrayList<SnapMode> fixedSnapModeList = null;
    private ArrayList<Integer> snapModeOrderQuene = null;

    public SnapSetting() {
        long l = SnapSettingNative.jni_new();
        this.initSnapModeListAndOrderQuene();
        this.setHandle(l, true);
    }

    public SnapSetting(SnapSetting setting) {
        if (setting == null) {
            String string = InternalResource.loadString("SnapSetting setting", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)setting);
        if (l == 0L) {
            String string = InternalResource.loadString("SnapSetting(SnapSetting setting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l2 = SnapSettingNative.jni_Clone(l);
        this.initSnapModeListAndOrderQuene();
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)setting));
    }

    SnapSetting(long handle) {
        this.initSnapModeListAndOrderQuene();
        this.setHandle(handle, false);
    }

    public int getTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetTolerance()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetTolerance(this.getHandle());
    }

    public void setTolerance(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetTolerance(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetTolerance(this.getHandle(), value);
    }

    public int getMinSnappedLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetMinSnappedLength()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetMinSnappedLength(this.getHandle());
    }

    public void setMinSnappedLength(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetMinSnappedLength(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetMinSnappedLength(this.getHandle(), value);
    }

    public double getFixedAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetFixedAngle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetFixedAngle(this.getHandle());
    }

    public void setFixedAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetFixedAngle(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetFixedAngle(this.getHandle(), value);
    }

    public double getFixedLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetFixedLength()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetFixedLength(this.getHandle());
    }

    public void setFixedLength(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetFixedLength(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetFixedLength(this.getHandle(), value);
    }

    public int getMaxSnappedCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetMaxSnappedCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetMaxSnappedCount(this.getHandle());
    }

    public void setMaxSnappedCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetMaxSnappedCount(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 20) {
            value = 20;
        }
        if (value > 5000) {
            value = 5000;
        }
        SnapSettingNative.jni_SetMaxSnappedCount(this.getHandle(), value);
    }

    public boolean isSnappedLineBroken() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsSnappedLineBroken()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_IsSnappedLineBroken(this.getHandle());
    }

    public void setSnappedLineBroken(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSnappedLineBroken(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetSnappedLineBroken(this.getHandle(), value);
    }

    public boolean isEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_IsEnable(this.getHandle());
    }

    public void setEnable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEnable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetEnable(this.getHandle(), value);
    }

    public boolean get(SnapMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(SnapMode mode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetSnapMode(this.getHandle(), mode.value());
    }

    public void set(SnapMode mode, boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Set(SnapMode mode, boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetSnapMode(this.getHandle(), mode.value(), value);
    }

    public int indexOf(SnapMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(SnapMode mode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.snapModeOrderQuene.indexOf(this.fixedSnapModeList.indexOf((Object)mode));
    }

    public SnapMode getAt(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetAt(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 && index >= 12) {
            String string = InternalResource.loadString("getAt(int index)", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.fixedSnapModeList.get(this.snapModeOrderQuene.get(index));
    }

    public boolean exchange(SnapMode mode1, SnapMode mode2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Exchange(SnapMode mode1, SnapMode mode2)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mode1 == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mode2 == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.snapModeOrderQuene.indexOf(this.fixedSnapModeList.indexOf((Object)mode1));
        int n2 = this.snapModeOrderQuene.indexOf(this.fixedSnapModeList.indexOf((Object)mode2));
        return this.exchange(n, n2);
    }

    public boolean exchange(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            String string = InternalResource.loadString("exchange(int index1, int index2)", "SnapSetting_IndexShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (index1 > 12 || index2 > 12) {
            String string = InternalResource.loadString("exchange(int index1, int index2)", "SnapSetting_IndexShouldLessThanSnapModeCount", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Exchange(int index1, int index2)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.snapModeOrderQuene.get(index1);
        this.snapModeOrderQuene.set(index1, this.snapModeOrderQuene.get(index2));
        this.snapModeOrderQuene.set(index2, n);
        SnapSettingNative.jni_ExchangeByIndex(this.getHandle(), index1, index2);
        return true;
    }

    public boolean moveTo(SnapMode mode, int targetIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("MoveTo(SnapMode mode, int targetIndex)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.indexOf(mode);
        int n2 = this.snapModeOrderQuene.get(n);
        this.snapModeOrderQuene.remove(n);
        this.snapModeOrderQuene.add(targetIndex, n2);
        return SnapSettingNative.jni_MoveTo(this.getHandle(), n, targetIndex);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ToString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ FixedAngle=");
        stringBuffer.append(this.getFixedAngle());
        stringBuffer.append(",FixedLength=");
        stringBuffer.append(this.getFixedLength());
        stringBuffer.append(",IsSnapedLineBroen=");
        stringBuffer.append(this.isSnappedLineBroken());
        stringBuffer.append(",MaxSnappedCount=");
        stringBuffer.append(this.getMaxSnappedCount());
        stringBuffer.append(",MinLength=");
        stringBuffer.append(this.getMinSnappedLength());
        stringBuffer.append(",Tolerance=");
        stringBuffer.append(this.getTolerance());
        int n = this.getMaxSnappedCount();
        int[] nArray = SnapMode.getValues(SnapMode.class);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            SnapSettingNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }

    protected static void clearHandle(SnapSetting setting) {
        setting.clearHandle();
    }

    protected static SnapSetting creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return new SnapSetting(handle);
    }

    private void initSnapModeListAndOrderQuene() {
        this.fixedSnapModeList = new ArrayList();
        this.fixedSnapModeList.add(SnapMode.POINT_ON_ENDPOINT);
        this.fixedSnapModeList.add(SnapMode.POINT_ON_POINT);
        this.fixedSnapModeList.add(SnapMode.POINT_ON_LINE);
        this.fixedSnapModeList.add(SnapMode.POINT_ON_MIDPOINT);
        this.fixedSnapModeList.add(SnapMode.POINT_ON_EXTENSION);
        this.fixedSnapModeList.add(SnapMode.LINE_WITH_FIXED_ANGLE);
        this.fixedSnapModeList.add(SnapMode.LINE_WITH_FIXED_LENGTH);
        this.fixedSnapModeList.add(SnapMode.LINE_WITH_HORIZONTAL);
        this.fixedSnapModeList.add(SnapMode.LINE_WITH_VERTICAL);
        this.fixedSnapModeList.add(SnapMode.LINE_WITH_PARALLEL);
        this.fixedSnapModeList.add(SnapMode.LINE_WITH_PERPENDICULAR);
        this.snapModeOrderQuene = new ArrayList();
        this.snapModeOrderQuene.add(0);
        this.snapModeOrderQuene.add(3);
        this.snapModeOrderQuene.add(2);
        this.snapModeOrderQuene.add(1);
        this.snapModeOrderQuene.add(4);
        this.snapModeOrderQuene.add(7);
        this.snapModeOrderQuene.add(8);
        this.snapModeOrderQuene.add(9);
        this.snapModeOrderQuene.add(10);
        this.snapModeOrderQuene.add(5);
        this.snapModeOrderQuene.add(6);
    }
}

