/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.DirectionType;
import com.supermap.analyst.networkanalyst.InternalEnum;
import com.supermap.analyst.networkanalyst.InternalGeometry;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.PathGuideItemNative;
import com.supermap.analyst.networkanalyst.SideType;
import com.supermap.analyst.networkanalyst.TurnType;
import com.supermap.data.GeoLine;
import com.supermap.data.Rectangle2D;

public class PathGuideItem
extends InternalHandle {
    private Rectangle2D m_bounds = null;

    PathGuideItem(long handle) {
        this.setHandle(handle);
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getID()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetID(this.getHandle());
    }

    public int getIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIndex()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetIndex(this.getHandle());
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetName(this.getHandle());
    }

    public boolean isEdge() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEdge()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetIsEdge(this.getHandle());
    }

    public boolean isStop() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRouteNode()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetIsRouteNode(this.getHandle());
    }

    public double getWeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWeight()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetWeight(this.getHandle());
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetLength(this.getHandle());
    }

    public double getTurnAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTurnAngle()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetTurnAngle(this.getHandle());
    }

    public double getDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistance()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return PathGuideItemNative.jni_GetDistance(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_bounds == null) {
            double[] dArray = new double[4];
            PathGuideItemNative.jni_GetBounds(this.getHandle(), dArray);
            this.m_bounds = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        }
        return this.m_bounds;
    }

    public DirectionType getDirectionType() {
        DirectionType directionType;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDirectionType()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isEdge()) {
            directionType = DirectionType.NONE;
        } else {
            int n = PathGuideItemNative.jni_GetDirectionType(this.getHandle());
            directionType = (DirectionType)InternalEnum.parseUGCValue(DirectionType.class, n);
        }
        return directionType;
    }

    public TurnType getTurnType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTurnType()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = PathGuideItemNative.jni_GetTurnType(this.getHandle());
        return (TurnType)InternalEnum.parseUGCValue(TurnType.class, n);
    }

    public SideType getSideType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSideType()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = PathGuideItemNative.jni_GetSideType(this.getHandle());
        return (SideType)InternalEnum.parseUGCValue(SideType.class, n);
    }

    String toStr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ID=");
        stringBuffer.append(this.getID());
        stringBuffer.append(",Name=");
        stringBuffer.append(this.getName());
        stringBuffer.append(",Index=");
        stringBuffer.append(this.getIndex());
        stringBuffer.append(",Weight=");
        stringBuffer.append(this.getWeight());
        stringBuffer.append(",Length=");
        stringBuffer.append(this.getLength());
        stringBuffer.append(",Distance=");
        stringBuffer.append(this.getDistance());
        stringBuffer.append(",DirectionType=");
        stringBuffer.append((Object)this.getDirectionType());
        stringBuffer.append(",TurnType=");
        stringBuffer.append((Object)this.getTurnType());
        stringBuffer.append(",SideType=");
        stringBuffer.append((Object)this.getSideType());
        stringBuffer.append(",TurnAngle=");
        stringBuffer.append(this.getTurnAngle());
        stringBuffer.append(",IsEdge=");
        stringBuffer.append(this.isEdge());
        stringBuffer.append(",IsStop=");
        stringBuffer.append(this.isStop());
        stringBuffer.append(",Bounds=");
        stringBuffer.append(this.getBounds());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public GeoLine getGuideLine() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGuideLine()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        GeoLine geoLine = null;
        if (this.isEdge() && (l = PathGuideItemNative.jni_GetGeoLine(this.getHandle())) != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoLine, false);
        }
        return geoLine;
    }
}

