"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingAppInstanceUser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const instanceUserValidator_1 = require("./instanceUserValidator");
const messagingCustomResources_1 = require("./messagingCustomResources");
class MessagingAppInstanceUser extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, metadata, clientRequestToken, appInstanceArn, appInstanceUserId, tags, } = props;
        instanceUserValidator_1.instanceUserValidator(props);
        const appInstanceRequest = new messagingCustomResources_1.MessagingResources(this, 'MessagingAppInstance', {
            resourceType: 'AppInstanceUser',
            uid: uid,
            properties: {
                name: name || uid,
                metadata: metadata,
                clientRequestToken: clientRequestToken,
                appInstanceArn: appInstanceArn,
                appInstanceUserId: appInstanceUserId,
                tags: tags,
            },
        });
        this.appInstanceUserArn =
            appInstanceRequest.messagingCustomResource.getAttString('appInstanceUser');
    }
}
exports.MessagingAppInstanceUser = MessagingAppInstanceUser;
_a = JSII_RTTI_SYMBOL_1;
MessagingAppInstanceUser[_a] = { fqn: "cdk-amazon-chime-resources.MessagingAppInstanceUser", version: "2.0.8" };
//# sourceMappingURL=data:application/json;base64,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