"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sipRuleValidator = void 0;
var E164_NUMBER = /^\+[1-9]\d{10,14}$/;
var URI_HOSTNAME = /^[0-9a-z]{22}.voiceconnector.chime.aws$/;
var SMA_ID = /^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$/;
function sipRuleValidator(props) {
    if (props.triggerType) {
        if (props.triggerValue.includes('Token')) {
        }
        else {
            if (props.triggerType === 'ToPhoneNumber' &&
                !E164_NUMBER.test(props.triggerValue)) {
                throw new Error('Trigger Value must be must be valid E.164 number');
            }
            if (props.triggerType === 'RequestUriHostname' &&
                !URI_HOSTNAME.test(props.triggerValue)) {
                throw new Error('Trigger Value must be valid Chime Voice Connector');
            }
        }
    }
    if (props.targetApplications) {
        for (var target of props.targetApplications) {
            if (target.sipMediaApplicationId) {
                if (target.sipMediaApplicationId.includes('Token')) {
                }
                else {
                    if (!SMA_ID.test(target.sipMediaApplicationId)) {
                        throw new Error('sipMediaApplicationId must be valid');
                    }
                }
            }
            for (var target of props.targetApplications) {
                if (target.priority) {
                    if (target.priority < 1 || target.priority > 25) {
                        throw new Error('priority should be between 1 and 25');
                    }
                }
            }
            for (var target of props.targetApplications) {
                if (target.region) {
                    if (!(target.region.includes('Token[AWS.Region.') ||
                        target.region === 'us-east-1' ||
                        target.region === 'us-west-2')) {
                        throw new Error('Region must be us-east-1 or us-west-2');
                    }
                }
            }
        }
    }
    return true;
}
exports.sipRuleValidator = sipRuleValidator;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2lwUnVsZVZhbGlkYXRvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9wc3RuL3NpcFJ1bGVWYWxpZGF0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUEsSUFBSSxXQUFXLEdBQUcsb0JBQW9CLENBQUM7QUFFdkMsSUFBSSxZQUFZLEdBQUcseUNBQXlDLENBQUM7QUFFN0QsSUFBSSxNQUFNLEdBQUcsZ0VBQWdFLENBQUM7QUFFOUUsU0FBZ0IsZ0JBQWdCLENBQUMsS0FBbUI7SUFDbEQsSUFBSSxLQUFLLENBQUMsV0FBVyxFQUFFO1FBQ3JCLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEVBQUU7U0FDekM7YUFBTTtZQUNMLElBQ0UsS0FBSyxDQUFDLFdBQVcsS0FBSyxlQUFlO2dCQUNyQyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxFQUNyQztnQkFDQSxNQUFNLElBQUksS0FBSyxDQUFDLGtEQUFrRCxDQUFDLENBQUM7YUFDckU7WUFDRCxJQUNFLEtBQUssQ0FBQyxXQUFXLEtBQUssb0JBQW9CO2dCQUMxQyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxFQUN0QztnQkFDQSxNQUFNLElBQUksS0FBSyxDQUFDLG1EQUFtRCxDQUFDLENBQUM7YUFDdEU7U0FDRjtLQUNGO0lBRUQsSUFBSSxLQUFLLENBQUMsa0JBQWtCLEVBQUU7UUFDNUIsS0FBSyxJQUFJLE1BQU0sSUFBSSxLQUFLLENBQUMsa0JBQWtCLEVBQUU7WUFDM0MsSUFBSSxNQUFNLENBQUMscUJBQXFCLEVBQUU7Z0JBQ2hDLElBQUksTUFBTSxDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRTtpQkFDbkQ7cUJBQU07b0JBQ0wsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLEVBQUU7d0JBQzlDLE1BQU0sSUFBSSxLQUFLLENBQUMscUNBQXFDLENBQUMsQ0FBQztxQkFDeEQ7aUJBQ0Y7YUFDRjtZQUNELEtBQUssSUFBSSxNQUFNLElBQUksS0FBSyxDQUFDLGtCQUFrQixFQUFFO2dCQUMzQyxJQUFJLE1BQU0sQ0FBQyxRQUFRLEVBQUU7b0JBQ25CLElBQUksTUFBTSxDQUFDLFFBQVEsR0FBRyxDQUFDLElBQUksTUFBTSxDQUFDLFFBQVEsR0FBRyxFQUFFLEVBQUU7d0JBQy9DLE1BQU0sSUFBSSxLQUFLLENBQUMscUNBQXFDLENBQUMsQ0FBQztxQkFDeEQ7aUJBQ0Y7YUFDRjtZQUVELEtBQUssSUFBSSxNQUFNLElBQUksS0FBSyxDQUFDLGtCQUFrQixFQUFFO2dCQUMzQyxJQUFJLE1BQU0sQ0FBQyxNQUFNLEVBQUU7b0JBQ2pCLElBQ0UsQ0FBQyxDQUNDLE1BQU0sQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLG1CQUFtQixDQUFDO3dCQUMzQyxNQUFNLENBQUMsTUFBTSxLQUFLLFdBQVc7d0JBQzdCLE1BQU0sQ0FBQyxNQUFNLEtBQUssV0FBVyxDQUM5QixFQUNEO3dCQUNBLE1BQU0sSUFBSSxLQUFLLENBQUMsdUNBQXVDLENBQUMsQ0FBQztxQkFDMUQ7aUJBQ0Y7YUFDRjtTQUNGO0tBQ0Y7SUFFRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUF0REQsNENBc0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU2lwUnVsZVByb3BzIH0gZnJvbSAnLi9zaXBSdWxlJztcblxudmFyIEUxNjRfTlVNQkVSID0gL15cXCtbMS05XVxcZHsxMCwxNH0kLztcblxudmFyIFVSSV9IT1NUTkFNRSA9IC9eWzAtOWEtel17MjJ9LnZvaWNlY29ubmVjdG9yLmNoaW1lLmF3cyQvO1xuXG52YXIgU01BX0lEID0gL15bMC05YS16XXs4fS1bMC05YS16XXs0fS1bMC05YS16XXs0fS1bMC05YS16XXs0fS1bMC05YS16XXsxMn0kLztcblxuZXhwb3J0IGZ1bmN0aW9uIHNpcFJ1bGVWYWxpZGF0b3IocHJvcHM6IFNpcFJ1bGVQcm9wcykge1xuICBpZiAocHJvcHMudHJpZ2dlclR5cGUpIHtcbiAgICBpZiAocHJvcHMudHJpZ2dlclZhbHVlLmluY2x1ZGVzKCdUb2tlbicpKSB7XG4gICAgfSBlbHNlIHtcbiAgICAgIGlmIChcbiAgICAgICAgcHJvcHMudHJpZ2dlclR5cGUgPT09ICdUb1Bob25lTnVtYmVyJyAmJlxuICAgICAgICAhRTE2NF9OVU1CRVIudGVzdChwcm9wcy50cmlnZ2VyVmFsdWUpXG4gICAgICApIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdUcmlnZ2VyIFZhbHVlIG11c3QgYmUgbXVzdCBiZSB2YWxpZCBFLjE2NCBudW1iZXInKTtcbiAgICAgIH1cbiAgICAgIGlmIChcbiAgICAgICAgcHJvcHMudHJpZ2dlclR5cGUgPT09ICdSZXF1ZXN0VXJpSG9zdG5hbWUnICYmXG4gICAgICAgICFVUklfSE9TVE5BTUUudGVzdChwcm9wcy50cmlnZ2VyVmFsdWUpXG4gICAgICApIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdUcmlnZ2VyIFZhbHVlIG11c3QgYmUgdmFsaWQgQ2hpbWUgVm9pY2UgQ29ubmVjdG9yJyk7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgaWYgKHByb3BzLnRhcmdldEFwcGxpY2F0aW9ucykge1xuICAgIGZvciAodmFyIHRhcmdldCBvZiBwcm9wcy50YXJnZXRBcHBsaWNhdGlvbnMpIHtcbiAgICAgIGlmICh0YXJnZXQuc2lwTWVkaWFBcHBsaWNhdGlvbklkKSB7XG4gICAgICAgIGlmICh0YXJnZXQuc2lwTWVkaWFBcHBsaWNhdGlvbklkLmluY2x1ZGVzKCdUb2tlbicpKSB7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgaWYgKCFTTUFfSUQudGVzdCh0YXJnZXQuc2lwTWVkaWFBcHBsaWNhdGlvbklkKSkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdzaXBNZWRpYUFwcGxpY2F0aW9uSWQgbXVzdCBiZSB2YWxpZCcpO1xuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgICAgZm9yICh2YXIgdGFyZ2V0IG9mIHByb3BzLnRhcmdldEFwcGxpY2F0aW9ucykge1xuICAgICAgICBpZiAodGFyZ2V0LnByaW9yaXR5KSB7XG4gICAgICAgICAgaWYgKHRhcmdldC5wcmlvcml0eSA8IDEgfHwgdGFyZ2V0LnByaW9yaXR5ID4gMjUpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcigncHJpb3JpdHkgc2hvdWxkIGJlIGJldHdlZW4gMSBhbmQgMjUnKTtcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH1cblxuICAgICAgZm9yICh2YXIgdGFyZ2V0IG9mIHByb3BzLnRhcmdldEFwcGxpY2F0aW9ucykge1xuICAgICAgICBpZiAodGFyZ2V0LnJlZ2lvbikge1xuICAgICAgICAgIGlmIChcbiAgICAgICAgICAgICEoXG4gICAgICAgICAgICAgIHRhcmdldC5yZWdpb24uaW5jbHVkZXMoJ1Rva2VuW0FXUy5SZWdpb24uJykgfHxcbiAgICAgICAgICAgICAgdGFyZ2V0LnJlZ2lvbiA9PT0gJ3VzLWVhc3QtMScgfHxcbiAgICAgICAgICAgICAgdGFyZ2V0LnJlZ2lvbiA9PT0gJ3VzLXdlc3QtMidcbiAgICAgICAgICAgIClcbiAgICAgICAgICApIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignUmVnaW9uIG11c3QgYmUgdXMtZWFzdC0xIG9yIHVzLXdlc3QtMicpO1xuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIHJldHVybiB0cnVlO1xufVxuIl19