"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PutDataRetention = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_1 = require("@aws-sdk/client-chime");
const chimeClient = new client_chime_1.ChimeClient({
    region: process.env.AWS_REGION,
});
let putDataRetentionOutput;
let putDataRetentionInput;
exports.PutDataRetention = async (props) => {
    putDataRetentionInput = {
        AppInstanceArn: props.appInstanceArn,
        AppInstanceRetentionSettings: {
            ChannelRetentionSettings: {
                RetentionDays: parseInt(props.dataRetention),
            },
        },
    };
    try {
        putDataRetentionOutput = await chimeClient.send(new client_chime_1.PutAppInstanceRetentionSettingsCommand(putDataRetentionInput));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        appInstanceRetentionSettings: putDataRetentionOutput.AppInstanceRetentionSettings,
    };
};
//# sourceMappingURL=data:application/json;base64,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