"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteAppInstanceAdmin = exports.CreateAppInstanceAdmin = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_1 = require("@aws-sdk/client-chime");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeClient = new client_chime_1.ChimeClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let createAppInstanceAdminCommandInput;
let createAppInstanceAdminCommandOutput;
exports.CreateAppInstanceAdmin = async (uid, props) => {
    createAppInstanceAdminCommandInput = {
        AppInstanceArn: props.appInstanceArn,
        AppInstanceAdminArn: props.appInstanceAdminArn,
    };
    try {
        createAppInstanceAdminCommandOutput = await chimeClient.send(new client_chime_1.CreateAppInstanceAdminCommand(createAppInstanceAdminCommandInput));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: `/chime/appInstanceAdminArn/${uid}`,
            Description: 'appInstanceAdminArn',
            Value: createAppInstanceAdminCommandOutput.AppInstanceAdmin?.Arn,
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        AppInstanceAdminArn: createAppInstanceAdminCommandOutput.AppInstanceAdmin?.Arn,
        AppInstanceAdminName: createAppInstanceAdminCommandOutput.AppInstanceAdmin?.Name,
    };
};
exports.DeleteAppInstanceAdmin = async (uid) => {
    try {
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: `/chime/appInstanceAdminArn/${uid}` }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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