"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSDKMessaging = void 0;
const ChimeSDKMessagingClient_1 = require("./ChimeSDKMessagingClient");
const AssociateChannelFlowCommand_1 = require("./commands/AssociateChannelFlowCommand");
const BatchCreateChannelMembershipCommand_1 = require("./commands/BatchCreateChannelMembershipCommand");
const ChannelFlowCallbackCommand_1 = require("./commands/ChannelFlowCallbackCommand");
const CreateChannelBanCommand_1 = require("./commands/CreateChannelBanCommand");
const CreateChannelCommand_1 = require("./commands/CreateChannelCommand");
const CreateChannelFlowCommand_1 = require("./commands/CreateChannelFlowCommand");
const CreateChannelMembershipCommand_1 = require("./commands/CreateChannelMembershipCommand");
const CreateChannelModeratorCommand_1 = require("./commands/CreateChannelModeratorCommand");
const DeleteChannelBanCommand_1 = require("./commands/DeleteChannelBanCommand");
const DeleteChannelCommand_1 = require("./commands/DeleteChannelCommand");
const DeleteChannelFlowCommand_1 = require("./commands/DeleteChannelFlowCommand");
const DeleteChannelMembershipCommand_1 = require("./commands/DeleteChannelMembershipCommand");
const DeleteChannelMessageCommand_1 = require("./commands/DeleteChannelMessageCommand");
const DeleteChannelModeratorCommand_1 = require("./commands/DeleteChannelModeratorCommand");
const DescribeChannelBanCommand_1 = require("./commands/DescribeChannelBanCommand");
const DescribeChannelCommand_1 = require("./commands/DescribeChannelCommand");
const DescribeChannelFlowCommand_1 = require("./commands/DescribeChannelFlowCommand");
const DescribeChannelMembershipCommand_1 = require("./commands/DescribeChannelMembershipCommand");
const DescribeChannelMembershipForAppInstanceUserCommand_1 = require("./commands/DescribeChannelMembershipForAppInstanceUserCommand");
const DescribeChannelModeratedByAppInstanceUserCommand_1 = require("./commands/DescribeChannelModeratedByAppInstanceUserCommand");
const DescribeChannelModeratorCommand_1 = require("./commands/DescribeChannelModeratorCommand");
const DisassociateChannelFlowCommand_1 = require("./commands/DisassociateChannelFlowCommand");
const GetChannelMembershipPreferencesCommand_1 = require("./commands/GetChannelMembershipPreferencesCommand");
const GetChannelMessageCommand_1 = require("./commands/GetChannelMessageCommand");
const GetChannelMessageStatusCommand_1 = require("./commands/GetChannelMessageStatusCommand");
const GetMessagingSessionEndpointCommand_1 = require("./commands/GetMessagingSessionEndpointCommand");
const ListChannelBansCommand_1 = require("./commands/ListChannelBansCommand");
const ListChannelFlowsCommand_1 = require("./commands/ListChannelFlowsCommand");
const ListChannelMembershipsCommand_1 = require("./commands/ListChannelMembershipsCommand");
const ListChannelMembershipsForAppInstanceUserCommand_1 = require("./commands/ListChannelMembershipsForAppInstanceUserCommand");
const ListChannelMessagesCommand_1 = require("./commands/ListChannelMessagesCommand");
const ListChannelModeratorsCommand_1 = require("./commands/ListChannelModeratorsCommand");
const ListChannelsAssociatedWithChannelFlowCommand_1 = require("./commands/ListChannelsAssociatedWithChannelFlowCommand");
const ListChannelsCommand_1 = require("./commands/ListChannelsCommand");
const ListChannelsModeratedByAppInstanceUserCommand_1 = require("./commands/ListChannelsModeratedByAppInstanceUserCommand");
const ListSubChannelsCommand_1 = require("./commands/ListSubChannelsCommand");
const ListTagsForResourceCommand_1 = require("./commands/ListTagsForResourceCommand");
const PutChannelMembershipPreferencesCommand_1 = require("./commands/PutChannelMembershipPreferencesCommand");
const RedactChannelMessageCommand_1 = require("./commands/RedactChannelMessageCommand");
const SearchChannelsCommand_1 = require("./commands/SearchChannelsCommand");
const SendChannelMessageCommand_1 = require("./commands/SendChannelMessageCommand");
const TagResourceCommand_1 = require("./commands/TagResourceCommand");
const UntagResourceCommand_1 = require("./commands/UntagResourceCommand");
const UpdateChannelCommand_1 = require("./commands/UpdateChannelCommand");
const UpdateChannelFlowCommand_1 = require("./commands/UpdateChannelFlowCommand");
const UpdateChannelMessageCommand_1 = require("./commands/UpdateChannelMessageCommand");
const UpdateChannelReadMarkerCommand_1 = require("./commands/UpdateChannelReadMarkerCommand");
class ChimeSDKMessaging extends ChimeSDKMessagingClient_1.ChimeSDKMessagingClient {
    associateChannelFlow(args, optionsOrCb, cb) {
        const command = new AssociateChannelFlowCommand_1.AssociateChannelFlowCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchCreateChannelMembership(args, optionsOrCb, cb) {
        const command = new BatchCreateChannelMembershipCommand_1.BatchCreateChannelMembershipCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    channelFlowCallback(args, optionsOrCb, cb) {
        const command = new ChannelFlowCallbackCommand_1.ChannelFlowCallbackCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createChannel(args, optionsOrCb, cb) {
        const command = new CreateChannelCommand_1.CreateChannelCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createChannelBan(args, optionsOrCb, cb) {
        const command = new CreateChannelBanCommand_1.CreateChannelBanCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createChannelFlow(args, optionsOrCb, cb) {
        const command = new CreateChannelFlowCommand_1.CreateChannelFlowCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createChannelMembership(args, optionsOrCb, cb) {
        const command = new CreateChannelMembershipCommand_1.CreateChannelMembershipCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createChannelModerator(args, optionsOrCb, cb) {
        const command = new CreateChannelModeratorCommand_1.CreateChannelModeratorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteChannel(args, optionsOrCb, cb) {
        const command = new DeleteChannelCommand_1.DeleteChannelCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteChannelBan(args, optionsOrCb, cb) {
        const command = new DeleteChannelBanCommand_1.DeleteChannelBanCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteChannelFlow(args, optionsOrCb, cb) {
        const command = new DeleteChannelFlowCommand_1.DeleteChannelFlowCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteChannelMembership(args, optionsOrCb, cb) {
        const command = new DeleteChannelMembershipCommand_1.DeleteChannelMembershipCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteChannelMessage(args, optionsOrCb, cb) {
        const command = new DeleteChannelMessageCommand_1.DeleteChannelMessageCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteChannelModerator(args, optionsOrCb, cb) {
        const command = new DeleteChannelModeratorCommand_1.DeleteChannelModeratorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeChannel(args, optionsOrCb, cb) {
        const command = new DescribeChannelCommand_1.DescribeChannelCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeChannelBan(args, optionsOrCb, cb) {
        const command = new DescribeChannelBanCommand_1.DescribeChannelBanCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeChannelFlow(args, optionsOrCb, cb) {
        const command = new DescribeChannelFlowCommand_1.DescribeChannelFlowCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeChannelMembership(args, optionsOrCb, cb) {
        const command = new DescribeChannelMembershipCommand_1.DescribeChannelMembershipCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeChannelMembershipForAppInstanceUser(args, optionsOrCb, cb) {
        const command = new DescribeChannelMembershipForAppInstanceUserCommand_1.DescribeChannelMembershipForAppInstanceUserCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeChannelModeratedByAppInstanceUser(args, optionsOrCb, cb) {
        const command = new DescribeChannelModeratedByAppInstanceUserCommand_1.DescribeChannelModeratedByAppInstanceUserCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    describeChannelModerator(args, optionsOrCb, cb) {
        const command = new DescribeChannelModeratorCommand_1.DescribeChannelModeratorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    disassociateChannelFlow(args, optionsOrCb, cb) {
        const command = new DisassociateChannelFlowCommand_1.DisassociateChannelFlowCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getChannelMembershipPreferences(args, optionsOrCb, cb) {
        const command = new GetChannelMembershipPreferencesCommand_1.GetChannelMembershipPreferencesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getChannelMessage(args, optionsOrCb, cb) {
        const command = new GetChannelMessageCommand_1.GetChannelMessageCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getChannelMessageStatus(args, optionsOrCb, cb) {
        const command = new GetChannelMessageStatusCommand_1.GetChannelMessageStatusCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getMessagingSessionEndpoint(args, optionsOrCb, cb) {
        const command = new GetMessagingSessionEndpointCommand_1.GetMessagingSessionEndpointCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannelBans(args, optionsOrCb, cb) {
        const command = new ListChannelBansCommand_1.ListChannelBansCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannelFlows(args, optionsOrCb, cb) {
        const command = new ListChannelFlowsCommand_1.ListChannelFlowsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannelMemberships(args, optionsOrCb, cb) {
        const command = new ListChannelMembershipsCommand_1.ListChannelMembershipsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannelMembershipsForAppInstanceUser(args, optionsOrCb, cb) {
        const command = new ListChannelMembershipsForAppInstanceUserCommand_1.ListChannelMembershipsForAppInstanceUserCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannelMessages(args, optionsOrCb, cb) {
        const command = new ListChannelMessagesCommand_1.ListChannelMessagesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannelModerators(args, optionsOrCb, cb) {
        const command = new ListChannelModeratorsCommand_1.ListChannelModeratorsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannels(args, optionsOrCb, cb) {
        const command = new ListChannelsCommand_1.ListChannelsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannelsAssociatedWithChannelFlow(args, optionsOrCb, cb) {
        const command = new ListChannelsAssociatedWithChannelFlowCommand_1.ListChannelsAssociatedWithChannelFlowCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listChannelsModeratedByAppInstanceUser(args, optionsOrCb, cb) {
        const command = new ListChannelsModeratedByAppInstanceUserCommand_1.ListChannelsModeratedByAppInstanceUserCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listSubChannels(args, optionsOrCb, cb) {
        const command = new ListSubChannelsCommand_1.ListSubChannelsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listTagsForResource(args, optionsOrCb, cb) {
        const command = new ListTagsForResourceCommand_1.ListTagsForResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putChannelMembershipPreferences(args, optionsOrCb, cb) {
        const command = new PutChannelMembershipPreferencesCommand_1.PutChannelMembershipPreferencesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    redactChannelMessage(args, optionsOrCb, cb) {
        const command = new RedactChannelMessageCommand_1.RedactChannelMessageCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    searchChannels(args, optionsOrCb, cb) {
        const command = new SearchChannelsCommand_1.SearchChannelsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    sendChannelMessage(args, optionsOrCb, cb) {
        const command = new SendChannelMessageCommand_1.SendChannelMessageCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    tagResource(args, optionsOrCb, cb) {
        const command = new TagResourceCommand_1.TagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    untagResource(args, optionsOrCb, cb) {
        const command = new UntagResourceCommand_1.UntagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateChannel(args, optionsOrCb, cb) {
        const command = new UpdateChannelCommand_1.UpdateChannelCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateChannelFlow(args, optionsOrCb, cb) {
        const command = new UpdateChannelFlowCommand_1.UpdateChannelFlowCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateChannelMessage(args, optionsOrCb, cb) {
        const command = new UpdateChannelMessageCommand_1.UpdateChannelMessageCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateChannelReadMarker(args, optionsOrCb, cb) {
        const command = new UpdateChannelReadMarkerCommand_1.UpdateChannelReadMarkerCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
}
exports.ChimeSDKMessaging = ChimeSDKMessaging;
