import { HttpHandlerOptions as __HttpHandlerOptions } from "@aws-sdk/types";
import { ChimeSDKMessagingClient } from "./ChimeSDKMessagingClient";
import { AssociateChannelFlowCommandInput, AssociateChannelFlowCommandOutput } from "./commands/AssociateChannelFlowCommand";
import { BatchCreateChannelMembershipCommandInput, BatchCreateChannelMembershipCommandOutput } from "./commands/BatchCreateChannelMembershipCommand";
import { ChannelFlowCallbackCommandInput, ChannelFlowCallbackCommandOutput } from "./commands/ChannelFlowCallbackCommand";
import { CreateChannelBanCommandInput, CreateChannelBanCommandOutput } from "./commands/CreateChannelBanCommand";
import { CreateChannelCommandInput, CreateChannelCommandOutput } from "./commands/CreateChannelCommand";
import { CreateChannelFlowCommandInput, CreateChannelFlowCommandOutput } from "./commands/CreateChannelFlowCommand";
import { CreateChannelMembershipCommandInput, CreateChannelMembershipCommandOutput } from "./commands/CreateChannelMembershipCommand";
import { CreateChannelModeratorCommandInput, CreateChannelModeratorCommandOutput } from "./commands/CreateChannelModeratorCommand";
import { DeleteChannelBanCommandInput, DeleteChannelBanCommandOutput } from "./commands/DeleteChannelBanCommand";
import { DeleteChannelCommandInput, DeleteChannelCommandOutput } from "./commands/DeleteChannelCommand";
import { DeleteChannelFlowCommandInput, DeleteChannelFlowCommandOutput } from "./commands/DeleteChannelFlowCommand";
import { DeleteChannelMembershipCommandInput, DeleteChannelMembershipCommandOutput } from "./commands/DeleteChannelMembershipCommand";
import { DeleteChannelMessageCommandInput, DeleteChannelMessageCommandOutput } from "./commands/DeleteChannelMessageCommand";
import { DeleteChannelModeratorCommandInput, DeleteChannelModeratorCommandOutput } from "./commands/DeleteChannelModeratorCommand";
import { DescribeChannelBanCommandInput, DescribeChannelBanCommandOutput } from "./commands/DescribeChannelBanCommand";
import { DescribeChannelCommandInput, DescribeChannelCommandOutput } from "./commands/DescribeChannelCommand";
import { DescribeChannelFlowCommandInput, DescribeChannelFlowCommandOutput } from "./commands/DescribeChannelFlowCommand";
import { DescribeChannelMembershipCommandInput, DescribeChannelMembershipCommandOutput } from "./commands/DescribeChannelMembershipCommand";
import { DescribeChannelMembershipForAppInstanceUserCommandInput, DescribeChannelMembershipForAppInstanceUserCommandOutput } from "./commands/DescribeChannelMembershipForAppInstanceUserCommand";
import { DescribeChannelModeratedByAppInstanceUserCommandInput, DescribeChannelModeratedByAppInstanceUserCommandOutput } from "./commands/DescribeChannelModeratedByAppInstanceUserCommand";
import { DescribeChannelModeratorCommandInput, DescribeChannelModeratorCommandOutput } from "./commands/DescribeChannelModeratorCommand";
import { DisassociateChannelFlowCommandInput, DisassociateChannelFlowCommandOutput } from "./commands/DisassociateChannelFlowCommand";
import { GetChannelMembershipPreferencesCommandInput, GetChannelMembershipPreferencesCommandOutput } from "./commands/GetChannelMembershipPreferencesCommand";
import { GetChannelMessageCommandInput, GetChannelMessageCommandOutput } from "./commands/GetChannelMessageCommand";
import { GetChannelMessageStatusCommandInput, GetChannelMessageStatusCommandOutput } from "./commands/GetChannelMessageStatusCommand";
import { GetMessagingSessionEndpointCommandInput, GetMessagingSessionEndpointCommandOutput } from "./commands/GetMessagingSessionEndpointCommand";
import { ListChannelBansCommandInput, ListChannelBansCommandOutput } from "./commands/ListChannelBansCommand";
import { ListChannelFlowsCommandInput, ListChannelFlowsCommandOutput } from "./commands/ListChannelFlowsCommand";
import { ListChannelMembershipsCommandInput, ListChannelMembershipsCommandOutput } from "./commands/ListChannelMembershipsCommand";
import { ListChannelMembershipsForAppInstanceUserCommandInput, ListChannelMembershipsForAppInstanceUserCommandOutput } from "./commands/ListChannelMembershipsForAppInstanceUserCommand";
import { ListChannelMessagesCommandInput, ListChannelMessagesCommandOutput } from "./commands/ListChannelMessagesCommand";
import { ListChannelModeratorsCommandInput, ListChannelModeratorsCommandOutput } from "./commands/ListChannelModeratorsCommand";
import { ListChannelsAssociatedWithChannelFlowCommandInput, ListChannelsAssociatedWithChannelFlowCommandOutput } from "./commands/ListChannelsAssociatedWithChannelFlowCommand";
import { ListChannelsCommandInput, ListChannelsCommandOutput } from "./commands/ListChannelsCommand";
import { ListChannelsModeratedByAppInstanceUserCommandInput, ListChannelsModeratedByAppInstanceUserCommandOutput } from "./commands/ListChannelsModeratedByAppInstanceUserCommand";
import { ListSubChannelsCommandInput, ListSubChannelsCommandOutput } from "./commands/ListSubChannelsCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { PutChannelMembershipPreferencesCommandInput, PutChannelMembershipPreferencesCommandOutput } from "./commands/PutChannelMembershipPreferencesCommand";
import { RedactChannelMessageCommandInput, RedactChannelMessageCommandOutput } from "./commands/RedactChannelMessageCommand";
import { SearchChannelsCommandInput, SearchChannelsCommandOutput } from "./commands/SearchChannelsCommand";
import { SendChannelMessageCommandInput, SendChannelMessageCommandOutput } from "./commands/SendChannelMessageCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateChannelCommandInput, UpdateChannelCommandOutput } from "./commands/UpdateChannelCommand";
import { UpdateChannelFlowCommandInput, UpdateChannelFlowCommandOutput } from "./commands/UpdateChannelFlowCommand";
import { UpdateChannelMessageCommandInput, UpdateChannelMessageCommandOutput } from "./commands/UpdateChannelMessageCommand";
import { UpdateChannelReadMarkerCommandInput, UpdateChannelReadMarkerCommandOutput } from "./commands/UpdateChannelReadMarkerCommand";
/**
 * <p>The Amazon Chime SDK Messaging APIs in this section allow software developers to send
 *          and receive messages in custom messaging applications. These APIs depend on the frameworks
 *          provided by the Amazon Chime SDK Identity APIs. For more information about the messaging
 *          APIs, see <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Messaging.html">Amazon Chime SDK messaging</a>.</p>
 */
export declare class ChimeSDKMessaging extends ChimeSDKMessagingClient {
    /**
     * <p>Associates a channel flow with a channel. Once associated, all messages to that channel go through channel flow processors. To stop processing, use the
     *          <code>DisassociateChannelFlow</code> API.</p>
     *
     *          <note>
     *             <p>Only administrators or channel moderators can associate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code>
     *          of the user that makes the API call as the value in the header.</p>
     *          </note>
     */
    associateChannelFlow(args: AssociateChannelFlowCommandInput, options?: __HttpHandlerOptions): Promise<AssociateChannelFlowCommandOutput>;
    associateChannelFlow(args: AssociateChannelFlowCommandInput, cb: (err: any, data?: AssociateChannelFlowCommandOutput) => void): void;
    associateChannelFlow(args: AssociateChannelFlowCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: AssociateChannelFlowCommandOutput) => void): void;
    /**
     * <p>Adds a specified number of users to a channel. </p>
     */
    batchCreateChannelMembership(args: BatchCreateChannelMembershipCommandInput, options?: __HttpHandlerOptions): Promise<BatchCreateChannelMembershipCommandOutput>;
    batchCreateChannelMembership(args: BatchCreateChannelMembershipCommandInput, cb: (err: any, data?: BatchCreateChannelMembershipCommandOutput) => void): void;
    batchCreateChannelMembership(args: BatchCreateChannelMembershipCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: BatchCreateChannelMembershipCommandOutput) => void): void;
    /**
     * <p>Calls back Chime SDK Messaging with a processing response message. This should be invoked from the processor Lambda. This is a developer API.</p>
     *          <p>You can return one of the following processing responses:</p>
     *          <ul>
     *             <li>
     *                <p>Update message content or metadata</p>
     *             </li>
     *             <li>
     *                <p>Deny a message</p>
     *             </li>
     *             <li>
     *                <p>Make no changes to the message</p>
     *             </li>
     *          </ul>
     */
    channelFlowCallback(args: ChannelFlowCallbackCommandInput, options?: __HttpHandlerOptions): Promise<ChannelFlowCallbackCommandOutput>;
    channelFlowCallback(args: ChannelFlowCallbackCommandInput, cb: (err: any, data?: ChannelFlowCallbackCommandOutput) => void): void;
    channelFlowCallback(args: ChannelFlowCallbackCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ChannelFlowCallbackCommandOutput) => void): void;
    /**
     * <p>Creates a channel to which you can add users and send messages.</p>
     *
     *          <p>
     *             <b>Restriction</b>: You can't change a channel's
     *          privacy.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    createChannel(args: CreateChannelCommandInput, options?: __HttpHandlerOptions): Promise<CreateChannelCommandOutput>;
    createChannel(args: CreateChannelCommandInput, cb: (err: any, data?: CreateChannelCommandOutput) => void): void;
    createChannel(args: CreateChannelCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateChannelCommandOutput) => void): void;
    /**
     * <p>Permanently bans a member from a channel. Moderators can't add banned members to a
     *          channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then
     *             <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or
     *          channels.</p>
     *          <p>If you ban a user who is already part of a channel, that user is automatically kicked
     *          from the channel.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    createChannelBan(args: CreateChannelBanCommandInput, options?: __HttpHandlerOptions): Promise<CreateChannelBanCommandOutput>;
    createChannelBan(args: CreateChannelBanCommandInput, cb: (err: any, data?: CreateChannelBanCommandOutput) => void): void;
    createChannelBan(args: CreateChannelBanCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateChannelBanCommandOutput) => void): void;
    /**
     * <p>Creates a channel flow, a container for processors. Processors are AWS Lambda functions
     *          that perform actions on chat messages, such as stripping out profanity. You can associate
     *          channel flows with channels, and the processors in the channel flow then take action on all
     *          messages sent to that channel. This is a developer API.</p>
     *
     *            <p>Channel flows process the following items:</p>
     *          <ol>
     *             <li>
     *                <p>New and updated messages</p>
     *             </li>
     *             <li>
     *                <p>Persistent and non-persistent messages</p>
     *             </li>
     *             <li>
     *                <p>The Standard message type</p>
     *             </li>
     *          </ol>
     *
     *          <note>
     *             <p>Channel flows don't process Control or System messages. For more information about the message types provided by Chime SDK Messaging, refer to
     *            <a href="https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types">Message types</a> in the <i>Amazon Chime developer guide</i>.</p>
     *          </note>
     */
    createChannelFlow(args: CreateChannelFlowCommandInput, options?: __HttpHandlerOptions): Promise<CreateChannelFlowCommandOutput>;
    createChannelFlow(args: CreateChannelFlowCommandInput, cb: (err: any, data?: CreateChannelFlowCommandOutput) => void): void;
    createChannelFlow(args: CreateChannelFlowCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateChannelFlowCommandOutput) => void): void;
    /**
     * <p>Adds a user to a channel. The <code>InvitedBy</code> field in <code>ChannelMembership</code> is derived from the
     *          request header. A channel member can:</p>
     *
     *          <ul>
     *             <li>
     *                <p>List messages</p>
     *             </li>
     *             <li>
     *                <p>Send messages</p>
     *             </li>
     *             <li>
     *                <p>Receive messages</p>
     *             </li>
     *             <li>
     *                <p>Edit their own messages</p>
     *             </li>
     *             <li>
     *                <p>Leave the channel</p>
     *             </li>
     *          </ul>
     *
     *          <p>Privacy settings impact this action as follows:</p>
     *
     *          <ul>
     *             <li>
     *                <p>Public Channels: You do not need to be a member to list messages, but you must be
     *                a member to send messages.</p>
     *             </li>
     *             <li>
     *                <p>Private Channels: You must be a member to list or send messages.</p>
     *             </li>
     *          </ul>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    createChannelMembership(args: CreateChannelMembershipCommandInput, options?: __HttpHandlerOptions): Promise<CreateChannelMembershipCommandOutput>;
    createChannelMembership(args: CreateChannelMembershipCommandInput, cb: (err: any, data?: CreateChannelMembershipCommandOutput) => void): void;
    createChannelMembership(args: CreateChannelMembershipCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateChannelMembershipCommandOutput) => void): void;
    /**
     * <p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p>
     *
     *          <ul>
     *             <li>
     *                <p>Add and remove other members of the channel.</p>
     *             </li>
     *             <li>
     *                <p>Add and remove other moderators of the channel.</p>
     *             </li>
     *             <li>
     *                <p>Add and remove user bans for the channel.</p>
     *             </li>
     *             <li>
     *                <p>Redact messages in the channel.</p>
     *             </li>
     *             <li>
     *                <p>List messages in the channel.</p>
     *             </li>
     *          </ul>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    createChannelModerator(args: CreateChannelModeratorCommandInput, options?: __HttpHandlerOptions): Promise<CreateChannelModeratorCommandOutput>;
    createChannelModerator(args: CreateChannelModeratorCommandInput, cb: (err: any, data?: CreateChannelModeratorCommandOutput) => void): void;
    createChannelModerator(args: CreateChannelModeratorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateChannelModeratorCommandOutput) => void): void;
    /**
     * <p>Immediately makes a channel and its memberships inaccessible and marks them for
     *          deletion. This is an irreversible process.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    deleteChannel(args: DeleteChannelCommandInput, options?: __HttpHandlerOptions): Promise<DeleteChannelCommandOutput>;
    deleteChannel(args: DeleteChannelCommandInput, cb: (err: any, data?: DeleteChannelCommandOutput) => void): void;
    deleteChannel(args: DeleteChannelCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteChannelCommandOutput) => void): void;
    /**
     * <p>Removes a user from a channel's ban list.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    deleteChannelBan(args: DeleteChannelBanCommandInput, options?: __HttpHandlerOptions): Promise<DeleteChannelBanCommandOutput>;
    deleteChannelBan(args: DeleteChannelBanCommandInput, cb: (err: any, data?: DeleteChannelBanCommandOutput) => void): void;
    deleteChannelBan(args: DeleteChannelBanCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteChannelBanCommandOutput) => void): void;
    /**
     * <p>Deletes a channel flow, an irreversible process. This is a developer API.</p>
     *          <note>
     *             <p> This API works only when the channel flow is not associated with any channel. To get a list of all channels that a channel flow is associated with, use the
     *            <code>ListChannelsAssociatedWithChannelFlow</code> API. Use the <code>DisassociateChannelFlow</code> API to disassociate a channel flow from all channels. </p>
     *          </note>
     */
    deleteChannelFlow(args: DeleteChannelFlowCommandInput, options?: __HttpHandlerOptions): Promise<DeleteChannelFlowCommandOutput>;
    deleteChannelFlow(args: DeleteChannelFlowCommandInput, cb: (err: any, data?: DeleteChannelFlowCommandOutput) => void): void;
    deleteChannelFlow(args: DeleteChannelFlowCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteChannelFlowCommandOutput) => void): void;
    /**
     * <p>Removes a member from a channel.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    deleteChannelMembership(args: DeleteChannelMembershipCommandInput, options?: __HttpHandlerOptions): Promise<DeleteChannelMembershipCommandOutput>;
    deleteChannelMembership(args: DeleteChannelMembershipCommandInput, cb: (err: any, data?: DeleteChannelMembershipCommandOutput) => void): void;
    deleteChannelMembership(args: DeleteChannelMembershipCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteChannelMembershipCommandOutput) => void): void;
    /**
     * <p>Deletes a channel message. Only admins can perform this action. Deletion makes messages
     *          inaccessible immediately. A background process deletes any revisions created by
     *             <code>UpdateChannelMessage</code>.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    deleteChannelMessage(args: DeleteChannelMessageCommandInput, options?: __HttpHandlerOptions): Promise<DeleteChannelMessageCommandOutput>;
    deleteChannelMessage(args: DeleteChannelMessageCommandInput, cb: (err: any, data?: DeleteChannelMessageCommandOutput) => void): void;
    deleteChannelMessage(args: DeleteChannelMessageCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteChannelMessageCommandOutput) => void): void;
    /**
     * <p>Deletes a channel moderator.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    deleteChannelModerator(args: DeleteChannelModeratorCommandInput, options?: __HttpHandlerOptions): Promise<DeleteChannelModeratorCommandOutput>;
    deleteChannelModerator(args: DeleteChannelModeratorCommandInput, cb: (err: any, data?: DeleteChannelModeratorCommandOutput) => void): void;
    deleteChannelModerator(args: DeleteChannelModeratorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteChannelModeratorCommandOutput) => void): void;
    /**
     * <p>Returns the full details of a channel in an Amazon Chime
     *          <code>AppInstance</code>.</p>
     *
     *          <note>
     *
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    describeChannel(args: DescribeChannelCommandInput, options?: __HttpHandlerOptions): Promise<DescribeChannelCommandOutput>;
    describeChannel(args: DescribeChannelCommandInput, cb: (err: any, data?: DescribeChannelCommandOutput) => void): void;
    describeChannel(args: DescribeChannelCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeChannelCommandOutput) => void): void;
    /**
     * <p>Returns the full details of a channel ban.</p>
     *
     *          <note>
     *
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    describeChannelBan(args: DescribeChannelBanCommandInput, options?: __HttpHandlerOptions): Promise<DescribeChannelBanCommandOutput>;
    describeChannelBan(args: DescribeChannelBanCommandInput, cb: (err: any, data?: DescribeChannelBanCommandOutput) => void): void;
    describeChannelBan(args: DescribeChannelBanCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeChannelBanCommandOutput) => void): void;
    /**
     * <p>Returns the full details of a channel flow in an Amazon Chime <code>AppInstance</code>. This is a developer API.</p>
     */
    describeChannelFlow(args: DescribeChannelFlowCommandInput, options?: __HttpHandlerOptions): Promise<DescribeChannelFlowCommandOutput>;
    describeChannelFlow(args: DescribeChannelFlowCommandInput, cb: (err: any, data?: DescribeChannelFlowCommandOutput) => void): void;
    describeChannelFlow(args: DescribeChannelFlowCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeChannelFlowCommandOutput) => void): void;
    /**
     * <p>Returns the full details of a user's channel membership.</p>
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    describeChannelMembership(args: DescribeChannelMembershipCommandInput, options?: __HttpHandlerOptions): Promise<DescribeChannelMembershipCommandOutput>;
    describeChannelMembership(args: DescribeChannelMembershipCommandInput, cb: (err: any, data?: DescribeChannelMembershipCommandOutput) => void): void;
    describeChannelMembership(args: DescribeChannelMembershipCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeChannelMembershipCommandOutput) => void): void;
    /**
     * <p> Returns the details of a channel based on the membership of the specified
     *             <code>AppInstanceUser</code>.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    describeChannelMembershipForAppInstanceUser(args: DescribeChannelMembershipForAppInstanceUserCommandInput, options?: __HttpHandlerOptions): Promise<DescribeChannelMembershipForAppInstanceUserCommandOutput>;
    describeChannelMembershipForAppInstanceUser(args: DescribeChannelMembershipForAppInstanceUserCommandInput, cb: (err: any, data?: DescribeChannelMembershipForAppInstanceUserCommandOutput) => void): void;
    describeChannelMembershipForAppInstanceUser(args: DescribeChannelMembershipForAppInstanceUserCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeChannelMembershipForAppInstanceUserCommandOutput) => void): void;
    /**
     * <p>Returns the full details of a channel moderated by the specified
     *             <code>AppInstanceUser</code>.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    describeChannelModeratedByAppInstanceUser(args: DescribeChannelModeratedByAppInstanceUserCommandInput, options?: __HttpHandlerOptions): Promise<DescribeChannelModeratedByAppInstanceUserCommandOutput>;
    describeChannelModeratedByAppInstanceUser(args: DescribeChannelModeratedByAppInstanceUserCommandInput, cb: (err: any, data?: DescribeChannelModeratedByAppInstanceUserCommandOutput) => void): void;
    describeChannelModeratedByAppInstanceUser(args: DescribeChannelModeratedByAppInstanceUserCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeChannelModeratedByAppInstanceUserCommandOutput) => void): void;
    /**
     * <p>Returns the full details of a single ChannelModerator.</p>
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    describeChannelModerator(args: DescribeChannelModeratorCommandInput, options?: __HttpHandlerOptions): Promise<DescribeChannelModeratorCommandOutput>;
    describeChannelModerator(args: DescribeChannelModeratorCommandInput, cb: (err: any, data?: DescribeChannelModeratorCommandOutput) => void): void;
    describeChannelModerator(args: DescribeChannelModeratorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeChannelModeratorCommandOutput) => void): void;
    /**
     * <p>Disassociates a channel flow from all its channels. Once disassociated, all messages to
     *          that channel stop going through the channel flow processor.</p>
     *          <note>
     *             <p>Only administrators or channel moderators can disassociate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code>
     *            of the user that makes the API call as the value in the header.</p>
     *          </note>
     */
    disassociateChannelFlow(args: DisassociateChannelFlowCommandInput, options?: __HttpHandlerOptions): Promise<DisassociateChannelFlowCommandOutput>;
    disassociateChannelFlow(args: DisassociateChannelFlowCommandInput, cb: (err: any, data?: DisassociateChannelFlowCommandOutput) => void): void;
    disassociateChannelFlow(args: DisassociateChannelFlowCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DisassociateChannelFlowCommandOutput) => void): void;
    /**
     * <p>Gets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel.
     *          Only the <code>AppInstanceUser</code> who owns the membership can retrieve preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can't retrieve preferences for other users.
     *          Banned users can't retrieve membership preferences for the channel from which they are banned.</p>
     */
    getChannelMembershipPreferences(args: GetChannelMembershipPreferencesCommandInput, options?: __HttpHandlerOptions): Promise<GetChannelMembershipPreferencesCommandOutput>;
    getChannelMembershipPreferences(args: GetChannelMembershipPreferencesCommandInput, cb: (err: any, data?: GetChannelMembershipPreferencesCommandOutput) => void): void;
    getChannelMembershipPreferences(args: GetChannelMembershipPreferencesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetChannelMembershipPreferencesCommandOutput) => void): void;
    /**
     * <p>Gets the full details of a channel message.</p>
     *
     *          <note>
     *             <p>The x-amz-chime-bearer request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    getChannelMessage(args: GetChannelMessageCommandInput, options?: __HttpHandlerOptions): Promise<GetChannelMessageCommandOutput>;
    getChannelMessage(args: GetChannelMessageCommandInput, cb: (err: any, data?: GetChannelMessageCommandOutput) => void): void;
    getChannelMessage(args: GetChannelMessageCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetChannelMessageCommandOutput) => void): void;
    /**
     * <p>Gets message status for a specified <code>messageId</code>. Use this API to determine the intermediate status of messages going through channel flow processing. The API provides an alternative to
     *          retrieving message status if the event was not received because a client wasn't connected to a websocket. </p>
     *
     *          <p>Messages can have any one of these statuses.</p>
     *
     *          <dl>
     *             <dt>SENT</dt>
     *             <dd>
     *                <p>Message processed successfully</p>
     *             </dd>
     *             <dt>PENDING</dt>
     *             <dd>
     *                <p>Ongoing processing</p>
     *             </dd>
     *             <dt>FAILED</dt>
     *             <dd>
     *                <p>Processing failed</p>
     *             </dd>
     *             <dt>DENIED</dt>
     *             <dd>
     *                <p>Messasge denied by the processor</p>
     *             </dd>
     *          </dl>
     *
     *          <note>
     *             <ul>
     *                <li>
     *                   <p>This API does not return statuses for denied messages, because we don't store them once the processor denies them. </p>
     *                </li>
     *                <li>
     *                   <p>Only the message sender can invoke this API.</p>
     *                </li>
     *                <li>
     *                   <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header</p>
     *                </li>
     *             </ul>
     *          </note>
     */
    getChannelMessageStatus(args: GetChannelMessageStatusCommandInput, options?: __HttpHandlerOptions): Promise<GetChannelMessageStatusCommandOutput>;
    getChannelMessageStatus(args: GetChannelMessageStatusCommandInput, cb: (err: any, data?: GetChannelMessageStatusCommandOutput) => void): void;
    getChannelMessageStatus(args: GetChannelMessageStatusCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetChannelMessageStatusCommandOutput) => void): void;
    /**
     * <p>The details of the endpoint for the messaging session.</p>
     */
    getMessagingSessionEndpoint(args: GetMessagingSessionEndpointCommandInput, options?: __HttpHandlerOptions): Promise<GetMessagingSessionEndpointCommandOutput>;
    getMessagingSessionEndpoint(args: GetMessagingSessionEndpointCommandInput, cb: (err: any, data?: GetMessagingSessionEndpointCommandOutput) => void): void;
    getMessagingSessionEndpoint(args: GetMessagingSessionEndpointCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetMessagingSessionEndpointCommandOutput) => void): void;
    /**
     * <p>Lists all the users banned from a particular channel.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    listChannelBans(args: ListChannelBansCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelBansCommandOutput>;
    listChannelBans(args: ListChannelBansCommandInput, cb: (err: any, data?: ListChannelBansCommandOutput) => void): void;
    listChannelBans(args: ListChannelBansCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelBansCommandOutput) => void): void;
    /**
     * <p>Returns a paginated lists of all the channel flows created under a single Chime. This is a developer API.</p>
     */
    listChannelFlows(args: ListChannelFlowsCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelFlowsCommandOutput>;
    listChannelFlows(args: ListChannelFlowsCommandInput, cb: (err: any, data?: ListChannelFlowsCommandOutput) => void): void;
    listChannelFlows(args: ListChannelFlowsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelFlowsCommandOutput) => void): void;
    /**
     * <p>Lists all channel memberships in a channel.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     *
     *          <p>If you want to list the channels to which a specific app instance user belongs, see the
     *          <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html">ListChannelMembershipsForAppInstanceUser</a> API.</p>
     */
    listChannelMemberships(args: ListChannelMembershipsCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelMembershipsCommandOutput>;
    listChannelMemberships(args: ListChannelMembershipsCommandInput, cb: (err: any, data?: ListChannelMembershipsCommandOutput) => void): void;
    listChannelMemberships(args: ListChannelMembershipsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelMembershipsCommandOutput) => void): void;
    /**
     * <p> Lists all channels that a particular <code>AppInstanceUser</code> is a part of. Only an
     *             <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    listChannelMembershipsForAppInstanceUser(args: ListChannelMembershipsForAppInstanceUserCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelMembershipsForAppInstanceUserCommandOutput>;
    listChannelMembershipsForAppInstanceUser(args: ListChannelMembershipsForAppInstanceUserCommandInput, cb: (err: any, data?: ListChannelMembershipsForAppInstanceUserCommandOutput) => void): void;
    listChannelMembershipsForAppInstanceUser(args: ListChannelMembershipsForAppInstanceUserCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelMembershipsForAppInstanceUserCommandOutput) => void): void;
    /**
     * <p>List all the messages in a channel. Returns a paginated list of
     *             <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending
     *          order.</p>
     *          <note>
     *             <p>Redacted messages appear in the results as empty, since they are only redacted, not
     *             deleted. Deleted messages do not appear in the results. This action always returns the
     *             latest version of an edited message.</p>
     *             <p>Also, the x-amz-chime-bearer request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    listChannelMessages(args: ListChannelMessagesCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelMessagesCommandOutput>;
    listChannelMessages(args: ListChannelMessagesCommandInput, cb: (err: any, data?: ListChannelMessagesCommandOutput) => void): void;
    listChannelMessages(args: ListChannelMessagesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelMessagesCommandOutput) => void): void;
    /**
     * <p>Lists all the moderators for a channel.</p>
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    listChannelModerators(args: ListChannelModeratorsCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelModeratorsCommandOutput>;
    listChannelModerators(args: ListChannelModeratorsCommandInput, cb: (err: any, data?: ListChannelModeratorsCommandOutput) => void): void;
    listChannelModerators(args: ListChannelModeratorsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelModeratorsCommandOutput) => void): void;
    /**
     * <p>Lists all Channels created under a single Chime App as a paginated list. You can specify
     *          filters to narrow results.</p>
     *
     *          <p class="title">
     *             <b>Functionality & restrictions</b>
     *          </p>
     *          <ul>
     *             <li>
     *                <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the
     *                account.</p>
     *             </li>
     *             <li>
     *                <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to
     *                list the private channels in an account.</p>
     *             </li>
     *          </ul>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    listChannels(args: ListChannelsCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelsCommandOutput>;
    listChannels(args: ListChannelsCommandInput, cb: (err: any, data?: ListChannelsCommandOutput) => void): void;
    listChannels(args: ListChannelsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelsCommandOutput) => void): void;
    /**
     * <p>Lists all channels associated with a specified channel flow. You can associate a channel flow with multiple channels, but you can only associate a channel with one channel flow. This is a developer API.</p>
     */
    listChannelsAssociatedWithChannelFlow(args: ListChannelsAssociatedWithChannelFlowCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelsAssociatedWithChannelFlowCommandOutput>;
    listChannelsAssociatedWithChannelFlow(args: ListChannelsAssociatedWithChannelFlowCommandInput, cb: (err: any, data?: ListChannelsAssociatedWithChannelFlowCommandOutput) => void): void;
    listChannelsAssociatedWithChannelFlow(args: ListChannelsAssociatedWithChannelFlowCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelsAssociatedWithChannelFlowCommandOutput) => void): void;
    /**
     * <p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    listChannelsModeratedByAppInstanceUser(args: ListChannelsModeratedByAppInstanceUserCommandInput, options?: __HttpHandlerOptions): Promise<ListChannelsModeratedByAppInstanceUserCommandOutput>;
    listChannelsModeratedByAppInstanceUser(args: ListChannelsModeratedByAppInstanceUserCommandInput, cb: (err: any, data?: ListChannelsModeratedByAppInstanceUserCommandOutput) => void): void;
    listChannelsModeratedByAppInstanceUser(args: ListChannelsModeratedByAppInstanceUserCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListChannelsModeratedByAppInstanceUserCommandOutput) => void): void;
    /**
     * <p>Lists all the SubChannels in an elastic channel when given a channel ID. Available only to the app instance admins and channel moderators of elastic channels.</p>
     */
    listSubChannels(args: ListSubChannelsCommandInput, options?: __HttpHandlerOptions): Promise<ListSubChannelsCommandOutput>;
    listSubChannels(args: ListSubChannelsCommandInput, cb: (err: any, data?: ListSubChannelsCommandOutput) => void): void;
    listSubChannels(args: ListSubChannelsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListSubChannelsCommandOutput) => void): void;
    /**
     * <p>Lists the tags applied to an Amazon Chime SDK messaging resource.</p>
     */
    listTagsForResource(args: ListTagsForResourceCommandInput, options?: __HttpHandlerOptions): Promise<ListTagsForResourceCommandOutput>;
    listTagsForResource(args: ListTagsForResourceCommandInput, cb: (err: any, data?: ListTagsForResourceCommandOutput) => void): void;
    listTagsForResource(args: ListTagsForResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListTagsForResourceCommandOutput) => void): void;
    /**
     * <p>Sets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel.
     *          Only the <code>AppInstanceUser</code> who owns the membership can set preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can't set preferences for other users.
     *          Banned users can't set membership preferences for the channel from which they are banned.</p>
     */
    putChannelMembershipPreferences(args: PutChannelMembershipPreferencesCommandInput, options?: __HttpHandlerOptions): Promise<PutChannelMembershipPreferencesCommandOutput>;
    putChannelMembershipPreferences(args: PutChannelMembershipPreferencesCommandInput, cb: (err: any, data?: PutChannelMembershipPreferencesCommandOutput) => void): void;
    putChannelMembershipPreferences(args: PutChannelMembershipPreferencesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutChannelMembershipPreferencesCommandOutput) => void): void;
    /**
     * <p>Redacts message content, but not metadata. The message exists in the back end, but the
     *          action returns null content, and the state shows as redacted.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    redactChannelMessage(args: RedactChannelMessageCommandInput, options?: __HttpHandlerOptions): Promise<RedactChannelMessageCommandOutput>;
    redactChannelMessage(args: RedactChannelMessageCommandInput, cb: (err: any, data?: RedactChannelMessageCommandOutput) => void): void;
    redactChannelMessage(args: RedactChannelMessageCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RedactChannelMessageCommandOutput) => void): void;
    /**
     * <p>Allows <code>ChimeBearer</code> to search channels by channel members. AppInstanceUsers can search across the channels that they belong to. AppInstanceAdmins can search across all channels.</p>
     */
    searchChannels(args: SearchChannelsCommandInput, options?: __HttpHandlerOptions): Promise<SearchChannelsCommandOutput>;
    searchChannels(args: SearchChannelsCommandInput, cb: (err: any, data?: SearchChannelsCommandOutput) => void): void;
    searchChannels(args: SearchChannelsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: SearchChannelsCommandOutput) => void): void;
    /**
     * <p>Sends a message to a particular channel that the member is a part of.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *
     *             <p>Also, <code>STANDARD</code> messages can contain 4KB of data and the 1KB of metadata.
     *                <code>CONTROL</code> messages can contain 30 bytes of data and no metadata.</p>
     *          </note>
     */
    sendChannelMessage(args: SendChannelMessageCommandInput, options?: __HttpHandlerOptions): Promise<SendChannelMessageCommandOutput>;
    sendChannelMessage(args: SendChannelMessageCommandInput, cb: (err: any, data?: SendChannelMessageCommandOutput) => void): void;
    sendChannelMessage(args: SendChannelMessageCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: SendChannelMessageCommandOutput) => void): void;
    /**
     * <p>Applies the specified tags to the specified Amazon Chime SDK messaging resource.</p>
     */
    tagResource(args: TagResourceCommandInput, options?: __HttpHandlerOptions): Promise<TagResourceCommandOutput>;
    tagResource(args: TagResourceCommandInput, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    tagResource(args: TagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    /**
     * <p>Removes the specified tags from the specified Amazon Chime SDK messaging resource.</p>
     */
    untagResource(args: UntagResourceCommandInput, options?: __HttpHandlerOptions): Promise<UntagResourceCommandOutput>;
    untagResource(args: UntagResourceCommandInput, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    untagResource(args: UntagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    /**
     * <p>Update a channel's attributes.</p>
     *          <p>
     *             <b>Restriction</b>: You can't change a channel's privacy. </p>
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    updateChannel(args: UpdateChannelCommandInput, options?: __HttpHandlerOptions): Promise<UpdateChannelCommandOutput>;
    updateChannel(args: UpdateChannelCommandInput, cb: (err: any, data?: UpdateChannelCommandOutput) => void): void;
    updateChannel(args: UpdateChannelCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateChannelCommandOutput) => void): void;
    /**
     * <p>Updates channel flow attributes. This is a developer API.</p>
     */
    updateChannelFlow(args: UpdateChannelFlowCommandInput, options?: __HttpHandlerOptions): Promise<UpdateChannelFlowCommandOutput>;
    updateChannelFlow(args: UpdateChannelFlowCommandInput, cb: (err: any, data?: UpdateChannelFlowCommandOutput) => void): void;
    updateChannelFlow(args: UpdateChannelFlowCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateChannelFlowCommandOutput) => void): void;
    /**
     * <p>Updates the content of a message.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    updateChannelMessage(args: UpdateChannelMessageCommandInput, options?: __HttpHandlerOptions): Promise<UpdateChannelMessageCommandOutput>;
    updateChannelMessage(args: UpdateChannelMessageCommandInput, cb: (err: any, data?: UpdateChannelMessageCommandOutput) => void): void;
    updateChannelMessage(args: UpdateChannelMessageCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateChannelMessageCommandOutput) => void): void;
    /**
     * <p>The details of the time when a user last read messages in a channel.</p>
     *
     *          <note>
     *             <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the
     *                <code>AppInstanceUserArn</code> of the user that makes the API call as the value in
     *             the header.</p>
     *          </note>
     */
    updateChannelReadMarker(args: UpdateChannelReadMarkerCommandInput, options?: __HttpHandlerOptions): Promise<UpdateChannelReadMarkerCommandOutput>;
    updateChannelReadMarker(args: UpdateChannelReadMarkerCommandInput, cb: (err: any, data?: UpdateChannelReadMarkerCommandOutput) => void): void;
    updateChannelReadMarker(args: UpdateChannelReadMarkerCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateChannelReadMarkerCommandOutput) => void): void;
}
