import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMessagingClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMessagingClient";
import { ChannelFlowCallbackRequest, ChannelFlowCallbackResponse } from "../models/models_0";
/**
 * The input for {@link ChannelFlowCallbackCommand}.
 */
export interface ChannelFlowCallbackCommandInput extends ChannelFlowCallbackRequest {
}
/**
 * The output of {@link ChannelFlowCallbackCommand}.
 */
export interface ChannelFlowCallbackCommandOutput extends ChannelFlowCallbackResponse, __MetadataBearer {
}
/**
 * <p>Calls back Chime SDK Messaging with a processing response message. This should be invoked from the processor Lambda. This is a developer API.</p>
 *          <p>You can return one of the following processing responses:</p>
 *          <ul>
 *             <li>
 *                <p>Update message content or metadata</p>
 *             </li>
 *             <li>
 *                <p>Deny a message</p>
 *             </li>
 *             <li>
 *                <p>Make no changes to the message</p>
 *             </li>
 *          </ul>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMessagingClient, ChannelFlowCallbackCommand } from "@aws-sdk/client-chime-sdk-messaging"; // ES Modules import
 * // const { ChimeSDKMessagingClient, ChannelFlowCallbackCommand } = require("@aws-sdk/client-chime-sdk-messaging"); // CommonJS import
 * const client = new ChimeSDKMessagingClient(config);
 * const command = new ChannelFlowCallbackCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ChannelFlowCallbackCommandInput} for command's `input` shape.
 * @see {@link ChannelFlowCallbackCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMessagingClientResolvedConfig | config} for ChimeSDKMessagingClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class ChannelFlowCallbackCommand extends $Command<ChannelFlowCallbackCommandInput, ChannelFlowCallbackCommandOutput, ChimeSDKMessagingClientResolvedConfig> {
    readonly input: ChannelFlowCallbackCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ChannelFlowCallbackCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMessagingClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ChannelFlowCallbackCommandInput, ChannelFlowCallbackCommandOutput>;
    private serialize;
    private deserialize;
}
