import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMessagingClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMessagingClient";
import { CreateChannelFlowRequest, CreateChannelFlowResponse } from "../models/models_0";
/**
 * The input for {@link CreateChannelFlowCommand}.
 */
export interface CreateChannelFlowCommandInput extends CreateChannelFlowRequest {
}
/**
 * The output of {@link CreateChannelFlowCommand}.
 */
export interface CreateChannelFlowCommandOutput extends CreateChannelFlowResponse, __MetadataBearer {
}
/**
 * <p>Creates a channel flow, a container for processors. Processors are AWS Lambda functions
 *          that perform actions on chat messages, such as stripping out profanity. You can associate
 *          channel flows with channels, and the processors in the channel flow then take action on all
 *          messages sent to that channel. This is a developer API.</p>
 *
 *            <p>Channel flows process the following items:</p>
 *          <ol>
 *             <li>
 *                <p>New and updated messages</p>
 *             </li>
 *             <li>
 *                <p>Persistent and non-persistent messages</p>
 *             </li>
 *             <li>
 *                <p>The Standard message type</p>
 *             </li>
 *          </ol>
 *
 *          <note>
 *             <p>Channel flows don't process Control or System messages. For more information about the message types provided by Chime SDK Messaging, refer to
 *            <a href="https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types">Message types</a> in the <i>Amazon Chime developer guide</i>.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMessagingClient, CreateChannelFlowCommand } from "@aws-sdk/client-chime-sdk-messaging"; // ES Modules import
 * // const { ChimeSDKMessagingClient, CreateChannelFlowCommand } = require("@aws-sdk/client-chime-sdk-messaging"); // CommonJS import
 * const client = new ChimeSDKMessagingClient(config);
 * const command = new CreateChannelFlowCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateChannelFlowCommandInput} for command's `input` shape.
 * @see {@link CreateChannelFlowCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMessagingClientResolvedConfig | config} for ChimeSDKMessagingClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ResourceLimitExceededException} (client fault)
 *  <p>The request exceeds the resource limit.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class CreateChannelFlowCommand extends $Command<CreateChannelFlowCommandInput, CreateChannelFlowCommandOutput, ChimeSDKMessagingClientResolvedConfig> {
    readonly input: CreateChannelFlowCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateChannelFlowCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMessagingClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateChannelFlowCommandInput, CreateChannelFlowCommandOutput>;
    private serialize;
    private deserialize;
}
