import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMessagingClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMessagingClient";
import { PutChannelMembershipPreferencesRequest, PutChannelMembershipPreferencesResponse } from "../models/models_0";
/**
 * The input for {@link PutChannelMembershipPreferencesCommand}.
 */
export interface PutChannelMembershipPreferencesCommandInput extends PutChannelMembershipPreferencesRequest {
}
/**
 * The output of {@link PutChannelMembershipPreferencesCommand}.
 */
export interface PutChannelMembershipPreferencesCommandOutput extends PutChannelMembershipPreferencesResponse, __MetadataBearer {
}
/**
 * <p>Sets the membership preferences of an <code>AppInstanceUser</code> for the specified channel. The <code>AppInstanceUser</code> must be a member of the channel.
 *          Only the <code>AppInstanceUser</code> who owns the membership can set preferences. Users in the <code>AppInstanceAdmin</code> and channel moderator roles can't set preferences for other users.
 *          Banned users can't set membership preferences for the channel from which they are banned.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMessagingClient, PutChannelMembershipPreferencesCommand } from "@aws-sdk/client-chime-sdk-messaging"; // ES Modules import
 * // const { ChimeSDKMessagingClient, PutChannelMembershipPreferencesCommand } = require("@aws-sdk/client-chime-sdk-messaging"); // CommonJS import
 * const client = new ChimeSDKMessagingClient(config);
 * const command = new PutChannelMembershipPreferencesCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link PutChannelMembershipPreferencesCommandInput} for command's `input` shape.
 * @see {@link PutChannelMembershipPreferencesCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMessagingClientResolvedConfig | config} for ChimeSDKMessagingClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class PutChannelMembershipPreferencesCommand extends $Command<PutChannelMembershipPreferencesCommandInput, PutChannelMembershipPreferencesCommandOutput, ChimeSDKMessagingClientResolvedConfig> {
    readonly input: PutChannelMembershipPreferencesCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: PutChannelMembershipPreferencesCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMessagingClientResolvedConfig, options?: __HttpHandlerOptions): Handler<PutChannelMembershipPreferencesCommandInput, PutChannelMembershipPreferencesCommandOutput>;
    private serialize;
    private deserialize;
}
