import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { ChimeSDKMessagingServiceException as __BaseException } from "./ChimeSDKMessagingServiceException";
export declare enum AllowNotifications {
  ALL = "ALL",
  FILTERED = "FILTERED",
  NONE = "NONE",
}
export declare enum ChannelMembershipType {
  DEFAULT = "DEFAULT",
  HIDDEN = "HIDDEN",
}
export interface AppInstanceUserMembershipSummary {
  Type?: ChannelMembershipType | string;
  ReadMarkerTimestamp?: Date;
  SubChannelId?: string;
}
export interface AssociateChannelFlowRequest {
  ChannelArn: string | undefined;
  ChannelFlowArn: string | undefined;
  ChimeBearer: string | undefined;
}
export declare enum ErrorCode {
  AccessDenied = "AccessDenied",
  BadRequest = "BadRequest",
  Conflict = "Conflict",
  Forbidden = "Forbidden",
  NotFound = "NotFound",
  PhoneNumberAssociationsExist = "PhoneNumberAssociationsExist",
  PreconditionFailed = "PreconditionFailed",
  ResourceLimitExceeded = "ResourceLimitExceeded",
  ServiceFailure = "ServiceFailure",
  ServiceUnavailable = "ServiceUnavailable",
  Throttled = "Throttled",
  Throttling = "Throttling",
  Unauthorized = "Unauthorized",
  Unprocessable = "Unprocessable",
  VoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist",
}
export declare class BadRequestException extends __BaseException {
  readonly name: "BadRequestException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<BadRequestException, __BaseException>
  );
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export declare class ForbiddenException extends __BaseException {
  readonly name: "ForbiddenException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export declare class ServiceFailureException extends __BaseException {
  readonly name: "ServiceFailureException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceFailureException, __BaseException>
  );
}
export declare class ServiceUnavailableException extends __BaseException {
  readonly name: "ServiceUnavailableException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>
  );
}
export declare class ThrottledClientException extends __BaseException {
  readonly name: "ThrottledClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ThrottledClientException, __BaseException>
  );
}
export declare class UnauthorizedClientException extends __BaseException {
  readonly name: "UnauthorizedClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>
  );
}
export interface Identity {
  Arn?: string;
  Name?: string;
}
export interface BatchChannelMemberships {
  InvitedBy?: Identity;
  Type?: ChannelMembershipType | string;
  Members?: Identity[];
  ChannelArn?: string;
  SubChannelId?: string;
}
export interface BatchCreateChannelMembershipRequest {
  ChannelArn: string | undefined;
  Type?: ChannelMembershipType | string;
  MemberArns: string[] | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface BatchCreateChannelMembershipError {
  MemberArn?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface BatchCreateChannelMembershipResponse {
  BatchChannelMemberships?: BatchChannelMemberships;
  Errors?: BatchCreateChannelMembershipError[];
}
export declare class ResourceLimitExceededException extends __BaseException {
  readonly name: "ResourceLimitExceededException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>
  );
}
export interface ElasticChannelConfiguration {
  MaximumSubChannels: number | undefined;
  TargetMembershipsPerSubChannel: number | undefined;
  MinimumMembershipPercentage: number | undefined;
}
export declare enum ChannelMode {
  RESTRICTED = "RESTRICTED",
  UNRESTRICTED = "UNRESTRICTED",
}
export declare enum ChannelPrivacy {
  PRIVATE = "PRIVATE",
  PUBLIC = "PUBLIC",
}
export interface Channel {
  Name?: string;
  ChannelArn?: string;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  CreatedBy?: Identity;
  CreatedTimestamp?: Date;
  LastMessageTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  ChannelFlowArn?: string;
  ElasticChannelConfiguration?: ElasticChannelConfiguration;
}
export interface ChannelAssociatedWithFlowSummary {
  Name?: string;
  ChannelArn?: string;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
}
export interface ChannelBan {
  Member?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  CreatedBy?: Identity;
}
export interface ChannelBanSummary {
  Member?: Identity;
}
export declare enum InvocationType {
  ASYNC = "ASYNC",
}
export interface LambdaConfiguration {
  ResourceArn: string | undefined;
  InvocationType: InvocationType | string | undefined;
}
export interface ProcessorConfiguration {
  Lambda: LambdaConfiguration | undefined;
}
export declare enum FallbackAction {
  ABORT = "ABORT",
  CONTINUE = "CONTINUE",
}
export interface Processor {
  Name: string | undefined;
  Configuration: ProcessorConfiguration | undefined;
  ExecutionOrder: number | undefined;
  FallbackAction: FallbackAction | string | undefined;
}
export interface ChannelFlow {
  ChannelFlowArn?: string;
  Processors?: Processor[];
  Name?: string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
}
export interface MessageAttributeValue {
  StringValues?: string[];
}
export declare enum PushNotificationType {
  DEFAULT = "DEFAULT",
  VOIP = "VOIP",
}
export interface PushNotificationConfiguration {
  Title?: string;
  Body?: string;
  Type?: PushNotificationType | string;
}
export interface ChannelMessageCallback {
  MessageId: string | undefined;
  Content?: string;
  Metadata?: string;
  PushNotification?: PushNotificationConfiguration;
  MessageAttributes?: Record<string, MessageAttributeValue>;
  SubChannelId?: string;
}
export interface ChannelFlowCallbackRequest {
  CallbackId?: string;
  ChannelArn: string | undefined;
  DeleteResource?: boolean;
  ChannelMessage: ChannelMessageCallback | undefined;
}
export interface ChannelFlowCallbackResponse {
  ChannelArn?: string;
  CallbackId?: string;
}
export interface ChannelFlowSummary {
  ChannelFlowArn?: string;
  Name?: string;
  Processors?: Processor[];
}
export interface ChannelMembership {
  InvitedBy?: Identity;
  Type?: ChannelMembershipType | string;
  Member?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  SubChannelId?: string;
}
export interface ChannelSummary {
  Name?: string;
  ChannelArn?: string;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  LastMessageTimestamp?: Date;
}
export interface ChannelMembershipForAppInstanceUserSummary {
  ChannelSummary?: ChannelSummary;
  AppInstanceUserMembershipSummary?: AppInstanceUserMembershipSummary;
}
export interface PushNotificationPreferences {
  AllowNotifications: AllowNotifications | string | undefined;
  FilterRule?: string;
}
export interface ChannelMembershipPreferences {
  PushNotifications?: PushNotificationPreferences;
}
export interface ChannelMembershipSummary {
  Member?: Identity;
}
export declare enum ChannelMessagePersistenceType {
  NON_PERSISTENT = "NON_PERSISTENT",
  PERSISTENT = "PERSISTENT",
}
export declare enum ChannelMessageStatus {
  DENIED = "DENIED",
  FAILED = "FAILED",
  PENDING = "PENDING",
  SENT = "SENT",
}
export interface ChannelMessageStatusStructure {
  Value?: ChannelMessageStatus | string;
  Detail?: string;
}
export declare enum ChannelMessageType {
  CONTROL = "CONTROL",
  STANDARD = "STANDARD",
}
export interface ChannelMessage {
  ChannelArn?: string;
  MessageId?: string;
  Content?: string;
  Metadata?: string;
  Type?: ChannelMessageType | string;
  CreatedTimestamp?: Date;
  LastEditedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  Sender?: Identity;
  Redacted?: boolean;
  Persistence?: ChannelMessagePersistenceType | string;
  Status?: ChannelMessageStatusStructure;
  MessageAttributes?: Record<string, MessageAttributeValue>;
  SubChannelId?: string;
}
export interface ChannelMessageSummary {
  MessageId?: string;
  Content?: string;
  Metadata?: string;
  Type?: ChannelMessageType | string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  LastEditedTimestamp?: Date;
  Sender?: Identity;
  Redacted?: boolean;
  Status?: ChannelMessageStatusStructure;
  MessageAttributes?: Record<string, MessageAttributeValue>;
}
export interface ChannelModeratedByAppInstanceUserSummary {
  ChannelSummary?: ChannelSummary;
}
export interface ChannelModerator {
  Moderator?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  CreatedBy?: Identity;
}
export interface ChannelModeratorSummary {
  Moderator?: Identity;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateChannelRequest {
  AppInstanceArn: string | undefined;
  Name: string | undefined;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
  ChimeBearer: string | undefined;
  ChannelId?: string;
  MemberArns?: string[];
  ModeratorArns?: string[];
  ElasticChannelConfiguration?: ElasticChannelConfiguration;
}
export interface CreateChannelResponse {
  ChannelArn?: string;
}
export interface CreateChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface CreateChannelBanResponse {
  ChannelArn?: string;
  Member?: Identity;
}
export interface CreateChannelFlowRequest {
  AppInstanceArn: string | undefined;
  Processors: Processor[] | undefined;
  Name: string | undefined;
  Tags?: Tag[];
  ClientRequestToken: string | undefined;
}
export interface CreateChannelFlowResponse {
  ChannelFlowArn?: string;
}
export interface CreateChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  Type: ChannelMembershipType | string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface CreateChannelMembershipResponse {
  ChannelArn?: string;
  Member?: Identity;
  SubChannelId?: string;
}
export interface CreateChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface CreateChannelModeratorResponse {
  ChannelArn?: string;
  ChannelModerator?: Identity;
}
export interface DeleteChannelRequest {
  ChannelArn: string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface DeleteChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface DeleteChannelFlowRequest {
  ChannelFlowArn: string | undefined;
}
export interface DeleteChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface DeleteChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface DeleteChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface DescribeChannelRequest {
  ChannelArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface DescribeChannelResponse {
  Channel?: Channel;
}
export interface DescribeChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface DescribeChannelBanResponse {
  ChannelBan?: ChannelBan;
}
export interface DescribeChannelFlowRequest {
  ChannelFlowArn: string | undefined;
}
export interface DescribeChannelFlowResponse {
  ChannelFlow?: ChannelFlow;
}
export interface DescribeChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface DescribeChannelMembershipResponse {
  ChannelMembership?: ChannelMembership;
}
export interface DescribeChannelMembershipForAppInstanceUserRequest {
  ChannelArn: string | undefined;
  AppInstanceUserArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface DescribeChannelMembershipForAppInstanceUserResponse {
  ChannelMembership?: ChannelMembershipForAppInstanceUserSummary;
}
export interface DescribeChannelModeratedByAppInstanceUserRequest {
  ChannelArn: string | undefined;
  AppInstanceUserArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface DescribeChannelModeratedByAppInstanceUserResponse {
  Channel?: ChannelModeratedByAppInstanceUserSummary;
}
export interface DescribeChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface DescribeChannelModeratorResponse {
  ChannelModerator?: ChannelModerator;
}
export interface DisassociateChannelFlowRequest {
  ChannelArn: string | undefined;
  ChannelFlowArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface GetChannelMembershipPreferencesRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer: string | undefined;
}
export interface GetChannelMembershipPreferencesResponse {
  ChannelArn?: string;
  Member?: Identity;
  Preferences?: ChannelMembershipPreferences;
}
export interface GetChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface GetChannelMessageResponse {
  ChannelMessage?: ChannelMessage;
}
export interface GetChannelMessageStatusRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface GetChannelMessageStatusResponse {
  Status?: ChannelMessageStatusStructure;
}
export interface GetMessagingSessionEndpointRequest {}
export interface MessagingSessionEndpoint {
  Url?: string;
}
export interface GetMessagingSessionEndpointResponse {
  Endpoint?: MessagingSessionEndpoint;
}
export interface ListChannelBansRequest {
  ChannelArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer: string | undefined;
}
export interface ListChannelBansResponse {
  ChannelArn?: string;
  NextToken?: string;
  ChannelBans?: ChannelBanSummary[];
}
export interface ListChannelFlowsRequest {
  AppInstanceArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListChannelFlowsResponse {
  ChannelFlows?: ChannelFlowSummary[];
  NextToken?: string;
}
export interface ListChannelMembershipsRequest {
  ChannelArn: string | undefined;
  Type?: ChannelMembershipType | string;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface ListChannelMembershipsResponse {
  ChannelArn?: string;
  ChannelMemberships?: ChannelMembershipSummary[];
  NextToken?: string;
}
export interface ListChannelMembershipsForAppInstanceUserRequest {
  AppInstanceUserArn?: string;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer: string | undefined;
}
export interface ListChannelMembershipsForAppInstanceUserResponse {
  ChannelMemberships?: ChannelMembershipForAppInstanceUserSummary[];
  NextToken?: string;
}
export declare enum SortOrder {
  ASCENDING = "ASCENDING",
  DESCENDING = "DESCENDING",
}
export interface ListChannelMessagesRequest {
  ChannelArn: string | undefined;
  SortOrder?: SortOrder | string;
  NotBefore?: Date;
  NotAfter?: Date;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface ListChannelMessagesResponse {
  ChannelArn?: string;
  NextToken?: string;
  ChannelMessages?: ChannelMessageSummary[];
  SubChannelId?: string;
}
export interface ListChannelModeratorsRequest {
  ChannelArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer: string | undefined;
}
export interface ListChannelModeratorsResponse {
  ChannelArn?: string;
  NextToken?: string;
  ChannelModerators?: ChannelModeratorSummary[];
}
export interface ListChannelsRequest {
  AppInstanceArn: string | undefined;
  Privacy?: ChannelPrivacy | string;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer: string | undefined;
}
export interface ListChannelsResponse {
  Channels?: ChannelSummary[];
  NextToken?: string;
}
export interface ListChannelsAssociatedWithChannelFlowRequest {
  ChannelFlowArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListChannelsAssociatedWithChannelFlowResponse {
  Channels?: ChannelAssociatedWithFlowSummary[];
  NextToken?: string;
}
export interface ListChannelsModeratedByAppInstanceUserRequest {
  AppInstanceUserArn?: string;
  MaxResults?: number;
  NextToken?: string;
  ChimeBearer: string | undefined;
}
export interface ListChannelsModeratedByAppInstanceUserResponse {
  Channels?: ChannelModeratedByAppInstanceUserSummary[];
  NextToken?: string;
}
export interface ListSubChannelsRequest {
  ChannelArn: string | undefined;
  ChimeBearer: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface SubChannelSummary {
  SubChannelId?: string;
  MembershipCount?: number;
}
export interface ListSubChannelsResponse {
  ChannelArn?: string;
  SubChannels?: SubChannelSummary[];
  NextToken?: string;
}
export interface ListTagsForResourceRequest {
  ResourceARN: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Tag[];
}
export interface PutChannelMembershipPreferencesRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer: string | undefined;
  Preferences: ChannelMembershipPreferences | undefined;
}
export interface PutChannelMembershipPreferencesResponse {
  ChannelArn?: string;
  Member?: Identity;
  Preferences?: ChannelMembershipPreferences;
}
export interface RedactChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface RedactChannelMessageResponse {
  ChannelArn?: string;
  MessageId?: string;
  SubChannelId?: string;
}
export declare enum SearchFieldKey {
  MEMBERS = "MEMBERS",
}
export declare enum SearchFieldOperator {
  EQUALS = "EQUALS",
  INCLUDES = "INCLUDES",
}
export interface SearchField {
  Key: SearchFieldKey | string | undefined;
  Values: string[] | undefined;
  Operator: SearchFieldOperator | string | undefined;
}
export interface SearchChannelsRequest {
  ChimeBearer?: string;
  Fields: SearchField[] | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface SearchChannelsResponse {
  Channels?: ChannelSummary[];
  NextToken?: string;
}
export interface SendChannelMessageRequest {
  ChannelArn: string | undefined;
  Content: string | undefined;
  Type: ChannelMessageType | string | undefined;
  Persistence: ChannelMessagePersistenceType | string | undefined;
  Metadata?: string;
  ClientRequestToken?: string;
  ChimeBearer: string | undefined;
  PushNotification?: PushNotificationConfiguration;
  MessageAttributes?: Record<string, MessageAttributeValue>;
  SubChannelId?: string;
}
export interface SendChannelMessageResponse {
  ChannelArn?: string;
  MessageId?: string;
  Status?: ChannelMessageStatusStructure;
  SubChannelId?: string;
}
export interface TagResourceRequest {
  ResourceARN: string | undefined;
  Tags: Tag[] | undefined;
}
export interface UntagResourceRequest {
  ResourceARN: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UpdateChannelRequest {
  ChannelArn: string | undefined;
  Name?: string;
  Mode?: ChannelMode | string;
  Metadata?: string;
  ChimeBearer: string | undefined;
}
export interface UpdateChannelResponse {
  ChannelArn?: string;
}
export interface UpdateChannelFlowRequest {
  ChannelFlowArn: string | undefined;
  Processors: Processor[] | undefined;
  Name: string | undefined;
}
export interface UpdateChannelFlowResponse {
  ChannelFlowArn?: string;
}
export interface UpdateChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  Content?: string;
  Metadata?: string;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface UpdateChannelMessageResponse {
  ChannelArn?: string;
  MessageId?: string;
  Status?: ChannelMessageStatusStructure;
  SubChannelId?: string;
}
export interface UpdateChannelReadMarkerRequest {
  ChannelArn: string | undefined;
  ChimeBearer: string | undefined;
  SubChannelId?: string;
}
export interface UpdateChannelReadMarkerResponse {
  ChannelArn?: string;
  SubChannelId?: string;
}
export declare const AppInstanceUserMembershipSummaryFilterSensitiveLog: (
  obj: AppInstanceUserMembershipSummary
) => any;
export declare const AssociateChannelFlowRequestFilterSensitiveLog: (
  obj: AssociateChannelFlowRequest
) => any;
export declare const IdentityFilterSensitiveLog: (obj: Identity) => any;
export declare const BatchChannelMembershipsFilterSensitiveLog: (
  obj: BatchChannelMemberships
) => any;
export declare const BatchCreateChannelMembershipRequestFilterSensitiveLog: (
  obj: BatchCreateChannelMembershipRequest
) => any;
export declare const BatchCreateChannelMembershipErrorFilterSensitiveLog: (
  obj: BatchCreateChannelMembershipError
) => any;
export declare const BatchCreateChannelMembershipResponseFilterSensitiveLog: (
  obj: BatchCreateChannelMembershipResponse
) => any;
export declare const ElasticChannelConfigurationFilterSensitiveLog: (
  obj: ElasticChannelConfiguration
) => any;
export declare const ChannelFilterSensitiveLog: (obj: Channel) => any;
export declare const ChannelAssociatedWithFlowSummaryFilterSensitiveLog: (
  obj: ChannelAssociatedWithFlowSummary
) => any;
export declare const ChannelBanFilterSensitiveLog: (obj: ChannelBan) => any;
export declare const ChannelBanSummaryFilterSensitiveLog: (
  obj: ChannelBanSummary
) => any;
export declare const LambdaConfigurationFilterSensitiveLog: (
  obj: LambdaConfiguration
) => any;
export declare const ProcessorConfigurationFilterSensitiveLog: (
  obj: ProcessorConfiguration
) => any;
export declare const ProcessorFilterSensitiveLog: (obj: Processor) => any;
export declare const ChannelFlowFilterSensitiveLog: (obj: ChannelFlow) => any;
export declare const MessageAttributeValueFilterSensitiveLog: (
  obj: MessageAttributeValue
) => any;
export declare const PushNotificationConfigurationFilterSensitiveLog: (
  obj: PushNotificationConfiguration
) => any;
export declare const ChannelMessageCallbackFilterSensitiveLog: (
  obj: ChannelMessageCallback
) => any;
export declare const ChannelFlowCallbackRequestFilterSensitiveLog: (
  obj: ChannelFlowCallbackRequest
) => any;
export declare const ChannelFlowCallbackResponseFilterSensitiveLog: (
  obj: ChannelFlowCallbackResponse
) => any;
export declare const ChannelFlowSummaryFilterSensitiveLog: (
  obj: ChannelFlowSummary
) => any;
export declare const ChannelMembershipFilterSensitiveLog: (
  obj: ChannelMembership
) => any;
export declare const ChannelSummaryFilterSensitiveLog: (
  obj: ChannelSummary
) => any;
export declare const ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog: (
  obj: ChannelMembershipForAppInstanceUserSummary
) => any;
export declare const PushNotificationPreferencesFilterSensitiveLog: (
  obj: PushNotificationPreferences
) => any;
export declare const ChannelMembershipPreferencesFilterSensitiveLog: (
  obj: ChannelMembershipPreferences
) => any;
export declare const ChannelMembershipSummaryFilterSensitiveLog: (
  obj: ChannelMembershipSummary
) => any;
export declare const ChannelMessageStatusStructureFilterSensitiveLog: (
  obj: ChannelMessageStatusStructure
) => any;
export declare const ChannelMessageFilterSensitiveLog: (
  obj: ChannelMessage
) => any;
export declare const ChannelMessageSummaryFilterSensitiveLog: (
  obj: ChannelMessageSummary
) => any;
export declare const ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog: (
  obj: ChannelModeratedByAppInstanceUserSummary
) => any;
export declare const ChannelModeratorFilterSensitiveLog: (
  obj: ChannelModerator
) => any;
export declare const ChannelModeratorSummaryFilterSensitiveLog: (
  obj: ChannelModeratorSummary
) => any;
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
export declare const CreateChannelRequestFilterSensitiveLog: (
  obj: CreateChannelRequest
) => any;
export declare const CreateChannelResponseFilterSensitiveLog: (
  obj: CreateChannelResponse
) => any;
export declare const CreateChannelBanRequestFilterSensitiveLog: (
  obj: CreateChannelBanRequest
) => any;
export declare const CreateChannelBanResponseFilterSensitiveLog: (
  obj: CreateChannelBanResponse
) => any;
export declare const CreateChannelFlowRequestFilterSensitiveLog: (
  obj: CreateChannelFlowRequest
) => any;
export declare const CreateChannelFlowResponseFilterSensitiveLog: (
  obj: CreateChannelFlowResponse
) => any;
export declare const CreateChannelMembershipRequestFilterSensitiveLog: (
  obj: CreateChannelMembershipRequest
) => any;
export declare const CreateChannelMembershipResponseFilterSensitiveLog: (
  obj: CreateChannelMembershipResponse
) => any;
export declare const CreateChannelModeratorRequestFilterSensitiveLog: (
  obj: CreateChannelModeratorRequest
) => any;
export declare const CreateChannelModeratorResponseFilterSensitiveLog: (
  obj: CreateChannelModeratorResponse
) => any;
export declare const DeleteChannelRequestFilterSensitiveLog: (
  obj: DeleteChannelRequest
) => any;
export declare const DeleteChannelBanRequestFilterSensitiveLog: (
  obj: DeleteChannelBanRequest
) => any;
export declare const DeleteChannelFlowRequestFilterSensitiveLog: (
  obj: DeleteChannelFlowRequest
) => any;
export declare const DeleteChannelMembershipRequestFilterSensitiveLog: (
  obj: DeleteChannelMembershipRequest
) => any;
export declare const DeleteChannelMessageRequestFilterSensitiveLog: (
  obj: DeleteChannelMessageRequest
) => any;
export declare const DeleteChannelModeratorRequestFilterSensitiveLog: (
  obj: DeleteChannelModeratorRequest
) => any;
export declare const DescribeChannelRequestFilterSensitiveLog: (
  obj: DescribeChannelRequest
) => any;
export declare const DescribeChannelResponseFilterSensitiveLog: (
  obj: DescribeChannelResponse
) => any;
export declare const DescribeChannelBanRequestFilterSensitiveLog: (
  obj: DescribeChannelBanRequest
) => any;
export declare const DescribeChannelBanResponseFilterSensitiveLog: (
  obj: DescribeChannelBanResponse
) => any;
export declare const DescribeChannelFlowRequestFilterSensitiveLog: (
  obj: DescribeChannelFlowRequest
) => any;
export declare const DescribeChannelFlowResponseFilterSensitiveLog: (
  obj: DescribeChannelFlowResponse
) => any;
export declare const DescribeChannelMembershipRequestFilterSensitiveLog: (
  obj: DescribeChannelMembershipRequest
) => any;
export declare const DescribeChannelMembershipResponseFilterSensitiveLog: (
  obj: DescribeChannelMembershipResponse
) => any;
export declare const DescribeChannelMembershipForAppInstanceUserRequestFilterSensitiveLog: (
  obj: DescribeChannelMembershipForAppInstanceUserRequest
) => any;
export declare const DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeChannelMembershipForAppInstanceUserResponse
) => any;
export declare const DescribeChannelModeratedByAppInstanceUserRequestFilterSensitiveLog: (
  obj: DescribeChannelModeratedByAppInstanceUserRequest
) => any;
export declare const DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeChannelModeratedByAppInstanceUserResponse
) => any;
export declare const DescribeChannelModeratorRequestFilterSensitiveLog: (
  obj: DescribeChannelModeratorRequest
) => any;
export declare const DescribeChannelModeratorResponseFilterSensitiveLog: (
  obj: DescribeChannelModeratorResponse
) => any;
export declare const DisassociateChannelFlowRequestFilterSensitiveLog: (
  obj: DisassociateChannelFlowRequest
) => any;
export declare const GetChannelMembershipPreferencesRequestFilterSensitiveLog: (
  obj: GetChannelMembershipPreferencesRequest
) => any;
export declare const GetChannelMembershipPreferencesResponseFilterSensitiveLog: (
  obj: GetChannelMembershipPreferencesResponse
) => any;
export declare const GetChannelMessageRequestFilterSensitiveLog: (
  obj: GetChannelMessageRequest
) => any;
export declare const GetChannelMessageResponseFilterSensitiveLog: (
  obj: GetChannelMessageResponse
) => any;
export declare const GetChannelMessageStatusRequestFilterSensitiveLog: (
  obj: GetChannelMessageStatusRequest
) => any;
export declare const GetChannelMessageStatusResponseFilterSensitiveLog: (
  obj: GetChannelMessageStatusResponse
) => any;
export declare const GetMessagingSessionEndpointRequestFilterSensitiveLog: (
  obj: GetMessagingSessionEndpointRequest
) => any;
export declare const MessagingSessionEndpointFilterSensitiveLog: (
  obj: MessagingSessionEndpoint
) => any;
export declare const GetMessagingSessionEndpointResponseFilterSensitiveLog: (
  obj: GetMessagingSessionEndpointResponse
) => any;
export declare const ListChannelBansRequestFilterSensitiveLog: (
  obj: ListChannelBansRequest
) => any;
export declare const ListChannelBansResponseFilterSensitiveLog: (
  obj: ListChannelBansResponse
) => any;
export declare const ListChannelFlowsRequestFilterSensitiveLog: (
  obj: ListChannelFlowsRequest
) => any;
export declare const ListChannelFlowsResponseFilterSensitiveLog: (
  obj: ListChannelFlowsResponse
) => any;
export declare const ListChannelMembershipsRequestFilterSensitiveLog: (
  obj: ListChannelMembershipsRequest
) => any;
export declare const ListChannelMembershipsResponseFilterSensitiveLog: (
  obj: ListChannelMembershipsResponse
) => any;
export declare const ListChannelMembershipsForAppInstanceUserRequestFilterSensitiveLog: (
  obj: ListChannelMembershipsForAppInstanceUserRequest
) => any;
export declare const ListChannelMembershipsForAppInstanceUserResponseFilterSensitiveLog: (
  obj: ListChannelMembershipsForAppInstanceUserResponse
) => any;
export declare const ListChannelMessagesRequestFilterSensitiveLog: (
  obj: ListChannelMessagesRequest
) => any;
export declare const ListChannelMessagesResponseFilterSensitiveLog: (
  obj: ListChannelMessagesResponse
) => any;
export declare const ListChannelModeratorsRequestFilterSensitiveLog: (
  obj: ListChannelModeratorsRequest
) => any;
export declare const ListChannelModeratorsResponseFilterSensitiveLog: (
  obj: ListChannelModeratorsResponse
) => any;
export declare const ListChannelsRequestFilterSensitiveLog: (
  obj: ListChannelsRequest
) => any;
export declare const ListChannelsResponseFilterSensitiveLog: (
  obj: ListChannelsResponse
) => any;
export declare const ListChannelsAssociatedWithChannelFlowRequestFilterSensitiveLog: (
  obj: ListChannelsAssociatedWithChannelFlowRequest
) => any;
export declare const ListChannelsAssociatedWithChannelFlowResponseFilterSensitiveLog: (
  obj: ListChannelsAssociatedWithChannelFlowResponse
) => any;
export declare const ListChannelsModeratedByAppInstanceUserRequestFilterSensitiveLog: (
  obj: ListChannelsModeratedByAppInstanceUserRequest
) => any;
export declare const ListChannelsModeratedByAppInstanceUserResponseFilterSensitiveLog: (
  obj: ListChannelsModeratedByAppInstanceUserResponse
) => any;
export declare const ListSubChannelsRequestFilterSensitiveLog: (
  obj: ListSubChannelsRequest
) => any;
export declare const SubChannelSummaryFilterSensitiveLog: (
  obj: SubChannelSummary
) => any;
export declare const ListSubChannelsResponseFilterSensitiveLog: (
  obj: ListSubChannelsResponse
) => any;
export declare const ListTagsForResourceRequestFilterSensitiveLog: (
  obj: ListTagsForResourceRequest
) => any;
export declare const ListTagsForResourceResponseFilterSensitiveLog: (
  obj: ListTagsForResourceResponse
) => any;
export declare const PutChannelMembershipPreferencesRequestFilterSensitiveLog: (
  obj: PutChannelMembershipPreferencesRequest
) => any;
export declare const PutChannelMembershipPreferencesResponseFilterSensitiveLog: (
  obj: PutChannelMembershipPreferencesResponse
) => any;
export declare const RedactChannelMessageRequestFilterSensitiveLog: (
  obj: RedactChannelMessageRequest
) => any;
export declare const RedactChannelMessageResponseFilterSensitiveLog: (
  obj: RedactChannelMessageResponse
) => any;
export declare const SearchFieldFilterSensitiveLog: (obj: SearchField) => any;
export declare const SearchChannelsRequestFilterSensitiveLog: (
  obj: SearchChannelsRequest
) => any;
export declare const SearchChannelsResponseFilterSensitiveLog: (
  obj: SearchChannelsResponse
) => any;
export declare const SendChannelMessageRequestFilterSensitiveLog: (
  obj: SendChannelMessageRequest
) => any;
export declare const SendChannelMessageResponseFilterSensitiveLog: (
  obj: SendChannelMessageResponse
) => any;
export declare const TagResourceRequestFilterSensitiveLog: (
  obj: TagResourceRequest
) => any;
export declare const UntagResourceRequestFilterSensitiveLog: (
  obj: UntagResourceRequest
) => any;
export declare const UpdateChannelRequestFilterSensitiveLog: (
  obj: UpdateChannelRequest
) => any;
export declare const UpdateChannelResponseFilterSensitiveLog: (
  obj: UpdateChannelResponse
) => any;
export declare const UpdateChannelFlowRequestFilterSensitiveLog: (
  obj: UpdateChannelFlowRequest
) => any;
export declare const UpdateChannelFlowResponseFilterSensitiveLog: (
  obj: UpdateChannelFlowResponse
) => any;
export declare const UpdateChannelMessageRequestFilterSensitiveLog: (
  obj: UpdateChannelMessageRequest
) => any;
export declare const UpdateChannelMessageResponseFilterSensitiveLog: (
  obj: UpdateChannelMessageResponse
) => any;
export declare const UpdateChannelReadMarkerRequestFilterSensitiveLog: (
  obj: UpdateChannelReadMarkerRequest
) => any;
export declare const UpdateChannelReadMarkerResponseFilterSensitiveLog: (
  obj: UpdateChannelReadMarkerResponse
) => any;
