"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSDKVoice = void 0;
const ChimeSDKVoiceClient_1 = require("./ChimeSDKVoiceClient");
const AssociatePhoneNumbersWithVoiceConnectorCommand_1 = require("./commands/AssociatePhoneNumbersWithVoiceConnectorCommand");
const AssociatePhoneNumbersWithVoiceConnectorGroupCommand_1 = require("./commands/AssociatePhoneNumbersWithVoiceConnectorGroupCommand");
const BatchDeletePhoneNumberCommand_1 = require("./commands/BatchDeletePhoneNumberCommand");
const BatchUpdatePhoneNumberCommand_1 = require("./commands/BatchUpdatePhoneNumberCommand");
const CreatePhoneNumberOrderCommand_1 = require("./commands/CreatePhoneNumberOrderCommand");
const CreateProxySessionCommand_1 = require("./commands/CreateProxySessionCommand");
const CreateSipMediaApplicationCallCommand_1 = require("./commands/CreateSipMediaApplicationCallCommand");
const CreateSipMediaApplicationCommand_1 = require("./commands/CreateSipMediaApplicationCommand");
const CreateSipRuleCommand_1 = require("./commands/CreateSipRuleCommand");
const CreateVoiceConnectorCommand_1 = require("./commands/CreateVoiceConnectorCommand");
const CreateVoiceConnectorGroupCommand_1 = require("./commands/CreateVoiceConnectorGroupCommand");
const DeletePhoneNumberCommand_1 = require("./commands/DeletePhoneNumberCommand");
const DeleteProxySessionCommand_1 = require("./commands/DeleteProxySessionCommand");
const DeleteSipMediaApplicationCommand_1 = require("./commands/DeleteSipMediaApplicationCommand");
const DeleteSipRuleCommand_1 = require("./commands/DeleteSipRuleCommand");
const DeleteVoiceConnectorCommand_1 = require("./commands/DeleteVoiceConnectorCommand");
const DeleteVoiceConnectorEmergencyCallingConfigurationCommand_1 = require("./commands/DeleteVoiceConnectorEmergencyCallingConfigurationCommand");
const DeleteVoiceConnectorGroupCommand_1 = require("./commands/DeleteVoiceConnectorGroupCommand");
const DeleteVoiceConnectorOriginationCommand_1 = require("./commands/DeleteVoiceConnectorOriginationCommand");
const DeleteVoiceConnectorProxyCommand_1 = require("./commands/DeleteVoiceConnectorProxyCommand");
const DeleteVoiceConnectorStreamingConfigurationCommand_1 = require("./commands/DeleteVoiceConnectorStreamingConfigurationCommand");
const DeleteVoiceConnectorTerminationCommand_1 = require("./commands/DeleteVoiceConnectorTerminationCommand");
const DeleteVoiceConnectorTerminationCredentialsCommand_1 = require("./commands/DeleteVoiceConnectorTerminationCredentialsCommand");
const DisassociatePhoneNumbersFromVoiceConnectorCommand_1 = require("./commands/DisassociatePhoneNumbersFromVoiceConnectorCommand");
const DisassociatePhoneNumbersFromVoiceConnectorGroupCommand_1 = require("./commands/DisassociatePhoneNumbersFromVoiceConnectorGroupCommand");
const GetGlobalSettingsCommand_1 = require("./commands/GetGlobalSettingsCommand");
const GetPhoneNumberCommand_1 = require("./commands/GetPhoneNumberCommand");
const GetPhoneNumberOrderCommand_1 = require("./commands/GetPhoneNumberOrderCommand");
const GetPhoneNumberSettingsCommand_1 = require("./commands/GetPhoneNumberSettingsCommand");
const GetProxySessionCommand_1 = require("./commands/GetProxySessionCommand");
const GetSipMediaApplicationAlexaSkillConfigurationCommand_1 = require("./commands/GetSipMediaApplicationAlexaSkillConfigurationCommand");
const GetSipMediaApplicationCommand_1 = require("./commands/GetSipMediaApplicationCommand");
const GetSipMediaApplicationLoggingConfigurationCommand_1 = require("./commands/GetSipMediaApplicationLoggingConfigurationCommand");
const GetSipRuleCommand_1 = require("./commands/GetSipRuleCommand");
const GetVoiceConnectorCommand_1 = require("./commands/GetVoiceConnectorCommand");
const GetVoiceConnectorEmergencyCallingConfigurationCommand_1 = require("./commands/GetVoiceConnectorEmergencyCallingConfigurationCommand");
const GetVoiceConnectorGroupCommand_1 = require("./commands/GetVoiceConnectorGroupCommand");
const GetVoiceConnectorLoggingConfigurationCommand_1 = require("./commands/GetVoiceConnectorLoggingConfigurationCommand");
const GetVoiceConnectorOriginationCommand_1 = require("./commands/GetVoiceConnectorOriginationCommand");
const GetVoiceConnectorProxyCommand_1 = require("./commands/GetVoiceConnectorProxyCommand");
const GetVoiceConnectorStreamingConfigurationCommand_1 = require("./commands/GetVoiceConnectorStreamingConfigurationCommand");
const GetVoiceConnectorTerminationCommand_1 = require("./commands/GetVoiceConnectorTerminationCommand");
const GetVoiceConnectorTerminationHealthCommand_1 = require("./commands/GetVoiceConnectorTerminationHealthCommand");
const ListAvailableVoiceConnectorRegionsCommand_1 = require("./commands/ListAvailableVoiceConnectorRegionsCommand");
const ListPhoneNumberOrdersCommand_1 = require("./commands/ListPhoneNumberOrdersCommand");
const ListPhoneNumbersCommand_1 = require("./commands/ListPhoneNumbersCommand");
const ListProxySessionsCommand_1 = require("./commands/ListProxySessionsCommand");
const ListSipMediaApplicationsCommand_1 = require("./commands/ListSipMediaApplicationsCommand");
const ListSipRulesCommand_1 = require("./commands/ListSipRulesCommand");
const ListSupportedPhoneNumberCountriesCommand_1 = require("./commands/ListSupportedPhoneNumberCountriesCommand");
const ListVoiceConnectorGroupsCommand_1 = require("./commands/ListVoiceConnectorGroupsCommand");
const ListVoiceConnectorsCommand_1 = require("./commands/ListVoiceConnectorsCommand");
const ListVoiceConnectorTerminationCredentialsCommand_1 = require("./commands/ListVoiceConnectorTerminationCredentialsCommand");
const PutSipMediaApplicationAlexaSkillConfigurationCommand_1 = require("./commands/PutSipMediaApplicationAlexaSkillConfigurationCommand");
const PutSipMediaApplicationLoggingConfigurationCommand_1 = require("./commands/PutSipMediaApplicationLoggingConfigurationCommand");
const PutVoiceConnectorEmergencyCallingConfigurationCommand_1 = require("./commands/PutVoiceConnectorEmergencyCallingConfigurationCommand");
const PutVoiceConnectorLoggingConfigurationCommand_1 = require("./commands/PutVoiceConnectorLoggingConfigurationCommand");
const PutVoiceConnectorOriginationCommand_1 = require("./commands/PutVoiceConnectorOriginationCommand");
const PutVoiceConnectorProxyCommand_1 = require("./commands/PutVoiceConnectorProxyCommand");
const PutVoiceConnectorStreamingConfigurationCommand_1 = require("./commands/PutVoiceConnectorStreamingConfigurationCommand");
const PutVoiceConnectorTerminationCommand_1 = require("./commands/PutVoiceConnectorTerminationCommand");
const PutVoiceConnectorTerminationCredentialsCommand_1 = require("./commands/PutVoiceConnectorTerminationCredentialsCommand");
const RestorePhoneNumberCommand_1 = require("./commands/RestorePhoneNumberCommand");
const SearchAvailablePhoneNumbersCommand_1 = require("./commands/SearchAvailablePhoneNumbersCommand");
const UpdateGlobalSettingsCommand_1 = require("./commands/UpdateGlobalSettingsCommand");
const UpdatePhoneNumberCommand_1 = require("./commands/UpdatePhoneNumberCommand");
const UpdatePhoneNumberSettingsCommand_1 = require("./commands/UpdatePhoneNumberSettingsCommand");
const UpdateProxySessionCommand_1 = require("./commands/UpdateProxySessionCommand");
const UpdateSipMediaApplicationCallCommand_1 = require("./commands/UpdateSipMediaApplicationCallCommand");
const UpdateSipMediaApplicationCommand_1 = require("./commands/UpdateSipMediaApplicationCommand");
const UpdateSipRuleCommand_1 = require("./commands/UpdateSipRuleCommand");
const UpdateVoiceConnectorCommand_1 = require("./commands/UpdateVoiceConnectorCommand");
const UpdateVoiceConnectorGroupCommand_1 = require("./commands/UpdateVoiceConnectorGroupCommand");
const ValidateE911AddressCommand_1 = require("./commands/ValidateE911AddressCommand");
class ChimeSDKVoice extends ChimeSDKVoiceClient_1.ChimeSDKVoiceClient {
    associatePhoneNumbersWithVoiceConnector(args, optionsOrCb, cb) {
        const command = new AssociatePhoneNumbersWithVoiceConnectorCommand_1.AssociatePhoneNumbersWithVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    associatePhoneNumbersWithVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new AssociatePhoneNumbersWithVoiceConnectorGroupCommand_1.AssociatePhoneNumbersWithVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchDeletePhoneNumber(args, optionsOrCb, cb) {
        const command = new BatchDeletePhoneNumberCommand_1.BatchDeletePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchUpdatePhoneNumber(args, optionsOrCb, cb) {
        const command = new BatchUpdatePhoneNumberCommand_1.BatchUpdatePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createPhoneNumberOrder(args, optionsOrCb, cb) {
        const command = new CreatePhoneNumberOrderCommand_1.CreatePhoneNumberOrderCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createProxySession(args, optionsOrCb, cb) {
        const command = new CreateProxySessionCommand_1.CreateProxySessionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createSipMediaApplication(args, optionsOrCb, cb) {
        const command = new CreateSipMediaApplicationCommand_1.CreateSipMediaApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createSipMediaApplicationCall(args, optionsOrCb, cb) {
        const command = new CreateSipMediaApplicationCallCommand_1.CreateSipMediaApplicationCallCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createSipRule(args, optionsOrCb, cb) {
        const command = new CreateSipRuleCommand_1.CreateSipRuleCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createVoiceConnector(args, optionsOrCb, cb) {
        const command = new CreateVoiceConnectorCommand_1.CreateVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new CreateVoiceConnectorGroupCommand_1.CreateVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deletePhoneNumber(args, optionsOrCb, cb) {
        const command = new DeletePhoneNumberCommand_1.DeletePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteProxySession(args, optionsOrCb, cb) {
        const command = new DeleteProxySessionCommand_1.DeleteProxySessionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteSipMediaApplication(args, optionsOrCb, cb) {
        const command = new DeleteSipMediaApplicationCommand_1.DeleteSipMediaApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteSipRule(args, optionsOrCb, cb) {
        const command = new DeleteSipRuleCommand_1.DeleteSipRuleCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnector(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorCommand_1.DeleteVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorEmergencyCallingConfiguration(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorEmergencyCallingConfigurationCommand_1.DeleteVoiceConnectorEmergencyCallingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorGroupCommand_1.DeleteVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorOrigination(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorOriginationCommand_1.DeleteVoiceConnectorOriginationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorProxy(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorProxyCommand_1.DeleteVoiceConnectorProxyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorStreamingConfiguration(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorStreamingConfigurationCommand_1.DeleteVoiceConnectorStreamingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorTermination(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorTerminationCommand_1.DeleteVoiceConnectorTerminationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorTerminationCredentials(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorTerminationCredentialsCommand_1.DeleteVoiceConnectorTerminationCredentialsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    disassociatePhoneNumbersFromVoiceConnector(args, optionsOrCb, cb) {
        const command = new DisassociatePhoneNumbersFromVoiceConnectorCommand_1.DisassociatePhoneNumbersFromVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    disassociatePhoneNumbersFromVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new DisassociatePhoneNumbersFromVoiceConnectorGroupCommand_1.DisassociatePhoneNumbersFromVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getGlobalSettings(args, optionsOrCb, cb) {
        const command = new GetGlobalSettingsCommand_1.GetGlobalSettingsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getPhoneNumber(args, optionsOrCb, cb) {
        const command = new GetPhoneNumberCommand_1.GetPhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getPhoneNumberOrder(args, optionsOrCb, cb) {
        const command = new GetPhoneNumberOrderCommand_1.GetPhoneNumberOrderCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getPhoneNumberSettings(args, optionsOrCb, cb) {
        const command = new GetPhoneNumberSettingsCommand_1.GetPhoneNumberSettingsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getProxySession(args, optionsOrCb, cb) {
        const command = new GetProxySessionCommand_1.GetProxySessionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSipMediaApplication(args, optionsOrCb, cb) {
        const command = new GetSipMediaApplicationCommand_1.GetSipMediaApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSipMediaApplicationAlexaSkillConfiguration(args, optionsOrCb, cb) {
        const command = new GetSipMediaApplicationAlexaSkillConfigurationCommand_1.GetSipMediaApplicationAlexaSkillConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSipMediaApplicationLoggingConfiguration(args, optionsOrCb, cb) {
        const command = new GetSipMediaApplicationLoggingConfigurationCommand_1.GetSipMediaApplicationLoggingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSipRule(args, optionsOrCb, cb) {
        const command = new GetSipRuleCommand_1.GetSipRuleCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnector(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorCommand_1.GetVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorEmergencyCallingConfiguration(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorEmergencyCallingConfigurationCommand_1.GetVoiceConnectorEmergencyCallingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorGroupCommand_1.GetVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorLoggingConfiguration(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorLoggingConfigurationCommand_1.GetVoiceConnectorLoggingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorOrigination(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorOriginationCommand_1.GetVoiceConnectorOriginationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorProxy(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorProxyCommand_1.GetVoiceConnectorProxyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorStreamingConfiguration(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorStreamingConfigurationCommand_1.GetVoiceConnectorStreamingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorTermination(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorTerminationCommand_1.GetVoiceConnectorTerminationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorTerminationHealth(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorTerminationHealthCommand_1.GetVoiceConnectorTerminationHealthCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listAvailableVoiceConnectorRegions(args, optionsOrCb, cb) {
        const command = new ListAvailableVoiceConnectorRegionsCommand_1.ListAvailableVoiceConnectorRegionsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listPhoneNumberOrders(args, optionsOrCb, cb) {
        const command = new ListPhoneNumberOrdersCommand_1.ListPhoneNumberOrdersCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listPhoneNumbers(args, optionsOrCb, cb) {
        const command = new ListPhoneNumbersCommand_1.ListPhoneNumbersCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listProxySessions(args, optionsOrCb, cb) {
        const command = new ListProxySessionsCommand_1.ListProxySessionsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listSipMediaApplications(args, optionsOrCb, cb) {
        const command = new ListSipMediaApplicationsCommand_1.ListSipMediaApplicationsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listSipRules(args, optionsOrCb, cb) {
        const command = new ListSipRulesCommand_1.ListSipRulesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listSupportedPhoneNumberCountries(args, optionsOrCb, cb) {
        const command = new ListSupportedPhoneNumberCountriesCommand_1.ListSupportedPhoneNumberCountriesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listVoiceConnectorGroups(args, optionsOrCb, cb) {
        const command = new ListVoiceConnectorGroupsCommand_1.ListVoiceConnectorGroupsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listVoiceConnectors(args, optionsOrCb, cb) {
        const command = new ListVoiceConnectorsCommand_1.ListVoiceConnectorsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listVoiceConnectorTerminationCredentials(args, optionsOrCb, cb) {
        const command = new ListVoiceConnectorTerminationCredentialsCommand_1.ListVoiceConnectorTerminationCredentialsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putSipMediaApplicationAlexaSkillConfiguration(args, optionsOrCb, cb) {
        const command = new PutSipMediaApplicationAlexaSkillConfigurationCommand_1.PutSipMediaApplicationAlexaSkillConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putSipMediaApplicationLoggingConfiguration(args, optionsOrCb, cb) {
        const command = new PutSipMediaApplicationLoggingConfigurationCommand_1.PutSipMediaApplicationLoggingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorEmergencyCallingConfiguration(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorEmergencyCallingConfigurationCommand_1.PutVoiceConnectorEmergencyCallingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorLoggingConfiguration(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorLoggingConfigurationCommand_1.PutVoiceConnectorLoggingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorOrigination(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorOriginationCommand_1.PutVoiceConnectorOriginationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorProxy(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorProxyCommand_1.PutVoiceConnectorProxyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorStreamingConfiguration(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorStreamingConfigurationCommand_1.PutVoiceConnectorStreamingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorTermination(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorTerminationCommand_1.PutVoiceConnectorTerminationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorTerminationCredentials(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorTerminationCredentialsCommand_1.PutVoiceConnectorTerminationCredentialsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    restorePhoneNumber(args, optionsOrCb, cb) {
        const command = new RestorePhoneNumberCommand_1.RestorePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    searchAvailablePhoneNumbers(args, optionsOrCb, cb) {
        const command = new SearchAvailablePhoneNumbersCommand_1.SearchAvailablePhoneNumbersCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateGlobalSettings(args, optionsOrCb, cb) {
        const command = new UpdateGlobalSettingsCommand_1.UpdateGlobalSettingsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updatePhoneNumber(args, optionsOrCb, cb) {
        const command = new UpdatePhoneNumberCommand_1.UpdatePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updatePhoneNumberSettings(args, optionsOrCb, cb) {
        const command = new UpdatePhoneNumberSettingsCommand_1.UpdatePhoneNumberSettingsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateProxySession(args, optionsOrCb, cb) {
        const command = new UpdateProxySessionCommand_1.UpdateProxySessionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateSipMediaApplication(args, optionsOrCb, cb) {
        const command = new UpdateSipMediaApplicationCommand_1.UpdateSipMediaApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateSipMediaApplicationCall(args, optionsOrCb, cb) {
        const command = new UpdateSipMediaApplicationCallCommand_1.UpdateSipMediaApplicationCallCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateSipRule(args, optionsOrCb, cb) {
        const command = new UpdateSipRuleCommand_1.UpdateSipRuleCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateVoiceConnector(args, optionsOrCb, cb) {
        const command = new UpdateVoiceConnectorCommand_1.UpdateVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new UpdateVoiceConnectorGroupCommand_1.UpdateVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    validateE911Address(args, optionsOrCb, cb) {
        const command = new ValidateE911AddressCommand_1.ValidateE911AddressCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
}
exports.ChimeSDKVoice = ChimeSDKVoice;
