import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { ChimeSDKVoiceServiceException as __BaseException } from "./ChimeSDKVoiceServiceException";
export var ErrorCode;
(function (ErrorCode) {
    ErrorCode["AccessDenied"] = "AccessDenied";
    ErrorCode["BadRequest"] = "BadRequest";
    ErrorCode["Conflict"] = "Conflict";
    ErrorCode["Forbidden"] = "Forbidden";
    ErrorCode["Gone"] = "Gone";
    ErrorCode["NotFound"] = "NotFound";
    ErrorCode["PhoneNumberAssociationsExist"] = "PhoneNumberAssociationsExist";
    ErrorCode["PreconditionFailed"] = "PreconditionFailed";
    ErrorCode["ResourceLimitExceeded"] = "ResourceLimitExceeded";
    ErrorCode["ServiceFailure"] = "ServiceFailure";
    ErrorCode["ServiceUnavailable"] = "ServiceUnavailable";
    ErrorCode["Throttled"] = "Throttled";
    ErrorCode["Throttling"] = "Throttling";
    ErrorCode["Unauthorized"] = "Unauthorized";
    ErrorCode["Unprocessable"] = "Unprocessable";
    ErrorCode["VoiceConnectorGroupAssociationsExist"] = "VoiceConnectorGroupAssociationsExist";
})(ErrorCode || (ErrorCode = {}));
export class AccessDeniedException extends __BaseException {
    constructor(opts) {
        super({
            name: "AccessDeniedException",
            $fault: "client",
            ...opts,
        });
        this.name = "AccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AccessDeniedException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export var AlexaSkillStatus;
(function (AlexaSkillStatus) {
    AlexaSkillStatus["ACTIVE"] = "ACTIVE";
    AlexaSkillStatus["INACTIVE"] = "INACTIVE";
})(AlexaSkillStatus || (AlexaSkillStatus = {}));
export class BadRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "BadRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "BadRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BadRequestException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ForbiddenException extends __BaseException {
    constructor(opts) {
        super({
            name: "ForbiddenException",
            $fault: "client",
            ...opts,
        });
        this.name = "ForbiddenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ForbiddenException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class NotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "NotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "NotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NotFoundException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ServiceFailureException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceFailureException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceFailureException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceFailureException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ServiceUnavailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceUnavailableException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ThrottledClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "ThrottledClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "ThrottledClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ThrottledClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class UnauthorizedClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnauthorizedClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnauthorizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnauthorizedClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export var PhoneNumberProductType;
(function (PhoneNumberProductType) {
    PhoneNumberProductType["SipMediaApplicationDialIn"] = "SipMediaApplicationDialIn";
    PhoneNumberProductType["VoiceConnector"] = "VoiceConnector";
})(PhoneNumberProductType || (PhoneNumberProductType = {}));
export var CallingNameStatus;
(function (CallingNameStatus) {
    CallingNameStatus["Unassigned"] = "Unassigned";
    CallingNameStatus["UpdateFailed"] = "UpdateFailed";
    CallingNameStatus["UpdateInProgress"] = "UpdateInProgress";
    CallingNameStatus["UpdateSucceeded"] = "UpdateSucceeded";
})(CallingNameStatus || (CallingNameStatus = {}));
export var Capability;
(function (Capability) {
    Capability["SMS"] = "SMS";
    Capability["Voice"] = "Voice";
})(Capability || (Capability = {}));
export var OrderedPhoneNumberStatus;
(function (OrderedPhoneNumberStatus) {
    OrderedPhoneNumberStatus["Acquired"] = "Acquired";
    OrderedPhoneNumberStatus["Failed"] = "Failed";
    OrderedPhoneNumberStatus["Processing"] = "Processing";
})(OrderedPhoneNumberStatus || (OrderedPhoneNumberStatus = {}));
export var PhoneNumberOrderType;
(function (PhoneNumberOrderType) {
    PhoneNumberOrderType["New"] = "New";
    PhoneNumberOrderType["Porting"] = "Porting";
})(PhoneNumberOrderType || (PhoneNumberOrderType = {}));
export var PhoneNumberOrderStatus;
(function (PhoneNumberOrderStatus) {
    PhoneNumberOrderStatus["CancelRequested"] = "CancelRequested";
    PhoneNumberOrderStatus["Cancelled"] = "Cancelled";
    PhoneNumberOrderStatus["ChangeRequested"] = "ChangeRequested";
    PhoneNumberOrderStatus["Exception"] = "Exception";
    PhoneNumberOrderStatus["FOC"] = "FOC";
    PhoneNumberOrderStatus["Failed"] = "Failed";
    PhoneNumberOrderStatus["Partial"] = "Partial";
    PhoneNumberOrderStatus["PendingDocuments"] = "PendingDocuments";
    PhoneNumberOrderStatus["Processing"] = "Processing";
    PhoneNumberOrderStatus["Submitted"] = "Submitted";
    PhoneNumberOrderStatus["Successful"] = "Successful";
})(PhoneNumberOrderStatus || (PhoneNumberOrderStatus = {}));
export class ResourceLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export var GeoMatchLevel;
(function (GeoMatchLevel) {
    GeoMatchLevel["AreaCode"] = "AreaCode";
    GeoMatchLevel["Country"] = "Country";
})(GeoMatchLevel || (GeoMatchLevel = {}));
export var NumberSelectionBehavior;
(function (NumberSelectionBehavior) {
    NumberSelectionBehavior["AvoidSticky"] = "AvoidSticky";
    NumberSelectionBehavior["PreferSticky"] = "PreferSticky";
})(NumberSelectionBehavior || (NumberSelectionBehavior = {}));
export var ProxySessionStatus;
(function (ProxySessionStatus) {
    ProxySessionStatus["Closed"] = "Closed";
    ProxySessionStatus["InProgress"] = "InProgress";
    ProxySessionStatus["Open"] = "Open";
})(ProxySessionStatus || (ProxySessionStatus = {}));
export class ConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export var SipRuleTriggerType;
(function (SipRuleTriggerType) {
    SipRuleTriggerType["RequestUriHostname"] = "RequestUriHostname";
    SipRuleTriggerType["ToPhoneNumber"] = "ToPhoneNumber";
})(SipRuleTriggerType || (SipRuleTriggerType = {}));
export var VoiceConnectorAwsRegion;
(function (VoiceConnectorAwsRegion) {
    VoiceConnectorAwsRegion["AP_NORTHEAST_1"] = "ap-northeast-1";
    VoiceConnectorAwsRegion["AP_NORTHEAST_2"] = "ap-northeast-2";
    VoiceConnectorAwsRegion["AP_SOUTHEAST_1"] = "ap-southeast-1";
    VoiceConnectorAwsRegion["AP_SOUTHEAST_2"] = "ap-southeast-2";
    VoiceConnectorAwsRegion["CA_CENTRAL_1"] = "ca-central-1";
    VoiceConnectorAwsRegion["EU_CENTRAL_1"] = "eu-central-1";
    VoiceConnectorAwsRegion["EU_WEST_1"] = "eu-west-1";
    VoiceConnectorAwsRegion["EU_WEST_2"] = "eu-west-2";
    VoiceConnectorAwsRegion["US_EAST_1"] = "us-east-1";
    VoiceConnectorAwsRegion["US_WEST_2"] = "us-west-2";
})(VoiceConnectorAwsRegion || (VoiceConnectorAwsRegion = {}));
export var PhoneNumberAssociationName;
(function (PhoneNumberAssociationName) {
    PhoneNumberAssociationName["SipRuleId"] = "SipRuleId";
    PhoneNumberAssociationName["VoiceConnectorGroupId"] = "VoiceConnectorGroupId";
    PhoneNumberAssociationName["VoiceConnectorId"] = "VoiceConnectorId";
})(PhoneNumberAssociationName || (PhoneNumberAssociationName = {}));
export var PhoneNumberStatus;
(function (PhoneNumberStatus) {
    PhoneNumberStatus["AcquireFailed"] = "AcquireFailed";
    PhoneNumberStatus["AcquireInProgress"] = "AcquireInProgress";
    PhoneNumberStatus["Assigned"] = "Assigned";
    PhoneNumberStatus["Cancelled"] = "Cancelled";
    PhoneNumberStatus["DeleteFailed"] = "DeleteFailed";
    PhoneNumberStatus["DeleteInProgress"] = "DeleteInProgress";
    PhoneNumberStatus["PortinCancelRequested"] = "PortinCancelRequested";
    PhoneNumberStatus["PortinInProgress"] = "PortinInProgress";
    PhoneNumberStatus["ReleaseFailed"] = "ReleaseFailed";
    PhoneNumberStatus["ReleaseInProgress"] = "ReleaseInProgress";
    PhoneNumberStatus["Unassigned"] = "Unassigned";
})(PhoneNumberStatus || (PhoneNumberStatus = {}));
export var PhoneNumberType;
(function (PhoneNumberType) {
    PhoneNumberType["Local"] = "Local";
    PhoneNumberType["TollFree"] = "TollFree";
})(PhoneNumberType || (PhoneNumberType = {}));
export var OriginationRouteProtocol;
(function (OriginationRouteProtocol) {
    OriginationRouteProtocol["TCP"] = "TCP";
    OriginationRouteProtocol["UDP"] = "UDP";
})(OriginationRouteProtocol || (OriginationRouteProtocol = {}));
export var NotificationTarget;
(function (NotificationTarget) {
    NotificationTarget["EventBridge"] = "EventBridge";
    NotificationTarget["SNS"] = "SNS";
    NotificationTarget["SQS"] = "SQS";
})(NotificationTarget || (NotificationTarget = {}));
export const AddressFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.streetName && { streetName: SENSITIVE_STRING }),
    ...(obj.streetSuffix && { streetSuffix: SENSITIVE_STRING }),
    ...(obj.postDirectional && { postDirectional: SENSITIVE_STRING }),
    ...(obj.preDirectional && { preDirectional: SENSITIVE_STRING }),
    ...(obj.streetNumber && { streetNumber: SENSITIVE_STRING }),
    ...(obj.city && { city: SENSITIVE_STRING }),
    ...(obj.state && { state: SENSITIVE_STRING }),
    ...(obj.postalCode && { postalCode: SENSITIVE_STRING }),
    ...(obj.postalCodePlus4 && { postalCodePlus4: SENSITIVE_STRING }),
    ...(obj.country && { country: SENSITIVE_STRING }),
});
export const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const PhoneNumberErrorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberId && { PhoneNumberId: SENSITIVE_STRING }),
});
export const AssociatePhoneNumbersWithVoiceConnectorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberErrors && {
        PhoneNumberErrors: obj.PhoneNumberErrors.map((item) => PhoneNumberErrorFilterSensitiveLog(item)),
    }),
});
export const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const AssociatePhoneNumbersWithVoiceConnectorGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberErrors && {
        PhoneNumberErrors: obj.PhoneNumberErrors.map((item) => PhoneNumberErrorFilterSensitiveLog(item)),
    }),
});
export const BatchDeletePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchDeletePhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberErrors && {
        PhoneNumberErrors: obj.PhoneNumberErrors.map((item) => PhoneNumberErrorFilterSensitiveLog(item)),
    }),
});
export const UpdatePhoneNumberRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberId && { PhoneNumberId: SENSITIVE_STRING }),
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const BatchUpdatePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UpdatePhoneNumberRequestItems && {
        UpdatePhoneNumberRequestItems: obj.UpdatePhoneNumberRequestItems.map((item) => UpdatePhoneNumberRequestItemFilterSensitiveLog(item)),
    }),
});
export const BatchUpdatePhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberErrors && {
        PhoneNumberErrors: obj.PhoneNumberErrors.map((item) => PhoneNumberErrorFilterSensitiveLog(item)),
    }),
});
export const CandidateAddressFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.streetInfo && { streetInfo: SENSITIVE_STRING }),
    ...(obj.streetNumber && { streetNumber: SENSITIVE_STRING }),
    ...(obj.city && { city: SENSITIVE_STRING }),
    ...(obj.state && { state: SENSITIVE_STRING }),
    ...(obj.postalCode && { postalCode: SENSITIVE_STRING }),
    ...(obj.postalCodePlus4 && { postalCodePlus4: SENSITIVE_STRING }),
    ...(obj.country && { country: SENSITIVE_STRING }),
});
export const CreatePhoneNumberOrderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const OrderedPhoneNumberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: SENSITIVE_STRING }),
});
export const PhoneNumberOrderFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OrderedPhoneNumbers && {
        OrderedPhoneNumbers: obj.OrderedPhoneNumbers.map((item) => OrderedPhoneNumberFilterSensitiveLog(item)),
    }),
});
export const CreatePhoneNumberOrderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberOrder && { PhoneNumberOrder: PhoneNumberOrderFilterSensitiveLog(obj.PhoneNumberOrder) }),
});
export const GeoMatchParamsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ParticipantPhoneNumbers && { ParticipantPhoneNumbers: SENSITIVE_STRING }),
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const ParticipantFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: SENSITIVE_STRING }),
    ...(obj.ProxyPhoneNumber && { ProxyPhoneNumber: SENSITIVE_STRING }),
});
export const ProxySessionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Participants && { Participants: obj.Participants.map((item) => ParticipantFilterSensitiveLog(item)) }),
});
export const CreateProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: ProxySessionFilterSensitiveLog(obj.ProxySession) }),
});
export const SipMediaApplicationEndpointFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LambdaArn && { LambdaArn: SENSITIVE_STRING }),
});
export const CreateSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => SipMediaApplicationEndpointFilterSensitiveLog(item)) }),
});
export const SipMediaApplicationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => SipMediaApplicationEndpointFilterSensitiveLog(item)) }),
});
export const CreateSipMediaApplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplication && {
        SipMediaApplication: SipMediaApplicationFilterSensitiveLog(obj.SipMediaApplication),
    }),
});
export const CreateSipMediaApplicationCallRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FromPhoneNumber && { FromPhoneNumber: SENSITIVE_STRING }),
    ...(obj.ToPhoneNumber && { ToPhoneNumber: SENSITIVE_STRING }),
    ...(obj.SipHeaders && { SipHeaders: SENSITIVE_STRING }),
    ...(obj.ArgumentsMap && { ArgumentsMap: SENSITIVE_STRING }),
});
export const SipMediaApplicationCallFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSipMediaApplicationCallResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SipRuleTargetApplicationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSipRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SipRuleFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSipRuleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VoiceConnectorFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateVoiceConnectorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VoiceConnectorItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VoiceConnectorGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateVoiceConnectorGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeletePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberId && { PhoneNumberId: SENSITIVE_STRING }),
});
export const DeleteProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSipRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorOriginationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorProxyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorTerminationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Usernames && { Usernames: SENSITIVE_STRING }),
});
export const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const DisassociatePhoneNumbersFromVoiceConnectorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberErrors && {
        PhoneNumberErrors: obj.PhoneNumberErrors.map((item) => PhoneNumberErrorFilterSensitiveLog(item)),
    }),
});
export const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const DisassociatePhoneNumbersFromVoiceConnectorGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberErrors && {
        PhoneNumberErrors: obj.PhoneNumberErrors.map((item) => PhoneNumberErrorFilterSensitiveLog(item)),
    }),
});
export const VoiceConnectorSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetGlobalSettingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberId && { PhoneNumberId: SENSITIVE_STRING }),
});
export const PhoneNumberAssociationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PhoneNumberCapabilitiesFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PhoneNumberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberId && { PhoneNumberId: SENSITIVE_STRING }),
    ...(obj.E164PhoneNumber && { E164PhoneNumber: SENSITIVE_STRING }),
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const GetPhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: PhoneNumberFilterSensitiveLog(obj.PhoneNumber) }),
});
export const GetPhoneNumberOrderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPhoneNumberOrderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberOrder && { PhoneNumberOrder: PhoneNumberOrderFilterSensitiveLog(obj.PhoneNumberOrder) }),
});
export const GetPhoneNumberSettingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const GetProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: ProxySessionFilterSensitiveLog(obj.ProxySession) }),
});
export const GetSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSipMediaApplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplication && {
        SipMediaApplication: SipMediaApplicationFilterSensitiveLog(obj.SipMediaApplication),
    }),
});
export const GetSipMediaApplicationAlexaSkillConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SipMediaApplicationAlexaSkillConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AlexaSkillIds && { AlexaSkillIds: SENSITIVE_STRING }),
});
export const GetSipMediaApplicationAlexaSkillConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplicationAlexaSkillConfiguration && {
        SipMediaApplicationAlexaSkillConfiguration: SipMediaApplicationAlexaSkillConfigurationFilterSensitiveLog(obj.SipMediaApplicationAlexaSkillConfiguration),
    }),
});
export const GetSipMediaApplicationLoggingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SipMediaApplicationLoggingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSipMediaApplicationLoggingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSipRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSipRuleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DNISEmergencyCallingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyPhoneNumber && { EmergencyPhoneNumber: SENSITIVE_STRING }),
    ...(obj.TestPhoneNumber && { TestPhoneNumber: SENSITIVE_STRING }),
});
export const EmergencyCallingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DNIS && { DNIS: obj.DNIS.map((item) => DNISEmergencyCallingConfigurationFilterSensitiveLog(item)) }),
});
export const GetVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyCallingConfiguration && {
        EmergencyCallingConfiguration: EmergencyCallingConfigurationFilterSensitiveLog(obj.EmergencyCallingConfiguration),
    }),
});
export const GetVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorLoggingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LoggingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorLoggingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorOriginationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OriginationRouteFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OriginationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorOriginationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorProxyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ProxyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FallBackPhoneNumber && { FallBackPhoneNumber: SENSITIVE_STRING }),
});
export const GetVoiceConnectorProxyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Proxy && { Proxy: ProxyFilterSensitiveLog(obj.Proxy) }),
});
export const GetVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StreamingNotificationTargetFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StreamingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorStreamingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorTerminationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TerminationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DefaultPhoneNumber && { DefaultPhoneNumber: SENSITIVE_STRING }),
});
export const GetVoiceConnectorTerminationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Termination && { Termination: TerminationFilterSensitiveLog(obj.Termination) }),
});
export const GetVoiceConnectorTerminationHealthRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TerminationHealthFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetVoiceConnectorTerminationHealthResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAvailableVoiceConnectorRegionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPhoneNumberOrdersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPhoneNumberOrdersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPhoneNumbersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPhoneNumbersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumbers && { PhoneNumbers: obj.PhoneNumbers.map((item) => PhoneNumberFilterSensitiveLog(item)) }),
});
export const ListProxySessionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListProxySessionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSipMediaApplicationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSipMediaApplicationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSipRulesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSipRulesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSupportedPhoneNumberCountriesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PhoneNumberCountryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSupportedPhoneNumberCountriesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVoiceConnectorGroupsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVoiceConnectorGroupsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVoiceConnectorsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVoiceConnectorsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListVoiceConnectorTerminationCredentialsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Usernames && { Usernames: SENSITIVE_STRING }),
});
export const PutSipMediaApplicationAlexaSkillConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplicationAlexaSkillConfiguration && {
        SipMediaApplicationAlexaSkillConfiguration: SipMediaApplicationAlexaSkillConfigurationFilterSensitiveLog(obj.SipMediaApplicationAlexaSkillConfiguration),
    }),
});
export const PutSipMediaApplicationAlexaSkillConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplicationAlexaSkillConfiguration && {
        SipMediaApplicationAlexaSkillConfiguration: SipMediaApplicationAlexaSkillConfigurationFilterSensitiveLog(obj.SipMediaApplicationAlexaSkillConfiguration),
    }),
});
export const PutSipMediaApplicationLoggingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutSipMediaApplicationLoggingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyCallingConfiguration && {
        EmergencyCallingConfiguration: EmergencyCallingConfigurationFilterSensitiveLog(obj.EmergencyCallingConfiguration),
    }),
});
export const PutVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyCallingConfiguration && {
        EmergencyCallingConfiguration: EmergencyCallingConfigurationFilterSensitiveLog(obj.EmergencyCallingConfiguration),
    }),
});
export const PutVoiceConnectorLoggingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutVoiceConnectorLoggingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutVoiceConnectorOriginationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutVoiceConnectorOriginationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutVoiceConnectorProxyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FallBackPhoneNumber && { FallBackPhoneNumber: SENSITIVE_STRING }),
});
export const PutVoiceConnectorProxyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Proxy && { Proxy: ProxyFilterSensitiveLog(obj.Proxy) }),
});
export const PutVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutVoiceConnectorStreamingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutVoiceConnectorTerminationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Termination && { Termination: TerminationFilterSensitiveLog(obj.Termination) }),
});
export const PutVoiceConnectorTerminationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Termination && { Termination: TerminationFilterSensitiveLog(obj.Termination) }),
});
export const CredentialFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Username && { Username: SENSITIVE_STRING }),
    ...(obj.Password && { Password: SENSITIVE_STRING }),
});
export const PutVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Credentials && { Credentials: obj.Credentials.map((item) => CredentialFilterSensitiveLog(item)) }),
});
export const RestorePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberId && { PhoneNumberId: SENSITIVE_STRING }),
});
export const RestorePhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: PhoneNumberFilterSensitiveLog(obj.PhoneNumber) }),
});
export const SearchAvailablePhoneNumbersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SearchAvailablePhoneNumbersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const UpdateGlobalSettingsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdatePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberId && { PhoneNumberId: SENSITIVE_STRING }),
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const UpdatePhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: PhoneNumberFilterSensitiveLog(obj.PhoneNumber) }),
});
export const UpdatePhoneNumberSettingsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const UpdateProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: ProxySessionFilterSensitiveLog(obj.ProxySession) }),
});
export const UpdateSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => SipMediaApplicationEndpointFilterSensitiveLog(item)) }),
});
export const UpdateSipMediaApplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplication && {
        SipMediaApplication: SipMediaApplicationFilterSensitiveLog(obj.SipMediaApplication),
    }),
});
export const UpdateSipMediaApplicationCallRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Arguments && { Arguments: SENSITIVE_STRING }),
});
export const UpdateSipMediaApplicationCallResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSipRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSipRuleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateVoiceConnectorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateVoiceConnectorGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ValidateE911AddressRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.StreetNumber && { StreetNumber: SENSITIVE_STRING }),
    ...(obj.StreetInfo && { StreetInfo: SENSITIVE_STRING }),
    ...(obj.City && { City: SENSITIVE_STRING }),
    ...(obj.State && { State: SENSITIVE_STRING }),
    ...(obj.Country && { Country: SENSITIVE_STRING }),
    ...(obj.PostalCode && { PostalCode: SENSITIVE_STRING }),
});
export const ValidateE911AddressResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Address && { Address: AddressFilterSensitiveLog(obj.Address) }),
    ...(obj.CandidateAddressList && {
        CandidateAddressList: obj.CandidateAddressList.map((item) => CandidateAddressFilterSensitiveLog(item)),
    }),
});
